/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CombinCmpItemInfo;
import com.kingdee.eas.hr.compensation.ITaxRateList;
import com.kingdee.eas.hr.compensation.TaxRateListCollection;
import com.kingdee.eas.hr.compensation.TaxRateListFactory;
import com.kingdee.eas.hr.compensation.TaxRateListInfo;
import com.kingdee.eas.hr.compensation.client.AbstractHSTaxDetailReportPanelUI;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class HSTaxDetailReportPanelUI
extends AbstractHSTaxDetailReportPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(HSTaxDetailReportPanelUI.class);
    private boolean isFirstLoad = true;

    @Override
    public void onLoad() throws Exception {
        this.perItemFilter = true;
        super.onLoad();
        this.promTaxRateQuery.setEnabled(false);
        this.promTaxRateQuery.setDisplayFormat("$taxRate$");
        this.promTaxRateQuery.setIsDefaultFilterFieldsEnabled(false);
        this.promTaxRateQuery.setHasHideQuichFilterPanel(true);
        this.isFirstLoad = false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void initAllEditor() throws Exception {
        super.initAllEditor();
        this.promTaxRateQuery.setDisplayFormat("$taxRate$");
        this.promTaxRateQuery.setEditFormat("$taxRate$");
        this.promTaxRateQuery.setCommitFormat("$taxRate$");
        this.promTaxRateQuery.setEnabledMultiSelection(true);
        this.promTaxRateQuery.getQueryAgent().getQueryExecutor().option().isAutoIgnoreZero = false;
    }

    @Override
    protected void init() {
        this.prmtCmpScheme.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    Object[] objs = (Object[])e.getData();
                    HSTaxDetailReportPanelUI.this.lstSelectItem.removeAllElements();
                    HSTaxDetailReportPanelUI.this.lstAllItem.removeAllElements();
                    HSTaxDetailReportPanelUI.this.lstSelectItemData = new ArrayList();
                    HSTaxDetailReportPanelUI.this.lstAllSelectItemData = null;
                    if (objs != null && objs.length != 0) {
                        CmpSchemeInfo[] schemeInfos = HSTaxDetailReportPanelUI.this.getCmpSchemeInfoArrayByObject(objs);
                        HSTaxDetailReportPanelUI.this.getCmpItemCollection(schemeInfos);
                        HSTaxDetailReportPanelUI.this.fillDefaultSelectItem();
                        HSTaxDetailReportPanelUI.this.fillCmpItemCatalogData(false);
                        return;
                    }
                }
                catch (Exception exc) {
                    HSTaxDetailReportPanelUI.this.handUIException(exc);
                }
            }
        });
        this.setCmpItemFilterUI(null);
    }

    @Override
    protected void cmbItemCatalog_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbItemCatalog_itemStateChanged(e);
        int state = e.getStateChange();
        if (state == 1) {
            this.reloadAllListByItemCatalog();
        }
    }

    @Override
    protected void chkShowDelete_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowDelete_itemStateChanged(e);
    }

    @Override
    protected void showTaxRate_itemStateChanged(ItemEvent e) throws Exception {
        super.showTaxRate_itemStateChanged(e);
        if (this.showTaxRate.isSelected()) {
            this.promTaxRateQuery.setEnabled(true);
            this.chkIsHaveOld.setEnabled(true);
        } else {
            this.promTaxRateQuery.setValue(null);
            this.promTaxRateQuery.setEnabled(false);
            this.chkIsHaveOld.setEnabled(false);
        }
    }

    @Override
    protected void chkIsHaveOld_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsHaveOld_itemStateChanged(e);
        this.promTaxRateQuery.setData(null);
        this.promTaxRateQuery.setEntityViewInfo(new EntityViewInfo());
        if (this.chkIsHaveOld.isSelected()) {
            this.promTaxRateQuery.setQueryInfo("com.kingdee.eas.hr.compensation.app.TaxRateQueryAll");
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("usePeriod", (Object)"200803"));
            v.setFilter(filterInfo);
            this.promTaxRateQuery.setEntityViewInfo(v);
            this.promTaxRateQuery.setRefresh(true);
        } else {
            this.promTaxRateQuery.setQueryInfo("com.kingdee.eas.hr.compensation.app.TaxRateQuery");
        }
        this.promTaxRateQuery.getQueryAgent().getQueryExecutor().option().isAutoIgnoreZero = false;
    }

    @Override
    protected void fillCmpItemCatalogData(boolean isFromQuerySolution) throws Exception {
        super.fillCmpItemCatalogData(isFromQuerySolution);
    }

    @Override
    protected void setCustomerParamForSelectItem(CustomerParams cp) {
        try {
            if (cp != null && cp.getCustomerParam("selectListItem") != null) {
                String ids = cp.getCustomerParam("selectListItem");
                this.lstSelectItemData = new ArrayList();
                if (!StringUtils.isEmpty((String)ids)) {
                    String[] items = ids.split("~");
                    CmpItemCollection cmpItemNotSortColl = this.f7Info.getPubCmpItemColl();
                    if (cmpItemNotSortColl != null && cmpItemNotSortColl.size() > 0) {
                        int length = items.length;
                        for (int j = 0; j < length; ++j) {
                            int size = cmpItemNotSortColl.size();
                            for (int i = 0; i < size; ++i) {
                                if (!cmpItemNotSortColl.get(i).getId().toString().equals(items[j])) continue;
                                this.lstSelectItemData.add(cmpItemNotSortColl.get(i));
                            }
                        }
                    }
                }
            } else {
                this.fillDefaultSelectItem();
            }
            HRCommonQueryUtils.fillSelectItemList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (cp != null && cp.getCustomerParam("ShowTaxRate") != null) {
            this.showTaxRate.setSelected(cp.getBoolean("ShowTaxRate"));
        } else {
            this.showTaxRate.setSelected(false);
        }
        if (cp != null && cp.getCustomerParam("chkIsYearbonus") != null) {
            this.chkIsYearbonus.setSelected(cp.getBoolean("chkIsYearbonus"));
        } else {
            this.chkIsYearbonus.setSelected(false);
        }
        if (cp != null && cp.getCustomerParam("chkIsHaveOld") != null) {
            this.chkIsHaveOld.setSelected(cp.getBoolean("chkIsHaveOld"));
        } else {
            this.chkIsHaveOld.setSelected(false);
        }
        if (cp != null && cp.getCustomerParam("QueryByTaxRate") != null) {
            try {
                String value = cp.getCustomerParam("QueryByTaxRate");
                EntityViewInfo evi = new EntityViewInfo();
                String[] taxRateIDs = StringUtils.split((String)value, (String)"~");
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(taxRateIDs)), CompareType.INCLUDE));
                evi.setFilter(fi);
                TaxRateListCollection taxRateColl = TaxRateListFactory.getRemoteInstance().getTaxRateListCollection(evi);
                this.promTaxRateQuery.setData((Object)taxRateColl.toArray());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.promTaxRateQuery.setData(null);
        }
        this.fillAllItemList(this.colCmpItem, this.lstSelectItemData);
    }

    protected CmpItemCollection getCmpItemCollection(CmpSchemeInfo[] schemeInfos) throws Exception {
        this.lstAllItem.removeAllElements();
        if (schemeInfos == null || schemeInfos.length == 0) {
            return null;
        }
        ArrayList<String> schemeIDs = new ArrayList<String>();
        for (int i = 0; i < schemeInfos.length; ++i) {
            schemeIDs.add(schemeInfos[i].getId().toString());
        }
        this.colCmpItem = new CmpItemCollection();
        List cmpItemList = this.getSchemeItemBizInteface().getAllItemsByScheme(schemeIDs, this.getEntityViewInfo(schemeIDs));
        if (cmpItemList == null || cmpItemList.size() == 0) {
            return this.colCmpItem;
        }
        this.deletedItemSet = this.getSchemeItemBizInteface().getDeletedCmpItem(schemeIDs);
        CombinCmpItemInfo combinItemInfo = null;
        for (int i = 0; i < cmpItemList.size(); ++i) {
            combinItemInfo = (CombinCmpItemInfo)cmpItemList.get(i);
            combinItemInfo.getCmpItemInfo().put("collect_State", "1");
            this.colCmpItem.add(combinItemInfo.getCmpItemInfo());
        }
        return this.colCmpItem;
    }

    @Override
    protected EntityViewInfo getEntityViewInfo(List schemeIDs) {
        if (schemeIDs == null || schemeIDs.size() == 0) {
            return new EntityViewInfo();
        }
        HashSet set = new HashSet();
        set.addAll(schemeIDs);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.dataType", (Object)60));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER%", CompareType.NOTLIKE));
        filterInfo.setMaskString(" #0 and #1 and #2");
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    protected void fillAllItemList(CmpItemCollection colCmpItem, List lstSelectItemData) {
        this.lstAllItem.removeAllElements();
        if (colCmpItem == null || colCmpItem.size() <= 0) {
            return;
        }
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null) {
            return;
        }
        Iterator itr = colCmpItem.iterator();
        CmpItemInfo itemInfo = null;
        while (itr.hasNext()) {
            itemInfo = (CmpItemInfo)itr.next();
            if (itemInfo == null || itemInfo.getCmpItemCatalog() == null || !itemInfo.getCmpItemCatalog().getNumber().equals(infoCmpItemCatalog.getNumber())) continue;
            if (lstSelectItemData == null) {
                this.lstAllItem.addElement((Object)itemInfo);
                continue;
            }
            boolean blIsExist = false;
            int size = lstSelectItemData.size();
            for (int i = 0; i < size; ++i) {
                if (!((CmpItemInfo)lstSelectItemData.get(i)).getNumber().equals(itemInfo.getNumber())) continue;
                blIsExist = true;
                break;
            }
            if (blIsExist) continue;
            this.lstAllItem.addElement((Object)itemInfo);
        }
        this.lstAllItem.setSelectedIndex(0);
    }

    @Override
    public List getAllSelectItem() {
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return this.lstSelectItemData;
    }

    public CmpPeriodInfo getCmpPeriodInfo() {
        return (CmpPeriodInfo)this.prmtCmpPeriod.getData();
    }

    public String getUsePeriod() {
        return this.chkIsHaveOld.isSelected() ? "200803" : this.GetNowUsePeriod();
    }

    private String GetNowUsePeriod() {
        try {
            ITaxRateList taxRateFac = TaxRateListFactory.getRemoteInstance();
            String oql = "select * where enabled = 1";
            TaxRateListCollection taxRateCol = taxRateFac.getTaxRateListCollection(oql);
            if (taxRateCol != null && taxRateCol.size() > 0) {
                return taxRateCol.get(0).getString("usePeriod");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return "";
    }

    public boolean isShowTaxRate() {
        return this.showTaxRate.isSelected();
    }

    public boolean isYearbonus() {
        return this.chkIsYearbonus.isSelected();
    }

    public List getTaxRateList() {
        if (this.promTaxRateQuery.getData() == null) {
            return null;
        }
        Object[] objs = (Object[])this.promTaxRateQuery.getData();
        ArrayList<TaxRateListInfo> list = new ArrayList<TaxRateListInfo>();
        TaxRateListInfo rateInfo = null;
        for (int i = 0; i < objs.length; ++i) {
            rateInfo = (TaxRateListInfo)objs[i];
            if (rateInfo == null) continue;
            list.add(rateInfo);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public boolean isZeroItemValueNull() {
        return this.chkZeroItemDisplayNull.isSelected();
    }

    public HashMap getAllSchemeItems() {
        HashMap allMap = new HashMap();
        CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        if (info == null || info.length <= 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(info[i].getId().toString());
        }
        ArrayList<String> privateItems = new ArrayList<String>();
        int size2 = this.lstSelectItemData.size();
        for (int i = 0; i < size2; ++i) {
            privateItems.add(((CmpItemInfo)this.lstSelectItemData.get(i)).getNumber());
        }
        try {
            allMap = CmpReportFacadeFactory.getRemoteInstance().getItemsByScheme(lstSchemeIds, privateItems, this.chkIncDelItem.isSelected());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return allMap;
    }

    @Override
    protected void leftToRight() {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    protected void rightToLeft() {
        if (this.lstSelectItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement((Object)info);
            this.lstAllItem.addElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.promTaxRateQuery.setData(null);
        this.showTaxRate.setSelected(false);
        this.chkIsYearbonus.setSelected(false);
        this.chkIsHaveOld.setSelected(false);
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        cp.putBoolean("ShowTaxRate", this.showTaxRate.isSelected());
        cp.putBoolean("chkIsYearbonus", this.chkIsYearbonus.isSelected());
        cp.putBoolean("chkIsHaveOld", this.chkIsHaveOld.isSelected());
        if (this.promTaxRateQuery.getData() != null) {
            StringBuffer taxRateIDs = new StringBuffer();
            Object[] objs = (Object[])this.promTaxRateQuery.getData();
            TaxRateListInfo infoTem = null;
            int size = objs.length;
            for (int i = 0; i < size; ++i) {
                infoTem = (TaxRateListInfo)objs[i];
                if (i == 0) {
                    taxRateIDs.append(infoTem.getId().toString());
                    continue;
                }
                taxRateIDs.append("~" + infoTem.getId().toString());
            }
            cp.addCustomerParam("QueryByTaxRate", taxRateIDs.toString());
        }
        return cp;
    }

    @Override
    protected void reloadAllListByItemCatalog() {
        this.lstSelectItemData = this.getAllSelectItem();
        this.fillAllItemList(this.colCmpItem, this.lstSelectItemData);
        this.setUnenabledItem();
    }

    private Set getDefaultSelectItem() {
        HashSet<String> numSet = new HashSet<String>();
        numSet.add("FSAL007");
        numSet.add("FSAL027");
        numSet.add("FSAL029");
        numSet.add("FSAL014");
        numSet.add("FSAL041");
        return numSet;
    }

    private void fillDefaultSelectItem() {
        this.lstSelectItemData = new ArrayList();
        Set itemSet = this.getDefaultSelectItem();
        if (this.colCmpItem == null || this.colCmpItem.size() <= 0) {
            return;
        }
        CmpItemInfo itemInfo = null;
        for (int i = 0; i < this.colCmpItem.size(); ++i) {
            itemInfo = this.colCmpItem.get(i);
            if (!itemSet.contains(itemInfo.getNumber())) continue;
            if (!this.isFirstLoad) {
                this.lstSelectItem.addElement((Object)itemInfo);
            }
            this.lstSelectItemData.add(itemInfo);
        }
    }
}

