/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.view.KDPlainParagraph;
import com.kingdee.bos.ctrl.kdf.util.render.view.TextAreaViewUI;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class HrTextAreaRender
implements IBasicRender {
    private static Logger logger = Logger.getLogger(HrTextAreaRender.class);
    private JTextArea area = new JTextArea();
    protected boolean isBlackWhite = false;

    public HrTextAreaRender() {
        this.area.setUI((TextUI)new TextAreaViewUI());
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
    }

    public int getPerfHeight(int width, String value) {
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.area.setText(value);
        this.area.setSize(width, 10);
        return this.area.getPreferredSize().height;
    }

    private Rectangle getPaintBounds(Rectangle rect, Style style, View view) {
        Styles.VerticalAlignment va = style.getVerticalAlign();
        if (va == Styles.VerticalAlignment.TOP) {
            return rect;
        }
        float yspan = view.getPreferredSpan(1);
        if (va == Styles.VerticalAlignment.MIDDLE) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan) / 2.0f);
        } else if (va == Styles.VerticalAlignment.BOTTOM) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan));
        }
        return rect;
    }

    private View getView(Rectangle rect, String text, Style style) {
        View view = ((BasicTextAreaUI)this.area.getUI()).getRootView(this.area);
        this.area.setFont(style.getKDFont().getFont());
        Color fontColor = style.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            this.area.setForeground(fontColor);
        } else {
            this.area.setForeground(Color.BLACK);
        }
        this.area.setText(text);
        Styles.HorizontalAlignment ha = style.getHorizontalAlign();
        int align = ha == Styles.HorizontalAlignment.CENTER ? 1 : (ha == Styles.HorizontalAlignment.RIGHT ? 2 : 0);
        View boxView = view.getView(0);
        int size = boxView.getViewCount();
        for (int i = 0; i < size; ++i) {
            ((KDPlainParagraph)boxView.getView(i)).setHorizontalAlign(align);
        }
        view.setSize(rect.width, rect.height);
        return view;
    }

    public void draw(Graphics g, Shape clip, Object text, Style style) {
        Shape old = g.getClip();
        int height = 20;
        Rectangle rect = null;
        Rectangle cr = clip.getBounds();
        height = (int)this.getPreferredHeight(g, clip, (String)text, style);
        g.clipRect(cr.x, cr.y, cr.width, height);
        rect = new Rectangle(cr.x, cr.y, cr.width, height);
        View view = this.getView(rect, (String)text, style);
        rect = this.getPaintBounds(rect, style, view);
        view.paint(g, rect);
        g.setClip(old);
    }

    public float getPreferredHeight(Graphics g, Shape clip, String text, Style style) {
        return this.getView(clip.getBounds(), text, style).getPreferredSpan(1);
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.isBlackWhite;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final JTextArea area = new JTextArea();
        area.setUI((TextUI)new TextAreaViewUI());
        area.setComponentOrientation(ComponentOrientation.UNKNOWN);
        JButton btn = new JButton("dsfasdfasf");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info((Object)area.getPreferredSize());
                frame.pack();
            }
        });
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)btn, "North");
        frame.getContentPane().add((Component)area, "Center");
        area.setText("erqewr\ndsfsafsafsdfasffdgdssds");
        frame.pack();
        frame.setVisible(true);
    }
}

