/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.client.AbstractImportDateSalariatPointTableUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointSalariatGradeEditUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointTableUI;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ImportDateSalariatPointTableUI
extends AbstractImportDateSalariatPointTableUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportDateSalariatPointTableUI.class);
    private static final String RES = "com.kingdee.eas.hr.compensation.client.ImportDateEndDataResource";
    private HSSFWorkbook workbook;
    private int errorHandleStyle = 0;
    private int errorCount = 0;
    private int successCount = 0;
    private StringBuffer errorStr;
    private boolean isShowMsg = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenTen);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFifty);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenhundred);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
        this.txtFile.setEditable(false);
    }

    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        int i;
        Object EIEUI;
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName(EASResource.getString((String)RES, (String)"SALTABLE"));
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"can_not_update_open_file"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(wb);
        HSSFCellStyle cellStyle = this.createValueCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        int columnIndex = 0;
        HSSFRow headRow = sheet.createRow(0);
        LinkedHashMap colKeyName = (LinkedHashMap)this.getUIContext().get("colKeyName");
        for (Map.Entry entry : colKeyName.entrySet()) {
            if (entry.getKey() == null || columnIndex >= 256) continue;
            HSSFCell cell = headRow.createCell((int)((short)columnIndex));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(entry.getValue().toString());
            cell.setCellStyle(titleStyle);
            ++columnIndex;
        }
        HSSFCell cellNumber = null;
        KDTable tblMain = null;
        if (this.getUIContext().get("Owner") instanceof SalariatPointTableUI) {
            EIEUI = (SalariatPointTableUI)((Object)this.getUIContext().get("Owner"));
            tblMain = ((SalariatPointTableUI)((Object)EIEUI)).getTable();
        } else if (this.getUIContext().get("Owner") instanceof SalariatPointSalariatGradeEditUI) {
            EIEUI = (SalariatPointSalariatGradeEditUI)((Object)this.getUIContext().get("Owner"));
            tblMain = ((SalariatPointSalariatGradeEditUI)((Object)EIEUI)).getTable();
        }
        int j = 0;
        if (tblMain != null) {
            j = tblMain.getRowCount();
        }
        for (i = 0; i < j; ++i) {
            HSSFRow headRowNew = sheet.createRow(i + 1);
            int size = tblMain.getColumnCount();
            for (int ii = 0; ii < size; ++ii) {
                cellNumber = headRowNew.createCell((int)((short)ii));
                cellNumber.setCellType(CellType.STRING);
                if (tblMain.getCell(i, ii) == null || tblMain.getCell(i, ii).getValue() == null) continue;
                cellNumber.setCellValue(tblMain.getCell(i, ii).getValue().toString());
            }
        }
        this.createValueCellStyle(wb);
        for (i = 0; i < columnIndex; ++i) {
            sheet.setDefaultColumnStyle((int)((short)i), (CellStyle)cellStyle);
            sheet.setDefaultColumnWidth(20);
        }
        wb.setSheetName(0, EASResource.getString((String)RES, (String)"SAL"));
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"export_template_success"));
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        short size = 13;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        return titleStyle;
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
    }

    private boolean checkFile() {
        HSSFSheet sheet;
        int rowNum;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum)).getPhysicalNumberOfRows()) < 1) {
            return false;
        }
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        return true;
    }

    private boolean handError(String msg) {
        ++this.errorCount;
        this.errorStr.append(msg).append("\n");
        if (this.errorHandleStyle == 1) {
            this.showMsg();
            this.isShowMsg = true;
            return true;
        }
        if (this.errorHandleStyle == 2) {
            if (this.errorCount == 10) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 3) {
            if (this.errorCount == 50) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 4) {
            if (this.errorCount == 100) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        return false;
    }

    private void showMsg() {
        StringBuffer titleInfo = new StringBuffer();
        if (this.successCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"success_import")).append(this.successCount).append(EASResource.getString((String)RES, (String)"item")).append("\n");
        }
        if (this.errorCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"fail_import")).append(this.errorCount).append(EASResource.getString((String)RES, (String)"item"));
        }
        if (this.errorStr == null || this.errorStr.toString().trim().length() == 0) {
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            MsgBox.showInfo((Component)((Object)this), (String)titleInfo.toString());
        } else {
            titleInfo.append("\uff0c" + EASResource.getString((String)RES, (String)"PLEANSE_SEEDETAIL"));
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)titleInfo.toString(), (String)this.errorStr.toString(), (int)2);
        }
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_file"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String errorMsg;
        HSSFCell fCell;
        int currRowNum;
        Object EIEUI;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        KDTable tblMain = null;
        if (this.getUIContext().get("Owner") instanceof SalariatPointTableUI) {
            EIEUI = (SalariatPointTableUI)((Object)this.getUIContext().get("Owner"));
            tblMain = ((SalariatPointTableUI)((Object)EIEUI)).getTable();
        } else if (this.getUIContext().get("Owner") instanceof SalariatPointSalariatGradeEditUI) {
            EIEUI = (SalariatPointSalariatGradeEditUI)((Object)this.getUIContext().get("Owner"));
            tblMain = ((SalariatPointSalariatGradeEditUI)((Object)EIEUI)).getTable();
        }
        int sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        if (rowNum <= 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_file_is_null"));
            return;
        }
        ErrorHandleModeEnum mode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        this.errorHandleStyle = mode.getValue();
        this.errorCount = 0;
        this.errorStr = new StringBuffer();
        this.successCount = 0;
        HashMap<String, String> mapImportSalNum = new HashMap<String, String>();
        Pattern p = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        String at = EASResource.getString((String)RES, (String)"at");
        String line = EASResource.getString((String)RES, (String)"row");
        for (int i = 1; i < rowNum; ++i) {
            currRowNum = i + 1;
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                ++rowNum;
                continue;
            }
            fCell = row.getCell(0);
            String pNumber = ExcelUtil.getCellValue((HSSFCell)fCell);
            if (pNumber == null || pNumber.trim().length() == 0) {
                errorMsg = at + currRowNum + line + EASResource.getString((String)RES, (String)"SALNOTNULL");
                if (!this.handError(errorMsg)) continue;
                SysUtil.abort();
            }
            if (mapImportSalNum.containsKey(pNumber)) {
                errorMsg = HRResourceUtils.getMessage((String)RES, (String)"35_SALHAVE", (String[])new String[]{String.valueOf(currRowNum)});
                if (!this.handError(errorMsg)) continue;
                SysUtil.abort();
                continue;
            }
            mapImportSalNum.put(pNumber, pNumber);
        }
        rowNum = sheet.getPhysicalNumberOfRows();
        String val = null;
        boolean isSuss = false;
        for (int i = 1; i < rowNum; ++i) {
            currRowNum = i + 1;
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                ++rowNum;
                continue;
            }
            int size = tblMain.getColumnCount();
            for (int col = 0; col < size; ++col) {
                isSuss = false;
                fCell = row.getCell((int)((short)col));
                if (fCell == null) continue;
                if (tblMain.getRow(i - 1) == null) {
                    errorMsg = EASResource.getString((String)RES, (String)"SALNOTROW");
                    if (!this.handError(errorMsg)) break;
                    SysUtil.abort();
                }
                val = ExcelUtil.getCellValue((HSSFCell)fCell);
                if (col == 0 && tblMain.getCell(i - 1, col) != null) {
                    if (tblMain.getCell(i - 1, col).getValue() == null) break;
                    if (tblMain.getCell(i - 1, col).getValue() == null || val.equals(tblMain.getCell(i - 1, col).getValue().toString())) continue;
                    errorMsg = at + currRowNum + line + EASResource.getString((String)RES, (String)"SALNOTYIZ");
                    if (!this.handError(errorMsg)) break;
                    SysUtil.abort();
                    continue;
                }
                if (col == 0 || tblMain.getCell(i - 1, col) == null) continue;
                if (val == null || val.length() <= 0) {
                    tblMain.getCell(i - 1, col).setValue(null);
                    continue;
                }
                if (val != null && val.trim().length() > 0 && !p.matcher(val).matches()) {
                    errorMsg = at + currRowNum + line + EASResource.getString((String)RES, (String)"CMPITENISNOTDATA");
                    if (!this.handError(errorMsg)) break;
                    SysUtil.abort();
                }
                if (tblMain.getCell(i - 1, col) == null) continue;
                tblMain.getCell(i - 1, col).setValue((Object)new BigDecimal(val));
                isSuss = true;
            }
            if (!isSuss) continue;
            ++this.successCount;
        }
        if (this.errorHandleStyle == 5 || !this.isShowMsg) {
            this.showMsg();
        }
        this.getUIWindow().close();
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj = ImportDateSalariatPointTableUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = ImportDateSalariatPointTableUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }
}

