/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.PartJobFixedAdjustFactory;
import com.kingdee.eas.hr.compensation.client.AbstractPartJobFixedAdjustListUI;
import com.kingdee.eas.hr.compensation.client.PartJobFixedAdjustEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartJobFixedAdjustListUI
extends AbstractPartJobFixedAdjustListUI {
    private static final Logger logger = CoreUIObject.getLogger(PartJobFixedAdjustListUI.class);

    public PartJobFixedAdjustListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK orgPK = null;
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId());
        }
        return orgPK;
    }

    protected String getEditUIName() {
        return PartJobFixedAdjustEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PartJobFixedAdjustFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    private void intiCtl() {
        HRUtils.setFocusDir(this.tblMain, 0);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                PartJobFixedAdjustListUI.this.doSelectChanged(e);
            }
        });
    }

    private void doSelectChanged(KDTSelectEvent e) {
        IRow row;
        Object obj;
        int rowInd;
        KDTSelectBlock blk = e.getSelectBlock();
        if (blk != null && (rowInd = blk.getBeginRow()) >= 0 && (obj = (row = this.tblMain.getRow(rowInd)).getCell("adjSchemeState").getValue()) != null && obj instanceof BizEnumValueInfo) {
            BizEnumValueInfo info = (BizEnumValueInfo)obj;
            String state = (String)info.getValue();
            if (state.equals("10") || state.equals("70")) {
                this.wbtnAudit.setEnabled(true);
                this.menuItemApprove.setEnabled(true);
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                this.menuItemCancelAudit.setEnabled(false);
            } else {
                this.wbtnAudit.setEnabled(false);
                this.menuItemApprove.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.menuItemCancelAudit.setEnabled(true);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.intiCtl();
        this.actionAttachment.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionLocate.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionCancelAudit.setEnabled(true);
        this.wbtnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.wbtnAudit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.AUDIT"));
        this.wbtnAudit.setEnabled(true);
        this.btnAdjNameList.setIcon(EASResource.getIcon((String)"imgTbtn_organigerlist"));
        this.btnAdjNameList.setEnabled(true);
        this.menuItemApprove.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemCancelAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() != 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
            return;
        }
        KDTBlock block = (KDTBlock)blocks.get(0);
        String adjSchID = null;
        IRow row = this.tblMain.getRow(block.getTop());
        if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
            Object obj = row.getCell("id").getValue();
            adjSchID = (String)obj;
            try {
                PartJobFixedAdjustFactory.getRemoteInstance().checkEffectDate(BOSUuid.read((String)adjSchID));
            }
            catch (BOSException e1) {
                if (e1.getMessage().contains(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"699_PartJobFixedAdjustListUI"))) {
                    MsgBox.showInfo((String)e1.getMessage());
                    SysUtil.abort();
                }
                if (e1.getMessage().contains(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"700_PartJobFixedAdjustListUI"))) {
                    MsgBox.showInfo((String)e1.getMessage());
                    SysUtil.abort();
                }
                throw e1;
            }
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.CONFIRM_AUDIT")) == 2) {
            return;
        }
        PartJobFixedAdjustFactory.getRemoteInstance().audit(BOSUuid.read(adjSchID));
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selectIDs = this.getSelectedIdValues();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        HashMap value;
        super.actionCancelAudit_actionPerformed(e);
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() != 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
            return;
        }
        KDTBlock block = (KDTBlock)blocks.get(0);
        IRow row = this.tblMain.getRow(block.getTop());
        Object obj = null;
        if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
            obj = row.getCell("id").getValue();
        }
        String partJobFixedAdjustID = null;
        BizEnumValueInfo enable = (BizEnumValueInfo)HRTableTools.getTableSelectCellValue(this.tblMain, "adjSchemeState");
        if (obj == null || enable == null || enable.getInt() != 30) {
            return;
        }
        partJobFixedAdjustID = (String)obj;
        if (this.isAlreadyInAdjustScheme(partJobFixedAdjustID)) {
            SysUtil.abort();
        }
        if ((value = PartJobFixedAdjustFactory.getRemoteInstance().checkCanUnaudit(partJobFixedAdjustID)) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
        } else if (value.size() > 0) {
            String personNumber = "";
            String fixedNumber = "";
            Iterator iter = value.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry entry = iter.next();
                personNumber = entry.getKey().toString();
                fixedNumber = entry.getValue().toString();
            }
            String msg = "" + HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"28_FIXED_CANUNAUDIT_FAIL", (String[])new String[]{personNumber, fixedNumber});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        PartJobFixedAdjustFactory.getRemoteInstance().cancelAudit(partJobFixedAdjustID);
        this.actionRefresh_actionPerformed(e);
    }

    private boolean isAlreadyInAdjustScheme(String partJobFixedAdjustID) throws EASBizException, BOSException {
        HashMap mapAlreadyInAdjustScheme = PartJobFixedAdjustFactory.getRemoteInstance().getAlreadyInPartJobFixedA(null, partJobFixedAdjustID);
        if (mapAlreadyInAdjustScheme == null || mapAlreadyInAdjustScheme.size() <= 0) {
            return false;
        }
        String strAlreadyInAdjustScheme = null;
        String strPersonId2 = null;
        for (String strPersonId2 : mapAlreadyInAdjustScheme.keySet()) {
            if (!StringUtils.isEmpty(strAlreadyInAdjustScheme)) {
                strAlreadyInAdjustScheme = strAlreadyInAdjustScheme + ",";
                strAlreadyInAdjustScheme = strAlreadyInAdjustScheme + mapAlreadyInAdjustScheme.get(strPersonId2).toString();
                continue;
            }
            strAlreadyInAdjustScheme = mapAlreadyInAdjustScheme.get(strPersonId2).toString();
        }
        MsgBox.showInfo((String)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"29_PART_ADJ_REPEAT_PER_UNAUDTI", (String[])new String[]{strAlreadyInAdjustScheme}));
        return true;
    }

    @Override
    public void actionAdjNameList_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() != 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
            return;
        }
        ArrayList<String> lstAdjSchNumList = new ArrayList<String>();
        KDTSelectBlock sb = null;
        String adjSchNum = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int j = 0;
            int bottom = 0;
            if (sb.getMode() == 8 || sb.getMode() == 4) {
                j = 0;
                bottom = this.tblMain.getRowCount();
            } else {
                j = sb.getTop();
                bottom = sb.getBottom() + 1;
            }
            while (j < bottom) {
                adjSchNum = this.tblMain.getRow(j).getCell("number").getValue().toString();
                lstAdjSchNumList.add(adjSchNum);
                ++j;
            }
        }
        if (lstAdjSchNumList.size() <= 0) {
            return;
        }
        Map ctx = this.getUIContext();
        ctx.put("number", lstAdjSchNumList);
        IUIWindow adjEditUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.hr.compensation.client.PartJobFixedAdjustReportUI", ctx, null, OprtState.VIEW);
        adjEditUI.show();
    }
}

