/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.client.AbstractPartJobFixedAdjustReportFilter;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PartJobFixedAdjustReportFilter
extends AbstractPartJobFixedAdjustReportFilter {
    private static final Logger logger = CoreUIObject.getLogger(PartJobFixedAdjustReportFilter.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource.";
    private String cmpAdjustiveSchBasicURL = "com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.";
    private final String ALLLISTITEM_CP = "allListItem";
    private final String LSTSELECTITEM_CP = "lstSelectItem";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public String getFixedCmpItemNum() {
        List lstFixedCmpItem = this.getListSelectItem();
        CmpItemInfo info = null;
        String numbers = "";
        int n = lstFixedCmpItem.size();
        for (int i = 0; i < n; ++i) {
            info = (CmpItemInfo)lstFixedCmpItem.get(i);
            numbers = i == 0 ? info.getNumber() : numbers + "," + info.getNumber();
        }
        return numbers;
    }

    public void clear() {
        super.clear();
        this.btnCmpDate.setSelected(true);
        this.pkBeginDate.setValue((Object)new java.util.Date());
        this.pkEndDate.setValue((Object)new java.util.Date());
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        try {
            CmpItemCollection itemCol = this.getCmpItemCollection();
            this.fillCmpItem(itemCol);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    private void fillCmpItem(CmpItemCollection itemCol) {
        Iterator itemIterator = itemCol.iterator();
        while (itemIterator.hasNext()) {
            CmpItemInfo fixItem = (CmpItemInfo)itemIterator.next();
            this.lstAllItem.addElement((Object)fixItem);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putDate("beginDate", (java.util.Date)this.pkBeginDate.getSqlDate());
        cp.putDate("endDate", (java.util.Date)this.pkEndDate.getSqlDate());
        cp.addCustomerParam("btnCmpDate", String.valueOf(this.btnCmpDate.isSelected()));
        cp.addCustomerParam("btnEnableDate", String.valueOf(this.btnEnableDate.isSelected()));
        cp.addCustomerParam(this.ALLLISTITEM_CP, this.allListStr());
        cp.addCustomerParam(this.LSTSELECTITEM_CP, this.selectListStr());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("btnCmpDate") != null) {
            this.btnCmpDate.setSelected(Boolean.valueOf(cp.getCustomerParam("btnCmpDate")).booleanValue());
        }
        if (cp.getCustomerParam("btnEnableDate") != null) {
            this.btnEnableDate.setSelected(Boolean.valueOf(cp.getCustomerParam("btnEnableDate")).booleanValue());
        }
        if (cp.getCustomerParam("beginDate") != null) {
            this.pkBeginDate.setValue((Object)cp.getDate("beginDate"));
        }
        if (cp.getCustomerParam("endDate") != null) {
            this.pkEndDate.setValue((Object)cp.getDate("endDate"));
        }
        String allListStr = cp.getCustomerParam(this.ALLLISTITEM_CP);
        this.setAllItem(allListStr);
        String ids = cp.getCustomerParam(this.LSTSELECTITEM_CP);
        this.setLstSelectItem(ids);
    }

    public boolean verify() {
        boolean flagOfDate = false;
        boolean flagOfDateTemp = false;
        Date beginDate = this.pkBeginDate.getSqlDate();
        Date endDate = this.pkEndDate.getSqlDate();
        if (beginDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "NEED_DATE")));
            return false;
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "NEED_DATE")));
            return false;
        }
        flagOfDateTemp = DateTimeUtils.dayEquals((java.util.Date)endDate, (java.util.Date)beginDate);
        if (!flagOfDateTemp) {
            flagOfDate = DateTimeUtils.dayAfter((java.util.Date)endDate, (java.util.Date)beginDate);
            if (!flagOfDate) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "BEGINDATE_AFTER_ENDDATE")));
                this.pkEndDate.requestFocusInWindow();
            }
        } else {
            flagOfDate = true;
        }
        if (this.lstSelectItem.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MSG_CHOOSE_FIXED_CMPITEM")));
            this.lstAllItem.requestFocusInWindow();
            return false;
        }
        return flagOfDate;
    }

    public List getListSelectItem() {
        ArrayList<CmpItemInfo> listSelectList = new ArrayList<CmpItemInfo>();
        int countListSelectItem = this.lstSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                listSelectList.add(i, info);
            }
        }
        return listSelectList;
    }

    private CmpItemCollection getCmpItemCollection() throws Exception {
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        String fixcmpHrOrgId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        StringBuffer sql = new StringBuffer("SELECT DISTINCT T1.FNumber ");
        sql.append("FROM T_HR_CMPITEM T1 ");
        sql.append("INNER JOIN T_HR_FixedCmpSchemeItem T2 ON T1.FID = T2.FCmpItemID ");
        sql.append("INNER JOIN T_HR_FixedCmpScheme T3 ON T3.FID = T2.FFixedCmpSchemeID ");
        sql.append("WHERE T3.FHrOrgUnitID IN ('" + fixcmpHrOrgId + "')");
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)fixcmpHrOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1");
        env.setFilter(filterInfo);
        cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(env);
        return cmpItemColl;
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
        }
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            this.lstAllItem.addElement((Object)info);
            this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
        }
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    private String allListStr() {
        String allListArray = "";
        int allListItemSize = this.lstAllItem.getElementCount();
        int controlInt = allListItemSize - 1;
        for (int i = 0; i < allListItemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstAllItem.getElement(i);
            allListArray = allListArray + cmpItemInfo.getId().toString();
            if (i == controlInt) continue;
            allListArray = allListArray + "~";
        }
        return allListArray;
    }

    private String selectListStr() {
        ArrayList<Object> lstSelectItemData = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return HRCommonQueryUtils.getSelectedItemIDS(lstSelectItemData);
    }

    private void setAllItem(String allListStr) {
        this.lstAllItem.removeAllElements();
        if (allListStr != null) {
            String[] allListStrArray = allListStr.split("~");
            int arrayInt = allListStrArray.length;
            HashSet<String> keySet = new HashSet<String>();
            for (int i = 0; i < arrayInt; ++i) {
                keySet.add(allListStrArray[i]);
            }
            EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
            FilterInfo fitlerInfoTmp = new FilterInfo();
            fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            entityViewInfoTmp.setFilter(fitlerInfoTmp);
            try {
                CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
                int catalogSize = cmpItemColl.size();
                for (int i = 0; i < catalogSize; ++i) {
                    CmpItemInfo cmpItemInfo = cmpItemColl.get(i);
                    this.lstAllItem.addElement((Object)cmpItemInfo);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void setLstSelectItem(String ids) {
        if (ids != null && !"".equals(ids)) {
            try {
                List lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, "~");
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }
}

