/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemCollection;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemInfo;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatPointGradeTableUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SalariatPointGradeTableUI
extends AbstractSalariatPointGradeTableUI {
    private static Logger logger = Logger.getLogger(SalariatPointGradeTableUI.class);
    private String schemeID = null;
    private SalariatSchemeInfo schemeInfo = null;
    private List columnNames = null;
    private List pointColumnNames = null;
    private List itemColumnNames = null;
    private Map newColumnTypes = null;
    private SalariatHiberPropsCollection pointList = null;
    private SalariatMapPersonItemCollection mapPersonList = null;
    private boolean isChanged = false;
    private boolean isEditStopped = false;
    private int rowIndex = -1;
    private LocateAssistant locateAssisant;
    private KDTSortManager sm = null;
    private Map enumMap = new HashMap();

    public SalariatPointGradeTableUI() throws Exception {
        this.kdMainTbl.addKDTEditListener((KDTEditListener)new CellEditAdapter());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        ArrayList valueMapList = new ArrayList();
        HashMap<String, Object> valueMap = null;
        IRow row = null;
        ICell cell = null;
        HashMap<String, Object> personItemMap = null;
        int rowCount = this.kdMainTbl.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int j;
            row = this.kdMainTbl.getRow(i);
            valueMap = new HashMap<String, Object>();
            personItemMap = new HashMap<String, Object>();
            Object cellValue = null;
            int size = this.itemColumnNames.size();
            for (j = 0; j < size; ++j) {
                String columnName = this.itemColumnNames.get(j).toString();
                cell = row.getCell(columnName);
                cellValue = cell.getValue();
                Object columnType = this.newColumnTypes.get(columnName);
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    IntEnum enum0;
                    if (cellValue instanceof IntEnum) {
                        enum0 = (IntEnum)cellValue;
                        personItemMap.put(columnName, enum0.getValue());
                        continue;
                    }
                    if (!(cellValue instanceof StringEnum)) continue;
                    enum0 = (StringEnum)cellValue;
                    personItemMap.put(columnName, enum0.getValue());
                    continue;
                }
                if (cellValue != null && cellValue instanceof CoreBaseInfo) {
                    personItemMap.put(columnName, ((CoreBaseInfo)cellValue).getId().toString());
                    continue;
                }
                personItemMap.put(columnName, cellValue);
            }
            valueMap.put("map_person", personItemMap);
            size = this.pointColumnNames.size();
            for (j = 0; j < size; ++j) {
                cell = row.getCell(this.pointColumnNames.get(j).toString());
                cellValue = cell.getValue();
                if (cellValue != null && cellValue instanceof CoreBaseInfo) {
                    valueMap.put(this.pointColumnNames.get(j).toString(), ((CoreBaseInfo)cellValue).getId().toString());
                    continue;
                }
                valueMap.put(this.pointColumnNames.get(j).toString(), cellValue);
            }
            valueMapList.add(valueMap);
        }
        try {
            ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)this.schemeID));
            IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)this.schemeInfo.getBOSType(), (IObjectPK)schemePK, (String)this.schemeInfo.getName(), (String)"salaritsch_grand_update");
            SalariatSchemeFacadeFactory.getRemoteInstance().saveListGradeData(this.schemeID, this.schemeInfo.getGradeTableName(), this.pointColumnNames, valueMapList, null);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            MsgBox.showInfo((String)HRUtils.getSalariatResourceStr("SAVE_SUCCESS"));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean verifyDataNew() throws Exception {
        int i;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        int rowCount = this.kdMainTbl.getRowCount();
        int colCount = this.kdMainTbl.getColumnCount();
        IRow row = null;
        ICell cell = null;
        for (i = 0; i < colCount; ++i) {
            Component comp;
            IColumn col = this.kdMainTbl.getColumn(i);
            ICellEditor editor = col.getEditor();
            if (editor == null || (comp = editor.getComponent()) == null || !(comp instanceof KDBizPromptBox)) continue;
            for (int j = 0; j < rowCount; ++j) {
                ICell cel = this.kdMainTbl.getCell(j, i);
                Object obj = cel.getValue();
                if (obj == null || obj instanceof CoreBaseInfo) continue;
                MsgBox.showError((String)HRUtils.getSalariatResourceStr("F7_EDIT_ILLEGAL"));
                this.kdMainTbl.getEditManager().editCellAt(j, i);
                return false;
            }
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.kdMainTbl.getRow(i);
            StringBuffer newKey = new StringBuffer();
            int size = this.itemColumnNames.size();
            for (int j = 0; j < size; ++j) {
                cell = row.getCell(this.itemColumnNames.get(j).toString());
                Object cellValue = cell.getValue();
                if (cellValue == null) continue;
                Object columnType = this.newColumnTypes.get(this.itemColumnNames.get(j).toString());
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    DataBaseInfo info = (DataBaseInfo)cellValue;
                    newKey.append(info.getId().toString());
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    IntEnum enum0;
                    if (cellValue instanceof IntEnum) {
                        enum0 = (IntEnum)cellValue;
                        newKey.append(enum0.getValue());
                        continue;
                    }
                    if (!(cellValue instanceof StringEnum)) continue;
                    enum0 = (StringEnum)cellValue;
                    newKey.append(enum0.getValue());
                    continue;
                }
                newKey.append(cellValue);
            }
            if (newKey.toString().equals("")) {
                MsgBox.showError((String)MessageFormat.format(HRUtils.getSalariatResourceStr("GRADETABLE_MISS_PERSONITEM"), i + 1));
                this.kdMainTbl.getSelectManager().removeAll(false);
                this.kdMainTbl.getEditManager().editCellAt(row.getRowIndex(), this.kdMainTbl.getColumnIndex(this.itemColumnNames.get(0).toString()));
                return false;
            }
            keyMap.put(newKey.toString(), "");
            if (keyMap.size() == i + 1) continue;
            MsgBox.showError((String)MessageFormat.format(HRUtils.getSalariatResourceStr("GRADETABLE_MUTIL_PERSIONITEM"), i + 1));
            this.kdMainTbl.getSelectManager().removeAll(false);
            this.kdMainTbl.getEditManager().editCellAt(row.getRowIndex(), this.kdMainTbl.getColumnIndex(this.itemColumnNames.get(0).toString()));
            return false;
        }
        return true;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRemoveLine.setText(null);
        this.btnInsertLine.setText(null);
        this.btnAddNewLine.setText(null);
        this.ctnMain.addButton((JButton)this.btnAddNewLine);
        this.ctnMain.addButton((JButton)this.btnInsertLine);
        this.ctnMain.addButton((JButton)this.btnRemoveLine);
    }

    private void setOperateState(boolean state) {
        if (state) {
            this.btnAddNewLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnSave.setEnabled(true);
        } else {
            this.btnAddNewLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnSave.setEnabled(false);
        }
        this.btnLocate.setEnabled(true);
    }

    public void onLoad() throws Exception {
        int i;
        super.onLoad();
        this.columnNames = new ArrayList();
        this.pointColumnNames = new ArrayList();
        this.itemColumnNames = new ArrayList();
        this.newColumnTypes = new HashMap();
        this.schemeID = (String)this.getUIContext().get("ID");
        ISalariatScheme iBiz = SalariatSchemeFactory.getRemoteInstance();
        ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)this.schemeID));
        this.schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)schemePK);
        boolean state = false;
        if (StateEnum.ENABLE.equals((Object)this.schemeInfo.getState())) {
            state = true;
        }
        this.setOperateState(state);
        this.pointList = HRUtils.getPointItemsByScheme(this.schemeID);
        this.mapPersonList = HRUtils.getMapPersonItemsByScheme(this.schemeID);
        CmpItemCollection personItems = HRUtils.getPersonItemsByScheme(this.schemeID);
        SalariatPointPropsCollection pointGrades = HRUtils.getPointGradeItemsByScheme(this.schemeID);
        DynamicTableInfo dynTableInfo = new DynamicTableInfo();
        dynTableInfo.setName(this.schemeInfo.getGradeTableName());
        int countColumn = personItems.size() + pointGrades.size();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        HRCmpItemUtils.addF7InfoToCmpItem(personItems);
        int j = 0;
        String value = null;
        boolean existOrgName = false;
        boolean existOrgLongName = false;
        for (i = 0; i < personItems.size(); ++i) {
            value = personItems.get(i).getNumber();
            if ("FPER005".equals(value)) {
                existOrgName = true;
            }
            if (!"FPER003".equals(value)) continue;
            existOrgLongName = true;
        }
        i = 0;
        while (i < personItems.size()) {
            ObjectValueRender avr;
            KDBizPromptBox bizPromptPosi;
            AdminF7 adminOrg;
            infosColumn[j] = new DynamicTableInfo.ColumnInfo(personItems.get(i));
            value = personItems.get(i).getNumber();
            this.columnNames.add(value);
            if (infosColumn[j].getObjectType() != null) {
                this.newColumnTypes.put(value, infosColumn[j].getObjectType());
                if (ItemObjectTypeEnum.ENUM.equals((Object)infosColumn[j].getObjectType())) {
                    this.enumMap.put(value, infosColumn[j].getDefaultObj());
                }
            } else {
                this.newColumnTypes.put(value, personItems.get(i).getDataType());
            }
            this.itemColumnNames.add(value);
            if ("FPER006".equals(value)) {
                PositionPromptBox2 positionSe = new PositionPromptBox2();
                HashSet<String> hrSet = new HashSet<String>();
                hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                positionSe.setHROFilter(hrSet);
                KDBizPromptBox bizPromptPosi2 = new KDBizPromptBox();
                bizPromptPosi2.setSelector((KDPromptSelector)positionSe);
                bizPromptPosi2.setEditable(false);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi2));
            }
            if ("FPER003".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$displayName$");
                bizPromptPosi.setEditFormat("$displayName$");
                bizPromptPosi.setEditable(false);
                if (existOrgLongName && existOrgName) {
                    bizPromptPosi.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            OrgUnitInfo adminOrg = (OrgUnitInfo)eventObj.getNewValue();
                            IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            cell.setValue((Object)adminOrg);
                        }
                    });
                }
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$displayName$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER004".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$number$");
                bizPromptPosi.setEditFormat("$number$");
                bizPromptPosi.setEditable(false);
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER002".equals(value)) {
                PersonPromptBox personBox = new PersonPromptBox();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)personBox);
                bizPromptPosi.setDisplayFormat("$number$");
                bizPromptPosi.setEditFormat("$number$");
                bizPromptPosi.setEditable(false);
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER005".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$name$");
                bizPromptPosi.setEditFormat("$name$");
                bizPromptPosi.setEditable(false);
                if (existOrgLongName && existOrgName) {
                    bizPromptPosi.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            OrgUnitInfo adminOrg = (OrgUnitInfo)eventObj.getNewValue();
                            IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER003");
                            cell.setValue((Object)adminOrg);
                        }
                    });
                }
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            ++i;
            ++j;
        }
        i = 0;
        while (i < pointGrades.size()) {
            DynamicTableInfo.ColumnInfo columnInfo = new DynamicTableInfo.ColumnInfo();
            SalariatPointPropsInfo grade = pointGrades.get(i);
            String seqStr = null;
            if (!StringUtils.isEmpty((String)pointGrades.get(i).getNumber())) {
                seqStr = pointGrades.get(i).getNumber().substring(9);
                int currMaxSeq = Integer.parseInt(seqStr);
                value = "FPointID_" + currMaxSeq;
                columnInfo.setHide(false);
                columnInfo.setReadOnly(false);
                columnInfo.setKey(value);
                columnInfo.setColumnNumber(value);
                columnInfo.setColumnName(value);
                this.columnNames.add(value);
                this.pointColumnNames.add(value);
                this.newColumnTypes.put(value, ItemObjectTypeEnum.BIZOBJECT);
                columnInfo.setColumnType(10);
                columnInfo.setObjectType(ItemObjectTypeEnum.BIZOBJECT);
                columnInfo.setDefaultObj("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
                columnInfo.setCellEditorByObjtype();
                columnInfo.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
                columnInfo.getInfosHead()[0].setHeadName(grade.getName());
                infosColumn[j] = columnInfo;
            }
            ++i;
            ++j;
        }
        this.doWithF7(personItems, infosColumn);
        dynTableInfo.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead(this.kdMainTbl, dynTableInfo);
        String key = null;
        for (int i2 = 0; i2 < this.kdMainTbl.getColumnCount(); ++i2) {
            key = this.kdMainTbl.getColumnKey(i2);
            if (!"FPER004".equals(key) && !"FPER002".equals(key)) continue;
            this.kdMainTbl.getColumn(i2).getStyleAttributes().setNumberFormat("");
        }
        if (this.schemeInfo.getPointTableName() != null) {
            try {
                IRowSet rowSet = SalariatSchemeFacadeFactory.getRemoteInstance().getListGradeData(this.schemeInfo.getGradeTableName());
                this.loadTableData(rowSet);
            }
            catch (Exception ex) {
                this.handleException((Exception)((Object)new SalariatException(SalariatException.ERROR_LOAD_POINTDATA, ex)));
            }
        }
        this.kdMainTbl.setColumnMoveable(false);
        HRUtils.removeLintMenu(this.kdMainTbl, this.getMenuManager(this.kdMainTbl));
        this.kdMainTbl.getStyleAttributes().setLocked(!state);
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdMainTbl, 0, this.kdMainTbl.getRowCount() - 1, new KDTSortManager(this.kdMainTbl));
    }

    private void loadTableData(IRowSet rs) throws Exception {
        if (rs == null) {
            return;
        }
        IRow row = null;
        while (rs.next()) {
            int i;
            row = this.kdMainTbl.addRow();
            String mapPersonID = rs.getString("FPersonMapID");
            SalariatMapPersonItemInfo mapPersonInfo = this.getMapPersonItemsByID(mapPersonID);
            if (mapPersonInfo != null) {
                int size = this.itemColumnNames.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String columnKey = (String)this.itemColumnNames.get(i2);
                    Object obj = mapPersonInfo.get(columnKey);
                    if (columnKey.equals("FPER010")) {
                        int enumValue = (Integer)obj;
                        row.getCell(columnKey).setValue((Object)Genders.getEnum((int)enumValue));
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        BigDecimal bigValue = ((BigDecimal)obj).setScale(2);
                        row.getCell(columnKey).setValue((Object)bigValue);
                        continue;
                    }
                    row.getCell(columnKey).setValue(obj);
                }
            }
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            String perItemNumber = null;
            int size = this.itemColumnNames.size();
            for (i = 0; i < size; ++i) {
                perItemNumber = this.itemColumnNames.get(i).toString();
                Object personItemIDValue = rs.getObject(perItemNumber);
                Object columnType = this.newColumnTypes.get(perItemNumber);
                if (personItemIDValue == null) continue;
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT) || "FPER003".equals(perItemNumber)) {
                    BOSUuid id = BOSUuid.read((String)personItemIDValue.toString());
                    IObjectValue valueObject = iDynamicObject.getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
                    row.getCell(perItemNumber).setValue((Object)valueObject);
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    row.getCell(perItemNumber).setValue(this.getEnumFromClassName(perItemNumber, personItemIDValue.toString()));
                    continue;
                }
                if (row.getCell(perItemNumber).getStyleAttributes().getNumberFormat() != null && row.getCell(perItemNumber).getStyleAttributes().getNumberFormat().toLowerCase().matches(".*yyyy.*")) {
                    row.getCell(perItemNumber).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
                }
                row.getCell(perItemNumber).setValue(personItemIDValue);
            }
            size = this.pointColumnNames.size();
            for (i = 0; i < size; ++i) {
                String pointID = rs.getString((String)this.pointColumnNames.get(i));
                row.getCell((String)this.pointColumnNames.get(i)).setValue((Object)this.getPointInfoByID(pointID));
            }
        }
    }

    private SalariatHiberPropsInfo getPointInfoByID(String id) {
        if (id == null) {
            return null;
        }
        SalariatHiberPropsInfo info = null;
        for (int i = 0; i < this.pointList.size(); ++i) {
            if (!id.equals(this.pointList.get(i).getId().toString())) continue;
            info = this.pointList.get(i);
            return info;
        }
        return info;
    }

    private SalariatMapPersonItemInfo getMapPersonItemsByID(String id) {
        if (id == null) {
            return null;
        }
        SalariatMapPersonItemInfo info = null;
        for (int i = 0; i < this.mapPersonList.size(); ++i) {
            if (!id.equals(this.mapPersonList.get(i).getId().toString())) continue;
            info = this.mapPersonList.get(i);
            return info;
        }
        return info;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        CmpItemCollection cmpItems1 = HRUtils.getPersonItemsBySchem(null, this.schemeID);
        CmpItemCollection cmpItess2 = HRUtils.getCmpItemCollection();
        if (cmpItess2.size() == 0) {
            throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(0).getNumber()});
        }
        if (cmpItems1.size() > 0) {
            int j = cmpItems1.size();
            for (int i = 0; i < j; ++i) {
                if (cmpItess2.contains(cmpItems1.get(i))) continue;
                throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(i).getNumber()});
            }
        }
        if (this.verifyDataNew()) {
            this.storeFields();
        }
        this.isChanged = false;
    }

    @Override
    public void actionAddnew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddnew_actionPerformed(e);
        this.kdMainTbl.addRow();
        this.isChanged = true;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.kdMainTbl.removeRow(activeIndex);
        this.isChanged = true;
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdMainTbl, 0, this.kdMainTbl.getRowCount() - 1, this.getKDSortManger());
        if (this.kdMainTbl.getRowCount() <= 1) {
            this.getKDSortManger().setSortAuto(true);
            this.getKDSortManger().clearGroup();
            if (this.kdMainTbl.getRowCount() > 0) {
                this.getKDSortManger().addGroup(0, 0);
            }
        }
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.kdMainTbl);
        }
        return this.sm;
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.kdMainTbl.addRow(activeIndex);
        this.isChanged = true;
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            if (!HRUtils.isPermissionByKey("salariatGrade_maintain")) {
                this.isChanged = false;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (!this.isChanged) {
            return super.checkBeforeWindowClosing();
        }
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
        if (result == 0) {
            try {
                if (!this.isEditStopped) {
                    this.kdMainTbl.getEditManager().stopEditing();
                }
                this.actionSave_actionPerformed(new ActionEvent(this.btnSave, 0, "Click SaveButton"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            return result != 2;
        }
        return super.checkBeforeWindowClosing();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.kdMainTbl;
    }

    private Object getEnumFromClassName(String itemNumber, String value) throws Exception {
        String enumClassName = (String)this.enumMap.get(itemNumber);
        if (enumClassName != null) {
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(enumClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)ex.getMessage());
                return value;
            }
            if (enumClass.getSuperclass().equals(IntEnum.class)) {
                return EnumUtils.getEnum(enumClass, (int)Integer.parseInt(value));
            }
            return EnumUtils.getEnumByValue(enumClass, (String)value);
        }
        return value;
    }

    private void doWithF7(CmpItemCollection personItems, DynamicTableInfo.ColumnInfo[] infosColumn) {
        String value = null;
        boolean existPostion = false;
        boolean existOrgName = false;
        boolean existOrgLongName = false;
        for (int i = 0; i < personItems.size(); ++i) {
            value = personItems.get(i).getNumber();
            if ("FPER006".equals(value)) {
                existPostion = true;
            }
            if ("FPER005".equals(value)) {
                existOrgName = true;
            }
            if (!"FPER003".equals(value)) continue;
            existOrgLongName = true;
        }
        if (existPostion && existOrgName && !existOrgLongName) {
            this.kdMainTbl.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointGradeTableUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointGradeTableUI.this.getOprtState())) {
                            SalariatPointGradeTableUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            int colIndex = SalariatPointGradeTableUI.this.kdMainTbl.getColumnIndex("FPER006");
                            IColumn column = SalariatPointGradeTableUI.this.kdMainTbl.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointGradeTableUI.this.handUIException(e1);
                    }
                }
            });
        } else if (existPostion && existOrgLongName && !existOrgName) {
            this.kdMainTbl.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointGradeTableUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointGradeTableUI.this.getOprtState())) {
                            SalariatPointGradeTableUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER003");
                            int colIndex = SalariatPointGradeTableUI.this.kdMainTbl.getColumnIndex("FPER006");
                            IColumn column = SalariatPointGradeTableUI.this.kdMainTbl.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointGradeTableUI.this.handUIException(e1);
                    }
                }
            });
        } else if (existPostion && existOrgLongName && existOrgName) {
            this.kdMainTbl.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointGradeTableUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointGradeTableUI.this.getOprtState())) {
                            SalariatPointGradeTableUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            int colIndex = SalariatPointGradeTableUI.this.kdMainTbl.getColumnIndex("FPER006");
                            IColumn column = SalariatPointGradeTableUI.this.kdMainTbl.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                    cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointGradeTableUI.this.kdMainTbl.getRow(SalariatPointGradeTableUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                    cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointGradeTableUI.this.handUIException(e1);
                    }
                }
            });
        } else if (!existPostion && existOrgLongName && existOrgName) {
            this.kdMainTbl.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointGradeTableUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointGradeTableUI.this.getOprtState())) {
                            SalariatPointGradeTableUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointGradeTableUI.this.handUIException(e1);
                    }
                }
            });
        }
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssisant == null) {
            this.locateAssisant = new LocateAssistant((CoreUIObject)this, this.kdMainTbl, this.getLocateNames());
        }
        this.locateAssisant.actionLocate();
    }

    protected String[] getLocateNames() {
        if (this.itemColumnNames.size() <= 0) {
            return null;
        }
        String[] itemColNames = new String[this.itemColumnNames.size()];
        int j = this.itemColumnNames.size();
        for (int i = 0; i < j; ++i) {
            itemColNames[i] = this.itemColumnNames.get(i).toString();
        }
        return itemColNames;
    }

    @Override
    protected void kdMainTbl_editStopped(KDTEditEvent e) throws Exception {
        int i;
        int size;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if ("FPER001".equals(this.kdMainTbl.getColumnKey(colIndex))) {
            String perNum = null;
            size = this.kdMainTbl.getColumnCount();
            for (i = 0; i < size; ++i) {
                if (!"FPER002".equals(this.kdMainTbl.getColumnKey(i))) continue;
                perNum = this.kdMainTbl.getColumnKey(i);
                break;
            }
            if (!StringUtils.isEmpty(perNum) && this.kdMainTbl.getCell(rowIndex, colIndex).getValue() != null) {
                PersonInfo pInfo = (PersonInfo)this.kdMainTbl.getCell(rowIndex, colIndex).getValue();
                this.kdMainTbl.getCell(rowIndex, perNum).setValue((Object)pInfo);
            }
        }
        if ("FPER002".equals(this.kdMainTbl.getColumnKey(colIndex))) {
            String perName = null;
            size = this.kdMainTbl.getColumnCount();
            for (i = 0; i < size; ++i) {
                if (!"FPER001".equals(this.kdMainTbl.getColumnKey(i))) continue;
                perName = this.kdMainTbl.getColumnKey(i);
                break;
            }
            if (!StringUtils.isEmpty(perName) && this.kdMainTbl.getCell(rowIndex, colIndex).getValue() != null) {
                PersonInfo pInfo = (PersonInfo)this.kdMainTbl.getCell(rowIndex, colIndex).getValue();
                this.kdMainTbl.getCell(rowIndex, perName).setValue((Object)pInfo);
            }
        }
    }

    class CellEditAdapter
    extends KDTEditAdapter {
        CellEditAdapter() {
        }

        public void editStarting(KDTEditEvent e) {
            ICellEditor editor;
            Component component;
            super.editStarting(e);
            KDTable table = (KDTable)e.getSource();
            int colIndex = e.getColIndex();
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().length() >= "FPointID".length() && column.getKey().substring(0, "FPointID".length()).equals("FPointID") && (component = (editor = table.getEditManager().getEditor()).getComponent()) instanceof KDBizPromptBox) {
                KDBizPromptBox kdBiz = (KDBizPromptBox)component;
                SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)kdBiz.getSelector();
                pointPromtBox.putParameter("schemeID", SalariatPointGradeTableUI.this.schemeID);
                pointPromtBox.putParameter((Object)"Owner", SalariatPointGradeTableUI.this.getUIContext().get("Owner"));
            }
            SalariatPointGradeTableUI.this.isChanged = true;
            SalariatPointGradeTableUI.this.isEditStopped = false;
        }

        public void editStopped(KDTEditEvent e) {
            super.editStopped(e);
            SalariatPointGradeTableUI.this.isEditStopped = true;
        }

        public void editValueChanged(KDTEditEvent e) {
            super.editValueChanged(e);
            SalariatPointGradeTableUI.this.isChanged = true;
        }
    }
}

