/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeCollection;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeFactory;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeCollection;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatPointNewF7UI;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SalariatPointNewF7UI
extends AbstractSalariatPointNewF7UI {
    private static final Logger logger = CoreUIObject.getLogger(SalariatPointNewF7UI.class);
    private boolean isCanceled = true;
    private String personID = null;
    private String schemeID = null;
    private List columnNames = null;
    private List columnTypes = null;
    private SalariatHiberPropsCollection pointList = null;
    private CmpItemCollection cmpItemColls = null;
    private SalariatSchemeInfo salariatSchemeInfo = null;
    private DynamicTableInfo.ColumnInfo[] infosColumn = null;
    private KDTSortManager sm = null;
    private boolean isChanged = false;
    private boolean isEditStopped = false;
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private SalariatHiberPropsInfo pointInfo = null;
    private String fSalPointSalGradeID = null;
    private String SalPointSalGradeNumber = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setSalPointTable();
        this.getSalPointSalGrade();
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex >= 0) {
            IRow row = this.kdMainTbl.getRow(activeIndex);
            this.pointInfo = (SalariatHiberPropsInfo)row.getCell("FPointID").getValue();
            if (this.getUIContext().get("AFFAIR") == null) {
                this.pointInfo.put("pointInfo", row);
                this.pointInfo.put("fSalPointSalGradeID", this.fSalPointSalGradeID);
                this.pointInfo.put("SalPointSalGradeNumber", this.SalPointSalGradeNumber);
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            MsgBox.showWarning((String)HRUtils.getSalariatResourceStr("MISS_SELECT_POINT"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    @Override
    protected void combYear_itemStateChanged(ItemEvent e) throws Exception {
        SalariatPointSalariatGradeInfo info = (SalariatPointSalariatGradeInfo)this.combSalPointSalGrade.getSelectedItem();
        if (info == null) {
            this.fSalPointSalGradeID = null;
            return;
        }
        this.fSalPointSalGradeID = info.getId().toString();
        this.SalPointSalGradeNumber = info.getNumber();
        this.loadSalPointTableData(info);
    }

    @Override
    protected void kdMainTbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
            if (activeIndex >= 0) {
                IRow row = this.kdMainTbl.getRow(activeIndex);
                this.pointInfo = (SalariatHiberPropsInfo)row.getCell("FPointID").getValue();
                if (this.getUIContext().get("AFFAIR") == null) {
                    this.pointInfo.put("pointInfo", row);
                    this.pointInfo.put("fSalPointSalGradeID", this.fSalPointSalGradeID);
                    this.pointInfo.put("SalPointSalGradeNumber", this.SalPointSalGradeNumber);
                }
                this.isCanceled = false;
                this.getUIWindow().close();
            } else {
                MsgBox.showWarning((String)HRUtils.getSalariatResourceStr("MISS_SELECT_POINT"));
            }
        }
    }

    private void setSalPointTable() throws Exception, BOSException, EASBizException {
        CmpItemCollection cmpItems;
        SalariatSchemeCollection salColl;
        FixedCmpSchemeCollection fixedScheme;
        this.columnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnNames.add("FPointID");
        this.columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        this.personID = (String)this.getUIContext().get("FPersonID");
        this.salariatSchemeInfo = null;
        String HrOrgID = null;
        if (((SysContext)this.getUIContext().get("sysContext")).getCurrentHRUnit() != null) {
            HrOrgID = ((SysContext)this.getUIContext().get("sysContext")).getCurrentHRUnit().getId().toString();
        }
        if ((fixedScheme = FixedCmpSchemeFactory.getRemoteInstance().getFixedCmpSchemeCollection("select id,salariatScheme.id where enable = 1 and hrOrgUnit ='" + HrOrgID + "'")) != null && fixedScheme.size() > 0 && fixedScheme.get(0).getSalariatScheme() != null && (salColl = SalariatSchemeFactory.getRemoteInstance().getSalariatSchemeCollection("where state = 1 and id ='" + fixedScheme.get(0).getSalariatScheme().getId().toString() + "'")) != null && salColl.size() > 0) {
            this.salariatSchemeInfo = salColl.get(0);
        }
        if (this.salariatSchemeInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"701_SalariatPointNewF7UI"));
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"702_SalariatPointNewF7UI"));
        }
        this.schemeID = this.salariatSchemeInfo.getId().toString();
        this.pointList = HRUtils.getPointItemsByScheme(this.schemeID);
        this.cmpItemColls = cmpItems = HRUtils.getCmpItemsByScheme(this.schemeID);
        DynamicTableInfo dynTableInfo = new DynamicTableInfo();
        dynTableInfo.setName(this.salariatSchemeInfo.getPointTableName());
        int countColumn = cmpItems.size() + 1;
        this.infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        DynamicTableInfo.ColumnInfo pointColumnInfo = new DynamicTableInfo.ColumnInfo();
        pointColumnInfo.setHide(false);
        pointColumnInfo.setReadOnly(false);
        pointColumnInfo.setKey("FPointID");
        pointColumnInfo.setColumnNumber("FPointID");
        pointColumnInfo.setColumnName("FPointID");
        pointColumnInfo.setColumnType(30);
        pointColumnInfo.setObjectType(ItemObjectTypeEnum.BIZOBJECT);
        pointColumnInfo.setDefaultObj("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setDefaultF7UI("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setCellEditorByObjtype();
        pointColumnInfo.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        pointColumnInfo.getInfosHead()[0].setHeadName(HRUtils.getSalariatResourceStr("POINT"));
        this.infosColumn[0] = pointColumnInfo;
        int j = 1;
        int i = 0;
        while (i < cmpItems.size()) {
            this.infosColumn[j] = new DynamicTableInfo.ColumnInfo(cmpItems.get(i));
            this.columnNames.add(cmpItems.get(i).getNumber());
            this.columnTypes.add(cmpItems.get(i).getDataType());
            ++i;
            ++j;
        }
        dynTableInfo.setInfosColumn(this.infosColumn);
        HRDynamicTableUtils.createTableHead(this.kdMainTbl, dynTableInfo);
        if (this.kdMainTbl.getRowCount() > 0) {
            this.kdMainTbl.getSelectManager().select(0, 0, 0, 0);
        }
        this.kdMainTbl.getSelectManager().setSelectMode(2);
    }

    private void getSalPointSalGrade() throws Exception {
        StringBuffer sql = new StringBuffer("select id,number,name where salariatscheme ='" + this.schemeID + "'");
        String adminSql = HRSchemeUtils.getAdminByUserRange(null);
        sql.append(" and enable = 1 ");
        sql.append("and id in (select fsalpointsalgradeid from T_HR_SalPointSalGradeAminOrg where fadminorgid in(" + adminSql + "))");
        SalariatPointSalariatGradeCollection coll = SalariatPointSalariatGradeFactory.getRemoteInstance().getSalariatPointSalariatGradeCollection(sql.toString());
        if (coll != null && coll.size() > 0) {
            this.combSalPointSalGrade.addItems(coll.toArray());
            this.combSalPointSalGrade.setSelectedIndex(0);
        }
    }

    private void loadSalPointTableData(SalariatPointSalariatGradeInfo info) throws Exception {
        IRowSet rs;
        if (this.salariatSchemeInfo.getPointTableName() == null || this.salariatSchemeInfo.getPointTableName().equals("")) {
            return;
        }
        SalariatSchemeFactory.getRemoteInstance().upGradeSalTable(this.salariatSchemeInfo.getPointTableName(), this.salariatSchemeInfo.getGradeTableName());
        if (info.getId() == null) {
            return;
        }
        this.kdMainTbl.removeRows();
        boolean isFromReport = false;
        if (this.getUIContext().get("isFromReport") != null && ((Boolean)this.getUIContext().get("isFromReport")).booleanValue()) {
            isFromReport = (Boolean)this.getUIContext().get("isFromReport");
        }
        if ((rs = EmpCmpSchmFacadeFactory.getRemoteInstance().getEmpSalPointSalGradeData(this.schemeID, this.personID, info.getId().toString(), isFromReport)) == null) {
            return;
        }
        int coumnCount = this.kdMainTbl.getColumnCount();
        IRow row = null;
        ICell cell = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            row = this.kdMainTbl.addRow();
            for (int i = 0; i < coumnCount; ++i) {
                cell = row.getCell(i);
                String columnName = (String)this.columnNames.get(i);
                Object columnType = this.columnTypes.get(i);
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    String objID = rs.getString(columnName);
                    SalariatHiberPropsInfo info1 = this.getPointInfoByID(objID);
                    cell.setValue((Object)info1);
                    map.put(objID, "true");
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) continue;
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rs.getString(columnName);
                    cell.setValue((Object)strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rs.getBigDecimal(columnName);
                    cell.setValue((Object)value);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rs.getInt(columnName);
                cell.setValue((Object)intValue);
            }
        }
        this.kdMainTbl.getStyleAttributes().setLocked(true);
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdMainTbl, 0, this.kdMainTbl.getRowCount() - 1, this.getKDSortManger());
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.kdMainTbl);
        }
        return this.sm;
    }

    private SalariatHiberPropsInfo getPointInfoByID(String id) {
        if (id == null) {
            return null;
        }
        SalariatHiberPropsInfo info = null;
        for (int i = 0; i < this.pointList.size(); ++i) {
            if (!id.equals(this.pointList.get(i).getId().toString())) continue;
            info = this.pointList.get(i);
            return info;
        }
        return info;
    }

    public SalariatHiberPropsInfo getPointInfo() {
        if (this.pointInfo != null) {
            this.pointInfo.setSimpleName(this.pointInfo.toString());
        }
        return this.pointInfo;
    }
}

