/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchHiberPropsEditUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SalariatSchHiberPropsEditUI
extends AbstractSalariatSchHiberPropsEditUI {
    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setDataObject(this.createNewData());
        } else if ((OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) && this.getUIContext().get("selectNodeObject") != null) {
            this.setDataObject((IObjectValue)((SalariatHiberPropsInfo)this.getUIContext().get("selectNodeObject")));
        }
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        SalariatHiberPropsInfo info = new SalariatHiberPropsInfo();
        if (this.getUIContext().get("selectNodeObject") != null) {
            SalariatHiberPropsInfo parentInfo = (SalariatHiberPropsInfo)this.getUIContext().get("selectNodeObject");
            info.setParent(parentInfo);
        }
        return info;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        KDTree treeMain = (KDTree)this.getUIContext().get("tree");
        DefaultKingdeeTreeNode treeSelectNode = (DefaultKingdeeTreeNode)this.getUIContext().get("selectNode");
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (!this.verifyData(treeSelectNode, null)) {
                return;
            }
            SalariatHiberPropsInfo parentInfo = this.salariatHiberProps.getParent();
            this.salariatHiberProps.setNumber(this.txtNumber.getText());
            this.salariatHiberProps.setName(this.txtName.getText());
            this.salariatHiberProps.setDescription(this.txtDescription.getText());
            this.salariatHiberProps.setLevel(parentInfo.getLevel() + 1);
            this.salariatHiberProps.setIsLeaf(true);
            parentInfo.setIsLeaf(false);
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)this.salariatHiberProps);
            treeSelectNode.add((MutableTreeNode)newNode);
            ((DefaultTreeModel)treeMain.getModel()).nodeStructureChanged((TreeNode)treeSelectNode);
            ((DefaultTreeModel)treeMain.getModel()).reload((TreeNode)newNode);
        } else if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (!this.verifyData((DefaultKingdeeTreeNode)treeSelectNode.getParent(), treeSelectNode)) {
                return;
            }
            this.salariatHiberProps.setNumber(this.txtNumber.getText());
            this.salariatHiberProps.setName(this.txtName.getText());
            this.salariatHiberProps.setDescription(this.txtDescription.getText());
            treeSelectNode.setUserObject((Object)this.salariatHiberProps);
            treeSelectNode.setText(this.salariatHiberProps.toString());
            ((DefaultTreeModel)treeMain.getModel()).reload((TreeNode)treeSelectNode);
        }
        TreePath path = new TreePath(treeSelectNode.getPath());
        treeMain.expandPath(path);
        treeMain.setSelectionPath(path);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setDataObject(this.createNewData());
        }
        this.loadFields();
    }

    protected boolean verifyData(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode selectNode) throws Exception {
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        if (number == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NUMBER)));
            return false;
        }
        if (name == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NAME)));
            return false;
        }
        int childCount = parentNode.getChildCount();
        if (childCount == 0) {
            return true;
        }
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (selectNode != null && selectNode.equals(child)) continue;
            SalariatHiberPropsInfo info = (SalariatHiberPropsInfo)child.getUserObject();
            if (number.equals(info.getNumber())) {
                this.handleException((Exception)((Object)new SalariatException(SalariatException.MULTI_POINT_NUMBER)));
                return false;
            }
            if (!name.equals(info.getName())) continue;
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MULTI_POINT_NAME)));
            return false;
        }
        return true;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnSubmit.setText(null);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }
}

