/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ISalaraitCmpPersonItemProps;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsCollection;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsFactory;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchPersonItemPropsUI;
import com.kingdee.eas.hr.compensation.client.BaseSelectItemData;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SalariatSchPersonItemPropsUI
extends AbstractSalariatSchPersonItemPropsUI {
    private static Logger logger = Logger.getLogger(SalariatSchPersonItemPropsUI.class);
    private static String PERSONSATALOB_NUMBER = "FPER";
    private ISalaraitCmpPersonItemProps iBiz = null;
    private SalariatSchemeInfo schmInfo = null;
    private SalaraitCmpPersonItemPropsCollection itemsCollection = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.itemsCollection = new SalaraitCmpPersonItemPropsCollection();
        int count = this.getSelectItemListModel().size();
        SalaraitCmpPersonItemPropsInfo salCmpItem = null;
        CmpItemInfo cmpItem = null;
        for (int i = 0; i < count; ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(i);
            cmpItem = (CmpItemInfo)item.getDataObject();
            salCmpItem = new SalaraitCmpPersonItemPropsInfo();
            salCmpItem.setItem(cmpItem);
            salCmpItem.setSeq(i);
            this.itemsCollection.add(salCmpItem);
        }
    }

    public boolean verifyDataNew() throws Exception {
        if (this.getSelectItemListModel().size() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_PERSOMITEMS)));
            return false;
        }
        return true;
    }

    private ISalaraitCmpPersonItemProps getSelectItemsBizInterface() {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalaraitCmpPersonItemPropsFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.allItemList.setEnabled(true);
            this.selectItemList.setEnabled(true);
            this.btnMoveAllLeft.setEnabled(true);
            this.btnMoveAllRight.setEnabled(true);
            this.btnMoveBottom.setEnabled(true);
            this.btnMoveLeft.setEnabled(true);
            this.btnMoveRight.setEnabled(true);
            this.btnMoveTop.setEnabled(true);
            this.btnUpgrade.setEnabled(true);
            this.btnDegrade.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.allItemList.setEnabled(false);
            this.selectItemList.setEnabled(false);
            this.btnMoveAllLeft.setEnabled(false);
            this.btnMoveAllRight.setEnabled(false);
            this.btnMoveBottom.setEnabled(false);
            this.btnMoveLeft.setEnabled(false);
            this.btnMoveRight.setEnabled(false);
            this.btnMoveTop.setEnabled(false);
            this.btnUpgrade.setEnabled(false);
            this.btnDegrade.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.selectItemListModel.removeAllElements();
        this.allItemListModel.removeAllElements();
        this.setControlState();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (this.getSchmInfo() == null) {
                this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SCHEMEINFO)));
                return;
            }
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpPersonItemsQuery");
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filterInfoItem = new FilterInfo();
            filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchmInfo().getId().toString()));
            String cmpItemids = HRUtils.getCmpItemIds(null);
            if (cmpItemids != null && cmpItemids.length() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("item.id", (Object)cmpItemids, CompareType.INNER));
                filterInfoItem.mergeFilter(fi, "and");
            }
            entityView.setFilter(filterInfoItem);
            SorterItemCollection sortCollection = entityView.getSorter();
            sortCollection.add(new SorterItemInfo("seq"));
            exec.setObjectView(entityView);
            IRowSet selectItemRowSet = exec.executeQuery();
            while (selectItemRowSet.next()) {
                CmpItemInfo cmpItem = new CmpItemInfo();
                cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("item.id")));
                cmpItem.setNumber(selectItemRowSet.getString("item.number"));
                cmpItem.setName(selectItemRowSet.getString("item.name"));
                BaseSelectItemData selectItem = new BaseSelectItemData(cmpItem);
                this.getSelectItemListModel().addElement(selectItem);
            }
        }
        MetaDataPK queryAllPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        IQueryExecutor execAll = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryAllPK);
        EntityViewInfo entityViewAll = new EntityViewInfo();
        FilterInfo filterInfoItemAll = new FilterInfo();
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)PERSONSATALOB_NUMBER));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoItemAll.setMaskString("#0 and #1 and #2");
        entityViewAll.setFilter(filterInfoItemAll);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        entityViewAll.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("enable");
        sorterOrderItem1.setSortType(SortType.DESCEND);
        entityViewAll.getSorter().add(sorterOrderItem1);
        execAll.setObjectView(entityViewAll);
        IRowSet rowSet = execAll.executeQuery();
        if (rowSet.size() <= 0) {
            return;
        }
        ArrayList mappingPersonItems = HRCmpItemUtils.getMappingPersonItems(null, 2);
        while (rowSet.next()) {
            String id;
            CmpItemInfo cmpItem = new CmpItemInfo();
            String number = rowSet.getString("number");
            if (rowSet.getInt("subject") == 20 && !mappingPersonItems.contains(number) || this.isMutexItem(id = rowSet.getString("id"))) continue;
            cmpItem.setId(BOSUuid.read((String)id));
            cmpItem.setNumber(number);
            cmpItem.setName(rowSet.getString("name"));
            BaseSelectItemData selectItem = new BaseSelectItemData(cmpItem);
            this.getAllItemListModel().addElement(selectItem);
        }
    }

    protected boolean isMutexItem(String itemId) {
        for (int i = 0; i < this.getSelectItemListModel().size(); ++i) {
            BaseSelectItemData itemData = (BaseSelectItemData)this.getSelectItemListModel().get(i);
            CmpItemInfo cmpItem = (CmpItemInfo)itemData.getDataObject();
            if (!itemId.equals(cmpItem.getId().toString())) continue;
            return true;
        }
        return false;
    }

    public SalariatSchemeInfo getSchmInfo() {
        return this.schmInfo;
    }

    public void setSchmInfo(SalariatSchemeInfo info) {
        this.schmInfo = info;
    }

    public SalaraitCmpPersonItemPropsCollection getItemsCollection() {
        if (this.itemsCollection == null) {
            this.itemsCollection = new SalaraitCmpPersonItemPropsCollection();
        }
        return this.itemsCollection;
    }
}

