/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.ISalariatPointProps;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatPointPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchPointPropsUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SalariatSchPointPropsUI
extends AbstractSalariatSchPointPropsUI {
    private static Logger logger = Logger.getLogger(SalariatSchPointPropsUI.class);
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_NUMBER = 1;
    private static final int COLUMN_NAME = 2;
    private static final int COLUMN_ISDEFAULT = 3;
    private SalariatSchemeInfo schemeInfo = null;
    private ISalariatPointProps iBiz = null;
    private SalariatPointPropsCollection propCollection = null;
    private List lstName = new ArrayList();
    public boolean isChanged = false;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddNew.setText(null);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsert.setText(null);
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.ctnMain.addButton((JButton)this.btnAddNew);
        this.ctnMain.addButton((JButton)this.btnInsert);
        this.ctnMain.addButton((JButton)this.btnDelete);
        this.kdTable.addKDTEditListener((KDTEditListener)new LineEditAdapter());
        this.kdTable.checkParsed();
        this.kdTable.getSelectManager().setSelectMode(2);
        KDCheckBox defaultBox = new KDCheckBox();
        defaultBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SalariatSchPointPropsUI.this.checkBoxChanged(e);
                }
            }
        });
        KDTDefaultCellEditor cellIsDefault = new KDTDefaultCellEditor((JCheckBox)defaultBox);
        this.kdTable.getColumn(3).setEditor((ICellEditor)cellIsDefault);
    }

    protected void checkBoxChanged(ItemEvent e) {
        if (this.kdTable.getSelectManager().get() == null) {
            return;
        }
        this.isChanged = true;
        KDTSelectBlock block = this.kdTable.getSelectManager().get();
        int n = block.getBeginRow();
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            IRow rowc = this.kdTable.getRow(i);
            if (rowc.getRowIndex() == n) continue;
            rowc.getCell(3).setValue((Object)false);
        }
    }

    protected ISalariatPointProps getBizInterface() throws Exception {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalariatPointPropsFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int size = this.kdTable.getRowCount();
        if (!this.schemeInfo.getState().equals((Object)StateEnum.UNENABLE)) {
            this.kdTable.getEditManager().stopEditing();
            this.propCollection = new SalariatPointPropsCollection();
            int maxSeqInNumber = this.getMaxSeqInNumber();
            for (int i = 0; i < size; ++i) {
                IRow row = this.kdTable.getRow(i);
                if (row.getCell(0).getValue() == null) {
                    ++maxSeqInNumber;
                }
                if (this.fieldStoreLineTwo(row, i, maxSeqInNumber)) continue;
                return;
            }
        } else {
            super.storeFields();
            this.kdTable.getEditManager().stopEditing();
            this.propCollection = new SalariatPointPropsCollection();
            for (int i = 0; i < size; ++i) {
                IRow row = this.kdTable.getRow(i);
                if (this.fieldStoreLine(row, i)) continue;
                return;
            }
        }
    }

    private void setColMaxLength() {
        try {
            IColumn col = this.kdTable.getColumn(2);
            KDTextField txtField = new KDTextField();
            txtField.setMaxLength(80);
            KDTDefaultCellEditor cellEditorCode = new KDTDefaultCellEditor((JTextField)txtField);
            col.setEditor((ICellEditor)cellEditorCode);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    private boolean fieldStoreLine(IRow row, int seq) {
        SalariatPointPropsInfo info = new SalariatPointPropsInfo();
        String name = (String)row.getCell(2).getValue();
        info.setString("name_l1", name);
        info.setString("name_l2", name);
        info.setString("name_l3", name);
        info.setSeq(seq);
        info.setNumber("FPointID_" + seq);
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        info.setIsDefault((Boolean)row.getCell(3).getValue());
        this.propCollection.add(info);
        return true;
    }

    private boolean fieldStoreLineTwo(IRow row, int seq, int maxSeq) {
        SalariatPointPropsInfo info = new SalariatPointPropsInfo();
        String name = (String)row.getCell(2).getValue();
        info.setString("name_l1", name);
        info.setString("name_l2", name);
        info.setString("name_l3", name);
        info.setSeq(seq);
        if (row.getCell(0).getValue() == null) {
            info.setNumber("FPointID_" + maxSeq);
        } else {
            info.setNumber(row.getCell(1).getValue().toString());
            info.setId(BOSUuid.read((String)row.getCell(0).getValue().toString()));
        }
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        info.setIsDefault((Boolean)row.getCell(3).getValue());
        this.propCollection.add(info);
        return true;
    }

    public boolean verifyDataNew() {
        if (this.kdTable.getRowCount() <= 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_GRADE)));
            return false;
        }
        boolean hasDefault = false;
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            IRow row = this.kdTable.getRow(i);
            if (row.getCell(2).getValue() == null) {
                this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MISS_GRADE_NAME)));
                this.kdTable.getSelectManager().removeAll(false);
                this.kdTable.getEditManager().editCellAt(row.getRowIndex(), 2);
                return false;
            }
            Boolean isDefault = (Boolean)row.getCell(3).getValue();
            if (!isDefault.booleanValue()) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            MsgBox.showError((String)HRUtils.getSalariatResourceStr("MISS_DEFAULT_GRADE"));
            return false;
        }
        return true;
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.kdTable.getColumn(1).getStyleAttributes().setLocked(false);
            this.kdTable.getColumn(2).getStyleAttributes().setLocked(false);
            this.kdTable.getColumn(3).getStyleAttributes().setLocked(false);
            this.btnAddNew.setEnabled(true);
            this.btnInsert.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdTable.getColumn(1).getStyleAttributes().setLocked(true);
            this.kdTable.getColumn(2).getStyleAttributes().setLocked(true);
            this.kdTable.getColumn(3).getStyleAttributes().setLocked(true);
            this.btnAddNew.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.initDataState();
        this.loadExistData();
        this.setControlState();
        HRUtils.setFocusDir(this.kdTable, 1);
        this.setColMaxLength();
        this.addTableHeadSort(this.kdTable);
    }

    public void addTableHeadSort(KDTable table) {
        table.checkParsed();
        KDTSortManager sortManager = new KDTSortManager(table);
        int size = table.getColumnCount();
        for (int i = 0; i < size; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sortManager.setSortAuto(true);
    }

    private void initDataState() {
        this.kdTable.removeRows();
        this.propCollection = null;
        this.lstName = new ArrayList();
    }

    private void loadExistData() throws Exception {
        if (!OprtState.EDIT.equals(this.getOprtState()) && !OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (this.getSchemeInfo() == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SCHEMEINFO)));
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchemeInfo().getId().toString()));
        view.setFilter(filterInfoItem);
        SorterItemCollection sortCollectiom = view.getSorter();
        sortCollectiom.add(new SorterItemInfo("seq"));
        this.propCollection = this.getBizInterface().getSalariatPointPropsCollection(view);
        this.kdTable.removeRows();
        for (int i = 0; i < this.propCollection.size(); ++i) {
            SalariatPointPropsInfo info = this.propCollection.get(i);
            IRow row = this.kdTable.addRow();
            row.getCell(0).setValue((Object)info.getId().toString());
            row.getCell(2).setValue((Object)info.getName());
            row.getCell(1).setValue((Object)info.getNumber());
            this.lstName.add(info.getName());
            row.getCell(3).setValue((Object)info.isIsDefault());
        }
    }

    public SalariatSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(SalariatSchemeInfo info) {
        this.schemeInfo = info;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
        this.isChanged = true;
        IRow row = this.kdTable.addRow();
        row.getCell(3).setValue((Object)false);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SalariatResource.CONFIRM_DELETE_SALCATALOG")))) {
            return;
        }
        super.btnDelete_actionPerformed(e);
        int activeIndex = this.kdTable.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        IRow row = this.kdTable.getRow(activeIndex);
        String name = (String)row.getCell(2).getValue();
        if (name != null) {
            this.lstName.remove(name);
        }
        this.isChanged = true;
        this.kdTable.removeRow(activeIndex);
    }

    @Override
    protected void btnInsert_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsert_actionPerformed(e);
        int activeIndex = this.kdTable.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.isChanged = true;
        IRow row = this.kdTable.addRow(activeIndex);
        row.getCell(3).setValue((Object)false);
    }

    public SalariatPointPropsCollection getPropCollection() {
        if (this.propCollection == null) {
            this.propCollection = new SalariatPointPropsCollection();
        }
        return this.propCollection;
    }

    public void disableEdit() {
        this.btnAddNew.setEnabled(false);
        this.btnInsert.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private int getMaxSeqInNumber() {
        int maxSeq = 0;
        int size = this.kdTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdTable.getRow(i);
            if (row.getCell(1).getValue() == null) continue;
            String number = row.getCell(1).getValue().toString();
            int position = number.indexOf("FPointID_");
            String seqStr = number.substring(9);
            int currMaxSeq = Integer.parseInt(seqStr);
            if (currMaxSeq <= maxSeq) continue;
            maxSeq = currMaxSeq;
        }
        return maxSeq;
    }

    class LineEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        LineEditAdapter() {
        }

        public void editStarting(KDTEditEvent evt) {
            super.editStarting(evt);
            KDTable table = (KDTable)evt.getSource();
            this.oldValue = table.getRow(evt.getRowIndex()).getCell(evt.getColIndex()).getValue();
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            Object newValue = evt.getValue();
            IRow row = table.getRow(rowIndex);
            ICell cell = row.getCell(colIndex);
            switch (colIndex) {
                case 2: {
                    String newName = (String)newValue;
                    String oldName = (String)this.oldValue;
                    if (newName == null) {
                        SalariatSchPointPropsUI.this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MISS_GRADE_NAME)));
                        table.getSelectManager().removeAll(false);
                        table.getEditManager().editCellAt(rowIndex, colIndex);
                        break;
                    }
                    if (newName.equals(oldName)) break;
                    try {
                        if (SalariatSchPointPropsUI.this.lstName.contains(newName)) {
                            SalariatSchPointPropsUI.this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MULTI_GRADE_NAME)));
                            cell.setValue((Object)oldName);
                            table.getSelectManager().removeAll(false);
                            table.getEditManager().editCellAt(rowIndex, colIndex);
                            break;
                        }
                        cell.setValue((Object)newName);
                        SalariatSchPointPropsUI.this.lstName.remove(oldName);
                        SalariatSchPointPropsUI.this.lstName.add(newName);
                        SalariatSchPointPropsUI.this.isChanged = true;
                    }
                    catch (Exception ex) {
                        SalariatSchPointPropsUI.this.handUIException(ex);
                    }
                    break;
                }
            }
        }
    }
}

