/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSelectAdjCmpItemUI;
import com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;

public class SelectAdjCmpItemUI
extends AbstractSelectAdjCmpItemUI {
    public SelectAdjCmpItemUI() throws Exception {
        this.initCtl();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        AdjustSchemeEditUI editUI = this.getEditUI();
        editUI.needRefresh = false;
        this.disposeUIWindow();
    }

    private AdjustSchemeEditUI getEditUI() {
        Map ctx = this.getUIContext();
        Object obj = ctx.get("SELECTCMPITEMUIPARAM");
        if (obj != null && obj instanceof AdjustSchemeEditUI) {
            return (AdjustSchemeEditUI)((Object)obj);
        }
        return null;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        AdjustSchemeEditUI editUI = this.getEditUI();
        editUI.newCmpItemList.clear();
        editUI.itemMap.clear();
        editUI.needRefresh = true;
        int size = this.lstSelect.getElementCount();
        for (int i = 0; i < size; ++i) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelect.getElement(i);
            editUI.newCmpItemList.add(info.getNumber());
            editUI.itemMap.put(info.getId().toString(), info);
        }
        editUI.rebuildKDTable();
        this.disposeUIWindow();
    }

    private void initCtl() {
        this.wbtnSelectAll.setEnabled(true);
        this.wbtnSelectOne.setEnabled(true);
        this.wbtnUnSelectAll.setEnabled(true);
        this.wbtnUnSelectOne.setEnabled(true);
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.wbtnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.wbtnSelectOne.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.wbtnUnSelectOne.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.wbtnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.lstUnSelect.setSelectionMode(0);
        this.lstSelect.setSelectionMode(0);
        this.lstSelect.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectAdjCmpItemUI.this.doClickedSelect(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.lstUnSelect.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectAdjCmpItemUI.this.doClickedUnselect(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void doClickedUnselect(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int startInd = this.lstSelect.getSelectedIndex();
            int selectInd = this.lstUnSelect.getSelectedIndex();
            if (startInd >= 0 && startInd < this.lstSelect.getElementCount() - 1) {
                this.lstSelect.insertElement(this.lstUnSelect.getElement(selectInd), ++startInd);
            } else {
                this.lstSelect.addElement(this.lstUnSelect.getElement(selectInd));
            }
            this.lstUnSelect.removeElementAt(selectInd);
        }
    }

    private void doClickedSelect(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int startInd = this.lstUnSelect.getSelectedIndex();
            int selectInd = this.lstSelect.getSelectedIndex();
            if (startInd >= 0 && startInd < this.lstUnSelect.getElementCount() - 1) {
                this.lstUnSelect.insertElement(this.lstSelect.getElement(selectInd), ++startInd);
            } else {
                this.lstUnSelect.addElement(this.lstSelect.getElement(selectInd));
            }
            this.lstSelect.removeElementAt(selectInd);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    private void initData() {
        Map ctx = this.getUIContext();
        Object obj = ctx.get("SELECTCMPITEMUIPARAM");
        if (obj instanceof AdjustSchemeEditUI) {
            String itemNum;
            int i;
            int size;
            AdjustSchemeEditUI editUI = (AdjustSchemeEditUI)((Object)obj);
            List unSelectList = HRUtils.subtract(editUI.allCmpItemList, editUI.oldCmpItemList);
            if (unSelectList != null) {
                size = unSelectList.size();
                for (i = 0; i < size; ++i) {
                    itemNum = (String)unSelectList.get(i);
                    this.lstUnSelect.addElement(editUI.adjCmpMap.get(itemNum));
                }
            }
            size = editUI.oldCmpItemList.size();
            for (i = 0; i < size; ++i) {
                itemNum = (String)editUI.oldCmpItemList.get(i);
                this.lstSelect.addElement(editUI.adjCmpMap.get(itemNum));
            }
        }
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveAll_actionPerformed(e);
        int startInd = this.lstUnSelect.getSelectedIndex();
        int index = 0;
        if (startInd >= 0) {
            index = startInd;
            int size = this.lstSelect.getElementCount();
            for (int i = 0; i < size; ++i) {
                this.lstUnSelect.insertElement(this.lstSelect.getElement(i), index);
                ++index;
            }
        } else {
            int size = this.lstSelect.getElementCount();
            for (int i = 0; i < size; ++i) {
                this.lstUnSelect.addElement(this.lstSelect.getElement(i));
            }
        }
        this.lstSelect.removeAllElements();
    }

    @Override
    public void actionRemoveOne_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int size;
        super.actionRemoveOne_actionPerformed(e);
        int selectElmInd = this.lstSelect.getSelectedIndex();
        if (selectElmInd < 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchEditUIResource.SELECT_ONE_CMPITEM"));
            return;
        }
        int startInd = this.lstUnSelect.getSelectedIndex();
        int[] selectIndArray = this.lstSelect.getSelectedIndices();
        if (startInd >= 0 && startInd < this.lstUnSelect.getElementCount() - 1) {
            size = selectIndArray.length;
            for (i = 0; i < size; ++i) {
                this.lstUnSelect.insertElement(this.lstSelect.getElement(selectIndArray[i]), ++startInd);
            }
        } else {
            size = selectIndArray.length;
            for (i = 0; i < size; ++i) {
                this.lstUnSelect.addElement(this.lstSelect.getElement(selectIndArray[i]));
            }
        }
        for (i = selectIndArray.length - 1; i >= 0; --i) {
            this.lstSelect.removeElementAt(selectIndArray[i]);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rightStartInd = this.lstSelect.getSelectedIndex();
        int ind = this.lstSelect.getElementCount() - 1;
        if (rightStartInd >= 0) {
            ind = rightStartInd;
            int size = this.lstUnSelect.getElementCount();
            for (int i = 0; i < size; ++i) {
                this.lstSelect.insertElement(this.lstUnSelect.getElement(i), ind);
                ++ind;
            }
        } else {
            int size = this.lstUnSelect.getElementCount();
            for (int i = 0; i < size; ++i) {
                this.lstSelect.addElement(this.lstUnSelect.getElement(i));
            }
        }
        this.lstUnSelect.removeAllElements();
    }

    @Override
    public void actionSelectOne_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int size;
        super.actionSelectOne_actionPerformed(e);
        int selectElmInd = this.lstUnSelect.getSelectedIndex();
        if (selectElmInd < 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchEditUIResource.SELECT_ONE_CMPITEM"));
            return;
        }
        int startInd = this.lstSelect.getSelectedIndex();
        int[] selectIndArray = this.lstUnSelect.getSelectedIndices();
        if (startInd >= 0 && startInd < this.lstSelect.getElementCount() - 1) {
            size = selectIndArray.length;
            for (i = 0; i < size; ++i) {
                this.lstSelect.insertElement(this.lstUnSelect.getElement(selectIndArray[i]), ++startInd);
            }
        } else {
            size = selectIndArray.length;
            for (i = 0; i < size; ++i) {
                this.lstSelect.addElement(this.lstUnSelect.getElement(selectIndArray[i]));
            }
        }
        for (i = selectIndArray.length - 1; i >= 0; --i) {
            this.lstUnSelect.removeElementAt(selectIndArray[i]);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

