/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.client.EmployeeTypePromptBox;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractShRptCurrentPayStatFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ShRptCurrentPayStatFilterUI
extends AbstractShRptCurrentPayStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ShRptCurrentPayStatFilterUI.class);
    private HROrgUnitInfo hrOrgUnitInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.initEvent();
        this.initCmpItemCatalogData();
    }

    public void initLayout() {
        super.initLayout();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        view.setFilter(filter);
        this.prmtCmpPeriod.setEntityViewInfo(view);
        this.prmtCmpPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        this.prmtCmpPeriod.setEditable(false);
        this.prmtEmployeeType.setSelector((KDPromptSelector)new EmployeeTypePromptBox());
        this.prmtEmployeeType.setEditable(false);
        this.prmtEmployeeType.setEnabledMultiSelection(true);
        this.prmtEmployeeType.setDisplayFormat("$name$");
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(true);
        adminF7.show();
        Object obj = adminF7.getData();
        if (obj != null && obj instanceof Object[]) {
            Object[] units = (Object[])obj;
            int size = units.length;
            for (int i = 0; i < size; ++i) {
                AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)units[i];
                if (this.isExistInTable(unitInfo.getId().toString())) continue;
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)unitInfo.getId().toString());
                row.getCell("number").setValue((Object)unitInfo.getNumber());
                row.getCell("name").setValue((Object)unitInfo.getName());
                row.getCell("level").setValue((Object)unitInfo.getLevel());
                row.getCell("longnumber").setValue((Object)unitInfo.getLongNumber());
            }
        }
    }

    private boolean isExistInTable(String unitId) {
        boolean isExist = false;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String strId = this.tblMain.getRow(i).getCell("id").getValue().toString();
            if (!strId.equals(unitId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() != 0) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int size = rowIndexs.length;
            for (int i = size - 1; i >= 0; --i) {
                this.tblMain.removeRow(rowIndexs[i]);
            }
        }
    }

    @Override
    protected void rboCustomUnits_itemStateChanged(ItemEvent e) throws Exception {
        this.tblMain.removeRows();
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.tblMain.setEnabled(true);
    }

    @Override
    protected void rboSywb_itemStateChanged(ItemEvent e) throws Exception {
        this.btnAdd.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.tblMain.setEnabled(false);
        this.tblMain.removeRows();
    }

    public void clear() {
        this.prmtEmployeeType.setData(null);
        this.rboCustomUnits.setSelected(true);
        this.prmtCmpPeriod.setData(null);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.tblMain.setEnabled(true);
        this.tblMain.removeRows();
    }

    public Object getParam() {
        int size;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String empTypes = null;
        if (this.prmtEmployeeType.getData() != null) {
            Object[] objEmpTypes = (Object[])this.prmtEmployeeType.getData();
            StringBuffer strEmpTypes = new StringBuffer();
            size = objEmpTypes.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    strEmpTypes.append("~");
                }
                strEmpTypes.append(((EmployeeTypeInfo)objEmpTypes[i]).getId().toString());
            }
            empTypes = strEmpTypes.toString();
        }
        map.put("empTypeIds", empTypes);
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        String cmpPeriodId = periodInfo.getId().toString();
        map.put("periodId", cmpPeriodId);
        map.put("periodName", periodInfo.getName());
        String strReportType = "0";
        if (this.rboCustomUnits.isSelected()) {
            strReportType = "2";
        }
        size = this.tblMain.getRowCount();
        String[] compUnitIds = new String[size];
        String[] compUnitLongNums = new String[size];
        String[] compUnitLevels = new String[size];
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            compUnitIds[i] = row.getCell("id").getValue().toString();
            compUnitLevels[i] = row.getCell("level").getValue().toString();
            compUnitLongNums[i] = row.getCell("longnumber").getValue().toString();
        }
        map.put("compUnitIds", compUnitIds);
        map.put("compUnitLevels", compUnitLevels);
        map.put("compUnitLongNums", compUnitLongNums);
        map.put("reportType", strReportType);
        StringBuffer selectListArray = new StringBuffer();
        int selectListtemSize = this.lstSelectItem.getElementCount();
        int controlInt = selectListtemSize - 1;
        for (int i = 0; i < selectListtemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            selectListArray.append(cmpItemInfo.getId().toString()).append(":").append(cmpItemInfo.getNumber()).append(":").append(cmpItemInfo.getName()).append(":").append(cmpItemInfo.getDecDigital());
            if (i == controlInt) continue;
            selectListArray.append("~");
        }
        map.put("selectListItem", selectListArray.toString());
        return map;
    }

    public CustomerParams getCustomerParams() {
        int size;
        CustomerParams cp = new CustomerParams();
        if (this.prmtEmployeeType.getData() != null) {
            Object[] objEmpTypes = (Object[])this.prmtEmployeeType.getData();
            StringBuffer strEmpTypes = new StringBuffer();
            size = objEmpTypes.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    strEmpTypes.append("~");
                }
                strEmpTypes.append(((EmployeeTypeInfo)objEmpTypes[i]).getId().toString());
            }
            cp.addCustomerParam("empTypeIds", strEmpTypes.toString());
        }
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        String cmpPeriodId = periodInfo.getId().toString();
        cp.addCustomerParam("periodId", cmpPeriodId);
        cp.addCustomerParam("periodName", periodInfo.getName());
        String strReportType = "0";
        if (this.rboCustomUnits.isSelected()) {
            strReportType = "2";
        }
        size = this.tblMain.getRowCount();
        StringBuffer compUnitIds = new StringBuffer();
        StringBuffer compUnitLongNums = new StringBuffer();
        StringBuffer compUnitLevels = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!compUnitIds.toString().equals("")) {
                compUnitIds.append("~");
            }
            compUnitIds.append(row.getCell("id").getValue().toString());
            if (!compUnitLevels.toString().equals("")) {
                compUnitLevels.append("~");
            }
            compUnitLevels.append(row.getCell("level").getValue().toString());
            if (!compUnitLongNums.toString().equals("")) {
                compUnitLongNums.append("~");
            }
            compUnitLongNums.append(row.getCell("longnumber").getValue().toString());
        }
        cp.addCustomerParam("compUnitIds", compUnitIds.toString());
        cp.addCustomerParam("compUnitLevels", compUnitLevels.toString());
        cp.addCustomerParam("compUnitLongNums", compUnitLongNums.toString());
        cp.addCustomerParam("reportType", strReportType);
        String selectListArray = "";
        int selectListtemSize = this.lstSelectItem.getElementCount();
        int controlInt = selectListtemSize - 1;
        for (int i = 0; i < selectListtemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            selectListArray = selectListArray + cmpItemInfo.getId().toString();
            if (i == controlInt) continue;
            selectListArray = selectListArray + "~";
        }
        cp.addCustomerParam("selectListItem", selectListArray);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        try {
            String strEmpTypes = cp.getCustomerParam("empTypeIds");
            if (strEmpTypes != null && !strEmpTypes.equals("")) {
                String oql = "select id,name where id in ('" + strEmpTypes.replaceAll("~", "','") + "')";
                EmployeeTypeCollection typeCol = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(oql);
                this.prmtEmployeeType.setData((Object)typeCol.toArray());
            } else {
                this.prmtEmployeeType.setData(null);
            }
            String periodId = cp.getCustomerParam("periodId").toString();
            CmpPeriodInfo periodInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            this.prmtCmpPeriod.setData((Object)periodInfo);
            String strReportType = cp.getCustomerParam("reportType").toString();
            if (strReportType.equals("0")) {
                this.rboSywb.setSelected(true);
            } else {
                if (strReportType.equals("2")) {
                    this.rboCustomUnits.setSelected(true);
                }
                IAdminOrgUnit iUnit = AdminOrgUnitFactory.getRemoteInstance();
                if (cp.getCustomerParam("compUnitIds") != null) {
                    this.tblMain.checkParsed();
                    this.tblMain.removeRows();
                    String[] compUnitIds = cp.getCustomerParam("compUnitIds").split("~");
                    int size = compUnitIds.length;
                    for (int i = 0; i < size; ++i) {
                        AdminOrgUnitInfo compUnitInfo = iUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(compUnitIds[i]));
                        IRow row = this.tblMain.addRow();
                        row.getCell("id").setValue((Object)compUnitInfo.getId().toString());
                        row.getCell("number").setValue((Object)compUnitInfo.getNumber());
                        row.getCell("name").setValue((Object)compUnitInfo.getName());
                        row.getCell("level").setValue((Object)compUnitInfo.getLevel());
                        row.getCell("longnumber").setValue((Object)compUnitInfo.getLongNumber());
                    }
                }
            }
            this.lstSelectItem.removeAllElements();
            if (cp.getCustomerParam("selectListItem") != null) {
                String selectListStr = cp.getCustomerParam("selectListItem").toString();
                if (selectListStr.trim().length() != 0) {
                    int i;
                    String[] selectListStrArray = selectListStr.split("~");
                    int arrayInt = selectListStrArray.length;
                    HashSet<String> keySet = new HashSet<String>();
                    ArrayList<String> seqList = new ArrayList<String>();
                    for (int i2 = 0; i2 < arrayInt; ++i2) {
                        keySet.add(selectListStrArray[i2]);
                        seqList.add(selectListStrArray[i2]);
                    }
                    EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
                    FilterInfo fitlerInfoTmp = new FilterInfo();
                    fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
                    entityViewInfoTmp.setFilter(fitlerInfoTmp);
                    CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
                    HashMap<String, CmpItemInfo> seqHelperMap = new HashMap<String, CmpItemInfo>();
                    int catalogSize = cmpItemColl.size();
                    for (i = 0; i < catalogSize; ++i) {
                        CmpItemInfo cmpItemInfo = cmpItemColl.get(i);
                        seqHelperMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
                    }
                    int seqSize = seqList.size();
                    for (i = 0; i < seqSize; ++i) {
                        this.lstSelectItem.addElement((Object)((CmpItemInfo)seqHelperMap.get(seqList.get(i).toString())));
                    }
                }
                this.onLoadAllList();
                this.lstAllItem.requestFocus();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public boolean verify() {
        if (this.prmtCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"607_ShRptCmpPrizeStatFilterUI"));
            return false;
        }
        if (this.rboCustomUnits.isSelected() && this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"616_ShRptCurrentPayStatFilterUI"));
            return false;
        }
        if (this.tblMain.getRowCount() > 40) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"617_ShRptCurrentPayStatFilterUI"));
            return false;
        }
        if (this.lstSelectItem.getElementCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"618_ShRptCurrentPayStatFilterUI"));
            return false;
        }
        return true;
    }

    private void initCmpItemCatalogData() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        evi.setFilter(filterInfo);
        CmpItemCatalogCollection colCmpItemCatalog = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
        if (colCmpItemCatalog == null || colCmpItemCatalog.size() <= 0) {
            return;
        }
        Iterator itr = colCmpItemCatalog.iterator();
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        this.cmbItemCatalog.removeAllItems();
        while (itr.hasNext()) {
            cmpItemCatalogInfo = (CmpItemCatalogInfo)itr.next();
            this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
        }
    }

    private void initEvent() {
        this.cmbItemCatalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    try {
                        ShRptCurrentPayStatFilterUI.this.onLoadAllList();
                        ShRptCurrentPayStatFilterUI.this.lstAllItem.requestFocus();
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            }
        });
    }

    private void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        CmpItemCollection colCmpItem = this.getCmpItemCollection();
        if (infoCmpItemCatalog == null || colCmpItem == null) {
            return;
        }
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoCategory = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoCategory = infoCmpItem.getCmpItemCatalog();
            if (infoCategory == null || !infoCategory.getId().toString().equals(infoCmpItemCatalog.getId().toString())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstSelectItem.getElementCount();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
                if (!infoTempCmpItem.getId().toString().equals(infoCmpItem.getId().toString())) continue;
                isSame = true;
            }
            if (isSame) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private CmpItemCollection getCmpItemCollection() throws BOSException {
        CmpSchemeInfo cmpSchemeInfo = new CmpSchemeInfo();
        cmpSchemeInfo.setId(BOSUuid.read((String)"tXVbZgEMEADgABaACgrIKWwStok="));
        CmpItemCollection cmpItemColl = this.getCmpItemOfSchemeBySchme(cmpSchemeInfo);
        return cmpItemColl;
    }

    private CmpItemCollection getCmpItemOfSchemeBySchme(CmpSchemeInfo cmpSchemeInfo) throws BOSException {
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.dataType", (Object)"40,50,60", CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER%", CompareType.NOTLIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FFPER%", CompareType.NOTLIKE));
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("sortOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItem.*"));
        sic.add(new SelectorItemInfo("cmpItem.cmpItemCatalog.number"));
        sic.add(new SelectorItemInfo("cmpItem.hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        CmpSchemeItemCollection cmpSchemeItemColl = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        Object cmpItemInfo = null;
        CmpSchemeItemInfo cmpSchemeItemTemp = null;
        int j = cmpSchemeItemColl.size();
        for (int i = 0; i < j; ++i) {
            cmpSchemeItemTemp = cmpSchemeItemColl.get(i);
            cmpItemColl.add(cmpSchemeItemTemp.getCmpItem());
        }
        return cmpItemColl;
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        this.allRightToLeftItem();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        this.allLeftToRightItem();
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        this.rightToLeft();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        this.leftToRight();
    }

    private void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    private void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    private void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
            CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
            if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                this.lstAllItem.addElement((Object)info);
                this.lstAllItem.setSelectedValue((Object)info, true);
            }
        }
    }

    private void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                CmpItemCatalogInfo cmpItemCatalogInfo = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
                if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                    this.lstAllItem.addElement((Object)info);
                }
                this.lstSelectItem.removeElement((Object)info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }
}

