/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpReportFacade;
import com.kingdee.eas.hr.compensation.ITaxRateList;
import com.kingdee.eas.hr.compensation.TaxRateListCollection;
import com.kingdee.eas.hr.compensation.TaxRateListFactory;
import com.kingdee.eas.hr.compensation.TaxRateListInfo;
import com.kingdee.eas.hr.compensation.client.AbstractTaxDetailReportUI;
import com.kingdee.eas.hr.compensation.client.TaxDetailReportPanel;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaxDetailReportUI
extends AbstractTaxDetailReportUI {
    protected static final Logger logger = CoreUIObject.getLogger(TaxDetailReportUI.class);
    protected CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
    protected boolean isFirstDefaultQuery = true;
    protected TaxDetailReportPanel customerPanel = new TaxDetailReportPanel();
    protected CmpPeriodInfo infoCmpPeriod = null;
    protected EntityViewInfo infoEntityView = new EntityViewInfo();
    protected TaxRateListCollection colTaxRateList = null;
    protected List lstData = null;
    String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";

    public TaxDetailReportUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("FSAL029").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        this.tblMain.getColumn("shouldTax").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        this.tblMain.getColumn("taxRate").getStyleAttributes().setNumberFormat("0%");
        this.tblMain.getColumn("cutTax").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        this.tblMain.getColumn("tax").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        this.enableExportExcel(this.tblMain);
        ITaxRateList iTaxRateList = TaxRateListFactory.getRemoteInstance();
        this.colTaxRateList = iTaxRateList.getTaxRateListCollection();
        super.onLoad();
        this.showFilterDialog();
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void doQueryDialog() throws Exception {
        this.infoCmpPeriod = this.customerPanel.getInfoCmpPeriod();
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
        } else {
            this.infoEntityView = this.commonQueryDialog.getEntityViewInfoResult();
        }
        Window parentDlg = SwingUtilities.getWindowAncestor((Component)((Object)this));
        GetDataDialog dlg = null;
        dlg = parentDlg instanceof Dialog ? new GetDataDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this))) : (parentDlg instanceof Frame ? new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this))) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                TaxDetailReportUI.this.loadTableData();
                return null;
            }
        });
        dlg.show();
    }

    protected void loadTableData() throws Exception {
        ICmpReportFacade iCmpReportFacade = CmpReportFacadeFactory.getRemoteInstance();
        this.lstData = iCmpReportFacade.getTaxDetailReportData(this.infoCmpPeriod.getId().toString(), this.infoEntityView);
        this.fillTableData(this.lstData);
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.tblMain.getSelectManager().setSelectMode(15);
        }
    }

    protected void fillTableData(List lstData) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.setRefresh(false);
        BigDecimal bdTemp = null;
        BigDecimal bdBasePoint = null;
        BigDecimal bdRate = null;
        if (lstData == null) {
            return;
        }
        IRow iRow = null;
        TaxRateListInfo infoTemp = null;
        BigDecimal bdAll = null;
        boolean isGet = false;
        int size = lstData.size();
        for (int i = 0; i < size; ++i) {
            List lst = (List)lstData.get(i);
            bdAll = (BigDecimal)lst.get(9);
            iRow = this.tblMain.addRow();
            int length = this.tblMain.getColumnCount();
            for (int j = 1; j < length; ++j) {
                iRow.getCell(j).setValue(lst.get(j));
            }
            if (lst.get(1).equals("TOTAL")) {
                iRow.getCell(1).setValue((Object)EASResource.getString((String)(this.resClass + "TOTAL")));
                iRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
                isGet = false;
                continue;
            }
            bdTemp = (BigDecimal)lst.get(6);
            bdBasePoint = lst.get(4) instanceof BigDecimal ? (BigDecimal)lst.get(4) : null;
            if (bdTemp == null || bdBasePoint == null || this.colTaxRateList == null || this.colTaxRateList.size() <= 0) continue;
            int n = this.colTaxRateList.size();
            for (int m = 0; m < n; ++m) {
                infoTemp = this.colTaxRateList.get(m);
                bdRate = bdTemp.subtract(bdBasePoint);
                if (bdRate.compareTo(infoTemp.getEndPoint()) > 0 || bdRate.compareTo(infoTemp.getBeginPoint()) < 0) continue;
                if (infoTemp.getTaxRate() != null) {
                    bdTemp = infoTemp.getTaxRate().multiply(HRSchemeUtils.BD_ZEROZEROONE);
                    iRow.getCell(7).setValue((Object)bdTemp);
                } else {
                    iRow.getCell(7).setValue((Object)infoTemp.getTaxRate());
                }
                iRow.getCell(8).setValue((Object)infoTemp.getFastSub().setScale(2));
            }
        }
        this.tblMain.setRefresh(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnQuery);
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.tblMain.setColumnMoveable(true);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.commonQueryDialog.show()) {
            this.doQueryDialog();
        }
    }

    protected void showFilterDialog() throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = HRSchemeUtils.getQueryInfo((IMetaDataPK)queryPK).getFullName();
        this.commonQueryDialog.setWidth(450);
        this.commonQueryDialog.setHeight(330);
        if (this.getUIWindow() == null) {
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQueryDialog.setOwner((Component)((Object)this));
        }
        this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.commonQueryDialog.setShowFilter(true);
        this.commonQueryDialog.setShowSorter(false);
        this.commonQueryDialog.setShowToolbar(true);
        this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.customerPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpPeriodResource.CMPPERIOD_NAME"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
        this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.TITLE_TAXDETAIL_REPORT"));
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution;
            this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.infoEntityView == null) {
                this.infoEntityView = new EntityViewInfo();
            }
            if (CompUtils.isNullWhere(solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName))) {
                CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(solution));
                if (cp == null) {
                    this.isFirstDefaultQuery = false;
                    this.showFilterDialog();
                }
                this.customerPanel.setCustomerParams(cp);
                this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
                this.doQueryDialog();
            } else {
                this.isFirstDefaultQuery = false;
                if (this.commonQueryDialog.show()) {
                    this.doQueryDialog();
                } else {
                    SysUtil.abort();
                }
            }
        } else {
            this.isFirstDefaultQuery = false;
            if (this.commonQueryDialog.show()) {
                this.doQueryDialog();
            } else {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected Variant tableRequestPrintData(String varName) {
        Variant v = new Variant();
        v.setObject((Object)"");
        return v;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

