/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpAssActException;
import com.kingdee.eas.hr.compensation.GrantTypeEnum;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CmpAssActUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.util.CmpAssActUtil");
    public static final String hrToCompanyId = "00000000-0000-0000-0000-0000000000130FE9F8B5";
    public static final String adminToCompanyId = "00000000-0000-0000-0000-0000000000010FE9F8B5";

    public static void verifyHasCompany() throws Exception {
        GrantTypeEnum grantType = HRUtils.getGrantHRParamterValue(null);
        IRowSet rows = null;
        IQueryExecutor queryExcute = CmpAssActUtil.getQueryExecutor("com.kingdee.eas.hr.compensation.app.CmpCompanyRangQuery", null, null);
        if (grantType == null || 0 == grantType.getValue()) {
            queryExcute.setObjectView(CmpAssActUtil.getHrToCompanyView(null));
            rows = queryExcute.executeQuery();
        } else {
            queryExcute.setObjectView(CmpAssActUtil.getAdminToCompanyView(null));
            rows = queryExcute.executeQuery();
        }
        if (rows.size() < 1) {
            throw new CmpAssActException(CmpAssActException.COMPANY_NOT_NULL);
        }
    }

    public static List getAssActAttList(Context ctx, String company) throws BOSException {
        IQueryExecutor iQueryExecutor = CmpAssActUtil.getQueryExecutor("com.kingdee.eas.hr.compensation.app.AssActByCompUnionQuery", null, ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (ctx == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hr.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("hr.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company));
        }
        view.setFilter(filterInfo);
        iQueryExecutor.setObjectView(view);
        IRowSet rows = iQueryExecutor.executeQuery();
        String asstActTypeatt = null;
        ArrayList<String> assActAttList = new ArrayList<String>();
        try {
            while (rows.next()) {
                asstActTypeatt = rows.getString("asstActType.asstHGAttribute");
                assActAttList.add(asstActTypeatt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return assActAttList;
    }

    public static String makeCmpHGSql(Context ctx, String company) throws BOSException {
        List assActAttList = CmpAssActUtil.getAssActAttList(ctx, company);
        StringBuffer sb = new StringBuffer();
        int size = assActAttList.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append((String)assActAttList.get(i));
                sb.append(".id");
                continue;
            }
            if (i != size - 1) {
                sb.append((String)assActAttList.get(i));
                sb.append(".id, ");
                continue;
            }
            sb.append((String)assActAttList.get(i));
            sb.append(".id ");
        }
        return sb.toString();
    }

    public static IQueryExecutor getQueryExecutor(String query, EntityViewInfo viewInfo, Context ctx) {
        MetaDataPK queryPK = new MetaDataPK(query);
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    public static EntityViewInfo getHrToCompanyView(Context ctx) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (ctx == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)hrToCompanyId));
        view.setFilter(filterInfo);
        return view;
    }

    public static EntityViewInfo getAdminToCompanyView(Context ctx) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (ctx == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)adminToCompanyId));
        view.setFilter(filterInfo);
        return view;
    }

    public static ICellEditor getPositionEditor() {
        PositionPromptBox2 bizPosition = new PositionPromptBox2();
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setSelector((KDPromptSelector)bizPosition);
        bizPromptBox.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }

    public static ICellEditor getAdminEditor(HashMap rangMap) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        AdminF7 f7 = new AdminF7();
        f7.disablePerm(rangMap, true);
        bizPromptBox.setSelector((KDPromptSelector)f7);
        bizPromptBox.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }
}

