/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.eas.hr.compensation.CmpCheckInfo;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.BaseException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class CmpCheckLog
implements Serializable {
    private String uuid;
    private ArrayList errorSubject = new ArrayList();
    private ArrayList errorDetail = new ArrayList();
    private ArrayList errorData = new ArrayList();

    public String getLogUuID() {
        return this.uuid;
    }

    public void setLogUuID(String uuid) {
        this.uuid = uuid;
    }

    public int size() {
        return this.errorSubject.size();
    }

    public void add(String subject, String detail, Object data) {
        this.errorData.add(data);
        this.errorSubject.add(subject);
        String errDetail = subject;
        if (detail != null) {
            errDetail = errDetail + "\r\n" + detail;
        }
        this.errorDetail.add(errDetail);
    }

    public void addException(String subject, Throwable e) {
        String errDetail = subject;
        if (e.getMessage() != null) {
            errDetail = errDetail + "\r\n" + e.getMessage().replaceAll(this.getReplacedStr(), "");
        }
        this.add(subject, errDetail, e);
    }

    public void addCmpCheckInfo(CmpCheckInfo info) {
        String subject = info.getMessage();
        String detail = null;
        Object obj = null;
        List entry = info.getEntries();
        if (entry != null) {
            int size = entry.size();
            for (int i = 0; i < size; ++i) {
                CmpCheckInfo entryInfo = (CmpCheckInfo)entry.get(i);
                subject = entryInfo.getMessage();
                detail = entryInfo.entriesToString();
                obj = entryInfo.getEntries();
                if (obj == null) {
                    obj = entryInfo;
                }
                this.add(subject, detail, obj);
            }
        } else {
            this.add(subject, subject, info);
        }
    }

    public void addCmpCheckLog(CmpCheckLog log) {
        int size = log.getErrorDetailCount();
        for (int i = 0; i < size; ++i) {
            this.add(log.getErrorSubject(i), log.getErrorDetail(i), log.getData(i));
        }
    }

    public String getDataInfo(int i) {
        return this.errorData.get(i).toString();
    }

    public Object getData(int i) {
        return this.errorData.get(i);
    }

    public String getDataContent(int i) {
        Object obj = this.errorData.get(i);
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            if (t instanceof BaseException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    MyPrintStream ps = new MyPrintStream(os);
                    t.printStackTrace(ps);
                    return ps.toString();
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }
            return ExceptionUtil.getExcLinkStackTrace((Throwable)t);
        }
        if (obj instanceof List) {
            List datas = (List)obj;
            StringBuffer message = new StringBuffer();
            int size = datas.size();
            for (int j = 0; j < size; ++j) {
                message.append(datas.get(j).toString());
                message.append("\r\n");
            }
            return message.toString();
        }
        return obj.toString();
    }

    public String getErrorSubject(int i) {
        return (String)this.errorSubject.get(i);
    }

    public void setErrorSubject(int i, String subject) {
        this.errorSubject.set(i, subject);
    }

    public String getErrorDetail(int i) {
        return (String)this.errorDetail.get(i);
    }

    public int getErrorDetailCount() {
        return this.errorDetail.size();
    }

    private String getReplacedStr() {
        return "Caused exception message is: ";
    }

    private static class MyPrintStream
    extends PrintStream {
        private ByteArrayOutputStream os = null;

        public MyPrintStream(ByteArrayOutputStream os) throws UnsupportedEncodingException {
            super((OutputStream)os, false, "UTF8");
            os.reset();
            this.os = os;
        }

        private MyPrintStream() {
            super((OutputStream)null);
        }

        public String toString() {
            try {
                return this.os.toString("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }
}

