/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.app.AdapterDynamicDBTable;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.TexteditForTable;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.EnumUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class HRTableTools {
    private static Logger logger = Logger.getLogger(HRTableTools.class);

    public static void locationTableRow(KDTable table, String columnName, Object obj) {
        if (table == null || columnName == null || obj == null) {
            return;
        }
        int indexRow = 0;
        int allCount = 0;
        allCount = table.getDataRequestManager().getDataRequestMode() == 0 ? table.getRowCount() : 100;
        ICell iCell = null;
        int size = allCount;
        for (int i = 0; i < size && (iCell = table.getRow(i).getCell(columnName)) != null && iCell.getValue() != null; ++i) {
            if (!iCell.getValue().toString().equals(obj.toString())) continue;
            indexRow = i;
            break;
        }
        if (table.getRow(indexRow) != null) {
            table.getSelectManager().select(indexRow, 0);
        }
    }

    public static ICellEditor getNumberCellEditor(int length, int scale, BigDecimal defaultValue) {
        if (defaultValue == null) {
            defaultValue = new BigDecimal("0").setScale(scale);
        }
        KDFormattedTextField txtFormat = new KDFormattedTextField(1);
        txtFormat.setValue((Object)defaultValue);
        txtFormat.setHorizontalAlignment(4);
        txtFormat.setPrecision(scale);
        txtFormat.setDataVerifierType(12);
        txtFormat.setSupportedEmpty(false);
        return new KDTDefaultCellEditor((JTextField)txtFormat);
    }

    public static ICellEditor getDateCellEditor() {
        KDDatePicker kdDP = new KDDatePicker();
        return new KDTDefaultCellEditor(kdDP);
    }

    public static ICellEditor getStringCellEditor(int iMaxLength) {
        KDTextField txt = new KDTextField();
        txt.setMaxLength(iMaxLength);
        TexteditForTable textEdit = new TexteditForTable((JTextField)txt);
        return textEdit;
    }

    public static ICellEditor getCurCellEditor(int length, int scale, BigDecimal defaultValue, String isoCode) {
        KDFormattedTextField fCurrTxt = new KDFormattedTextField(1);
        fCurrTxt.setValue((Object)defaultValue);
        fCurrTxt.setHorizontalAlignment(4);
        fCurrTxt.setPrecision(scale);
        fCurrTxt.setMaximumValue((Comparable)new BigDecimal("9999999999.99"));
        fCurrTxt.setSupportedEmpty(false);
        fCurrTxt.setDataVerifierType(12);
        return new KDTDefaultCellEditor((JTextField)fCurrTxt);
    }

    public static ICellEditor getRateCellEditor(int length, int scale, BigDecimal defaultValue, String isoCode) {
        KDFormattedTextField fCurrTxt = new KDFormattedTextField(1);
        fCurrTxt.setValue((Object)defaultValue);
        fCurrTxt.setHorizontalAlignment(4);
        fCurrTxt.setPrecision(scale);
        fCurrTxt.setMaximumValue((Comparable)new BigDecimal("9999999999"));
        fCurrTxt.setMinimumValue((Comparable)HRSchemeUtils.BD_ZERO);
        fCurrTxt.setSupportedEmpty(false);
        fCurrTxt.setDataVerifierType(12);
        fCurrTxt.setRemoveingZeroInDispaly(false);
        fCurrTxt.setRemoveingZeroInEdit(false);
        return new KDTDefaultCellEditor((JTextField)fCurrTxt);
    }

    public static ICellEditor getEnumCellEditor(String enumName) {
        KDComboBox kdCBX = new KDComboBox(EnumUtils.getEnumList((String)enumName).toArray());
        kdCBX.setEditable(false);
        return new KDTDefaultCellEditor((JComboBox)kdCBX);
    }

    public static ICellEditor getIntCellEditor(int length, int defaultValue) {
        KDFormattedTextField fTxt = new KDFormattedTextField(0);
        fTxt.setValue((Object)defaultValue);
        fTxt.setSupportedEmpty(true);
        fTxt.setMaximumValue((Comparable)new BigDecimal("9999999999999"));
        fTxt.setDataVerifierType(0);
        fTxt.setHorizontalAlignment(4);
        fTxt.setDataVerifierType(12);
        return new KDTDefaultCellEditor((JTextField)fTxt);
    }

    public static ICellEditor getBizCellEditor(String defaultObj, String defaultQueryName, String defaultF7UI) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(false);
        if (defaultObj != null && !defaultObj.equals("")) {
            try {
                bizPromptBox.setSelector((KDPromptSelector)Class.forName(defaultObj).newInstance());
            }
            catch (Exception classE) {
                logger.error((Object)classE.getMessage());
            }
        } else if (defaultQueryName != null && !defaultQueryName.equals("")) {
            bizPromptBox.setQueryInfo(defaultQueryName);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            bizPromptBox.setSelectorCollection(sic);
        } else if (defaultF7UI != null && !defaultF7UI.equals("")) {
            bizPromptBox.setDefaultF7UIName(defaultF7UI);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            bizPromptBox.setSelectorCollection(sic);
        }
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }

    public static Object getTableSelectCellValue(KDTable table, String columnName) {
        IRow iRow;
        ICell iCell;
        int index;
        if (table != null && columnName != null && (index = table.getSelectManager().getActiveRowIndex()) >= 0 && (iCell = (iRow = table.getRow(index)).getCell(columnName)) != null) {
            return iCell.getValue();
        }
        return null;
    }

    public static Object getTableSelectCellValue(KDTable table, String columnName, int indexRow) {
        IRow iRow;
        ICell iCell;
        if (table != null && columnName != null && indexRow >= 0 && (iCell = (iRow = table.getRow(indexRow)).getCell(columnName)) != null) {
            return iCell.getValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rowMove(KDTable table, int state, String strOrderName, String strDataStateName) {
        int countRow = table.getRowCount();
        if (countRow <= 1) {
            return;
        }
        int indexFrom = table.getSelectManager().getActiveRowIndex();
        int indexTo = 0;
        int countChangeTimes = 1;
        if (state == 10) {
            if (indexFrom < 1) return;
            indexTo = indexFrom - 1;
        } else if (state == 20) {
            if (indexFrom >= countRow - 1) return;
            indexTo = indexFrom + 1;
        } else if (state == 30) {
            if (indexFrom < 1) return;
            indexTo = indexFrom - 1;
            countChangeTimes = indexFrom;
        } else if (state == 40) {
            if (indexFrom >= countRow - 1) return;
            indexTo = indexFrom + 1;
            countChangeTimes = countRow - indexFrom - 1;
        }
        for (int i = 0; i < countChangeTimes; ++i) {
            if (i != 0 && state == 30) {
                --indexFrom;
                --indexTo;
            } else if (i != 0 && state == 40) {
                ++indexFrom;
                ++indexTo;
            }
            IRow rowFrom = table.getRow(indexFrom);
            IRow rowTo = table.getRow(indexTo);
            ICell cellFrom = null;
            ICell cellTo = null;
            for (int j = 0; j < table.getColumnCount(); ++j) {
                cellFrom = rowFrom.getCell(j);
                cellTo = rowTo.getCell(j);
                Object temp = cellFrom.getValue();
                cellFrom.setValue(cellTo.getValue());
                cellTo.setValue(temp);
            }
            if (strOrderName != null) {
                cellFrom = rowFrom.getCell(strOrderName);
                if (cellFrom != null) {
                    cellFrom.setValue((Object)indexFrom);
                }
                if ((cellTo = rowTo.getCell(strOrderName)) != null) {
                    cellTo.setValue((Object)indexTo);
                }
            }
            if (strDataStateName == null) continue;
            cellFrom = rowFrom.getCell(strDataStateName);
            if (cellFrom != null) {
                cellFrom.setValue((Object)30);
            }
            if ((cellTo = rowTo.getCell(strDataStateName)) == null) continue;
            cellTo.setValue((Object)30);
        }
        table.getSelectManager().select(indexTo, 0);
    }

    public static String getIDDataType() {
        return "varchar";
    }

    public static int getIDLength() {
        return 50;
    }

    public static int getIDPrecision() {
        return 0;
    }

    public static ArrayList getTableColumnNames(Context ctx, String tableName) throws BOSException {
        String sql = "SELECT * FROM " + tableName + " WHERE 1<>1 ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> columnNames = new ArrayList<String>();
        try {
            ResultSetMetaData metaTable = rows.getMetaData();
            int size = metaTable.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                columnNames.add(metaTable.getColumnName(i));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return columnNames;
    }

    public static void addDynColumn(Context ctx, CmpItemInfo itemInfo, String tableName) throws BOSException, EASBizException {
        ArrayList columnNames = HRTableTools.getTableColumnNames(ctx, tableName);
        if (columnNames.contains(itemInfo.getNumber())) {
            return;
        }
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance(ctx);
        itemInfo = iCmpItem.getCmpItemInfo((IObjectPK)new ObjectUuidPK(itemInfo.getId()));
        ColumnMetasInfo metaInfo = HRTableTools.getColumnMetasInfoByItem(itemInfo);
        ArrayList<ColumnMetasInfo> lstAddColumns = new ArrayList<ColumnMetasInfo>();
        lstAddColumns.add(metaInfo);
        AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable();
        iDynamicDBTable.setContext(ctx);
        iDynamicDBTable.setListColumn(lstAddColumns);
        iDynamicDBTable.setTableName(tableName);
        try {
            iDynamicDBTable.alter();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean addDynColumn(Context ctx, ColumnMetasInfo metaInfo, String tableName) throws BOSException {
        ArrayList columnNames = HRTableTools.getTableColumnNames(ctx, tableName);
        if (columnNames.contains(metaInfo.getName())) {
            return false;
        }
        ArrayList<ColumnMetasInfo> lstAddColumns = new ArrayList<ColumnMetasInfo>();
        lstAddColumns.add(metaInfo);
        AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable();
        iDynamicDBTable.setContext(ctx);
        iDynamicDBTable.setListColumn(lstAddColumns);
        iDynamicDBTable.setTableName(tableName);
        try {
            iDynamicDBTable.alter();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static ColumnMetasInfo getColumnMetasInfoByItem(CmpItemInfo itemInfo) {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName(itemInfo.getNumber());
        metaInfo.setDataType(HRSchemeUtils.getDataType(itemInfo.getDataType().getValue()));
        if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY)) {
            metaInfo.setPrecision(17);
            metaInfo.setScale(4);
            metaInfo.setLength(17);
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
            metaInfo.setPrecision(21);
            metaInfo.setScale(8);
            metaInfo.setLength(21);
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
            metaInfo.setLength(9);
            metaInfo.setPrecision(itemInfo.getLength());
            metaInfo.setScale(itemInfo.getDecDigital());
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else {
            metaInfo.setPrecision(itemInfo.getLength());
            metaInfo.setScale(itemInfo.getDecDigital());
            metaInfo.setLength(itemInfo.getLength());
        }
        metaInfo.setAllowNull(Boolean.TRUE);
        metaInfo.setIntDataState(10);
        return metaInfo;
    }

    public static List getTableColumnValue(KDTable table, String columnName) {
        ArrayList<Object> list = new ArrayList<Object>();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            list.add(HRTableTools.getTableSelectCellValue(table, columnName, i));
        }
        return list;
    }

    public static void addColumnToTable(Context ctx, String tableName, String columnName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("if not exists (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='").append(columnName).append("' AND KSQL_COL_TABNAME='").append(tableName).append("')\n");
        sql.append("ALTER TABLE ").append(tableName).append(" ADD ").append(columnName).append(" VARCHAR(44) DEFAULT ''");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static String createPersonTempTable(Context ctx, Collection personIDColl) throws BOSException {
        return HRTableTools.createPersonTempTable(ctx, personIDColl, "FPersonID");
    }

    public static String createPersonTempTable(Context ctx, Collection columnValueColl, String columnKey) throws BOSException {
        String sql = " create TABLE aa (" + columnKey + " varchar(44) not null primary key) ";
        String temporaryTableName = null;
        try {
            temporaryTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e1) {
            throw new BOSException();
        }
        StringBuffer sbInsert = new StringBuffer(512);
        sbInsert.append(" INSERT INTO ").append(temporaryTableName).append("(" + columnKey + ")VALUES (?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sbInsert.toString());
            String ID = null;
            Iterator iter = columnValueColl.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ID = (String)iter.next();
                ps.setString(1, ID);
                ps.addBatch();
                if (++count != 8000) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return temporaryTableName;
    }

    public static String createTempTableAddSeq(Context ctx, List columnValueList, String columnKey, boolean addSeq) throws BOSException {
        String temporaryTableName = null;
        String sql = " create TABLE aa (" + columnKey + " varchar(44) not null ,fseq int) ";
        try {
            temporaryTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e1) {
            throw new BOSException();
        }
        StringBuffer sbInsert = new StringBuffer(512);
        sbInsert.append(" INSERT INTO ").append(temporaryTableName).append("(" + columnKey + ",fseq)VALUES (?,?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sbInsert.toString());
            String ID = null;
            int count = 0;
            for (int i = 0; i < columnValueList.size(); ++i) {
                ID = (String)columnValueList.get(i);
                ps.setString(1, ID);
                ps.setInt(2, i);
                ps.addBatch();
                if (++count != 8000) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return temporaryTableName;
    }

    public static void releaseTmpTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
    }

    public static String getEndInputTableName(Context ctx, String cmpSchemeID) throws BOSException {
        String sql = "select FTableName from T_HR_EndInputPart where fcmpschemeID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cmpSchemeID});
        String tableName = null;
        try {
            while (rs.next()) {
                tableName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (tableName == null) {
            tableName = "T_HR_PeriodEndInput";
        }
        return tableName;
    }

    public static String getEndInputTableName(String cmpSchemeID) throws BOSException {
        String sql = "select FTableName from T_HR_EndInputPart where fcmpschemeID = '" + cmpSchemeID + "'";
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        String tableName = null;
        try {
            while (rowSet.next()) {
                tableName = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (tableName == null) {
            tableName = "T_HR_PeriodEndInput";
        }
        return tableName;
    }
}

