/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.IMailServerSet;
import com.kingdee.eas.hr.base.MailServerSetFactory;
import com.kingdee.eas.hr.base.MailServerSetInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SalarySlipUtils {
    public static final String SALARYSLIP_FILENAME = "/HR/PB/SalarySlip";
    private static final String METADATA_FILENAME = "/HR/PB/SalarySlip/SalarySlip.bos-query";
    public static final String CMPITEMLIST_CTX = "cmpItem_list";
    public static final String SALARYDATA_CTX = "salary_data";
    public static final String SALARYNAME = "#NAME#";
    public static final String SALARYERROR_PERSON = "personlist";
    public static final String SALARYERROR_CMPSCHEME = "salary_cmpScheme";
    public static final String SALARYERROR_CMPPERIOD = "salary_cmpPeriod";
    public static final String SALARYERROR_TIME = "salary_beginTime";
    public static final String AttachmentID = "salary_AttachmentID";
    private Context ctx = null;
    private static SalarySlipUtils mailUtil = null;

    public static SalarySlipUtils getInstance(Context contex) {
        if (mailUtil == null) {
            mailUtil = new SalarySlipUtils();
        }
        SalarySlipUtils.mailUtil.ctx = contex;
        return mailUtil;
    }

    public static SalarySlipUtils getInstance() {
        if (mailUtil == null) {
            mailUtil = new SalarySlipUtils();
        }
        SalarySlipUtils.mailUtil.ctx = null;
        return mailUtil;
    }

    static MetaClass loadMetaClass() throws Exception {
        KDNoteHelper helper = new KDNoteHelper();
        MetaClass mc = helper.readMetaClass(METADATA_FILENAME);
        return mc;
    }

    static void saveMetaClass(MetaClass mc) throws Exception {
        KDNoteHelper helper = new KDNoteHelper();
        helper.writeMetaClass(mc, METADATA_FILENAME);
    }

    public static String strReplace(String from, String to, String source) {
        StringBuffer bf = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(source, from, true);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (tmp.equals(from)) {
                bf.append(to);
                continue;
            }
            bf.append(tmp);
        }
        return bf.toString();
    }

    static MetaField convertCmpItemToField(Context ctx, CmpItemInfo infoCmpItem) {
        MetaField mf = new MetaField();
        mf.setName(infoCmpItem.getNumber());
        Locale locale = SalarySlipUtils.getServerOriginalLocale(ctx);
        if (locale != null) {
            mf.setAlias(infoCmpItem.getName(), locale);
        } else {
            mf.setAlias(infoCmpItem.getName(), Locale.SIMPLIFIED_CHINESE);
        }
        mf.setType(DataType.STRING);
        return mf;
    }

    private static Locale getServerOriginalLocale(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo solution = loader.getSolution();
        LanguageCollection lc = solution.getLanguages();
        Locale locale = null;
        for (int i = 0; i < lc.size(); ++i) {
            if (!lc.get(i).getLocale().equals(ctx.getLocale())) continue;
            locale = lc.get(i).getOriginalLocale();
            break;
        }
        return locale;
    }

    public static void deleteCmpItem(CmpItemInfo infoCmpItem) throws Exception {
        MetaClass mc = SalarySlipUtils.loadMetaClass();
        MetaField mf = mc.getField(infoCmpItem.getNumber());
        if (mf != null) {
            mc.getFields().remove(mf);
        }
        SalarySlipUtils.saveMetaClass(mc);
    }

    public static void updateCmpItem(CmpItemInfo infoCmpItem) throws Exception {
        MetaClass mc = SalarySlipUtils.loadMetaClass();
        MetaField mf = mc.getField(infoCmpItem.getNumber());
        if (mf != null) {
            mf.setAlias(infoCmpItem.getName());
            mf.setDesc(infoCmpItem.getDescription());
            mf.setType(DataType.STRING);
        }
        SalarySlipUtils.saveMetaClass(mc);
    }

    public static void syncCmpItemData(Context ctx) throws Exception {
        MetaClass mc = SalarySlipUtils.loadMetaClass();
        mc.getFields().clear();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoItem.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        filterInfoItem.setMaskString("#0 and #1");
        evi.setFilter(filterInfoItem);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        if (rowSet.size() <= 0) {
            return;
        }
        CmpItemInfo infoCmpItem = new CmpItemInfo();
        while (rowSet.next()) {
            infoCmpItem.setNumber(rowSet.getString("number"));
            infoCmpItem.setName(rowSet.getString("name"));
            infoCmpItem.setDescription(rowSet.getString("description"));
            infoCmpItem.setDataType(ItemDataTypeEnum.getEnum(rowSet.getInt("datatype")));
            MetaField mf = SalarySlipUtils.convertCmpItemToField(ctx, infoCmpItem);
            mc.addField(mf);
        }
        SalarySlipUtils.saveMetaClass(mc);
    }

    static CmpItemInfo getTestCmpItem() {
        CmpItemInfo info = new CmpItemInfo();
        info.setNumber("test1213");
        info.setName("test121213");
        info.setDescription("des2");
        info.setDataType(ItemDataTypeEnum.STRING);
        return info;
    }

    public MailServerSetInfo getMailServerInfo() throws BOSException, BaseException, EASBizException {
        IMailServerSet iMSS = null;
        String oql = null;
        if (this.ctx == null) {
            iMSS = MailServerSetFactory.getRemoteInstance();
            oql = "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'";
        } else {
            iMSS = MailServerSetFactory.getLocalInstance((Context)this.ctx);
            oql = "where CU='" + ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId() + "'";
        }
        if (!iMSS.exists(oql)) {
            throw new BaseException(BaseException.SMTP_NOT_SET);
        }
        return iMSS.getMailServerSetInfo(oql);
    }

    public void sendHtmlMailForAct(Context ctx, String from, String to, String cc, String bcc, String subject, String body, MailServerSetInfo mssInfo, File attach) throws Exception {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", mssInfo.getSmtpAddress());
        MyAuthenticator authen = null;
        String pass = null;
        if (mssInfo.isIsAuth()) {
            props.put("mail.smtp.auth", "true");
            pass = CryptoTean.decrypt((String)mssInfo.getBOSType().toString(), (String)mssInfo.getSmtpPass());
            authen = new MyAuthenticator(mssInfo.getSmtpUser(), pass);
        } else {
            props.put("mail.smtp.auth", "false");
        }
        Session mailSession = Session.getDefaultInstance((Properties)props, authen);
        MimeMessage mimeMsg = new MimeMessage(mailSession);
        mimeMsg.setFrom((Address)new InternetAddress(mssInfo.getAdminAddress()));
        if (to != null) {
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        mimeMsg.setSubject(subject, "GBK");
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setContent((Object)body, "text/html;charset=GBK");
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        String attachName = attach.getName().substring(attach.getName().lastIndexOf("."));
        MimeBodyPart mbp2 = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(attach);
        mbp2.setDataHandler(new DataHandler((DataSource)fds));
        mbp2.setFileName(MimeUtility.encodeText((String)(subject + attachName), (String)"GBK", (String)"B"));
        mp.addBodyPart((BodyPart)mbp2);
        mimeMsg.setContent((Multipart)mp);
        mimeMsg.setSentDate(new Date());
        if (mimeMsg.getAllRecipients() != null && mimeMsg.getAllRecipients().length > 0) {
            if (mssInfo.isIsAuth()) {
                Transport transport = mailSession.getTransport("smtp");
                transport.connect(mssInfo.getSmtpAddress(), mssInfo.getSmtpUser(), pass);
                transport.sendMessage((Message)mimeMsg, mimeMsg.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)mimeMsg);
            }
        }
    }

    static class MyAuthenticator
    extends Authenticator {
        String user = null;
        String pass = null;

        public MyAuthenticator(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

