/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.util.PerHRAndCUUtil;
import com.kingdee.eas.hr.emp.EmpTypeConvertEnum;
import com.kingdee.eas.hr.emp.EmpTypeConvertException;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.AbstractEmpTypeConvertHisListUI;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmpTypeConvertHisListUI
extends AbstractEmpTypeConvertHisListUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpTypeConvertHisListUI.class);
    private String strPersonId = null;
    private Set strPersonIdSet = new HashSet();
    private boolean blIsOnePerson = false;
    private boolean isFirstDefaultQuery = true;
    private IObjectPK currentOrgPK = null;
    private Set cuSet = null;
    private Set hrSet = null;
    private boolean isRefreshParent = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.blIsOnePerson) {
            this.btnAudit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"252_EmpTypeConvertHisListUI"));
            this.actionRefresh_actionPerformed(null);
        } else {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"253_EmpTypeConvertHisListUI"));
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension();
        size.setSize(screenSize.getWidth() * 2.0 / 3.0, screenSize.getHeight() / 2.0);
        this.setPreferredSize(size);
    }

    protected void initWorkButton() {
        if (this.getUIContext().get("isOnePerson") != null && this.getUIContext().get("isOnePerson").toString().equals("1")) {
            this.blIsOnePerson = true;
            this.strPersonId = this.getUIContext().get("PersonID").toString();
            this.strPersonIdSet = (Set)this.getUIContext().get("PersonID");
        }
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnRemove.setEnabled(true);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action == null) {
            return null;
        }
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionAudit".equalsIgnoreCase(actionName) || "ActionRemove".equalsIgnoreCase(actionName)) {
            this.checkSelected();
            HashSet perSet = new HashSet();
            ArrayList perIdList = this.getSelectedIdValues();
            if (perIdList != null && perIdList.size() > 0) {
                perSet.add(perIdList.get(0));
            }
            Set hrNowSet = new HashSet();
            try {
                hrNowSet = PerHRAndCUUtil.getHRsFromPerSet(null, perSet);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            ObjectUuidPK currOrgPK = null;
            if (hrNowSet.toArray().length > 0) {
                currOrgPK = new ObjectUuidPK((String)hrNowSet.toArray()[0]);
            }
            return currOrgPK;
        }
        return super.getOrgPK(action);
    }

    private void checkManyHR() throws BOSException, EmployeeException, EmpTypeConvertException {
        this.getSelectList1();
        if (this.strPersonIdSet.size() > 0) {
            Set hrNowSet;
            this.hrSet = hrNowSet = PerHRAndCUUtil.getHRsFromPerSet(null, (Set)this.strPersonIdSet);
            this.cuSet = PerHRAndCUUtil.getCUsFromPerSet(null, (Set)this.strPersonIdSet);
            if (hrNowSet.size() > 1) {
                throw new EmployeeException(EmployeeException.MANYHR_NOT_SUPPORT, new Object[]{PerHRAndCUUtil.getHRsName(null, (Set)hrNowSet)});
            }
            if (this.hrSet.size() <= 0) {
                throw new EmpTypeConvertException(EmpTypeConvertException.HR_ERROR);
            }
            this.currentOrgPK = new ObjectUuidPK((String)this.hrSet.toArray()[0]);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkManyHR();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        List selectList = this.getSelectList1();
        if (selectList.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"254_EmpTypeConvertHisListUI"));
            return;
        }
        uiContext.put((Object)"hisIdList", (Object)this.getSelectList1());
        uiContext.put((Object)"isAudit", (Object)Boolean.TRUE);
        if (this.getUIContext().get("cadre") != null) {
            uiContext.put((Object)"cadre", (Object)"cadre");
        }
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        curDialog.show();
        this.isRefreshParent = ((EmpTypeConvertBatchEditUI)curDialog.getUIObject()).isStateChanged();
        this.tblMain.removeRows();
    }

    private List getSelectList1() {
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow iRow = null;
        ArrayList<String> selectList = new ArrayList<String>();
        String firstEtId = null;
        String nowEtId = null;
        if (this.strPersonIdSet != null) {
            this.strPersonIdSet.clear();
        }
        int size = index.length;
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(index[i]);
            firstEtId = this.tblMain.getRow(index[0]).getCell("fromEmpType.name").getValue().toString();
            if (!firstEtId.equals(nowEtId = iRow.getCell("fromEmpType.name").getValue().toString()) || ((BizEnumValueInfo)this.tblMain.getRow(index[i]).getCell("auditState").getValue()).getInt() == 1) continue;
            selectList.add(this.tblMain.getRow(index[i]).getCell("id").getValue().toString());
            this.strPersonIdSet.add(this.tblMain.getRow(index[i]).getCell("per.id").getValue().toString());
        }
        return selectList;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int iRowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        String strId = this.tblMain.getRow(iRowIndex).getCell("id").getValue().toString();
        EmpTypeConvertHisInfo info = EmpTypeConvertHisFactory.getRemoteInstance().getEmpTypeConvertHisInfo((IObjectPK)new ObjectUuidPK(strId));
        if (info.getAuditState().equals((Object)EmpTypeConvertEnum.AUDITED)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"255_EmpTypeConvertHisListUI"));
            return;
        }
        if (this.confirmRemove()) {
            this.Remove();
            super.actionRefresh_actionPerformed(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String hrIds = this.getHROrgUnitIds();
        String currentUserNumber = SysContext.getSysContext().getCurrentUserInfo().getNumber();
        String sql = "SELECT ADMIN.FID FROM T_ORG_ADMIN ADMIN left join T_ORG_UnitRelation OrgUR ON  ADMIN.FID=OrgUR.FFromUnitID LEFT JOIN T_PM_OrgRange ORGR ON ADMIN.FID = ORGR.FORGID LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID WHERE ((OrgUR.FToUnitID IN (" + hrIds + ") AND OrgUR.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5') OR ADMIN.FID IN (" + hrIds + ")) AND ORGR.FType = " + 20 + " AND PUSER.FNUMBER = '" + currentUserNumber + "'";
        try {
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)sql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)sql, CompareType.INNER));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (this.getUIContext().get("cadre") != null) {
            filter.getFilterItems().add(new FilterItemInfo("employee.isStandbyCadre", (Object)1));
            filter.setMaskString("(#0 or #1) and #2");
        } else {
            filter.setMaskString("#0 or #1");
        }
        return filter;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EmpTypeConvertHisListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (defaultView.getFilter() == null) {
                filter.getFilterItems().add(new FilterItemInfo("auditState", (Object)"0"));
            }
            filter.mergeFilter(this.getDefaultFilterForQuery(), "and");
            if (this.getUIContext().get("cadre") != null) {
                filter.getFilterItems().add(new FilterItemInfo("employee.isStandbyCadre", (Object)1));
                filter.mergeFilter(filter, "and");
            }
            filter.mergeFilter(defaultView.getFilter(), "and");
            defaultView.setFilter(filter);
            this.mainQuery = defaultView;
            this.refreshList();
        } else {
            super.actionQuery_actionPerformed(e);
        }
        this.isFirstDefaultQuery = false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("auditState", (Object)"0"));
        view.setFilter(filter);
        dlg.setDefalutEntityViewInfo(view);
        return dlg;
    }

    protected String getEditUIName() {
        return EmpTypeConvertEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpTypeConvertHisFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    public boolean isRefreshParent() {
        return this.isRefreshParent;
    }

    protected String getHROrgUnitIds() {
        String idString = "";
        try {
            StringBuffer idInfo = new StringBuffer();
            FullOrgUnitCollection orgCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.HRO, null, "employee_view");
            HashSet<String> ids = new HashSet<String>();
            if (orgCollection != null) {
                int n = orgCollection.size();
                for (int i = 0; i < n; ++i) {
                    ids.add(orgCollection.get(i).getId().toString());
                }
            }
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                idInfo.append("'").append(iterator.next().toString()).append("',");
            }
            idString = idInfo.substring(0, idInfo.length() - 1);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return idString;
    }
}

