/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ConfigSchemePermissionMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.EntityF7ConfigMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.MSFConfigMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.MenuConfigMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.QueryConfigMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.SchemeMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.StructureConfigMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.UIViewMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.ValidateMoveHandler;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class BasePlatformMoveHandler
implements ISHRMoveDataHandler {
    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        try {
            this.moveConfigSchemePermission(shrConn, ctx);
            this.moveEntityF7Config(shrConn, ctx);
            this.moveMenu(shrConn, ctx);
            this.moveMsfConfig(shrConn, ctx);
            this.movePermItem(shrConn, ctx);
            this.moveQueryConfig(shrConn, ctx);
            this.moveStructureConfig(shrConn, ctx);
            this.moveUiView(shrConn, ctx);
            this.moveScheme(shrConn, ctx);
            this.moveValidata(shrConn, ctx);
            this.moveDynamicListSetting(shrConn, ctx);
            this.moveWebServiceConfig(shrConn, ctx);
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_DynamicListSetting", e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void moveWebServiceConfig(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "T_HR_WebServiceConfig";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            UpdateTool.commonUpdate(shrConn, "T_HR_WebServiceConfig", "", ctx, 300);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveScheme(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "S_BS_SearchView";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
        try {
            SchemeMoveHandler schemeMove = new SchemeMoveHandler();
            schemeMove.moveData(shrConn, ctx);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveDynamicListSetting(Connection shrConn, Context ctx) throws EASBizException, BOSException, SQLException {
        try {
            SHRMoveDataHelpUtil.clearHrDataForBigField(shrConn, ctx, "T_BD_DynamicListSetting", "T_BD_DynamicListSetting_tmp", "FCONFIG");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_DynamicListSetting", "moving");
            UpdateTool.commonUpdate(shrConn, "T_BD_DynamicListSetting", "", ctx, 300);
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_DynamicListSetting", "FOwnerID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_DynamicListSetting".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_DynamicListSetting", e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SHRMoveDataHelpUtil.restore(shrConn, "T_BD_DynamicListSetting", "T_BD_DynamicListSetting_tmp", "FCONFIG");
        }
        try {
            UpdateTool.commonUpdate(shrConn, "T_BD_FieldRange", "", ctx, 300);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_FieldRange".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_FieldRange", e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(Connection conn, String tableName) throws SQLException {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<String> res = new ArrayList<String>();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            String sql = "select count(*) from " + tableName;
            state = conn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                res.add(rs.getString(1).toUpperCase());
            }
            if (res.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            state.close();
            conn.close();
            res.clear();
        }
        return false;
    }

    private void moveValidata(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        ValidateMoveHandler validateMove = new ValidateMoveHandler();
        validateMove.moveData(shrConn, ctx);
    }

    private void moveUiView(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        UIViewMoveHandler uIViewMoveHandler = new UIViewMoveHandler();
        uIViewMoveHandler.moveData(shrConn, ctx);
    }

    private void moveStructureConfig(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        StructureConfigMoveHandler structureConfigMove = new StructureConfigMoveHandler();
        structureConfigMove.moveData(shrConn, ctx);
    }

    private void moveQueryConfig(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        QueryConfigMoveHandler queryConfigMove = new QueryConfigMoveHandler();
        queryConfigMove.moveData(shrConn, ctx);
    }

    private void movePermItem(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "T_PM_PermItem";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete  from T_PM_PermItem where FLONGNUMBER like '%HR_WEB%' and fid not in('fffffff0-ffff-efff-97b7-000000000bb8PERMITEM','fffffff0-ffff-efff-97b7-000000000bb9PERMITEM','fffffff0-ffff-efff-97b7-000000000bbbPERMITEM','fffffff0-ffff-efff-dd69-0000000072aaPERMITEM','fffffff0-ffff-efff-dd69-0000000072abPERMITEM','fffffff0-ffff-efff-dd69-0000000072bcPERMITEM')";
            DbUtil.execute((Context)ctx, (String)delSql);
            UpdateTool.commonUpdate(shrConn, tableName, " where FLONGNUMBER like '%HR_WEB%' ", ctx, 200);
            UpdateTool.commonUpdate(shrConn, "T_PM_PermItemURL", "", ctx, 200);
            this.doDataClear();
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void doDataClear() throws BOSException, EASBizException {
        IPermItem PermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection perms = PermItem.getPermItemCollection("where LONGNUMBER like '%HR_WEB%' and LONGNUMBER like '%0040\u5b80\u693e\u7d85\u7f01\u5b58\u59e2%'");
        for (int i = 0; i < perms.size(); ++i) {
            PermItemInfo info = perms.get(i);
            info.setLongNumber(info.getLongNumber().replaceAll("\u5b80\u693e\u7d85\u7f01\u5b58\u59e2", "\u9471\u5c7c\u7d85\u7f01\u5b58\u59e2"));
            PermItem.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
        }
    }

    private void moveMsfConfig(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "T_BD_MSFConfig";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        MSFConfigMoveHandler mSFConfigMove = new MSFConfigMoveHandler();
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            mSFConfigMove.moveData(shrConn, ctx);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveMenu(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        MenuConfigMoveHandler menuConfigMove = new MenuConfigMoveHandler();
        menuConfigMove.moveData(shrConn, ctx);
    }

    private void moveEntityF7Config(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "T_BS_EntityF7Config";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            EntityF7ConfigMoveHandler entityF7ConfigMove = new EntityF7ConfigMoveHandler();
            entityF7ConfigMove.moveData(shrConn, ctx);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName.toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveConfigSchemePermission(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName = "T_HR_CONFIGSCHEMEPERMISSION";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            ConfigSchemePermissionMoveHandler configSchemePermissionMove = new ConfigSchemePermissionMoveHandler();
            configSchemePermissionMove.moveData(shrConn, ctx);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName.toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

