/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermItemURL;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermItemURLCollection;
import com.kingdee.eas.base.permission.PermItemURLFactory;
import com.kingdee.eas.base.permission.PermItemURLInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class PermItemMoveHandler
implements ISHRMoveDataHandler {
    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    public PermItemURLCollection compareData_Itemurl(Context ctx, PermItemURLCollection eas_url_collection, PermItemURLCollection shr_url_collection) {
        PermItemURLInfo infoEAS = null;
        PermItemURLInfo infoSHR = null;
        PermItemURLCollection diffCollectionSHR = new PermItemURLCollection();
        boolean match = false;
        for (int i = 0; i < shr_url_collection.size(); ++i) {
            infoSHR = shr_url_collection.get(i);
            for (int j = 0; j < eas_url_collection.size(); ++j) {
                infoEAS = eas_url_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Itemurl(Context ctx, PermItemURLCollection shr_url_collection) throws BOSException, EASBizException {
        PermItemURLInfo info = null;
        IPermItemURL iPermItemurl = PermItemURLFactory.getRemoteInstance();
        for (int i = 0; i < shr_url_collection.size(); ++i) {
            info = shr_url_collection.get(i);
            if (info.getParent() != null) {
                String parentId = info.getParent().getId().toString();
                if (!PermItemFactory.getRemoteInstance().exists("where id='" + parentId + "'")) continue;
            }
            iPermItemurl.addnew(info);
        }
    }

    public PermItemCollection compareData_Item(Context ctx, PermItemCollection eas_collection, PermItemCollection shr_collection) {
        PermItemInfo infoEAS = null;
        PermItemInfo infoSHR = null;
        PermItemCollection diffCollectionSHR = new PermItemCollection();
        boolean match = false;
        for (int i = 0; i < shr_collection.size(); ++i) {
            infoSHR = shr_collection.get(i);
            if (infoSHR.getNumber() == null) {
                match = false;
                continue;
            }
            for (int j = 0; j < eas_collection.size(); ++j) {
                infoEAS = eas_collection.get(j);
                if (infoEAS.getNumber() == null || !infoEAS.getId().toString().equals(infoSHR.getId().toString()) && !infoEAS.getNumber().equals(infoSHR.getNumber())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Item(Context ctx, PermItemCollection shr_collection) throws BOSException, EASBizException {
        PermItemInfo info = null;
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        for (int i = 0; i < shr_collection.size(); ++i) {
            info = shr_collection.get(i);
            iPermItem.addnew((CoreBaseInfo)info);
        }
    }

    public PermItemURLCollection getSHRData_PermItemUrl(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_PermItemURL";
        PermItemURLCollection shrCollection = new PermItemURLCollection();
        PermItemURLInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_PermItemURL".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fname = colummnsmap.containsKey("fname".toUpperCase()) ? rs.getString("fname") : "";
                String furl = colummnsmap.containsKey("furl".toUpperCase()) ? rs.getString("furl") : "";
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                String faction = colummnsmap.containsKey("faction".toUpperCase()) ? rs.getString("faction") : "";
                shrInfo = new PermItemURLInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setUrl(furl);
                shrInfo.setUipk(fuipk);
                shrInfo.setAction(faction);
                if (fparentid != null && !fparentid.isEmpty()) {
                    PermItemInfo info = new PermItemInfo();
                    info.setId(BOSUuid.read((String)fid));
                    shrInfo.setParent(info);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public PermItemCollection getSHRData_PermItem(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_PermItem";
        PermItemCollection shrCollection = new PermItemCollection();
        PermItemInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_PermItem".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fname = colummnsmap.containsKey("fname".toUpperCase()) ? rs.getString("fname") : "";
                String falias = colummnsmap.containsKey("falias_l2".toUpperCase()) ? rs.getString("falias_l2") : "";
                String flongnumber = colummnsmap.containsKey("flongnumber".toUpperCase()) ? rs.getString("flongnumber") : "";
                String fobjecttype = colummnsmap.containsKey("fobjecttype".toUpperCase()) ? rs.getString("fobjecttype") : "";
                String ftype = colummnsmap.containsKey("ftype".toUpperCase()) ? rs.getString("ftype") : "";
                String forgrelation = colummnsmap.containsKey("forgrelation".toUpperCase()) ? rs.getString("forgrelation") : "";
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fisleaf = colummnsmap.containsKey("fisleaf".toUpperCase()) ? rs.getString("fisleaf") : "";
                String foperationtype = colummnsmap.containsKey("foperationtype".toUpperCase()) ? rs.getString("foperationtype") : "";
                String fisapplytof7 = colummnsmap.containsKey("fisapplytof7".toUpperCase()) ? rs.getString("fisapplytof7") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String flevel = colummnsmap.containsKey("flevel".toUpperCase()) ? rs.getString("flevel") : "";
                String fisuserdefined = colummnsmap.containsKey("fisuserdefined".toUpperCase()) ? rs.getString("fisuserdefined") : "";
                String findex = colummnsmap.containsKey("findex".toUpperCase()) ? rs.getString("findex") : "";
                String flongindex = colummnsmap.containsKey("flongindex".toUpperCase()) ? rs.getString("flongindex") : "";
                String furl = colummnsmap.containsKey("furl".toUpperCase()) ? rs.getString("furl") : "";
                shrInfo = new PermItemInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setAlias(falias);
                shrInfo.setLongNumber(flongnumber);
                shrInfo.setObjectType(fobjecttype);
                shrInfo.put("fisapplytof7", (Object)fisapplytof7);
                shrInfo.setDescription(fdescription);
                shrInfo.put("flevel", (Object)flevel);
                shrInfo.put("furl", (Object)furl);
                shrInfo.setLongIndex(flongindex);
                if (findex != null && !findex.isEmpty()) {
                    shrInfo.setIndex(Integer.parseInt(findex));
                }
                if (fisuserdefined != null) {
                    boolean isuserdefined = fisuserdefined.equals("1");
                    shrInfo.setIsUserDefined(isuserdefined);
                }
                if (foperationtype != null && !foperationtype.isEmpty()) {
                    shrInfo.setOperationType(OperationType.getEnum((String)foperationtype));
                }
                if (fisleaf != null) {
                    boolean isleaf = fisleaf.equals("1");
                    shrInfo.setIsLeaf(isleaf);
                }
                if (fparentid != null && !fparentid.isEmpty()) {
                    PermItemInfo info = new PermItemInfo();
                    info.setId(BOSUuid.read((String)fid));
                    shrInfo.setParent(info);
                }
                if (forgrelation != null && !forgrelation.isEmpty()) {
                    shrInfo.setOrgRelation(OrgType.getEnum((String)forgrelation));
                }
                if (ftype != null && !ftype.isEmpty()) {
                    shrInfo.setType(PermItemType.getEnum((String)ftype));
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        PermItemCollection shr_collection = new PermItemCollection();
        PermItemCollection eas_collection = new PermItemCollection();
        PermItemURLCollection shr_url_collection = new PermItemURLCollection();
        PermItemURLCollection eas_url_collection = new PermItemURLCollection();
        shr_collection = this.getSHRData_PermItem(shrConn, ctx);
        eas_collection = PermItemFactory.getRemoteInstance().getPermItemCollection();
        shr_url_collection = this.getSHRData_PermItemUrl(shrConn, ctx);
        eas_url_collection = PermItemURLFactory.getRemoteInstance().getPermItemURLCollection();
        PermItemCollection diffQCollectionSHR_Item = null;
        if (eas_collection.isEmpty()) {
            this.addSHRDataToEAS_Item(ctx, shr_collection);
        } else {
            diffQCollectionSHR_Item = this.compareData_Item(ctx, eas_collection, shr_collection);
            if (diffQCollectionSHR_Item.size() > 0) {
                this.addSHRDataToEAS_Item(ctx, diffQCollectionSHR_Item);
            }
        }
        PermItemURLCollection diffQCollectionSHR_Itemurl = null;
        if (eas_url_collection.isEmpty()) {
            this.addSHRDataToEAS_Itemurl(ctx, shr_url_collection);
        } else {
            diffQCollectionSHR_Itemurl = this.compareData_Itemurl(ctx, eas_url_collection, shr_url_collection);
            if (diffQCollectionSHR_Itemurl.size() > 0) {
                this.addSHRDataToEAS_Itemurl(ctx, diffQCollectionSHR_Itemurl);
            }
        }
        return null;
    }
}

