/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmpContractBizException;
import com.kingdee.eas.hr.mvdt.SHRMVDTImportDataInfo;
import com.kingdee.eas.hr.mvdt.SHRMvTableListFactory;
import com.kingdee.eas.hr.mvdt.SHRMvTableListInfo;
import com.kingdee.eas.hr.mvdt.TableColumnConfigCollection;
import com.kingdee.eas.hr.mvdt.TableColumnConfigInfo;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDataMoveConstant;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class SHRImportEntityOrTableAnalyzeHandler {
    public ArrayList<SHRMVDTImportDataInfo> importDataList = new ArrayList();
    public boolean formatFlag = true;
    public Set<Integer> errorPos = new HashSet<Integer>();
    public Set<Integer> tipsPos = new HashSet<Integer>();
    public Set<String> existsTablesSet = new HashSet<String>();
    public Set<String> entityMappingTableSet = new HashSet<String>();
    public Context ctx = null;
    private int BIZTYPE_EXCEL_INDEX = 0;
    private int TABLE_NAME_INDEX = 1;
    private int TABLE_ALIAS_INDEX = 2;
    private int EXTRA_LP_INDEX = 3;
    private int ERROR_INFO = 4;

    public SHRImportEntityOrTableAnalyzeHandler() {
    }

    public SHRImportEntityOrTableAnalyzeHandler(Context ctx) {
        this.ctx = ctx;
    }

    public void initialization(Context ctx) throws IOException, BOSException {
        this.ctx = ctx;
        String localExcelPath = "W:\\a.xlsx";
        String localExcelLogPath = "W:\\a(error).xlsx";
        XSSFWorkbook xssfWorkbook = this.importExcelReader(localExcelPath);
        this.importExcelReaderCore(xssfWorkbook);
        this.importInfoAnalyzeAction();
        this.dealWithErrorInfo(xssfWorkbook, localExcelLogPath);
    }

    public String initialization2(Context ctx, XSSFWorkbook xssfWorkbook, HttpServletRequest request) throws IOException, BOSException {
        this.ctx = ctx;
        this.formatFlag = this.checkImportFileFormat(xssfWorkbook);
        if (this.formatFlag) {
            this.importExcelReaderCore(xssfWorkbook);
            this.truncateTableBeforeAnalyze();
            this.importInfoAnalyzeAction();
        }
        String errorPath = this.dealWithErrorInfo2(xssfWorkbook, request);
        return errorPath;
    }

    public XSSFWorkbook importExcelReader(String localExcelPath) throws IOException, BOSException {
        FileInputStream is = new FileInputStream(localExcelPath);
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)is);
        return xssfWorkbook;
    }

    public void importExcelReaderCore(XSSFWorkbook xssfWorkbook) {
        this.importDataList = new ArrayList();
        HashSet<String> existsEntityFullName = new HashSet<String>();
        for (int numSheet = 0; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
            for (int rowNum = 9; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                String tempBizType = xssfRow.getCell(this.BIZTYPE_EXCEL_INDEX) != null ? xssfRow.getCell(this.BIZTYPE_EXCEL_INDEX).toString() : "";
                String tempEntityOrTableName = xssfRow.getCell(this.TABLE_NAME_INDEX) != null ? xssfRow.getCell(this.TABLE_NAME_INDEX).toString() : "";
                String tempTableAlias = xssfRow.getCell(this.TABLE_ALIAS_INDEX) != null ? xssfRow.getCell(this.TABLE_ALIAS_INDEX).toString() : "";
                String tempEntityName = "";
                String tempTableName = "";
                String tempImportType = "";
                String extraLP = "";
                String verityBizType = this.isBizTypeLegal(tempBizType);
                String verifyEntiyOrTable = this.isEntityOrTableNameLegal(tempEntityOrTableName);
                if ("entity".equals(verifyEntiyOrTable)) {
                    tempEntityName = tempEntityOrTableName;
                    tempImportType = "entity";
                    verifyEntiyOrTable = "";
                } else if ("table".equals(verifyEntiyOrTable)) {
                    tempTableName = tempEntityOrTableName;
                    tempImportType = "table";
                    extraLP = xssfRow.getCell(this.EXTRA_LP_INDEX) != null ? xssfRow.getCell(this.EXTRA_LP_INDEX).toString() : "";
                    verifyEntiyOrTable = "";
                }
                SHRMVDTImportDataInfo tempDataInfo = new SHRMVDTImportDataInfo(numSheet, rowNum, tempBizType, tempImportType, tempEntityName, tempTableName, tempTableAlias, extraLP, "");
                if ("".equals(verityBizType) && "".equals(verifyEntiyOrTable)) {
                    if ("entity".equals(tempImportType)) {
                        if (existsEntityFullName.contains(tempEntityName.toUpperCase())) {
                            tempDataInfo.setErrorInfo("\u5b9e\u4f53\u5df2\u5b58\u5728\u3002");
                            this.errorPos.add(this.importDataList.size());
                        } else {
                            existsEntityFullName.add(tempEntityName.toUpperCase());
                        }
                    } else if ("table".equals(tempImportType)) {
                        if (this.existsTablesSet.contains(tempTableName.toUpperCase())) {
                            tempDataInfo.setErrorInfo("\u8868\u5df2\u7ecf\u5b58\u5728\u3002");
                            this.errorPos.add(this.importDataList.size());
                        } else {
                            this.existsTablesSet.add(tempTableName.toUpperCase());
                        }
                    }
                } else {
                    tempDataInfo.setErrorInfo(verityBizType + verifyEntiyOrTable);
                    this.errorPos.add(this.importDataList.size());
                }
                this.importDataList.add(tempDataInfo);
            }
        }
    }

    private String isBizTypeLegal(String bizType) {
        return "";
    }

    private String isEntityOrTableNameLegal(String entityOrTableName) {
        Pattern patternEntity = Pattern.compile("\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*", 2);
        Pattern patternTable = Pattern.compile("\\w+([-_]\\w+)*\\_\\w+([-_]\\w+)*", 2);
        Matcher matcherEntity = patternEntity.matcher(entityOrTableName);
        Matcher matcherTable = patternTable.matcher(entityOrTableName);
        if (matcherEntity.matches()) {
            return "entity";
        }
        if (matcherTable.matches()) {
            return "table";
        }
        return "\u975e\u6cd5\u7684\u5b9e\u4f53\u6216\u8005\u8868\u540d\u3002";
    }

    public void importInfoAnalyzeAction() {
        for (int pos = 0; pos < this.importDataList.size(); ++pos) {
            if (this.errorPos.contains(pos)) continue;
            String tempImportType = this.importDataList.get(pos).getImportType();
            if ("entity".equals(tempImportType)) {
                this.SHREntityAnalyzeAction(this.importDataList.get(pos), pos);
                continue;
            }
            if (!"table".equals(tempImportType)) continue;
            this.SHRTableAnalyzeAction(this.importDataList.get(pos), pos);
        }
    }

    public void dealWithErrorInfo(XSSFWorkbook xssfWorkbook, String path) throws IOException {
        for (int i : this.errorPos) {
            xssfWorkbook.getSheetAt(this.importDataList.get(i).getSheetNumber()).getRow(this.importDataList.get(i).getRowNumber()).createCell(this.ERROR_INFO).setCellValue(this.importDataList.get(i).getErrorInfo());
            xssfWorkbook.getSheetAt(this.importDataList.get(i).getSheetNumber()).getRow(this.importDataList.get(i).getRowNumber()).getCell(this.ERROR_INFO).getCellStyle().getFont();
        }
        for (int j : this.tipsPos) {
            xssfWorkbook.getSheetAt(this.importDataList.get(j).getSheetNumber()).getRow(this.importDataList.get(j).getRowNumber()).createCell(this.ERROR_INFO).setCellValue(this.importDataList.get(j).getErrorInfo());
        }
        if (!(this.errorPos.isEmpty() && this.tipsPos.isEmpty() && this.formatFlag)) {
            FileOutputStream out = new FileOutputStream(path);
            xssfWorkbook.write((OutputStream)out);
        }
    }

    public String dealWithErrorInfo2(XSSFWorkbook xssfWorkbook, HttpServletRequest request) throws IOException {
        String excelPath = "";
        if (!(this.errorPos.isEmpty() && this.tipsPos.isEmpty() && this.formatFlag)) {
            File file;
            HttpSession session = request.getSession();
            String fileAbsolutePath = UserUtil.getUserTempDirAbsolutePath((HttpSession)session);
            String fileTempPath = UserUtil.getUserTempDir((HttpSession)session);
            String fileName = "\u9519\u8bef\u6a21\u677f.xlsx";
            String fileUrl = fileAbsolutePath + File.separator + fileName;
            excelPath = request.getContextPath() + fileTempPath + File.separator + fileName;
            File filedir = new File(fileAbsolutePath);
            if (!filedir.exists()) {
                filedir.mkdirs();
            }
            if (!(file = new File(fileUrl)).exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            this.dealWithErrorInfo(xssfWorkbook, fileUrl);
        }
        return excelPath;
    }

    public void SHREntityAnalyzeAction(SHRMVDTImportDataInfo importDataInfo, int pos) {
        String entityName = importDataInfo.getEntityFullName();
        String bizType = importDataInfo.getBizType();
        EntityObjectInfo entityInfo = this.getEntityInfoByEntityFullName(entityName);
        if (entityInfo != null) {
            this.SHREntityAnalyzeManager(entityInfo, bizType, pos);
        } else {
            this.importDataList.get(pos).setErrorInfo("\u5f53\u524d\u73af\u5883\u627e\u4e0d\u5230\u6b64\u5b9e\u4f53.");
            this.errorPos.add(pos);
        }
    }

    public void SHRTableAnalyzeAction(SHRMVDTImportDataInfo importDataInfo, int pos) {
        String tableName = importDataInfo.getTableName().toUpperCase();
        String tableAlias = importDataInfo.getTableAlias();
        String bizType = importDataInfo.getBizType();
        String extraLP = importDataInfo.getExtraLP();
        if (this.entityMappingTableSet.contains(tableName)) {
            this.importDataList.get(pos).setErrorInfo("\u5df2\u5b58\u5728\u5b9e\u4f53\u5bf9\u5e94\u8868\u3002");
            this.errorPos.add(pos);
        } else {
            try {
                Map<String, ColumnInfo> tableColumnMap = TableColumnSyncTool.getSHRTableColumnMap(this.ctx, tableName);
                if (!tableColumnMap.isEmpty()) {
                    this.SHRTableAnalyzeManager(tableName, tableAlias, tableColumnMap, bizType, extraLP, pos);
                } else {
                    this.importDataList.get(pos).setErrorInfo("\u6b64\u8868\u5728\u5f53\u524d\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u3002");
                    this.errorPos.add(pos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.importDataList.get(pos).setErrorInfo("\u6b64\u8868\u4e0d\u5b58\u5728\u6216\u4e0d\u80fd\u89e3\u6790\u3002");
                this.errorPos.add(pos);
            }
        }
    }

    private void SHREntityAnalyzeManager(EntityObjectInfo entityInfo, String bizType, int pos) {
        if (entityInfo.getTable() == null) {
            this.importDataList.get(pos).setErrorInfo("\u6b64\u5b9e\u4f53\u6ca1\u6709\u5bf9\u5e94\u8868\u3002");
            this.errorPos.add(pos);
        } else {
            String tableName = entityInfo.getTable().getName().toUpperCase();
            String tableAlias = entityInfo.getTable().getAlias();
            if (this.existsTablesSet.contains(tableName)) {
                this.importDataList.get(pos).setErrorInfo("\u6b64\u5b9e\u4f53\u5bf9\u5e94\u8868\u5df2\u5b58\u5728\u3002");
                this.errorPos.add(pos);
            } else {
                this.entityMappingTableSet.add(tableName);
                this.saveEntityOfSHRMvTableList(entityInfo, bizType, tableName, tableAlias, null);
            }
        }
    }

    public void saveEntityOfSHRMvTableList(EntityObjectInfo entityInfo, String bizType, String tableName, String tableAlias, Integer dataType) {
        String entityDirectParentFullName;
        BusinessObjectInfo entityDirectParent;
        TableColumnConfigCollection tccc = new TableColumnConfigCollection();
        do {
            PropertyCollection propColl;
            if ((propColl = entityInfo.getProperties()).isEmpty()) continue;
            tccc.addCollection(this.SHREntityPropertyAnalyzer(propColl, tableName));
        } while ((entityDirectParent = entityInfo.getParent()) != null && (entityInfo = this.getEntityInfoByEntityFullName(entityDirectParentFullName = entityDirectParent.getFullName())) != null);
        SHRMvTableListInfo mvtli = this.SHRMvTableListInfoBuilder(bizType, tableName, tableAlias, tccc, dataType);
        this.saveSHRMvTableList(mvtli);
    }

    private void SHRTableAnalyzeManager(String tableName, String tableAlias, Map<String, ColumnInfo> tableColumnMap, String bizType, String extraLP, int pos) {
        Map<String, String> exMap = this.linkedPropertyMatchedFilter(tableColumnMap, extraLP, pos);
        TableColumnConfigCollection tccc = this.SHRTableColumnAnalyzer(tableName, tableColumnMap, exMap);
        SHRMvTableListInfo mvtli = this.SHRMvTableListInfoBuilder(bizType, tableName, tableAlias, tccc);
        this.saveSHRMvTableList(mvtli);
    }

    private Map<String, String> linkedPropertyMatchedFilter(Map<String, ColumnInfo> tableColumnMap, String extraLP, int pos) {
        HashMap<String, String> exMap = new HashMap<String, String>();
        if (!"".equals(extraLP)) {
            extraLP = extraLP.replaceAll("\uff0c", ",").replaceAll("\uff1a", ":");
            LinkedList exLinkedList = new LinkedList(Arrays.asList((Object[])extraLP.toUpperCase().split(",")));
            for (int i = 0; i < exLinkedList.size(); ++i) {
                String tempLP = ((String)exLinkedList.get(i)).split(":")[0];
                if (tableColumnMap.get(tempLP) != null) continue;
                this.importDataList.get(pos).appendErrorInfo("this linked property:" + tempLP + " is not exists.");
                this.tipsPos.add(pos);
                exLinkedList.remove(i);
            }
            for (String ex : exLinkedList) {
                exMap.put(ex.split(":")[0], ex.split(":")[1]);
            }
        }
        return exMap;
    }

    private TableColumnConfigCollection SHRTableColumnAnalyzer(String tableName, Map<String, ColumnInfo> tableColumnMap, Map<String, String> exMap) {
        TableColumnConfigCollection tccc = new TableColumnConfigCollection();
        for (String key : tableColumnMap.keySet()) {
            String columnType = exMap.get(key) == null ? "" : exMap.get(key).toLowerCase();
            if ("".equals(columnType)) continue;
            tccc.add(this.tableColumnConfigInfoBuilder(tableName, key, columnType));
        }
        return tccc;
    }

    private TableColumnConfigCollection SHREntityPropertyAnalyzer(PropertyCollection propColl, String tableName) {
        Iterator ite = propColl.iterator();
        TableColumnConfigCollection tccc = new TableColumnConfigCollection();
        while (ite.hasNext()) {
            RelationshipInfo relation;
            PropertyInfo currentPropertyInfo = (PropertyInfo)ite.next();
            BOSObjectType currentBOSType = currentPropertyInfo.getBOSType();
            String columnName = "";
            if (currentPropertyInfo.getMappingField() == null) continue;
            columnName = currentPropertyInfo.getMappingField().getName();
            String columnType = "";
            if (!currentBOSType.equals((Object)SHRDataMoveConstant.LINKED_PROPERTY) || "".equals(columnType = SHRImportEntityOrTableAnalyzeHandler.isSupplierObjectMatchedTargetEntity(relation = (RelationshipInfo)currentPropertyInfo.getStateManager().getStateValue("relationship")))) continue;
            tccc.add(this.tableColumnConfigInfoBuilder(tableName, columnName, columnType));
        }
        return tccc;
    }

    private SHRMvTableListInfo SHRMvTableListInfoBuilder(String bizType, String tableName, String tableAlias, TableColumnConfigCollection tccc, Integer dataType) {
        SHRMvTableListInfo mvtli = this.SHRMvTableListInfoBuilder(bizType, tableName, tableAlias, tccc);
        if (dataType != null) {
            mvtli.setDataType(dataType);
        }
        return mvtli;
    }

    private SHRMvTableListInfo SHRMvTableListInfoBuilder(String bizType, String tableName, String tableAlias, TableColumnConfigCollection tccc) {
        SHRMvTableListInfo mvtli = new SHRMvTableListInfo();
        mvtli.setBizType(bizType);
        mvtli.setMvSatus("not begin");
        mvtli.setMvTableName(tableName);
        mvtli.setMvTableAlias(tableAlias);
        mvtli.setDataType(3);
        mvtli.setRefreshIdStatus(false);
        mvtli.getTblColumns().addCollection(tccc);
        return mvtli;
    }

    private TableColumnConfigInfo tableColumnConfigInfoBuilder(String tableName, String columnName, String columnType) {
        TableColumnConfigInfo tcci = new TableColumnConfigInfo();
        tcci.setMvTableName(tableName);
        tcci.setColumnName(columnName);
        tcci.setColumnType(columnType);
        tcci.setDataType(1);
        return tcci;
    }

    protected void saveSHRMvTableList(SHRMvTableListInfo mvtli) {
        try {
            SHRMvTableListFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)mvtli);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityObjectInfo getEntityInfoByEntityFullName(String entityFullName) {
        EntityObjectInfo entityInfo = null;
        try {
            entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)new MetaDataPK(entityFullName));
            return entityInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return entityInfo;
        }
    }

    private void truncateTableBeforeAnalyze() throws BOSException {
        String[] truncateSql;
        for (String sql : truncateSql = new String[]{"delete from T_HR_TableColumnConfig where FMvTableID IN (SELECT FID from T_HR_SHRMvTableList where FDataType = 3)", "delete from T_HR_SHRMvTableList where FDataType = 3"}) {
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
    }

    public static String isSupplierObjectMatchedTargetEntity(RelationshipInfo relation) {
        String supplierObjectFullName = relation.getSupplierObject().getFullName();
        if (supplierObjectFullName.equals("com.kingdee.eas.basedata.person.app.Person")) {
            return "person";
        }
        if (supplierObjectFullName.equals("com.kingdee.eas.basedata.org.app.AdminOrgUnit")) {
            return "adminOrg";
        }
        if (supplierObjectFullName.equals("com.kingdee.eas.basedata.org.app.Position")) {
            return "position";
        }
        if (supplierObjectFullName.equals("com.kingdee.eas.basedata.org.app.Job")) {
            return "job";
        }
        if (supplierObjectFullName.equals("com.kingdee.eas.base.permission.app.User")) {
            return "user";
        }
        return "";
    }

    public void downloadTemplateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        File file;
        HttpSession session = request.getSession();
        String fileAbsolutePath = UserUtil.getUserTempDirAbsolutePath((HttpSession)session);
        String fileTempPath = UserUtil.getUserTempDir((HttpSession)session);
        String fileName = "\u5bfc\u5165\u6a21\u677f.xlsx";
        String fileUrl = fileAbsolutePath + File.separator + fileName;
        String excelPath = request.getContextPath() + fileTempPath + File.separator + fileName;
        File filedir = new File(fileAbsolutePath);
        if (!filedir.exists()) {
            filedir.mkdirs();
        }
        if (!(file = new File(fileUrl)).exists()) {
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        XSSFCell createCell = null;
        XSSFFont font1 = xssfWorkbook.createFont();
        font1.setColor(IndexedColors.RED.index);
        font1.setBold(true);
        XSSFCellStyle cellStyle1 = xssfWorkbook.createCellStyle();
        cellStyle1.setFont((Font)font1);
        XSSFCellStyle cellStyleBoderLeft = xssfWorkbook.createCellStyle();
        cellStyleBoderLeft.setBorderLeft(BorderStyle.THICK);
        xssfWorkbook.createSheet("\u5bfc\u5165\u5217\u8868");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").setColumnWidth(0, 2560);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").setColumnWidth(1, 8960);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").setColumnWidth(2, 11520);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").setColumnWidth(3, 12800);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").setColumnWidth(4, 5120);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(0, 0, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(1, 1, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(2, 2, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(3, 3, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(4, 4, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(5, 5, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(6, 6, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").addMergedRegion(new CellRangeAddress(7, 7, 0, 4));
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(0);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(0).createCell(0).setCellValue("\u6a21\u677f\u8bf4\u660e\uff1a");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(1);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(1).createCell(0).setCellStyle((CellStyle)cellStyle1);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(1).getCell(0).setCellValue("\u5b9e\u4f53\u5168\u8def\u5f84\uff08\u6216\u8868\u540d\uff09\uff1a\u5fc5\u586b\u9879\uff0c\u4e0a\u4f20\u540e\u5c06\u4f1a\u6309\u7167\u586b\u5199\u7684\u5168\u8def\u5f84\u6216\u8868\u540d\u8fdb\u884c\u5339\u914d\u8fc1\u79fb\uff1b");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(2);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(2).createCell(0).setCellValue("\u4e1a\u52a1\u9886\u57df\uff1a\u9009\u62e9\u586b\u5199\uff0c\u7528\u4e8e\u5bf9\u8fc1\u79fb\u7684\u6570\u636e\u8868\u8fdb\u884c\u5206\u7c7b\uff0c\u4fbf\u4e8e\u67e5\u770b\uff1b");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(3);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(3).createCell(0).setCellValue("\u8868\u522b\u540d\uff1a\u975e\u5fc5\u586b\uff0c\u5f53\u586b\u5199\u5b9e\u4f53\u5168\u8def\u5f84\u65f6\uff0c\u8868\u522b\u540d\u4f1a\u81ea\u52a8\u4ece\u5b9e\u4f53\u4e0a\u83b7\u53d6\uff1b\u5f53\u586b\u5199\u8868\u540d\u65f6\uff0c\u53ef\u9009\u62e9\u586b\u5199\uff0c\u7528\u4e8e\u5bf9\u8fc1\u79fb\u7684\u6570\u636e\u8868\u8fdb\u884c\u5907\u6ce8\uff0c\u4fbf\u4e8e\u67e5\u770b\uff1b");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(4);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(4).createCell(0).setCellValue("\u81ea\u5b9a\u4e49\u5916\u952e\uff1a\uff08\u975e\u5e38\u91cd\u8981\uff09\u975e\u5fc5\u586b\uff0c\u5f53\u4e8c\u5f00\u6570\u636e\u8868\u6709\u5f15\u7528\u7ec4\u7ec7\u3001\u804c\u4f4d\u3001\u5c97\u4f4d\u3001\u5458\u5de5\u3001\u7528\u6237ID\u65f6\uff0c\u52a1\u5fc5\u586b\u5199\u81ea\u5b9a\u4e49\u5916\u952e\uff0c\u5728\u5bfc\u5165\u65f6\u4f1a\u8fdb\u884c\u5237\u65b0\uff0c");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(4).getCell(0).setCellStyle((CellStyle)cellStyle1);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(5);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(5).createCell(0).setCellValue("\u82e5\u6709\u5f15\u7528\u4f46\u672a\u586b\u5199\uff0c\u53ef\u80fd\u5bfc\u81f4\u8fc1\u79fb\u540e\u6570\u636e\u4e0d\u5bf9");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(5).getCell(0).setCellStyle((CellStyle)cellStyle1);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(6);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(6).createCell(0).setCellValue("\u9519\u8bef\u4fe1\u606f\uff1a\u5bfc\u5165\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u7cfb\u7edf\u81ea\u52a8\u586b\u5145\uff0c\u8bf7\u52ff\u586b\u5199\u3002");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(7);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(7).createCell(0).setCellValue("\u4e0b\u8868\u84dd\u8272\u5b57\u4f53\u4e3a\u53c2\u8003\u6837\u4f8b\uff0c\u8bf7\u6e05\u7a7a\u540e\u586b\u5199\u3002");
        for (int i = 0; i <= 7; ++i) {
            xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(i).createCell(5).setCellStyle((CellStyle)cellStyleBoderLeft);
        }
        XSSFFont font2 = xssfWorkbook.createFont();
        font2.setColor(IndexedColors.BLACK.index);
        font2.setBold(true);
        XSSFCellStyle cellStyle2 = xssfWorkbook.createCellStyle();
        cellStyle2.setFont((Font)font2);
        cellStyle2.setBorderTop(BorderStyle.THICK);
        XSSFCellStyle cellStyleBoderTop = xssfWorkbook.createCellStyle();
        cellStyleBoderTop.setBorderTop(BorderStyle.THICK);
        XSSFCellStyle _cellStyle1 = cellStyle1.clone();
        _cellStyle1.setBorderTop(BorderStyle.THICK);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(8);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).createCell(0).setCellValue("\u4e1a\u52a1\u9886\u57df");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).getCell(0).setCellStyle((CellStyle)cellStyleBoderTop);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).createCell(1).setCellStyle((CellStyle)_cellStyle1);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).getCell(1).setCellValue("\u5b9e\u4f53\u5168\u8def\u5f84 \uff08\u6216\u8868\u540d\uff09");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).createCell(2).setCellValue("\u8868\u522b\u540d");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).getCell(2).setCellStyle((CellStyle)cellStyleBoderTop);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).createCell(3).setCellStyle((CellStyle)cellStyle2);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).getCell(3).setCellValue("\u81ea\u5b9a\u4e49\u5916\u952e");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).createCell(4).setCellValue("\u9519\u8bef\u4fe1\u606f");
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(8).getCell(4).setCellStyle((CellStyle)cellStyleBoderTop);
        XSSFCellStyle cellStyle3 = xssfWorkbook.createCellStyle();
        XSSFFont font3 = xssfWorkbook.createFont();
        font3.setItalic(true);
        font3.setColor(IndexedColors.BLUE.index);
        cellStyle3.setFont((Font)font3);
        xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").createRow(9);
        createCell = xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(9).createCell(0);
        createCell.setCellStyle((CellStyle)cellStyle3);
        createCell.setCellValue("\u4f8b:ATS");
        createCell = xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(9).createCell(1);
        createCell.setCellStyle((CellStyle)cellStyle3);
        createCell.setCellValue("\u4f8b:com.kingdee.eas.hr.ats.app.AtsTripBill");
        createCell = xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(9).createCell(2);
        createCell.setCellStyle((CellStyle)cellStyle3);
        createCell.setCellValue("");
        createCell = xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(9).createCell(3);
        createCell.setCellStyle((CellStyle)cellStyle3);
        createCell.setCellValue("person");
        createCell = xssfWorkbook.getSheet("\u5bfc\u5165\u5217\u8868").getRow(9).createCell(4);
        createCell.setCellStyle((CellStyle)cellStyle3);
        createCell.setCellValue("");
        FileOutputStream out = new FileOutputStream(fileUrl);
        xssfWorkbook.write((OutputStream)out);
        HashMap<String, String> gridDataMap = new HashMap<String, String>();
        gridDataMap.put("url", excelPath);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public void importDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String errorPath = "";
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile file = (MultipartFile)entity.getValue();
                XSSFWorkbook wb = null;
                wb = new XSSFWorkbook(file.getInputStream());
                if (wb == null) {
                    throw new SHRWebException((Throwable)new EmpContractBizException(EmpContractBizException.CANNOT_READ_EXCEL));
                }
                Context ctx = SHRContext.getInstance().getContext();
                errorPath = this.initialization2(ctx, wb, request);
            }
        }
        if (!"".equals(errorPath) && errorPath != null) {
            returnMap.put("importStatus", false);
        } else {
            returnMap.put("importStatus", true);
        }
        returnMap.put("url", errorPath);
        JSONUtils.writeJson((HttpServletResponse)response, returnMap);
    }

    private boolean checkImportFileFormat(XSSFWorkbook xssfWorkbook) {
        XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
        XSSFRow xssfRow = xssfSheet.getRow(8);
        if (!(xssfRow.getCell(this.BIZTYPE_EXCEL_INDEX).toString().equals("\u4e1a\u52a1\u9886\u57df") && xssfRow.getCell(this.TABLE_NAME_INDEX).toString().equals("\u5b9e\u4f53\u5168\u8def\u5f84 \uff08\u6216\u8868\u540d\uff09") && xssfRow.getCell(this.TABLE_ALIAS_INDEX).toString().equals("\u8868\u522b\u540d") && xssfRow.getCell(this.EXTRA_LP_INDEX).toString().equals("\u81ea\u5b9a\u4e49\u5916\u952e") && xssfRow.getCell(this.ERROR_INFO).toString().equals("\u9519\u8bef\u4fe1\u606f"))) {
            xssfWorkbook.removeSheetAt(0);
            xssfWorkbook.createSheet("\u9519\u8bef\u4fe1\u606f");
            xssfWorkbook.getSheet("\u9519\u8bef\u4fe1\u606f").createRow(0).createCell(0).setCellValue("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u7b26\u5408\u4e0b\u8f7d\u6a21\u677f\u7684\u683c\u5f0f\uff0c\u65e0\u6cd5\u89e3\u6790\u3002");
            return false;
        }
        return true;
    }
}

