/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.domain.UserMergeInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.RoleMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.UserGroupMoveHandler;
import com.kingdee.eas.hr.mvdt.handler.UserOrgPermMoveHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.hr.mvdt.util.WriteExcelDataTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class UserMoveHandler
implements ISHRMoveDataHandler {
    public static final String BOSTYPE = "13B7DE7F";
    private static final int AllONLY = 0;
    private static final int EASONLY = 1;
    private static final int SHRONLY = 2;
    private UserCollection userCollection_EAS = null;
    private UserCollection userCollection_SHR = null;
    private PersonCollection personCollection_EAS = null;
    private PersonCollection personCollection_SHR = null;
    private static Logger logger = Logger.getLogger(UserMoveHandler.class);
    public static List<String> excelHead = new ArrayList<String>();

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        RoleMoveHandler rolemoveHandler = new RoleMoveHandler();
        UserGroupMoveHandler usergroupHandler = new UserGroupMoveHandler();
        UserOrgPermMoveHandler userOrgPermHandler = new UserOrgPermMoveHandler();
        this.verifyData_Self(shrConn, ctx);
        return null;
    }

    private String verifyData_Self(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        Statement state = null;
        ResultSet rs = null;
        String tableName = "T_PM_USER";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return null;
        }
        try {
            String shrSql = "select FID,FNUMBER,FNAME_L2 from T_PM_USER ORDER BY FNUMBER";
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                String shrUserId = rs.getString(1);
                String shrUserNumber = rs.getString(2);
                String shrUserName = rs.getString(3);
                String easUserId = "";
                String sql = "select FID FROM T_PM_USER WHERE  FNUMBER = '" + shrUserNumber + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    String oql = "where bosType ='13B7DE7F' AND shrId = '" + shrUserId + "'";
                    SynIdMappingFactory.getRemoteInstance().delete(oql);
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    easUserId = executeQuery.getString("FID");
                    synIdMappingInfo.setBosType(BOSTYPE);
                    synIdMappingInfo.setShrId(shrUserId);
                    synIdMappingInfo.setEasId(easUserId);
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void exportUserExcle(Connection shrConn, Context ctx, HSSFWorkbook workbook, HSSFSheet sheet) throws EASBizException, BOSException, SQLException {
        ArrayList userorgpermDatas = new ArrayList();
        ArrayList<List<String>> userDatas = new ArrayList<List<String>>();
        this.VerifyUserData(shrConn, ctx, userDatas);
        HSSFCellStyle stringValueStyle = workbook.createCellStyle();
        stringValueStyle.setAlignment(HorizontalAlignment.LEFT);
        stringValueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        HSSFRow row = sheet.createRow(3);
        int size = userDatas.size();
        for (int i = 0; i < size; ++i) {
            row = sheet.createRow(3 + i);
            List rowVal = (List)userDatas.get(i);
            int num = rowVal.size();
            for (int j = 0; j < num; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue((String)rowVal.get(j));
            }
        }
    }

    public void VerifyUserData(Connection shrConn, Context ctx, List<List<String>> userDatas) throws BOSException, SQLException, EASBizException {
        this.userCollection_EAS = UserFactory.getRemoteInstance().getUserCollection();
        this.userCollection_SHR = this.getSHRData(shrConn, ctx);
        this.compareData(null, null, shrConn, ctx, this.userCollection_EAS, this.userCollection_SHR, userDatas);
    }

    private UserCollection compareData(UserCollection diffCollectionSHR, List userMergeInfos, Connection shrConn, Context ctx, UserCollection userCollection_EAS, UserCollection userCollection_SHR, List<List<String>> userDatas) throws BOSException, SQLException, EASBizException {
        UserInfo infoEAS = new UserInfo();
        UserInfo infoSHR = new UserInfo();
        boolean match = false;
        boolean personIsNull_SHR = false;
        String oql = "where bosType ='13B7DE7F'";
        SynIdMappingFactory.getRemoteInstance().delete(oql);
        PersonInfo personSHR = null;
        Object personEAS = null;
        for (int i = 0; i < userCollection_SHR.size(); ++i) {
            infoSHR = userCollection_SHR.get(i);
            personSHR = infoSHR.getPerson();
            personIsNull_SHR = personSHR == null;
            if (!personIsNull_SHR) {
                for (int j = 0; j < userCollection_EAS.size(); ++j) {
                    infoEAS = userCollection_EAS.get(j);
                    if (infoEAS.getPerson() == null || !infoSHR.getNumber().equals(infoEAS.getNumber())) continue;
                    this.generateMappingTable(ctx, infoSHR.getId().toString(), infoEAS.getId().toString());
                    this.generateMappingTrueExcelData(ctx, infoSHR, infoEAS, userDatas, "\u81ea\u52a8\u5408\u5e76");
                    match = true;
                    break;
                }
            }
            if (!match) {
                this.generateNotFoundInEASMappingExcelData(ctx, infoSHR, infoEAS, userDatas);
                if (diffCollectionSHR == null) continue;
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private int IsOnlyUser(PersonInfo personSHR, PersonInfo personEAS, UserCollection userCollection_SHR, UserCollection userCollection_EAS) throws BOSException {
        int count = 0;
        for (int i = 0; i < userCollection_EAS.size(); ++i) {
            if (userCollection_EAS.get(i).getPerson() == null || !userCollection_EAS.get(i).getPerson().getId().toString().equals(personEAS.getId().toString()) || ++count <= 1) continue;
            return 1;
        }
        boolean isOnly = true;
        String personID_SHE = personSHR.getId().toString();
        count = 0;
        for (int i = 0; i < userCollection_SHR.size(); ++i) {
            if (userCollection_SHR.get(i).getPerson() == null || !personID_SHE.equals(userCollection_SHR.get(i).getPerson().getId().toString()) || ++count <= 2) continue;
            isOnly = false;
            break;
        }
        if (isOnly) {
            return 0;
        }
        return 2;
    }

    private PersonInfo getPersonInfoFromCollection(String personID, PersonCollection personCollection, PersonInfo defaultInfo) {
        for (int i = 0; i < personCollection.size(); ++i) {
            if (!personID.equals(personCollection.get(i).getId().toString())) continue;
            defaultInfo = personCollection.get(i);
            break;
        }
        return defaultInfo;
    }

    public PersonCollection getPersonCollectionFromSHR(Connection shrConn, Context ctx) throws InterfaceDataBaseException, BOSException, SQLException {
        PersonCollection PersonDatasSHR = new PersonCollection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select Fnumber,Fid from T_BD_PERSON";
        PersonInfo shrInfo = null;
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String fnumber = rs.getString("fnumber");
            String fid = rs.getString("fid");
            shrInfo = new PersonInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            shrInfo.setNumber(fnumber);
            PersonDatasSHR.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return PersonDatasSHR;
    }

    private void generateNotFoundInSHRMappingExcelData(Context ctx, UserInfo infoSHR, UserInfo infoEAS, List<List<String>> userDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getType() != null ? infoEAS.getType().getName() : "");
        resultRow.add(infoEAS.getName());
        resultRow.add(infoEAS.getDefOrgUnit() != null ? infoEAS.getDefOrgUnit().getId().toString() : "");
        resultRow.add(infoEAS.getGroup() != null ? infoEAS.getGroup().getId().toString() : "");
        resultRow.add("");
        resultRow.add(infoEAS.getEffectiveDate().toLocaleString());
        resultRow.add(infoEAS.getInvalidationDate().toLocaleString());
        resultRow.add(infoEAS.getPWEffectiveDate().toLocaleString());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsForbidden()));
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        userDatas.add(resultRow);
    }

    private void generateNotFoundInEASMappingExcelData(Context ctx, UserInfo infoSHR, UserInfo infoEAS, List<List<String>> userDatas) throws EASBizException, BOSException {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getType() != null ? infoSHR.getType().getName() : "");
        resultRow.add(infoSHR.getName());
        resultRow.add(infoSHR.getDefOrgUnit() != null ? infoSHR.getDefOrgUnit().getId().toString() : "");
        resultRow.add(infoSHR.getGroup() != null ? infoSHR.getGroup().getId().toString() : "");
        resultRow.add("");
        resultRow.add(infoSHR.getEffectiveDate().toLocaleString());
        resultRow.add(infoSHR.getInvalidationDate().toLocaleString());
        resultRow.add(infoSHR.getPWEffectiveDate().toLocaleString());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsForbidden()));
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("\u65b0\u589e");
        resultRow.add("");
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(UserFactory.getRemoteInstance().exists("where number='" + infoSHR.getNumber().toString() + "'")));
        userDatas.add(resultRow);
    }

    private void generateMappingTrueExcelData(Context ctx, UserInfo infoSHR, UserInfo infoEAS, List<List<String>> userDatas, String moveType) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getType() != null ? infoSHR.getType().getName() : "");
        resultRow.add(infoSHR.getName());
        resultRow.add(infoSHR.getDefOrgUnit() != null ? infoSHR.getDefOrgUnit().getId().toString() : "");
        resultRow.add(infoSHR.getGroup() != null ? infoSHR.getGroup().getId().toString() : "");
        resultRow.add("");
        resultRow.add(infoSHR.getEffectiveDate().toLocaleString());
        resultRow.add(infoSHR.getInvalidationDate().toLocaleString());
        resultRow.add(infoSHR.getPWEffectiveDate().toLocaleString());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsForbidden()));
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getType() != null ? infoEAS.getType().getName() : "");
        resultRow.add(infoEAS.getName());
        resultRow.add(infoEAS.getDefOrgUnit() != null ? infoEAS.getDefOrgUnit().getId().toString() : "");
        resultRow.add(infoEAS.getGroup() != null ? infoEAS.getGroup().getId().toString() : "");
        resultRow.add("");
        resultRow.add(infoEAS.getEffectiveDate().toLocaleString());
        resultRow.add(infoEAS.getInvalidationDate().toLocaleString());
        resultRow.add(infoEAS.getPWEffectiveDate().toLocaleString());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsForbidden()));
        resultRow.add(moveType);
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsForbidden() == infoSHR.isIsForbidden()));
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.getNumber() == infoSHR.getNumber()));
        userDatas.add(resultRow);
    }

    private void generateMappingTable(Context ctx, String infoSHRId, String infoEASId) throws EASBizException, BOSException {
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    public UserCollection getSHRData(Connection shrConn, Context ctx) throws InterfaceDataBaseException, BOSException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_USER where fid not in('00000000-0000-0000-0000-00000000000013B7DE7F','256c221a-0106-1000-e000-10d7c0a813f413B7DE7F')";
        UserCollection shrCollection = new UserCollection();
        UserInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_USER".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            Date date;
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
            String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
            String ftype = colummnsmap.containsKey("ftype".toUpperCase()) ? rs.getString("ftype") : "";
            String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
            String fpassword = colummnsmap.containsKey("fpassword".toUpperCase()) ? rs.getString("fpassword") : "";
            String fisdelete = colummnsmap.containsKey("fisdelete".toUpperCase()) ? rs.getString("fisdelete") : "";
            String fislocked = colummnsmap.containsKey("fislocked".toUpperCase()) ? rs.getString("fislocked") : "";
            String fforbidden = colummnsmap.containsKey("fforbidden".toUpperCase()) ? rs.getString("fforbidden") : "";
            String feffectivedate = colummnsmap.containsKey("feffectivedate".toUpperCase()) ? rs.getString("feffectivedate") : "";
            String finvalidationdate = colummnsmap.containsKey("finvalidationdate".toUpperCase()) ? rs.getString("finvalidationdate") : "";
            String fdefaultlocale = colummnsmap.containsKey("fdefaultlocale".toUpperCase()) ? rs.getString("fdefaultlocale") : "";
            String fisregister = colummnsmap.containsKey("fisregister".toUpperCase()) ? rs.getString("fisregister") : "";
            String ferrcount = colummnsmap.containsKey("ferrcount".toUpperCase()) ? rs.getString("ferrcount") : "";
            String fgroupid = colummnsmap.containsKey("fgroupid".toUpperCase()) ? rs.getString("fgroupid") : "";
            String fpersonid = colummnsmap.containsKey("fpersonid".toUpperCase()) ? rs.getString("fpersonid") : "";
            String fsecurityid = colummnsmap.containsKey("fsecurityid".toUpperCase()) ? rs.getString("fsecurityid") : "";
            String fpweffectivedate = colummnsmap.containsKey("fpweffectivedate".toUpperCase()) ? rs.getString("fpweffectivedate") : "";
            String flockedtime = colummnsmap.containsKey("flockedtime".toUpperCase()) ? rs.getString("flockedtime") : "";
            String fisbizadmin = colummnsmap.containsKey("fisbizadmin".toUpperCase()) ? rs.getString("fisbizadmin") : "";
            String fischangedpw = colummnsmap.containsKey("fischangedpw".toUpperCase()) ? rs.getString("fischangedpw") : "";
            String fdeforgunitid = colummnsmap.containsKey("fdeforgunitid".toUpperCase()) ? rs.getString("fdeforgunitid") : "";
            String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
            String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
            String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
            String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
            String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
            String fcustomerid = colummnsmap.containsKey("fcustomerid".toUpperCase()) ? rs.getString("fcustomerid") : "";
            String fsupplierid = colummnsmap.containsKey("fsupplierid".toUpperCase()) ? rs.getString("fsupplierid") : "";
            String fmainroleid = colummnsmap.containsKey("fmainroleid".toUpperCase()) ? rs.getString("fmainroleid") : "";
            String fagentuser = colummnsmap.containsKey("fagentuser".toUpperCase()) ? rs.getString("fagentuser") : "";
            String floginauthorway = colummnsmap.containsKey("floginauthorway".toUpperCase()) ? rs.getString("floginauthorway") : "";
            String fpwdhisstr = colummnsmap.containsKey("fpwdhisstr".toUpperCase()) ? rs.getString("fpwdhisstr") : "";
            String freferid = colummnsmap.containsKey("freferid".toUpperCase()) ? rs.getString("freferid") : "";
            String fcell = colummnsmap.containsKey("fcell".toUpperCase()) ? rs.getString("fcell") : "";
            String fbackupemail = colummnsmap.containsKey("fbackupemail".toUpperCase()) ? rs.getString("fbackupemail") : "";
            String fhomephone = colummnsmap.containsKey("fhomephone".toUpperCase()) ? rs.getString("fhomephone") : "";
            String fofficephone = colummnsmap.containsKey("fofficephone".toUpperCase()) ? rs.getString("fofficephone") : "";
            String femail = colummnsmap.containsKey("femail".toUpperCase()) ? rs.getString("femail") : "";
            String fadnumber = colummnsmap.containsKey("fadnumber".toUpperCase()) ? rs.getString("fadnumber") : "";
            shrInfo = new UserInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            shrInfo.setName(fname);
            shrInfo.setNumber(fnumber);
            shrInfo.setDescription(fdescription);
            shrInfo.setPassword(fpassword);
            shrInfo.setCustomerID(fcustomerid);
            shrInfo.setSupplierID(fsupplierid);
            shrInfo.setPwdHisStr(fpwdhisstr);
            shrInfo.setReferId(freferid);
            shrInfo.setCell(fcell);
            shrInfo.setBackupEMail(fbackupemail);
            shrInfo.setHomePhone(fhomephone);
            shrInfo.setOfficePhone(fofficephone);
            shrInfo.setEmail(femail);
            shrInfo.setAdNumber(fadnumber);
            if (floginauthorway != null && !floginauthorway.isEmpty()) {
                shrInfo.setLoginAuthorWay(LoginAuthorWayEnum.getEnum((String)floginauthorway));
            }
            if (fagentuser != null && !fagentuser.isEmpty()) {
                boolean agentuser = fagentuser.equals("1");
                shrInfo.setAgentUser(agentuser);
            }
            if (fmainroleid != null && !fmainroleid.isEmpty()) {
                RoleInfo info = new RoleInfo();
                info.setId(BOSUuid.read((String)fmainroleid));
                shrInfo.setMainRole(info);
            }
            if (fdeforgunitid != null && !fdeforgunitid.isEmpty()) {
                FullOrgUnitInfo info = new FullOrgUnitInfo();
                info.setId(BOSUuid.read((String)fdeforgunitid));
                shrInfo.setDefOrgUnit(info);
            }
            if (fischangedpw != null && !fischangedpw.isEmpty()) {
                boolean ischangedpw = fischangedpw.equals("1");
                shrInfo.setChangedPW(ischangedpw);
            }
            if (fisbizadmin != null && !fisbizadmin.isEmpty()) {
                boolean isbizadmin = fisbizadmin.equals("1");
                shrInfo.setBizAdmin(isbizadmin);
            }
            if (flockedtime != null && !flockedtime.isEmpty()) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = formatter.parse(flockedtime);
                    shrInfo.setLockedTime(new Time(date.getTime()));
                }
                catch (ParseException e) {
                    throw new SQLException("\u65e5\u671f\u7c7b\u578b\u6570\u636e\u8f6c\u6362\u5931\u8d25...");
                }
            }
            if (fpweffectivedate != null && !fpweffectivedate.isEmpty()) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = formatter.parse(fpweffectivedate);
                    shrInfo.setPWEffectiveDate(date);
                }
                catch (ParseException e) {
                    throw new SQLException("\u65e5\u671f\u7c7b\u578b\u6570\u636e\u8f6c\u6362\u5931\u8d25...");
                }
            }
            if (fsecurityid != null && !fsecurityid.isEmpty()) {
                SecurityInfo info = new SecurityInfo();
                info.setId(BOSUuid.read((String)fsecurityid));
                shrInfo.setSecurity(info);
            }
            if (fpersonid != null && !fpersonid.isEmpty()) {
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)fpersonid));
                shrInfo.setPerson(info);
            }
            if (fgroupid != null && !fgroupid.isEmpty()) {
                UserGroupInfo info = new UserGroupInfo();
                info.setId(BOSUuid.read((String)fgroupid));
                shrInfo.setGroup(info);
            }
            if (ferrcount != null && !ferrcount.isEmpty()) {
                shrInfo.setErrCount(Integer.parseInt(ferrcount));
            }
            if (fisregister != null && !fisregister.isEmpty()) {
                boolean isregister = fisregister.equals("1");
                shrInfo.setIsRegister(isregister);
            }
            if (fdefaultlocale != null && !fdefaultlocale.isEmpty()) {
                Locale locale = new Locale(fdefaultlocale);
                shrInfo.setDefaultLocale(locale);
            }
            if (finvalidationdate != null && !finvalidationdate.isEmpty()) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = formatter.parse(finvalidationdate);
                    shrInfo.setInvalidationDate(new Timestamp(date.getTime()));
                }
                catch (ParseException e) {
                    throw new SQLException("\u65e5\u671f\u7c7b\u578b\u6570\u636e\u8f6c\u6362\u5931\u8d25...");
                }
            }
            if (feffectivedate != null && !feffectivedate.isEmpty()) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = formatter.parse(feffectivedate);
                    shrInfo.setEffectiveDate(new Timestamp(date.getTime()));
                }
                catch (ParseException e) {
                    throw new SQLException("\u65e5\u671f\u7c7b\u578b\u6570\u636e\u8f6c\u6362\u5931\u8d25...");
                }
            }
            if (fisdelete != null && !fisdelete.isEmpty()) {
                boolean isdelete = fisdelete.equals("1");
                shrInfo.setIsDelete(isdelete);
            }
            if (fislocked != null && !fislocked.isEmpty()) {
                boolean islocked = fislocked.equals("1");
                shrInfo.setIsLocked(islocked);
            }
            if (fforbidden != null && !fforbidden.isEmpty()) {
                boolean forbidden = fforbidden.equals("1");
                shrInfo.setIsForbidden(forbidden);
            }
            if (ftype != null) {
                shrInfo.setType(UserType.getEnum((int)Integer.parseInt(ftype)));
            }
            if (fcreatorid != null && !fcreatorid.isEmpty()) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)fcreatorid));
                shrInfo.setCreator(user);
            }
            if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                shrInfo.setCU(ctrinfo);
            }
            shrCollection.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return shrCollection;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveUser(shrConn, ctx);
        RoleMoveHandler rolemoveHandler = new RoleMoveHandler();
        rolemoveHandler.moveData(shrConn, ctx);
        UserGroupMoveHandler userGroupHandler = new UserGroupMoveHandler();
        userGroupHandler.moveData(shrConn, ctx);
        UserOrgPermMoveHandler userOrgPermHandler = new UserOrgPermMoveHandler();
        userOrgPermHandler.moveData(shrConn, ctx);
        this.moveUserOrgRanger(shrConn, ctx);
        this.moveUserSubOrgRanger(shrConn, ctx);
        return null;
    }

    private void moveUserSubOrgRanger(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        try {
            String tableName = "T_PM_OrgRangeIncludeSubOrg";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            UpdateTool.commonUpdate(shrConn, "T_PM_ORGRANGEINCLUDESUBORG", "", ctx, 500);
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_ORGRANGEINCLUDESUBORG", "FUserID");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_ORGRANGEINCLUDESUBORG", "FOrgID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_ORGRANGEINCLUDESUBORG".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_ORGRANGE".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveUserOrgRanger(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        try {
            String tableName = "T_PM_ORGRANGE";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            UpdateTool.commonUpdate(shrConn, "T_PM_ORGRANGE", "", ctx, 500);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_ORGRANGE".toUpperCase(), "finished");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_ORGRANGE", "FUSERID");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_ORGRANGE", "FORGID");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_ORGRANGE".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveUser(Connection shrConn, Context ctx) throws BOSException, SQLException, EASBizException {
        try {
            String tableName = "T_PM_USER";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            this.userCollection_EAS = UserFactory.getRemoteInstance().getUserCollection();
            this.userCollection_SHR = this.getSHRData(shrConn, ctx);
            UserCollection diffCollectionSHR = new UserCollection();
            ArrayList UserMergeInfos = new ArrayList();
            if (this.userCollection_EAS.isEmpty()) {
                this.addSHRDataToEAS(shrConn, ctx, this.userCollection_SHR);
            } else {
                this.compareData(diffCollectionSHR, UserMergeInfos, shrConn, ctx, this.userCollection_EAS, this.userCollection_SHR);
                if (diffCollectionSHR != null && diffCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS(shrConn, ctx, diffCollectionSHR);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_USER", "FPersonId");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_USER", "FCreatorID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_USER".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_USER".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void compareSHRDataToEAS(Connection shrConn, Context ctx, List<UserMergeInfo> userMergeInfos) throws BOSException, SQLException, EASBizException {
        for (UserMergeInfo MergeInfo : userMergeInfos) {
            if (MergeInfo.getMovetype() != 0) continue;
            this.compareOrgRange(shrConn, ctx, MergeInfo);
        }
    }

    private void compareOrgRange(Connection shrConn, Context ctx, UserMergeInfo mergeInfo) throws BOSException, SQLException, EASBizException {
        OrgRangeCollection orgrange_eas = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection("where user='" + mergeInfo.getUser_eas().getId().toString() + "'");
        OrgRangeCollection orgrange_shr = this.getOrgRangeSHR(shrConn, ctx, mergeInfo.getUser_shr().getId().toString());
        for (int i = 0; i < orgrange_shr.size(); ++i) {
            OrgRangeCollection IsExist;
            OrgRangeInfo info_shr = orgrange_shr.get(i);
            boolean math = true;
            for (int j = 0; j < orgrange_eas.size(); ++j) {
                OrgRangeInfo info_eas = orgrange_eas.get(i);
                if (!info_eas.getOrg().getId().toString().equals(info_shr.getOrg().getId().toString())) continue;
                math = false;
                break;
            }
            if (!math) continue;
            if (info_shr.getType() == null) {
                info_shr.setType(OrgRangeType.getEnum((int)10));
            }
            if ((IsExist = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection("where id='" + info_shr.getId().toString() + "'")) != null) continue;
            OrgRangeFactory.getRemoteInstance().addnew((CoreBaseInfo)info_shr);
        }
    }

    private OrgRangeCollection getOrgRangeSHR(Connection shrConn, Context ctx, String userid) throws SQLException, InterfaceDataBaseException, BOSException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_OrgRange where fuserid='" + userid + "'";
        OrgRangeCollection shrCollection = new OrgRangeCollection();
        OrgRangeInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_OrgRange".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            UserInfo info;
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String fuserid = colummnsmap.containsKey("fuserid".toUpperCase()) ? rs.getString("fuserid") : "";
            String forgid = colummnsmap.containsKey("forgid".toUpperCase()) ? rs.getString("forgid") : "";
            String ftype = colummnsmap.containsKey("ftype".toUpperCase()) ? rs.getString("ftype") : "";
            shrInfo = new OrgRangeInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            if (fuserid != null && !fuserid.isEmpty()) {
                info = new UserInfo();
                info.setId(BOSUuid.read((String)fuserid));
                shrInfo.setUser(info);
            }
            if (forgid != null && !forgid.isEmpty()) {
                info = new FullOrgUnitInfo();
                info.setId(BOSUuid.read((String)forgid));
                shrInfo.setOrg((FullOrgUnitInfo)info);
            }
            if (ftype != null) {
                shrInfo.setType(OrgRangeType.getEnum((String)ftype));
            }
            shrCollection.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return shrCollection;
    }

    private void addSHRDataToEAS(Connection shrConn, Context ctx, UserCollection userCollection_SHR) throws BOSException, EASBizException {
        UserInfo info = null;
        IUser User = UserFactory.getRemoteInstance();
        CoreBaseCollection bases = new CoreBaseCollection();
        for (int i = 0; i < userCollection_SHR.size(); ++i) {
            info = userCollection_SHR.get(i);
            boolean isExist = this.checkExist(info.getId().toString(), info.getNumber());
            if (!isExist) {
                bases.add((CoreBaseInfo)info);
                if (i % 1000 != 0) continue;
                User.addnewBatchData(bases);
                bases.clear();
                continue;
            }
            String oldSHR_ID = info.getId().toString();
            BOSUuid newEAS_ID = BOSUuid.create((String)BOSTYPE);
            info.setId(newEAS_ID);
            bases.add((CoreBaseInfo)info);
            this.generateMappingTable(ctx, oldSHR_ID, newEAS_ID.toString());
        }
        if (bases.size() > 0) {
            User.addnewBatchData(bases);
        }
    }

    private boolean checkExist(String Id, String number) throws EASBizException, BOSException {
        if (Id == null || Id.isEmpty()) {
            return true;
        }
        return UserFactory.getRemoteInstance().exists("where id='" + Id + "' or number='" + number + "'");
    }

    private void compareData(UserCollection diffCollectionSHR, List userMergeInfos, Connection shrConn, Context ctx, UserCollection userCollection_EAS2, UserCollection userCollection_SHR2) throws EASBizException, BOSException, SQLException {
        ArrayList<List<String>> userDatas = new ArrayList<List<String>>();
        this.compareData(diffCollectionSHR, userMergeInfos, shrConn, ctx, this.userCollection_EAS, this.userCollection_SHR, userDatas);
    }

    static {
        excelHead.add("\u7528\u6237\u8d26\u53f7 ");
        excelHead.add("\u7c7b\u578b");
        excelHead.add("\u7528\u6237\u5b9e\u540d");
        excelHead.add("\u6240\u5c5e\u7ec4\u7ec7");
        excelHead.add("\u6240\u5c5e\u7528\u6237\u7ec4");
        excelHead.add("\u6388\u6743\u6743");
        excelHead.add("\u8d26\u6237\u751f\u6548\u65f6\u95f4");
        excelHead.add("\u8d26\u6237\u5931\u6548\u65f6\u95f4");
        excelHead.add("\u5bc6\u7801\u751f\u6548\u65f6\u95f4");
        excelHead.add("\u7981\u7528\u72b6\u6001");
        excelHead.add("\u7528\u6237\u8d26\u53f7");
        excelHead.add("\u7c7b\u578b");
        excelHead.add("\u7528\u6237\u5b9e\u540d");
        excelHead.add("\u6240\u5c5e\u7ec4\u7ec7");
        excelHead.add("\u6240\u5c5e\u7528\u6237\u7ec4");
        excelHead.add("\u6388\u6743\u6743");
        excelHead.add("\u8d26\u6237\u751f\u6548\u65f6\u95f4");
        excelHead.add("\u8d26\u6237\u5931\u6548\u65f6\u95f4");
        excelHead.add("\u5bc6\u7801\u751f\u6548\u65f6\u95f4");
        excelHead.add("\u7981\u7528\u72b6\u6001");
        excelHead.add("\u8fc1\u79fb\u65b9\u5f0f");
        excelHead.add("\u7981\u7528\u72b6\u6001\u4e00\u81f4");
        excelHead.add("\u8d26\u53f7\u91cd\u590d");
    }
}

