/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.ShrSetUpPatchCollection;
import com.kingdee.eas.hr.mvdt.ShrSetUpPatchFactory;
import com.kingdee.eas.hr.mvdt.ShrSetUpPatchInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class PatchSetUpHandler {
    private Context ctx = SHRContext.getInstance().getContext();

    public List<String> getExecutePatchList() throws BOSException, SQLException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(" SELECT A.FPATCHNUM, A.FSENDTIME, A.FDOMAIN, A.FDESCRIPTION \n").append("   FROM T_HR_SHRSETUPPATCH A, \n").append("        (SELECT MAX(FSENDTIME) MAXSENDTIME, FDOMAIN \n").append("           FROM T_HR_SHRSETUPPATCH \n").append("          GROUP BY FDOMAIN) B \n").append("  WHERE A.FDOMAIN = B.FDOMAIN \n").append("    AND A.FSENDTIME >= B.MAXSENDTIME \n").append("  ORDER BY A.FSENDTIME ASC \n");
        IRowSet ir = DbUtil.executeQuery((Context)this.ctx, (String)sBuffer.toString());
        ArrayList<String> patchList = new ArrayList<String>();
        while (ir.next()) {
            patchList.add(ir.getString("FPATCHNUM"));
        }
        return patchList;
    }

    public String getPatchListAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sii = new SorterItemInfo();
        sii.setPropertyName("SENDTIME");
        sii.setSortType(SortType.ASCEND);
        sic.add(sii);
        evi.setSorter(sic);
        ShrSetUpPatchCollection coll = ShrSetUpPatchFactory.getLocalInstance(this.ctx).getShrSetUpPatchCollection(evi);
        ArrayList patchList = new ArrayList();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < coll.size(); ++i) {
            ShrSetUpPatchInfo info = coll.get(i);
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            tmpMap.put("patchNum", info.getPatchNum());
            tmpMap.put("sendTime", df.format(info.getSendTime()));
            tmpMap.put("domain", info.getDomain());
            tmpMap.put("description", info.getDescription());
            patchList.add(tmpMap);
        }
        HashMap resMap = new HashMap();
        resMap.put("patchList", patchList);
        JSONUtils.writeJson((HttpServletResponse)response, resMap);
        return null;
    }

    public void genTestDataAction() throws ParseException, EASBizException, BOSException {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        ShrSetUpPatchInfo info = new ShrSetUpPatchInfo();
        info.setPatchNum("TEST001");
        info.setSendTime(myFormatter.parse("2016-07-07"));
        info.setDomain("ATS");
        info.setDescription("\u6d4b\u8bd5\u8865\u4e01001");
        Context ctx = SHRContext.getInstance().getContext();
        ShrSetUpPatchFactory.getLocalInstance(ctx).addnew(info);
        info = new ShrSetUpPatchInfo();
        info.setPatchNum("TEST002");
        info.setSendTime(myFormatter.parse("2016-08-03"));
        info.setDomain("REC");
        info.setDescription("\u6d4b\u8bd5\u8865\u4e01002");
        ShrSetUpPatchFactory.getLocalInstance(ctx).addnew(info);
        info = new ShrSetUpPatchInfo();
        info.setPatchNum("TEST003");
        info.setSendTime(myFormatter.parse("2016-05-15"));
        info.setDomain("BASE");
        info.setDescription("\u6d4b\u8bd5\u8865\u4e01003");
        ShrSetUpPatchFactory.getLocalInstance(ctx).addnew(info);
        info = new ShrSetUpPatchInfo();
        info.setPatchNum("TEST004");
        info.setSendTime(myFormatter.parse("2016-03-03"));
        info.setDomain("PER");
        info.setDescription("\u6d4b\u8bd5\u8865\u4e01004");
        ShrSetUpPatchFactory.getLocalInstance(ctx).addnew(info);
    }
}

