/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ZipFileAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class AntZipFileAccessor
implements ZipFileAccessor {
    private Logger logger = Logger.getLogger(AntZipFileAccessor.class);
    private ZipFile baseFile;
    private final String baseFilePath;

    public AntZipFileAccessor(String filepath) throws IOException {
        this.logger.info((Object)AntZipFileAccessor.class.getClassLoader().getResource("org/apache/tools/zip/ZipFile.class").toString());
        this.baseFile = new ZipFile(filepath);
        this.baseFilePath = filepath;
    }

    @Override
    public void close() throws Exception {
        if (this.baseFile != null) {
            this.baseFile.close();
        }
    }

    @Override
    public boolean isFileExist(String filename) {
        ZipEntry entry = this.baseFile.getEntry(this.cleanPath(filename));
        return entry != null;
    }

    @Override
    public InputStream getFileInputStream(String filename) {
        ZipEntry entry = this.baseFile.getEntry(this.cleanPath(filename));
        try {
            return this.baseFile.getInputStream(entry);
        }
        catch (Exception e) {
            this.logger.error((Object)"Get fileinputstream error!", (Throwable)e);
            throw new AdminException("File[" + filename + "] not found in " + this.baseFilePath, e);
        }
    }

    private String cleanPath(String filename) {
        String file = StringUtils.cleanPath(filename);
        if (file.startsWith(".")) {
            file = file.substring(1);
        }
        this.logger.debug((Object)("JarFile:" + file));
        return file;
    }

    @Override
    public String[] getFileNames(String filename) throws IOException {
        if (filename.indexOf("*") >= 0) {
            String path = StringUtils.cleanPath(filename);
            String fName = path.substring(path.lastIndexOf("/") + 1);
            fName = StringUtils.replace(fName, "*", "\\S*");
            fName = StringUtils.replace(fName, ".", "\\.");
            Pattern p = Pattern.compile(fName);
            path = path.substring(0, path.lastIndexOf("/") + 1);
            Enumeration entries = this.baseFile.getEntries();
            ArrayList<String> files = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(path) || (name = name.substring(path.length())).indexOf("/") >= 0 || !p.matcher(name).matches()) continue;
                files.add(entry.getName());
            }
            if (files != null) {
                Object[] res = new String[files.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = (String)files.get(i);
                }
                Arrays.sort(res);
                this.logger.debug((Object)("Find files " + Arrays.asList(res) + " matches [" + fName + "] was found in [" + this.baseFilePath + "]!" + path));
                return res;
            }
            this.logger.warn((Object)("No files matches [" + fName + "] was found in [" + path + "]!"));
            return new String[0];
        }
        return new String[]{filename};
    }

    @Override
    public String[] getFileInfo(String[] prefix, String[] postfix) throws IOException {
        Enumeration entries = this.baseFile.getEntries();
        ArrayList<String> files = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            int i;
            ZipEntry entry = (ZipEntry)entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            boolean isAccord = false;
            if (prefix != null && prefix.length > 0) {
                for (i = 0; i < prefix.length; ++i) {
                    if (!name.startsWith(prefix[i])) continue;
                    isAccord = true;
                    break;
                }
            }
            if (!isAccord) continue;
            if (postfix != null && postfix.length > 0) {
                isAccord = false;
                for (i = 0; i < postfix.length; ++i) {
                    if (!name.endsWith(postfix[i])) continue;
                    isAccord = true;
                    break;
                }
            }
            if (!isAccord) continue;
            files.add(name);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public String getBaseFile() {
        return this.baseFilePath;
    }
}

