/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AbstractDCParser;
import com.kingdee.eas.hr.mvdt.patch.executeSql.AdditionalLog;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DomainException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.EASSubsystemInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ScriptInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ExecuteScriptFileParser
extends AbstractDCParser {
    private String scriptControlFilePath;
    private Map<String, EASSubsystemInfo> subSystemMap;
    private Logger logger = Logger.getLogger((String)"ExecuteScriptFileParser");
    private DatabaseVO databaseInfo;

    public ExecuteScriptFileParser(DatabaseVO db, String scriptControlFilePath) throws IOException {
        super(new File(scriptControlFilePath).getParentFile().getAbsolutePath() + "/");
        this.scriptControlFilePath = "./" + new File(scriptControlFilePath).getName();
        this.databaseInfo = db;
    }

    public List<ScriptInfo> scan() {
        this.scan(this.scriptControlFilePath);
        return this.Elememt2ScriptInfo(this.subSystemMap);
    }

    @Override
    void scan(String scriptControlFilePath) {
        this.subSystemMap = new LinkedHashMap<String, EASSubsystemInfo>();
        if (this.scriptFileAccess.isFileExist(scriptControlFilePath)) {
            SAXBuilder builder = new SAXBuilder();
            Document mainControlDoc = null;
            try {
                InputStream updateXml = this.scriptFileAccess.getFileInputStream(scriptControlFilePath);
                mainControlDoc = builder.build(updateXml);
                updateXml.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception while analyze the datacenter update.xml", (Throwable)e);
                AdditionalLog.getErrLogger().error((Object)"Exception while analyze the datacenter update.xml", (Throwable)e);
                throw new DomainException("File is not a valid xml file, filePath=" + scriptControlFilePath + "ErrMsg:" + e.getMessage(), e);
            }
            Element root = mainControlDoc.getRootElement();
            List sysList = root.getChildren("subsystem");
            if (sysList != null && sysList.size() > 0) {
                for (Element ele : sysList) {
                    String sysName = ele.getAttributeValue("name");
                    String relativePath = super.getControlFileDir(scriptControlFilePath);
                    String subControlPath = relativePath + ele.getTextNormalize();
                    this.subSystemMap.putAll(this.scanSystem(sysName, subControlPath));
                }
            } else {
                this.logger.error((Object)"No system element found in update.xml!");
            }
        }
    }

    public List<ScriptInfo> Elememt2ScriptInfo(Map<String, EASSubsystemInfo> subSystemMap) {
        ArrayList allScriptElement = new ArrayList();
        ArrayList tableElementList = new ArrayList();
        ArrayList dateElementList = new ArrayList();
        ArrayList viewElementList = new ArrayList();
        ArrayList indexElementList = new ArrayList();
        ArrayList fkElementList = new ArrayList();
        Iterator<String> it = subSystemMap.keySet().iterator();
        while (it.hasNext()) {
            EASSubsystemInfo subsystem = subSystemMap.get(it.next());
            tableElementList.addAll(subsystem.getTableScriptFiles());
            dateElementList.addAll(subsystem.getDataScriptFiles());
            fkElementList.addAll(subsystem.getFkScriptFiles());
            viewElementList.addAll(subsystem.getViewScriptFiles());
            indexElementList.addAll(subsystem.getIndexScriptFiles());
        }
        allScriptElement.addAll(tableElementList);
        allScriptElement.addAll(fkElementList);
        allScriptElement.addAll(dateElementList);
        allScriptElement.addAll(viewElementList);
        allScriptElement.addAll(indexElementList);
        ArrayList<ScriptInfo> scriptInfoList = new ArrayList<ScriptInfo>();
        for (Element scriptElement : allScriptElement) {
            String sqlDbType = scriptElement.getAttributeValue("type");
            if (sqlDbType == null) {
                sqlDbType = "all";
            }
            if (this.isTargetDbType(sqlDbType, this.databaseInfo.getDBType())) {
                ScriptInfo scriptInfo = new ScriptInfo();
                scriptInfo.scriptFilePath = StringUtils.cleanPath(this.scriptFileAccess.getBaseFile() + scriptElement.getText());
                this.logger.info((Object)("sql path : " + scriptInfo.scriptFilePath));
                String split = scriptElement.getAttributeValue("split");
                String charset = scriptElement.getAttributeValue("encoding");
                Boolean dialect = Boolean.valueOf(scriptElement.getAttributeValue("dialect"));
                String path = scriptElement.getText();
                scriptInfo.scriptType = sqlDbType;
                if (StringUtils.hasText(split)) {
                    scriptInfo.scriptSplit = split;
                }
                if (StringUtils.hasText(charset)) {
                    scriptInfo.charset = charset;
                }
                scriptInfo.dialect = dialect;
                if (new File(scriptInfo.scriptFilePath).exists()) {
                    scriptInfoList.add(scriptInfo);
                    continue;
                }
                throw new DomainException("File [" + scriptInfo.scriptFilePath + "] does not exist!");
            }
            this.logger.warn((Object)("sqlType is [" + sqlDbType + "],Execute DB type is [" + this.databaseInfo.getDBType() + "],sql file is[" + scriptElement.getTextNormalize() + "]"));
        }
        return scriptInfoList;
    }

    private boolean isTargetDbType(String sqlDbType, String dbType) {
        if (sqlDbType.equalsIgnoreCase("all")) {
            return true;
        }
        return dbType.toLowerCase().contains(sqlDbType.toLowerCase());
    }
}

