/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

public class OsUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean IS_OS_AIX = OsUtils.getOSMatches(OS_NAME, "AIX");
    public static final boolean IS_OS_HPUNIX = OsUtils.getOSMatches(OS_NAME, "HP-UX");
    public static final boolean IS_OS_LINUX = OsUtils.getOSMatches(OS_NAME, "LINUX");
    public static final boolean IS_OS_400 = OsUtils.getOSMatches(OS_NAME, "OS/400");
    public static final boolean IS_OS_SOLARIS = OsUtils.getOSMatches(OS_NAME, "SUNOS") || OsUtils.getOSMatches(OS_NAME, "SOLARIS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HPUNIX || IS_OS_LINUX || IS_OS_SOLARIS;
    public static final boolean IS_OS_WINDOWS = OsUtils.getOSMatches(OS_NAME, "WINDOWS");
    public static final boolean IS_OS_WINDOWS2000 = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "5.0");
    public static final boolean IS_OS_WINDOWSXP = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "5.1");

    private static boolean getOSMatches(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.toUpperCase().startsWith(osNamePrefix);
    }

    private static boolean getOSMatches(String osName, String osVersion, String osNamePrefix, String osVersionPrefix) {
        if (osName == null || osVersion == null) {
            return false;
        }
        return osName.toUpperCase().startsWith(osNamePrefix) && osVersion.toUpperCase().startsWith(osVersionPrefix);
    }

    public static String[] getShellCmd() {
        String[] cmd = null;
        cmd = IS_OS_WINDOWS ? new String[]{"cmd.exe", "/C"} : (IS_OS_SOLARIS ? new String[]{"/bin/sh"} : new String[]{"/bin/sh", "-C"});
        return cmd;
    }
}

