/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.mvdt.handler.AdminMoveDataByEasMethodHandler;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class SynchDataUtilTool {
    public boolean isChangeString(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        String innerValue;
        boolean isChange = false;
        String outerValue = (String)outRowMap.get(key);
        if (this.compare(outerValue, innerValue = (String)innerInfo.get(key))) {
            isChange = true;
            innerInfo.put(key, (Object)outerValue);
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
        }
        return isChange;
    }

    public boolean isChangeStringMul(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        String innerValue;
        Locale locale = LocaleUtils.getLocale((String)"l2");
        boolean isChange = false;
        String outerValue = (String)outRowMap.get(key);
        if (this.compare(outerValue, innerValue = (String)innerInfo.get(key, locale))) {
            isChange = true;
            innerInfo.put(key, (Object)outerValue, locale);
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
        }
        return isChange;
    }

    private boolean compare(Object outerValue, Object innerValue) {
        return outerValue == null && innerValue != null || outerValue != null && !outerValue.equals(innerValue);
    }

    public static void synchBasicItemF7(Context ctx, Map outRowMap, String key, CoreBaseInfo objInfo) throws BOSException, EASBizException {
        String outerValue = (String)outRowMap.get(key);
        if (StringUtils.isEmpty((String)outerValue) || objInfo == null) {
            return;
        }
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)objInfo.getBOSType());
        if (!iCoreBase.exists((IObjectPK)new ObjectUuidPK(outerValue))) {
            Locale locale = LocaleUtils.getLocale((String)"l2");
            objInfo.setId(BOSUuid.read((String)outerValue));
            objInfo.put("name", (Object)((String)outRowMap.get(key + ".name")), locale);
            objInfo.put("number", (Object)((String)outRowMap.get(key + ".number")), locale);
            iCoreBase.addnew(objInfo);
        }
    }

    public boolean isChangeF7(Context ctx, Map outRowMap, CoreBaseInfo innerInfo, String key, CoreBaseInfo newValue) throws BOSException {
        boolean isChange = false;
        String outerId = (String)outRowMap.get(key);
        CoreBaseInfo innerValue = (CoreBaseInfo)innerInfo.get(key);
        if (outerId == null) {
            if (innerValue != null) {
                innerInfo.put(key, null);
                String outerNumber = (String)outRowMap.get(key + ".number");
                String innerId = AdminMoveDataByEasMethodHandler.getInnerId(ctx, outerId);
                this.generateUpdateRecordInfo(innerId, outerId, innerInfo, key);
                return true;
            }
            return false;
        }
        String outerNumber = (String)outRowMap.get(key + ".number");
        String innerId = AdminMoveDataByEasMethodHandler.getInnerId(ctx, outerId);
        if (StringUtils.isEmpty((String)innerId)) {
            innerId = outerId;
        }
        if (innerValue == null || !innerValue.getId().toString().equals(innerId)) {
            newValue.setId(BOSUuid.read((String)innerId));
            innerInfo.put(key, (Object)newValue);
            isChange = true;
            if (innerValue == null) {
                this.generateUpdateRecordInfo(null, outerId, innerInfo, key);
            } else {
                this.generateUpdateRecordInfo(innerId, outerId, innerInfo, key);
            }
        }
        return isChange;
    }

    public boolean isChangeF7(Map outRowMap, CoreBaseInfo innerInfo, String key, CoreBaseInfo newValue) {
        boolean isChange = false;
        String outerValue = (String)outRowMap.get(key);
        CoreBaseInfo innerValue = (CoreBaseInfo)innerInfo.get(key);
        if (outerValue == null && innerValue != null) {
            innerInfo.put(key, null);
            this.generateUpdateRecordInfo(innerValue.getId(), outerValue, innerInfo, key);
            return true;
        }
        if (outerValue == null && innerValue == null) {
            return false;
        }
        if (innerValue == null || !innerValue.getId().toString().equals(outerValue)) {
            newValue.setId(BOSUuid.read((String)outerValue));
            innerInfo.put(key, (Object)newValue);
            if (innerValue == null) {
                this.generateUpdateRecordInfo(null, outerValue, innerInfo, key);
            } else {
                this.generateUpdateRecordInfo(innerValue.getId(), outerValue, innerInfo, key);
            }
            isChange = true;
        }
        return isChange;
    }

    public boolean isChangeInt(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        int innerValue;
        boolean isChange = false;
        if (outRowMap.get(key) == null) {
            return isChange;
        }
        int outerValue = TypeConversionUtils.objToInt(outRowMap.get(key));
        if (outerValue != (innerValue = TypeConversionUtils.objToInt((Object)innerInfo.get(key)))) {
            isChange = true;
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
            innerInfo.put(key, (Object)outerValue);
        }
        return isChange;
    }

    public boolean isChangeBoolean(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        boolean innerValue;
        boolean isChange = false;
        if (outRowMap.get(key) == null) {
            return isChange;
        }
        boolean outerValue = TypeConversionUtils.objToBoolean(outRowMap.get(key));
        if (outerValue != (innerValue = TypeConversionUtils.objToBoolean((Object)innerInfo.get(key)))) {
            isChange = true;
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
            innerInfo.put(key, (Object)outerValue);
        }
        return isChange;
    }

    public boolean isChangeBigDecimal(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        boolean isChange = false;
        BigDecimal innerValue = TypeConversionUtils.objToBigDecimal((Object)innerInfo.get(key));
        BigDecimal outerValue = TypeConversionUtils.objToBigDecimal(outRowMap.get(key));
        if (this.bigDecimalCompare(outerValue, innerValue)) {
            isChange = true;
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
            innerInfo.put(key, (Object)outerValue);
        }
        return isChange;
    }

    public boolean isChangeDate(Map outRowMap, CoreBaseInfo innerInfo, String key) {
        boolean isChange = false;
        Date innerValue = TypeConversionUtils.objToDate((Object)innerInfo.get(key));
        Date outerValue = TypeConversionUtils.objToDate(outRowMap.get(key));
        if (outerValue != null) {
            outerValue = DateTimeUtils.truncateDate((Date)outerValue);
        }
        if (innerValue != null) {
            innerValue = DateTimeUtils.truncateDate((Date)innerValue);
        }
        if (!SynchDataUtilTool.dayEquals(outerValue, innerValue)) {
            isChange = true;
            this.generateUpdateRecordInfo(innerValue, outerValue, innerInfo, key);
            innerInfo.put(key, (Object)outerValue);
        }
        return isChange;
    }

    public void generateUpdateRecordInfo(Object oldVal, Object newVal, Object instanceObj, String propName) {
        String objTypeName = this.getObjectName(instanceObj);
        this.generateUpdateRecordInfo(oldVal, newVal, objTypeName, propName);
    }

    private String getObjectName(Object instanceObj) {
        if (instanceObj instanceof PersonInfo) {
            return "person";
        }
        if (instanceObj instanceof PositionInfo) {
            return "position";
        }
        if (instanceObj instanceof FullOrgUnitInfo || instanceObj instanceof OUPartAdminInfo) {
            return "orgUnit";
        }
        if (instanceObj instanceof PositionMemberInfo) {
            return "positionMember";
        }
        String objFullName = instanceObj.getClass().getName();
        String ObjName = objFullName.substring(objFullName.lastIndexOf("."));
        return ObjName;
    }

    private boolean bigDecimalCompare(Object outerValue, Object innerValue) {
        if (outerValue == null && innerValue != null || outerValue != null && innerValue == null) {
            return true;
        }
        if (outerValue != null && innerValue != null) {
            BigDecimal outer = (BigDecimal)outerValue;
            BigDecimal inner = (BigDecimal)innerValue;
            return outer.compareTo(inner) != 0;
        }
        return false;
    }

    public static boolean dayEquals(Date dt, Date dt1) {
        if (dt == null && dt1 != null) {
            return false;
        }
        if (dt != null && dt1 == null) {
            return false;
        }
        if (dt == null && dt1 == null) {
            return true;
        }
        return DateTimeUtils.dayEquals((Date)dt, (Date)dt1);
    }
}

