/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;

public class ExcelExportUtil {
    public static final String DEFAULT_DATE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final int DEFAULT_COLUMN_WIDTH = 35;

    public static SXSSFWorkbook exportExcel(ArrayList<LinkedHashMap<String, String>> titleList, JSONArray dataArray) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        workbook.setCompressTempFiles(true);
        CreationHelper createHelper = workbook.getCreationHelper();
        ExcelExportUtil.exportExcel(workbook, createHelper, titleList, dataArray, titleList.get(0).get("title1"));
        return workbook;
    }

    public static SXSSFWorkbook exportExcel(ArrayList<LinkedHashMap<String, String>> titleList, JSONArray dataArray, String sheetName) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        workbook.setCompressTempFiles(true);
        CreationHelper createHelper = workbook.getCreationHelper();
        ExcelExportUtil.exportExcel(workbook, createHelper, titleList, dataArray, sheetName);
        return workbook;
    }

    private static void exportExcel(SXSSFWorkbook workbook, CreationHelper createHelper, ArrayList<LinkedHashMap<String, String>> titleList, JSONArray dataArray, String sheetName) {
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.createFreezePane(0, 3, 0, 3);
        ExcelExportUtil.fillData(workbook, dataArray, sheet, createHelper, titleList);
    }

    public static SXSSFWorkbook exportExcel(ArrayList<LinkedHashMap<String, String>> titleList, JSONArray dataArray, JSONArray recordArray0) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        workbook.setCompressTempFiles(true);
        CreationHelper createHelper = workbook.getCreationHelper();
        ExcelExportUtil.exportExcel(workbook, createHelper, titleList, dataArray, "\u5fc5\u987b\u5904\u7406\u5185\u5bb9");
        ExcelExportUtil.exportExcel(workbook, createHelper, titleList, recordArray0, "\u544a\u77e5\u5185\u5bb9");
        return workbook;
    }

    private static void fillData(SXSSFWorkbook workbook, JSONArray dataArray, SXSSFSheet sheet, CreationHelper createHelper, ArrayList<LinkedHashMap<String, String>> titleList) {
        CellStyle title1Style = workbook.createCellStyle();
        title1Style.setAlignment(HorizontalAlignment.CENTER);
        title1Style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = workbook.createFont();
        titleFont.setFontHeightInPoints((short)20);
        titleFont.setBold(true);
        title1Style.setFont(titleFont);
        CellStyle title2Style = workbook.createCellStyle();
        title2Style.setAlignment(HorizontalAlignment.CENTER);
        title2Style.setVerticalAlignment(VerticalAlignment.CENTER);
        title2Style.setBorderTop(BorderStyle.THIN);
        title2Style.setBorderRight(BorderStyle.THIN);
        title2Style.setBorderBottom(BorderStyle.THIN);
        title2Style.setBorderLeft(BorderStyle.THIN);
        Font title2Font = workbook.createFont();
        title2Font.setUnderline((byte)1);
        title2Font.setColor(IndexedColors.BLUE.index);
        title2Style.setFont(title2Font);
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        Font headerFont = workbook.createFont();
        headerFont.setFontHeightInPoints((short)12);
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        Font cellFont = workbook.createFont();
        cellFont.setBold(false);
        cellStyle.setFont(cellFont);
        String title1 = titleList.get(0).get("title1");
        String title2 = titleList.get(0).get("title2");
        LinkedHashMap<String, String> headMap = titleList.get(1);
        int[] colWidthArr = new int[headMap.size()];
        String[] headKeyArr = new String[headMap.size()];
        String[] headValArr = new String[headMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : headMap.entrySet()) {
            headKeyArr[i] = entry.getKey();
            headValArr[i] = entry.getValue();
            int bytes = headKeyArr[i].getBytes().length;
            int n = colWidthArr[i] = bytes < 35 ? 35 : bytes;
            if (i == headKeyArr.length - 1) {
                sheet.setColumnWidth(i, colWidthArr[i] * 768);
            } else {
                sheet.setColumnWidth(i, colWidthArr[i] * 256);
            }
            ++i;
        }
        if (null == dataArray || dataArray.size() <= 0) {
            return;
        }
        int rowIndex = 0;
        for (Object obj : dataArray) {
            if (rowIndex == 0) {
                SXSSFRow title1Row = sheet.createRow(0);
                title1Row.createCell(0).setCellValue(title1);
                title1Row.getCell(0).setCellStyle(title1Style);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headMap.size() - 1));
                SXSSFRow title2Row = sheet.createRow(1);
                title2Row.createCell(0).setCellValue(title2);
                XSSFHyperlink hyperLink = (XSSFHyperlink)createHelper.createHyperlink(HyperlinkType.URL);
                hyperLink.setAddress(title2);
                title2Row.getCell(0).setHyperlink((Hyperlink)hyperLink);
                title2Row.getCell(0).setCellStyle(title2Style);
                sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, headMap.size() - 1));
                SXSSFRow headerRow = sheet.createRow(2);
                for (int j = 0; j < headValArr.length; ++j) {
                    headerRow.createCell(j).setCellValue(headValArr[j]);
                    headerRow.getCell(j).setCellStyle(headerStyle);
                }
                rowIndex = 3;
            }
            JSONObject jo = (JSONObject)JSONObject.toJSON(obj);
            SXSSFRow dataRow = sheet.createRow(rowIndex);
            int total = headKeyArr.length;
            for (int k = 0; k < total; ++k) {
                SXSSFCell cell = dataRow.createCell(k);
                Object o = jo.get((Object)headKeyArr[k]);
                String cellValue = "";
                cellValue = o == null ? "" : (o instanceof Date ? new SimpleDateFormat(DEFAULT_DATE_PATTERN).format(o) : (o instanceof Float || o instanceof Double ? new BigDecimal(o.toString()).setScale(2, 4).toString() : o.toString()));
                cell.setCellValue(cellValue);
                cell.setCellStyle(cellStyle);
            }
            ++rowIndex;
        }
    }
}

