/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.util.DateTimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public final class RegactivedFileMergeUtils {
    private static final String REGACTIVED_FILE = "regActived.dat";
    private static final String REGACTIVED_FILE_BAK = "regActived.dat_bak";
    private static final String srcPath = "W:\\tools\\reg_src";
    private static final String targetPath = "W:\\tools\\reg_trg";

    public static void main(String[] args) {
        String srcFileName = RegactivedFileMergeUtils.assembleSourceFileName();
        String targetFileName = RegactivedFileMergeUtils.getDefaultActiveFileName();
        if (RegactivedFileMergeUtils.isExistBakfile()) {
            // empty if block
        }
        RegactivedFileMergeUtils.bakupProperties(targetFileName, REGACTIVED_FILE_BAK);
        try {
            RegactivedFileMergeUtils.mergeRegactivedFile(srcFileName, targetFileName, false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void mergeRegactivedFileWorkFlow(String srcFileName, boolean isNeedReMerge, boolean isCoverTargetPropKey) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(srcFileName);
        RegactivedFileMergeUtils.doMergeRegactivedFileWorkFlow(inputStream, isNeedReMerge, isCoverTargetPropKey);
    }

    public static void mergeRegactivedFileWorkFlow(InputStream inputStream, boolean isNeedReMerge, boolean isCoverTargetPropKey) throws FileNotFoundException {
        RegactivedFileMergeUtils.doMergeRegactivedFileWorkFlow(inputStream, isNeedReMerge, isCoverTargetPropKey);
    }

    public static void doMergeRegactivedFileWorkFlow(InputStream inputStream, boolean isNeedReMerge, boolean isCoverTargetPropKey) throws FileNotFoundException {
        String targetFileName = RegactivedFileMergeUtils.getDefaultActiveFileName();
        if (RegactivedFileMergeUtils.isExistBakfile()) {
            if (isNeedReMerge) {
                Date date = DateTimeUtils.getGMTDate();
                RegactivedFileMergeUtils.bakupProperties(targetFileName, RegactivedFileMergeUtils.assembleActiveFileName(1, REGACTIVED_FILE_BAK + date.getTime()));
            }
        } else {
            RegactivedFileMergeUtils.bakupProperties(targetFileName, RegactivedFileMergeUtils.assembleActiveFileName(1, REGACTIVED_FILE_BAK));
        }
        RegactivedFileMergeUtils.mergeRegactivedFile(inputStream, targetFileName, isCoverTargetPropKey);
        RegactivedFileMergeUtils.syncToOtherServerInstance();
    }

    public static Map getActiveFileContent() {
        String targetFileName = RegactivedFileMergeUtils.getDefaultActiveFileName();
        return RegactivedFileMergeUtils.doLoadPorpeties(targetFileName);
    }

    public static boolean regactivedFileMerged() {
        return RegactivedFileMergeUtils.isExistBakfile();
    }

    public static String assembleTargetFileName() {
        return targetPath + File.separator + REGACTIVED_FILE;
    }

    public static String assembleSourceFileName() {
        return srcPath + File.separator + REGACTIVED_FILE;
    }

    public static void mergeRegactivedFile(String srcFileName, String targetFileName, boolean isCoverTargetPropKey) throws FileNotFoundException {
        Properties targetProperties = RegactivedFileMergeUtils.doLoadPorpeties(targetFileName);
        Properties srcProperties = RegactivedFileMergeUtils.doLoadPorpeties(srcFileName);
        FileOutputStream targetFileOutputStream = new FileOutputStream(targetFileName);
        RegactivedFileMergeUtils.doMergeRegactivedFile(srcProperties, targetProperties, targetFileOutputStream, isCoverTargetPropKey);
    }

    public static void mergeRegactivedFile(InputStream inputStream, String targetFileName, boolean isCoverTargetPropKey) throws FileNotFoundException {
        Properties targetProperties = RegactivedFileMergeUtils.doLoadPorpeties(targetFileName);
        Properties srcProperties = RegactivedFileMergeUtils.doLoadPorpeties(inputStream);
        FileOutputStream targetFileOutputStream = new FileOutputStream(targetFileName);
        RegactivedFileMergeUtils.doMergeRegactivedFile(srcProperties, targetProperties, targetFileOutputStream, isCoverTargetPropKey);
    }

    public static void doMergeRegactivedFile(Properties srcProperties, Properties targetProperties, FileOutputStream targetFileOutputStream, boolean isCoverTargetPropKey) {
        for (Map.Entry<Object, Object> e : srcProperties.entrySet()) {
            String oldValue;
            String key = e.getKey().toString();
            String putValue = oldValue = e.getValue().toString();
            String newValue = RegactivedFileMergeUtils.reEncryptErpNumber(key);
            if (!oldValue.equals(newValue)) {
                putValue = newValue;
            }
            if (isCoverTargetPropKey) {
                targetProperties.setProperty(key, putValue);
                continue;
            }
            if (targetProperties.get(key) != null) continue;
            targetProperties.setProperty(key, putValue);
        }
        try {
            targetProperties.store(targetFileOutputStream, "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties doLoadPorpeties(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return RegactivedFileMergeUtils.doLoadPorpeties(inputStream);
    }

    public static Properties doLoadPorpeties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static void bakupProperties(String srcFileFileName, String destFileFileName) {
        RegactivedFileMergeUtils.doCopyFiles(srcFileFileName, destFileFileName);
    }

    public static void doCopyFiles(String srcFileName, String destFileName) {
        File srcFile = new File(srcFileName);
        File destFile = new File(destFileName);
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void syncToOtherServerInstance() {
        String srcFileFileName = RegactivedFileMergeUtils.assembleActiveFileName(1);
        String destFileFileName = "";
        int serverCount = RegactivedFileMergeUtils.getServerInstanceCount();
        if (serverCount > 1) {
            for (int i = 1; i <= serverCount; ++i) {
                destFileFileName = RegactivedFileMergeUtils.assembleActiveFileName(i);
                RegactivedFileMergeUtils.doCopyFiles(srcFileFileName, destFileFileName);
            }
        }
    }

    public static int getServerInstanceCount() {
        File f = new File(RegactivedFileMergeUtils.getProfielsPath());
        File[] filelist = f.listFiles();
        int serverCount = 0;
        if (filelist != null) {
            for (File files : f.listFiles()) {
                if (!files.isDirectory() || !RegactivedFileMergeUtils.isServerInstancePattern(files.getName())) continue;
                ++serverCount;
            }
        }
        return serverCount == 0 ? 1 : serverCount;
    }

    public static String getProfielsPath() {
        String eas_home = System.getProperty("EAS_HOME");
        String profiles_home = eas_home + File.separator + "server" + File.separator + "profiles";
        return profiles_home;
    }

    public static String assembleActiveFileName(int server) {
        return RegactivedFileMergeUtils.getProfielsPath() + File.separator + "server" + server + File.separator + "config" + File.separator + REGACTIVED_FILE;
    }

    public static String assembleActiveFileName(int server, String fileName) {
        return RegactivedFileMergeUtils.getProfielsPath() + File.separator + "server" + server + File.separator + "config" + File.separator + fileName;
    }

    public static boolean isExistBakfile() {
        String fileName = RegactivedFileMergeUtils.assembleActiveFileName(1, REGACTIVED_FILE_BAK);
        File f = new File(fileName);
        return f.exists();
    }

    public static String getDefaultActiveFileName() {
        return RegactivedFileMergeUtils.assembleActiveFileName(1);
    }

    private static boolean isServerInstancePattern(String name) {
        String pattern = "^server[1-9]$";
        return name.matches(pattern);
    }

    private static void reloadRegActivedFile() {
        try {
            Class<?> c = Class.forName("com.kingdee.eas.base.license.file.cloudRegist.CloudActivationFileManager");
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Method destory = c.getDeclaredMethod("distroy", new Class[0]);
            destory.invoke(constructor.newInstance(new Object[0]), new Object[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String reEncryptErpNumber(String erpNumber) {
        String encrypt = "";
        try {
            Class<?> coderClass = Class.forName("com.kingdee.eas.base.license.file.Coder");
            Method encryptBASE64 = coderClass.getDeclaredMethod("encryptBASE64", byte[].class);
            Object erpNumberEnrcy = encryptBASE64.invoke(coderClass, new Object[]{erpNumber.getBytes("GBK")});
            Class<?> licenseUtilClass = Class.forName("com.kingdee.eas.base.license.file.LicenseUtil");
            Method encryptAES = licenseUtilClass.getDeclaredMethod("encryptAES", String.class);
            Object value = encryptAES.invoke(licenseUtilClass, erpNumberEnrcy.toString());
            encrypt = value.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encrypt;
    }
}

