/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.ws.ca.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SHRMoveDataHelpUtil {
    public static final int rowMax = 100000;

    public static void moveTableAction(Connection shrConn, Context ctx, String tableName, String bossType, String otherFileterSql) throws BOSException, EASBizException {
        String filterId = "";
        SHRMoveDataHelpUtil.getInsertSqlByBatch(shrConn, ctx, tableName, bossType, filterId, 100);
        SHRMoveDataHelpUtil.UpdateColumnValueByBatch(shrConn, ctx, tableName, bossType, 100);
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
    }

    public static void moveTableHisAction(Connection shrConn, Context ctx, String tableName, String bossType, String otherFileterSql) throws BOSException, EASBizException {
        try {
            SHRMoveDataHelpUtil.getInsertSqlByBatch(shrConn, ctx, tableName, bossType, "", 100);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "");
        }
        catch (BOSException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String updateMapTableValue(Connection shrConn, Context ctx, List<String> columnList, String fromTableName, String toTableName, String bosType, int count) throws BOSException, EASBizException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String columnString = "";
        for (int i = 0; i < columnList.size(); ++i) {
            columnString = columnString + "," + columnList.get(i);
        }
        columnString = columnString.substring(1);
        String getAdminMapSql = "SELECT FSHRID,FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '" + bosType + "' AND FMAPWAY <> 'ID\u91cd\u590d'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAdminMapSql);
        try {
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FSHRID");
                String easId = executeQuery.getString("FEASID");
                String checkValueSql = "select " + columnString + " from " + fromTableName + " WHERE FID = '" + shrId + "'";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkValueSql);
                String updateSHRColumnString = "";
                String updateEASColumnString = "";
                while (executeQuery2.next()) {
                    for (int i = 0; i < columnList.size(); ++i) {
                        if (executeQuery2.getString(columnList.get(i)) == null || executeQuery2.getString(columnList.get(i)) == "") continue;
                        updateSHRColumnString = updateSHRColumnString + "," + columnList.get(i);
                        updateEASColumnString = updateEASColumnString + ",B." + columnList.get(i);
                    }
                    updateSHRColumnString = updateSHRColumnString.substring(1);
                    updateEASColumnString = updateEASColumnString.substring(1);
                    String updateSql = "UPDATE  " + toTableName + " A SET (" + updateSHRColumnString + ") = (SELECT " + updateEASColumnString + " FROM " + fromTableName + " B WHERE B.FID = '" + shrId + "') WHERE A.FID = '" + easId + "'";
                    sqlList.add(updateSql);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, count);
        return null;
    }

    public static String getInsertSql(Connection shrConn, Context ctx, String tableName, String shrId, String newId) throws BOSException {
        String insertSql = "";
        String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
        String value = SHRMoveDataHelpUtil.getColumnValueAllSql(shrConn, ctx, tableName, shrId, newId);
        insertSql = "insert into " + tableName + "(" + column + ") values (" + value + ")";
        return insertSql;
    }

    public static void getInsertSqlByBatch(Connection shrConn, Context ctx, String tableName, String bossType, String filterId, int count) throws BOSException, EASBizException {
        try {
            if (filterId.equals("")) {
                String sql = "select FShrId from T_HR_SynIdMapping where FBosType = '" + bossType + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    String shrId = executeQuery.getString("FShrId");
                    filterId = filterId + ",'" + shrId + "'";
                }
                filterId = !filterId.equals("") ? filterId.substring(1) : "'1'";
            }
            ArrayList<String> sqlList = new ArrayList();
            String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
            sqlList = SHRMoveDataHelpUtil.getColumnValue(shrConn, ctx, tableName, column, filterId);
            DbUtil.execute((Context)ctx, (String)("delete from " + tableName + " where fid NOT in (" + filterId + ")"));
            SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, count);
        }
        catch (EASBizException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String UpdateColumnValueByBatch(Connection shrConn, Context ctx, String tableName, String adminBossType, int count) throws BOSException, EASBizException {
        HashMap<String, ColumnInfo> columnMap = new HashMap();
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
            List<Map<String, Object>> easInfoList = SHRMoveDataHelpUtil.getEasInfo(shrConn, ctx, adminBossType, tableName, columnMap, column);
            List<Map<String, Object>> shrInfoList = SHRMoveDataHelpUtil.getShrInfo(shrConn, ctx, adminBossType, tableName, columnMap, column);
            for (int i = 0; i < easInfoList.size(); ++i) {
                Map<String, Object> easMap = easInfoList.get(i);
                Map<String, Object> shrMap = shrInfoList.get(i);
                String updateSql = "UPDATE " + tableName + " SET ";
                String valueSql = "";
                Iterator iterator = columnMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object shrValue;
                    String key;
                    String columnName = key = (String)iterator.next();
                    ColumnInfo columnInfo = (ColumnInfo)columnMap.get(key);
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                    Object easValue = null;
                    if (columnInfo.getColumnType().contains("VARCHAR") || columnInfo.getColumnType().contains("varchar") || columnInfo.getColumnType().contains("NVARCHAR2") || columnInfo.getColumnType().contains("nvarchar")) {
                        easValue = easMap.get(columnName);
                        if (easValue != null && !easValue.equals("")) continue;
                        shrValue = "";
                        shrValue = shrMap.get(columnName) != null ? shrMap.get(columnName).toString() : shrMap.get(columnName);
                        if (shrValue == null || shrValue.equals("")) continue;
                        valueSql = valueSql + "," + columnName + "='" + shrValue + "'";
                        continue;
                    }
                    if (columnInfo.getColumnType().contains("NUMBER") || columnInfo.getColumnType().contains("number")) {
                        easValue = easMap.get(columnName);
                        if (easValue != null && !easValue.equals("")) continue;
                        shrValue = "";
                        shrValue = shrMap.get(columnName) != null ? shrMap.get(columnName).toString() : shrMap.get(columnName);
                        if (shrValue == null || shrValue.equals("")) continue;
                        valueSql = valueSql + "," + columnName + "=" + shrValue;
                        continue;
                    }
                    if (!columnInfo.getColumnType().contains("TIME") && !columnInfo.getColumnType().contains("time") || (easValue = easMap.get(columnName)) != null && !easValue.equals("")) continue;
                    shrValue = "";
                    shrValue = shrMap.get(columnName) != null ? shrMap.get(columnName).toString() : shrMap.get(columnName);
                    if (shrValue == null || shrValue.equals("")) continue;
                    valueSql = valueSql + "," + columnName + "={" + shrValue + "}";
                }
                if (valueSql.equals("")) continue;
                updateSql = updateSql + valueSql.substring(1) + " WHERE FID = '" + easMap.get("FID") + "'";
                sqlList.add(updateSql);
            }
            SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, count);
        }
        catch (InterfaceDataBaseException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String updateColumnValueByShrValue(Connection shrConn, Context ctx, String tableName, String bosType, int count) throws BOSException, EASBizException {
        HashMap<String, ColumnInfo> columnMap = new HashMap();
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
            List<Map<String, Object>> easInfoList = SHRMoveDataHelpUtil.getEasInfo(shrConn, ctx, bosType, tableName, columnMap, column);
            List<Object> shrInfoList = new ArrayList();
            shrInfoList = tableName.contains("T_ORG_POSITION") ? SHRMoveDataHelpUtil.getShrInfo(shrConn, ctx, bosType, tableName + "_SHR_TEMP", columnMap, column) : SHRMoveDataHelpUtil.getShrInfo(shrConn, ctx, bosType, tableName, columnMap, column);
            for (int i = 0; i < easInfoList.size(); ++i) {
                Map shrMap = (Map)shrInfoList.get(i);
                Map<String, Object> easMap = easInfoList.get(i);
                String updateSql = "UPDATE " + tableName + " SET ";
                String valueSql = "";
                Iterator iterator = columnMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String columnName = key = (String)iterator.next();
                    ColumnInfo columnInfo = (ColumnInfo)columnMap.get(key);
                    if (!SHRMoveDataHelpUtil.noUpdateColumnValue(shrConn, ctx, tableName, columnName) || !SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                    Object shrValue = null;
                    if (columnInfo.getColumnType().contains("VARCHAR") || columnInfo.getColumnType().contains("varchar") || columnInfo.getColumnType().contains("NVARCHAR2") || columnInfo.getColumnType().contains("nvarchar")) {
                        shrValue = shrMap.get(columnName);
                        if (shrValue == null || shrValue.equals("")) continue;
                        valueSql = valueSql + "," + columnName + "='" + shrValue + "'";
                        continue;
                    }
                    if (columnInfo.getColumnType().contains("NUMBER") || columnInfo.getColumnType().contains("number") || columnInfo.getColumnType().contains("int")) {
                        shrValue = shrMap.get(columnName);
                        if (shrValue == null || shrValue.equals("")) continue;
                        valueSql = valueSql + "," + columnName + "=" + shrValue;
                        continue;
                    }
                    if (!columnInfo.getColumnType().contains("TIME") && !columnInfo.getColumnType().contains("time") || (shrValue = shrMap.get(columnName)) == null || shrValue.equals("")) continue;
                    valueSql = valueSql + "," + columnName + "={" + shrValue + "}";
                }
                if (valueSql.equals("")) continue;
                updateSql = updateSql + valueSql.substring(1) + " WHERE FID = '" + easMap.get("FID") + "'";
                sqlList.add(updateSql);
            }
            SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, count);
        }
        catch (InterfaceDataBaseException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static boolean noUpdateColumnValue(Connection shrConn, Context ctx, String tableName, String columnName) throws BOSException, EASBizException {
        int level;
        boolean result = true;
        if (columnName.toUpperCase().equals("NUMBER") || columnName.toUpperCase().equals("FID")) {
            result = false;
        }
        if (tableName.equals("T_ORG_POSITION") && (columnName.toUpperCase().equals("FKACLASSFICATIONID") || columnName.toUpperCase().equals("FDELETEDSTATUS") || columnName.toUpperCase().equals("FHRORGUNITID"))) {
            result = false;
        }
        if (tableName.equals("T_ORG_POSITION") && columnName.toUpperCase().equals("FDELETEDSTATUS")) {
            result = false;
        }
        if (tableName.equals("T_ORG_ADMIN") && columnName.toUpperCase().equals("FISSEALUP")) {
            result = false;
        }
        if ((level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx).intValue()) != 0) {
            if (tableName.equals("T_ORG_ADMIN") && columnName.toUpperCase().equals("FLONGNUMBER")) {
                result = false;
            }
            if (tableName.equals("T_ORG_ADMIN") && columnName.toUpperCase().equals("FDISPLAYNAME_L2")) {
                result = false;
            }
            if (tableName.equals("T_ORG_BASEUNIT") && columnName.toUpperCase().equals("FLONGNUMBER")) {
                result = false;
            }
            if (tableName.equals("T_ORG_BASEUNIT") && columnName.toUpperCase().equals("FDISPLAYNAME_L2")) {
                result = false;
            }
        }
        if (tableName.equals("T_ORG_BASEUNIT") && columnName.toUpperCase().equals("FISSEALUP")) {
            result = false;
        }
        if (tableName.equals("T_ORG_BASEUNIT") && columnName.toUpperCase().equals("FMAINTAINCUID")) {
            result = false;
        }
        if (SHRMoveDataHelpUtil.getFilterDisplayName(ctx) != 0 && tableName.equals("T_ORG_CTRLUNIT") && columnName.toUpperCase().equals("FLONGNUMBER")) {
            result = false;
        }
        return result;
    }

    public static ArrayList<String> getColumnValue(Connection shrConn, Context ctx, String tableName, String column, String filterShrId) throws BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        Map<Object, Object> columnMap = new HashMap();
        Statement state = null;
        ResultSet rs = null;
        try {
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            String getValueSql = "SELECT " + column + " FROM " + tableName + " WHERE FID NOT IN (" + filterShrId + ") ORDER BY FID";
            state = shrConn.createStatement();
            rs = state.executeQuery(getValueSql);
            while (rs.next()) {
                String[] listArray = column.split(",");
                String resultSql = "";
                for (int j = 0; j < listArray.length; ++j) {
                    String value = "";
                    String columnName = listArray[j];
                    if (columnName.toUpperCase().contains("FZDY")) {
                        resultSql = resultSql + ",null";
                        continue;
                    }
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                    String columnValue = rs.getString(j + 1);
                    value = columnValue != null ? columnValue.toString() : columnValue;
                    if (((ColumnInfo)columnMap.get(columnName)).getColumnType().toUpperCase().contains("VARCHAR")) {
                        if (value != null) {
                            value = "'" + value + "'";
                        }
                    } else if (!((ColumnInfo)columnMap.get(columnName)).getColumnType().toUpperCase().contains("NUMBER") && ((ColumnInfo)columnMap.get(columnName)).getColumnType().toUpperCase().contains("TIME") && value != null) {
                        value = "{" + value + "}";
                    }
                    resultSql = resultSql + "," + value;
                }
                String insertSql = "insert into " + tableName + "(" + column + ") values (" + resultSql.substring(1) + ")";
                resultList.add(insertSql);
            }
            return resultList;
        }
        catch (InterfaceDataBaseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getIdMapping(Context ctx, String adminBossType) throws BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "select FShrId,FEasId from T_HR_SynIdMapping where FBosType = '" + adminBossType + "'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FShrId");
                String easId = executeQuery.getString("FEasId");
                resultMap.put(shrId, easId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static List<Map<String, Object>> getShrInfo(Connection shrConn, Context ctx, String adminBossType, String tableName, Map<String, ColumnInfo> columnMap, String column) throws BOSException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Statement state = null;
        ResultSet rs = null;
        String[] listArray = column.split(",");
        try {
            String sql = "select FShrId from T_HR_SynIdMapping where FBosType = '" + adminBossType + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            String filterSql = "'1'";
            while (executeQuery.next()) {
                filterSql = filterSql + ",'" + executeQuery.getString("FShrId") + "'";
            }
            String getSql = "SELECT " + column + " FROM " + tableName + " WHERE FID IN (" + filterSql + ") ORDER BY FID";
            state = shrConn.createStatement();
            rs = state.executeQuery(getSql);
            while (rs.next()) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (int i = 0; i < listArray.length; ++i) {
                    String columnName = listArray[i];
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                    resultMap.put(columnName, rs.getString(columnName));
                }
                resultList.add(resultMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, Object>> getEasInfo(Connection shrConn, Context ctx, String adminBossType, String tableName, Map<String, ColumnInfo> columnMap, String column) throws BOSException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String[] listArray = column.split(",");
        String filterSql = "select FEasId from T_HR_SynIdMapping where FBosType = '" + adminBossType + "'";
        try {
            String getSql = "SELECT " + column + " FROM " + tableName + " WHERE FID IN (" + filterSql + ")  ORDER BY FID";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getSql);
            while (executeQuery.next()) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (int i = 0; i < listArray.length; ++i) {
                    String columnName = listArray[i];
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                    resultMap.put(columnName, executeQuery.getObject(columnName));
                }
                resultList.add(resultMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static String getColumnAllSql(Connection shrConn, Context ctx, String tableName) throws BOSException {
        String querySql = "";
        Map<Object, Object> columnMap = new HashMap();
        try {
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName.toUpperCase());
            Iterator<Object> iterator = columnMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String columnName = key = (String)iterator.next();
                if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName.toUpperCase(), columnName)) continue;
                querySql = querySql + "," + columnName;
            }
            if (!querySql.equals("")) {
                querySql = querySql.substring(1);
            }
        }
        catch (InterfaceDataBaseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return querySql;
    }

    public static String getColumnValueAllSql(Connection shrConn, Context ctx, String tableName, String id, String newId) throws BOSException {
        String resultSql = "";
        Map<Object, Object> columnMap = new HashMap();
        try {
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            Iterator<Object> iterator = columnMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String columnName = key = (String)iterator.next();
                ColumnInfo columnInfo = (ColumnInfo)columnMap.get(key);
                if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                String shrSql = "select " + columnName + " from " + tableName + " where FID = '" + id + "'";
                Statement state = shrConn.createStatement();
                ResultSet rs = state.executeQuery(shrSql);
                while (rs.next()) {
                    String value = "";
                    value = rs.getString(1) != null ? rs.getString(1).toString() : rs.getString(1);
                    if (columnInfo.getColumnType().toUpperCase().contains("VARCHAR")) {
                        if (value != null) {
                            value = "'" + value + "'";
                        }
                    } else if (!columnInfo.getColumnType().toUpperCase().contains("NUMBER") && columnInfo.getColumnType().toUpperCase().contains("TIME") && value != null) {
                        value = "{" + value + "}";
                    }
                    if (columnName.toUpperCase().equals("FID")) {
                        value = newId;
                    }
                    resultSql = resultSql + "," + value;
                }
                state.close();
            }
        }
        catch (InterfaceDataBaseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resultSql.substring(1);
    }

    public static String UpdateColumnValue(Connection shrConn, Context ctx, String tableName, String shrId, String easId) throws BOSException {
        Map<Object, Object> columnMap = new HashMap();
        Statement state = null;
        ResultSet rs = null;
        try {
            Connection easConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            Iterator<Object> iterator = columnMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String columnName = key = (String)iterator.next();
                ColumnInfo columnInfo = (ColumnInfo)columnMap.get(key);
                if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName, columnName)) continue;
                String sql = "select " + columnName + " from " + tableName + " where FID='" + easId + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    String updateSql;
                    String shrValue;
                    String shrSql;
                    Object value = null;
                    if (columnInfo.getColumnType().contains("VARCHAR") || columnInfo.getColumnType().contains("NVARCHAR2")) {
                        value = executeQuery.getString(columnName);
                        if (value != null && !value.equals("")) continue;
                        shrSql = "select " + columnName + " from " + tableName + " where FID='" + shrId + "'";
                        state = easConn.createStatement();
                        rs = state.executeQuery(shrSql);
                        while (rs.next()) {
                            shrValue = "";
                            shrValue = rs.getString(1) != null ? rs.getString(1).toString() : rs.getString(1);
                            if (shrValue == null || shrValue.equals("")) continue;
                            updateSql = "update " + tableName + " set " + columnName + " = '" + shrValue + "' where FID='" + easId + "'";
                            DbUtil.execute((Context)ctx, (String)updateSql);
                        }
                        continue;
                    }
                    if (columnInfo.getColumnType().contains("NUMBER")) {
                        value = executeQuery.getInt(columnName);
                        if (value != null && !value.equals("")) continue;
                        shrSql = "select " + columnName + " from " + tableName + " where FID='" + shrId + "'";
                        state = easConn.createStatement();
                        rs = state.executeQuery(shrSql);
                        while (rs.next()) {
                            shrValue = "";
                            shrValue = rs.getString(1) != null ? rs.getString(1).toString() : rs.getString(1);
                            if (shrValue == null || shrValue.equals("")) continue;
                            updateSql = "update " + tableName + " set " + columnName + " = " + shrValue + " where FID='" + easId + "'";
                            DbUtil.execute((Context)ctx, (String)updateSql);
                        }
                        continue;
                    }
                    if (!columnInfo.getColumnType().contains("TIME") || (value = executeQuery.getDate(columnName)) != null && !value.equals("")) continue;
                    shrSql = "select " + columnName + " from " + tableName + " where FID='" + shrId + "'";
                    state = easConn.createStatement();
                    rs = state.executeQuery(shrSql);
                    while (rs.next()) {
                        shrValue = "";
                        shrValue = rs.getString(1) != null ? rs.getString(1).toString() : rs.getString(1);
                        if (shrValue == null || shrValue.equals("")) continue;
                        updateSql = "update " + tableName + " set " + columnName + " = {" + shrValue + "} where FID='" + easId + "'";
                        DbUtil.execute((Context)ctx, (String)updateSql);
                    }
                }
            }
            SHRDbConnectionTool.releasDBResource(easConn, state, rs);
        }
        catch (InterfaceDataBaseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static boolean IfColumnExist(Connection shrConn, Context ctx, String tableName, String columnName) throws BOSException {
        boolean result = false;
        String sql2 = "select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + tableName + "' and KSQL_COL_NAME = '" + columnName + "'";
        try {
            IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            if (executeQuery2.size() > 0) {
                result = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean IfTableExist(Context ctx, String tableName) throws BOSException {
        boolean result = false;
        String sql2 = "select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + tableName + "'";
        try {
            IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            if (executeQuery2.size() > 0) {
                result = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean ifMultiCU(Context ctx) throws BOSException {
        String sql = "select count(*) as CuCount  from T_ORG_Admin where FISCU  = 1 ";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.size() > 0 && executeQuery.next() && executeQuery.getInt("CuCount") > 1) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getAdminCU(Context ctx) throws BOSException {
        String sql = "select FID from T_ORG_Admin where FISCU  = 1 ";
        String adminId = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                adminId = executeQuery.getString("FID");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return adminId;
    }

    public static void updateTableMoveStateByTableName(Context ctx, String tableName, String finishState) throws BOSException, EASBizException {
        SHRMoveDataHelpUtil.updateTableMoveState(ctx, "FMVTABLENAME", tableName.toUpperCase(), finishState);
    }

    public static void updateTableMoveStateById(Context ctx, String Id, String finishState) throws BOSException, EASBizException {
        SHRMoveDataHelpUtil.updateTableMoveState(ctx, "FID", Id, finishState);
    }

    public static void updateTableMoveState(Context ctx, String type, String value, String finishState) throws BOSException, EASBizException {
        String updateSql = "UPDATE T_HR_SHRMVTABLELIST SET FMVSATUS = '" + finishState + "'";
        if ("moving".equals(finishState) || "finished".equals(finishState)) {
            updateSql = updateSql + ", FMVEXCEPTION = '' ";
        }
        updateSql = updateSql + " WHERE " + type + " = '" + value + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static void updateTableMoveExceptionByTableName(Context ctx, String tableName, String exceptionInfo) throws BOSException, EASBizException {
        SHRMoveDataHelpUtil.updateTableMoveException(ctx, "FMVTABLENAME", tableName.toUpperCase(), exceptionInfo);
    }

    public static void updateTableMoveExceptionById(Context ctx, String Id, String exceptionInfo) throws BOSException, EASBizException {
        SHRMoveDataHelpUtil.updateTableMoveException(ctx, "FID", Id, exceptionInfo);
    }

    public static void updateTableMoveException(Context ctx, String type, String value, String exceptionInfo) throws BOSException, EASBizException {
        String updateSql = "UPDATE T_HR_SHRMVTABLELIST SET FMVEXCEPTION = '" + exceptionInfo.replaceAll("'", "/") + "' WHERE " + type + " = '" + value + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static String getMappingTableShrId(Connection shrConn, Context ctx, String bossType) throws BOSException, EASBizException {
        String filterId = "";
        String sql = "select FShrId from T_HR_SynIdMapping where FBosType = '" + bossType + "'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FShrId");
                filterId = filterId + ",'" + shrId + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        filterId = !filterId.equals("") ? filterId.substring(1) : "'1'";
        return filterId;
    }

    public static String getMappingTableEASId(Connection shrConn, Context ctx, String bossType) throws BOSException, EASBizException {
        String filterId = "";
        String sql = "select FEasId from T_HR_SynIdMapping where FBosType = '" + bossType + "'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FEasId");
                filterId = filterId + ",'" + shrId + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        filterId = !filterId.equals("") ? filterId.substring(1) : "'1'";
        return filterId;
    }

    public static String getStartSHRId(Connection shrConn, Context ctx, String bossType, String tableName) throws BOSException, EASBizException {
        String filterId = "'1'";
        String sql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FID FROM " + tableName + "_EAS_TEMP)";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FID");
                filterId = filterId + ",'" + shrId + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filterId;
    }

    public static String getNoMapSHRId(Connection shrConn, Context ctx, String bossType, String tableName) throws BOSException, EASBizException {
        String filterAddNewID = "'\u65b0\u589e\u7684\u7ec4\u7ec7'";
        try {
            String getAddnewIdSql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping where FBOSTYPE = '" + bossType + "') OR FID IN (SELECT FSHRID FROM T_HR_SynIdMapping where FBOSTYPE = '" + bossType + "' AND FMapWay = 'ID\u91cd\u590d')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAddnewIdSql);
            while (executeQuery.next()) {
                String id = executeQuery.getString("FID");
                filterAddNewID = filterAddNewID + ",'" + id + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filterAddNewID;
    }

    public static boolean checkMoveTableIfFinished(Context ctx, String tableName) throws BOSException, EASBizException {
        String sql = "SELECT fmvsatus FROM T_HR_SHRMvTableList WHERE FMVTABLENAME = '" + tableName + "'";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String status = executeQuery.getString("fmvsatus");
                if (!status.equals("finished")) continue;
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void insertEasDataToTemp(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        Statement state = null;
        try {
            state = shrConn.createStatement();
            ArrayList<String> shrToEasTable = new ArrayList<String>();
            shrToEasTable.add("T_ORG_ADMIN");
            shrToEasTable.add("T_ORG_BASEUNIT");
            shrToEasTable.add("T_ORG_JOB");
            shrToEasTable.add("T_ORG_JOBCATEGORY");
            shrToEasTable.add("T_ORG_POSITION");
            shrToEasTable.add("T_BD_PERSON");
            shrToEasTable.add("T_ORG_OUPARTADMIN");
            shrToEasTable.add("T_HR_PERSONPOSITION");
            shrToEasTable.add("T_ORG_HRO");
            shrToEasTable.add("T_ORG_CTRLUNIT");
            shrToEasTable.add("T_ORG_POSITIONMEMBER");
            shrToEasTable.add("T_PM_USER");
            shrToEasTable.add("T_ORG_LAYERTYPE");
            for (int j = 0; j < shrToEasTable.size(); ++j) {
                String sql;
                IRowSet tableRowSet;
                String tableName = (String)shrToEasTable.get(j);
                Connection easConn = null;
                easConn = EJBFactory.getConnection((Context)ctx);
                if (!StringUtils.isEmpty((String)tableName) && (tableRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableName + "'"))).next()) {
                    TableColumnSyncTool.synSHRTableInfoToEAS(ctx, shrConn, easConn, tableName);
                }
                if (TableColumnSyncTool.getTableColumnMap(shrConn, tableName + "_SHR_TEMP").size() > 0) {
                    state.executeUpdate("DROP TABLE " + tableName + "_SHR_TEMP");
                }
                if (SHRMoveDataHelpUtil.IfTableExist(ctx, tableName + "_EAS_TEMP")) {
                    DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tableName + "_EAS_TEMP"));
                }
                if (SHRMoveDataHelpUtil.IfTableExist(ctx, tableName + "_SHR_TEMP")) {
                    DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tableName + "_SHR_TEMP"));
                }
                if (shrConn.getMetaData().getDriverName().toUpperCase().contains("ORACLE")) {
                    state.executeUpdate("CREATE TABLE " + tableName + "_SHR_TEMP as SELECT * FROM " + tableName);
                } else {
                    state.executeUpdate("SELECT * INTO " + tableName + "_SHR_TEMP FROM " + tableName);
                }
                DbUtil.execute((Context)ctx, (String)("SELECT * INTO " + tableName + "_EAS_TEMP FROM " + tableName));
                DbUtil.execute((Context)ctx, (String)("SELECT TOP 1 * INTO " + tableName + "_SHR_TEMP FROM " + tableName));
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + "_SHR_TEMP"));
                UpdateTool.commonUpdate(shrConn, tableName + "_SHR_TEMP", "", ctx, 100);
            }
            state.close();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void backupCopyForTest(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String sql = "SELECT FMVTABLENAME FROM T_HR_SHRMvTableList WHERE FBIZTYPE IN ('ADMIN','PERSON','POSITION','JOB') ORDER BY FBIZTYPE";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String tableName = executeQuery.getString("FMVTABLENAME");
                String tempTableName = tableName + "_TEST";
                if (SHRMoveDataHelpUtil.IfTableExist(ctx, tempTableName)) continue;
                DbUtil.execute((Context)ctx, (String)("SELECT * INTO " + tempTableName + " FROM " + tableName));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void synchronizationTable(Connection shrConn, Context ctx, String tableName) throws BOSException, EASBizException {
        try {
            Statement state = null;
            state = shrConn.createStatement();
            if (TableColumnSyncTool.getTableColumnMap(shrConn, tableName + "_SHR_TEMP").size() > 0) {
                state.executeUpdate("DROP TABLE " + tableName + "_SHR_TEMP");
            }
            if (shrConn.getMetaData().getDriverName().toUpperCase().contains("ORACLE")) {
                state.executeUpdate("CREATE TABLE " + tableName + "_SHR_TEMP as SELECT * FROM " + tableName);
            } else {
                state.executeUpdate("SELECT * INTO " + tableName + "_SHR_TEMP FROM " + tableName);
            }
            DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + "_SHR_TEMP"));
            UpdateTool.commonUpdate(shrConn, tableName + "_SHR_TEMP", "", ctx, 100);
            DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tableName + "_EAS_TEMP"));
            DbUtil.execute((Context)ctx, (String)("SELECT * INTO " + tableName + "_EAS_TEMP FROM " + tableName));
            state.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean isTableExist(Connection shrConn, Context ctx, String tableName) throws BOSException, EASBizException {
        boolean result = false;
        Statement state = null;
        ResultSet rs = null;
        String sql = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FID' and KSQL_COL_TABNAME='" + tableName + "'";
        try {
            state = shrConn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void refreshFidAction(Context ctx, String mvTableName, String columnName, String columnType) throws BOSException, EASBizException {
        String adminBossType = "6A6435BE";
        String positionBossType = "74AE612E";
        String personBossType = "80EF7DED";
        String jobBossType = "75702498";
        String orgUnitLayerTypeBossType = "62824988";
        String jobCategoryBossType = "B48B2DB6";
        String mapBossType = "";
        if (columnType.equals("adminOrg")) {
            mapBossType = adminBossType;
        } else if (columnType.equals("postion")) {
            mapBossType = positionBossType;
        } else if (columnType.equals("person")) {
            mapBossType = personBossType;
        } else if (columnType.equals("job")) {
            mapBossType = jobBossType;
        } else if (columnType.equals("OrgUnitLayerType")) {
            mapBossType = orgUnitLayerTypeBossType;
        } else if (columnType.equals("jobCategory")) {
            mapBossType = jobCategoryBossType;
        }
        int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        try {
            String sql = "SELECT FSHRID,FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '" + mapBossType + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FSHRID");
                if (level != 0 && shrId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) continue;
                String easId = executeQuery.getString("FEASID");
                String updateSql = "UPDATE " + mvTableName + " SET " + columnName + " = '" + easId + "' WHERE " + columnName + "='" + shrId + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void insertByBatch(Context ctx, List<String> sqlList, int count) throws BOSException, EASBizException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            int j = 1;
            for (int i = 0; i < sqlList.size(); ++i) {
                ps.addBatch(sqlList.get(i));
                if (++j != count) continue;
                ps.executeBatch();
                ps.close();
                ps = conn.createStatement();
                j = 1;
            }
            ps.executeBatch();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertByBatchConnection(Context ctx, List<String> sqlList, int count) throws BOSException, EASBizException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            ps = conn.createStatement();
            int j = 1;
            for (int i = 0; i < sqlList.size(); ++i) {
                ps.addBatch(sqlList.get(i));
                if (++j != count) continue;
                ps.executeBatch();
                ps.close();
                ps = conn.createStatement();
                j = 1;
            }
            ps.executeBatch();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void logExceptionInfo(Context ctx, String tableName, Exception e) {
        String exception = SHRMoveDataHelpUtil.getErrorInfoFromException(e);
        Object[] param = new Object[]{exception.substring(0, exception.length() > 2000 ? 2000 : exception.length()), tableName};
        try {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_SHRMvTableList SET FmvException = ?  WHERE FMVTABLENAME = ?", (Object[])param);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    private static String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    public static Integer getMoveAdminLevel(Context ctx) throws BOSException, EASBizException {
        String sql = "SELECT FStartAdminLevel FROM T_HR_DataMoveProject";
        int adminLevel = 0;
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                adminLevel = executeQuery.getInt("FStartAdminLevel");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return adminLevel;
    }

    public static Integer getFilterDisplayName(Context ctx) throws BOSException, EASBizException {
        int level = SHRMoveDataHelpUtil.getMoveAdminLevel(ctx);
        int startNumber = 0;
        if (level == 1) {
            String sql = "SELECT FNAME_L2 FROM T_ORG_ADMIN WHERE FLEVEL = 1";
            try {
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    startNumber = executeQuery.getString("FNAME_L2").length();
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return startNumber;
    }

    public static String getFilterFname(Context ctx) throws BOSException, EASBizException {
        int level = SHRMoveDataHelpUtil.getMoveAdminLevel(ctx);
        String name = "";
        if (level == 1) {
            String sql = "SELECT FNAME_L2 FROM T_ORG_ADMIN WHERE FLEVEL = 1";
            try {
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    name = executeQuery.getString("FNAME_L2") + "_";
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return name;
    }

    public static boolean checkEasDBifEmpty() throws SHRWebException {
        boolean resultInfo = false;
        Context ctx = SHRContext.getInstance().getContext();
        String sql = "select * from T_HR_DataMoveProject WHERE FIsEmptyDataBase = 1";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.size() > 0) {
                resultInfo = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultInfo;
    }

    public static boolean checkIdIsExist(String shrId, String easTableName, String easId) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            if (shrId.equals(easId)) {
                return false;
            }
            String checkSql = "SELECT * FROM " + easTableName + " WHERE FID = '" + shrId + "' AND FID != '" + easId + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (executeQuery.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean checkMapTableIdRepeat(String bosType, String mapWay) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            String checkSql = "SELECT * FROM T_HR_SynIdMapping WHERE FBosType = '" + bosType + "' and FMapWay = '" + mapWay + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (executeQuery.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(Connection shrConn, String restoreTable, String desTable, String field) throws SQLException {
        Statement state = null;
        String sql = "update " + restoreTable + " set " + field + "=(select " + field + " from " + desTable + " where " + restoreTable + ".fid=" + desTable + ".fid) where " + restoreTable + ".FID IN(SELECT FID FROM " + desTable + ")";
        try {
            state = shrConn.createStatement();
            state.execute(sql);
            shrConn.commit();
        }
        catch (Exception e) {
            try {
                shrConn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                state.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean clearHrData(Connection shrConn, Context ctx, String tableName, String tempTableName, String fieldName) throws SQLException {
        String dbName = shrConn.getMetaData().getDatabaseProductName();
        Statement state = null;
        state = shrConn.createStatement();
        try {
            String sql;
            if ("Oracle".equals(dbName)) {
                ResultSet rs = null;
                rs = state.executeQuery("select 1 from user_tables where table_name='" + tempTableName.toUpperCase() + "' OR  table_name='" + tempTableName + "'");
                if (rs.next()) {
                    state.execute("DROP TABLE  " + tempTableName);
                }
                sql = "create table " + tempTableName + " as select * from " + tableName;
            } else {
                state.execute("IF EXISTS ( SELECT  TABLE_NAME FROM INFORMATION_SCHEMA.TABLES   WHERE   TABLE_NAME = '" + tempTableName + "')  DROP TABLE " + tempTableName + ";");
                sql = "select * into " + tempTableName + " from " + tableName + ";";
            }
            state.execute(sql);
            state.execute("update " + tableName + " set " + fieldName + " =  replace(replace(" + fieldName + ",'\u804c\u4f4d','\u804c\u52a1'),'\u5c97\u4f4d','\u804c\u4f4d')");
            shrConn.commit();
        }
        catch (Exception e) {
            shrConn.rollback();
            throw new SQLException(e);
        }
        finally {
            state.close();
        }
        return true;
    }

    public static boolean clearHrDataForBigField(Connection shrConn, Context ctx, String tableName, String tempTableName, String fieldName) throws SQLException {
        String dbName = shrConn.getMetaData().getDatabaseProductName();
        Statement state = null;
        state = shrConn.createStatement();
        try {
            if ("Oracle".equals(dbName)) {
                ResultSet rs = null;
                rs = state.executeQuery("select 1 from user_tables where table_name='" + tempTableName.toUpperCase() + "' OR  table_name='" + tempTableName + "'");
                if (rs.next()) {
                    state.execute("DROP TABLE  " + tempTableName);
                }
                String sql = "create table " + tempTableName + " as select * from " + tableName;
                state.execute(sql);
                state.execute("update " + tableName + " set " + fieldName + " =  replace(replace(" + fieldName + ",'\u804c\u4f4d','\u804c\u52a1'),'\u5c97\u4f4d','\u804c\u4f4d')");
                shrConn.commit();
            } else {
                state.execute("IF EXISTS ( SELECT  TABLE_NAME FROM INFORMATION_SCHEMA.TABLES   WHERE   TABLE_NAME = '" + tempTableName + "')  DROP TABLE " + tempTableName + ";");
                String sql = "select * into " + tempTableName + " from " + tableName + ";";
                state.execute(sql);
                state.execute("update " + tableName + " set " + fieldName + " =  replace(convert(varchar(8000), " + fieldName + "),'\u804c\u4f4d','\u804c\u52a1');");
                state.execute("update " + tableName + " set " + fieldName + " =  replace(convert(varchar(8000), " + fieldName + "),'\u5c97\u4f4d','\u804c\u4f4d');");
                shrConn.commit();
            }
        }
        catch (Exception e) {
            shrConn.rollback();
            throw new SQLException(e);
        }
        finally {
            state.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty(Connection conn, String tableName) throws SQLException {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<String> res = new ArrayList<String>();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            String sql = "select count(*) from " + tableName;
            state = conn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                res.add(rs.getString(1).toUpperCase());
            }
            if (res.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            state.close();
            conn.close();
            res.clear();
        }
        return false;
    }

    public static boolean TableExist(Connection conn, String tableName) throws BOSException {
        boolean result = false;
        Statement state = null;
        ArrayList<String> res = new ArrayList<String>();
        String sql2 = "select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + tableName + "'";
        try {
            state = conn.createStatement();
            ResultSet rs = state.executeQuery(sql2);
            while (rs.next()) {
                res.add(rs.getString(1).toUpperCase());
            }
            result = !res.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

