/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.handler.rec.UpdateRecUIViewHelper;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import com.kingdee.shr.recuritment.IInterviewRange;
import com.kingdee.shr.recuritment.IInterviewerManagement;
import com.kingdee.shr.recuritment.InterviewRangeCollection;
import com.kingdee.shr.recuritment.InterviewRangeFactory;
import com.kingdee.shr.recuritment.InterviewRangeInfo;
import com.kingdee.shr.recuritment.InterviewResultCollection;
import com.kingdee.shr.recuritment.InterviewResultFactory;
import com.kingdee.shr.recuritment.InterviewResultInfo;
import com.kingdee.shr.recuritment.InterviewerManagementFactory;
import com.kingdee.shr.recuritment.InterviewerManagementInfo;
import com.kingdee.shr.recuritment.InterviewerUseRangeEnum;
import com.kingdee.shr.recuritment.RecApprovalFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ControlRecuritmentDataMoveHandler
implements ISHRControlMoveDataHandler {
    private static final String MOVENUMBER_RECURITDEMAND = "RecuritmentDemand";
    private static final String MOVENUMBER_RESUMEBASEREC = "ResumeBaseRec";
    private static final String MOVENUMBER_RECINTERVIEW = "RecInterview";
    private static final String MOVENUMBER_RECAPPROVAL = "RecApproval";
    private static final String MOVENUMBER_RECUIVIEW = "RecUiView";

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveRecuritDemandData(ctx);
        this.moveResumeBaseRecData(ctx);
        this.moveRecInterviewData(ctx);
        this.moveRecApprovalData(ctx);
        this.moveRecUiView(ctx);
        return "";
    }

    private void moveRecUiView(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, MOVENUMBER_RECUIVIEW)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECUIVIEW, "moving");
                UpdateRecUIViewHelper uiViewHelper = new UpdateRecUIViewHelper();
                uiViewHelper.setContext(ctx);
                uiViewHelper.levelUp();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECUIVIEW, "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, MOVENUMBER_RECUIVIEW, "\u62db\u8058\u89c6\u56fe\u5347\u7ea7\u5931\u8d25\n" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private void moveRecApprovalData(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, MOVENUMBER_RECAPPROVAL)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECAPPROVAL, "moving");
                RecApprovalFactory.getRemoteInstance().initInterviewStageResult();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECAPPROVAL, "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, MOVENUMBER_RECAPPROVAL, "\u62db\u8058\u9700\u6c42\u6570\u636e\u5347\u7ea7\u5931\u8d25\n" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private void moveResumeBaseRecData(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, MOVENUMBER_RESUMEBASEREC)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RESUMEBASEREC, "moving");
                ResumeBaseRecFactory.getRemoteInstance().updateOldResumeData();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RESUMEBASEREC, "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, MOVENUMBER_RESUMEBASEREC, "\u62db\u8058\u9700\u6c42\u6570\u636e\u5347\u7ea7\u5931\u8d25\n" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private void moveRecuritDemandData(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, MOVENUMBER_RECURITDEMAND)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECURITDEMAND, "moving");
                RecuritmentDemandFactory.getRemoteInstance().recuritmentDemandOldBillUpdate();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECURITDEMAND, "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, MOVENUMBER_RECURITDEMAND, "\u62db\u8058\u9700\u6c42\u6570\u636e\u5347\u7ea7\u5931\u8d25\n" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private void moveRecInterviewData(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, MOVENUMBER_RECINTERVIEW)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECINTERVIEW, "moving");
                this.updateInterviewResult(ctx);
                this.updateInterviewerManagement(ctx);
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, MOVENUMBER_RECINTERVIEW, "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, MOVENUMBER_RECINTERVIEW, "\u62db\u8058\u9762\u8bd5\u6570\u636e\u5347\u7ea7\u5931\u8d25\n" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private void updateInterviewResult(Context ctx) throws BOSException {
        InterviewResultCollection coll = InterviewResultFactory.getLocalInstance((Context)ctx).getInterviewResultCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            InterviewResultInfo interviewResult = coll.get(i);
            String currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewResult.getId()));
            String sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{currInterviewStageId, interviewResult.getId().toString()});
        }
    }

    private String getCurrInterviewStageId(Context ctx, IObjectPK interviewResulId) throws BOSException {
        String currInterviewStageId = null;
        try {
            Object[] params = new Object[]{interviewResulId.toString()};
            String sql01 = "SELECT P.FID,R.FResult FROM T_REC_InterviewPlanResult R JOIN (SELECT FID,FInterviewStageName,FInviteStatus,FInterviewTime,FInterviewID,FOrder FROM T_REC_InterviewPlan WHERE FInterviewID = ?) P ON (R.FInterviewPlanId = P.FID) ORDER BY FInterviewId ASC,FOrder ASC";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql01, (Object[])params);
            while (rs.next()) {
                currInterviewStageId = rs.getString(1);
                String result = rs.getString(2);
                if ("3".equals(result)) continue;
                break;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return currInterviewStageId;
    }

    public void updateInterviewerManagement(Context ctx) throws EASBizException, BOSException {
        IInterviewRange iInterviewRange = InterviewRangeFactory.getLocalInstance((Context)ctx);
        IInterviewerManagement iInterviewerManagement = InterviewerManagementFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("ableDepartNames.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("useRange"));
        selector.add(new SelectorItemInfo("ablePositionIds"));
        selector.add(new SelectorItemInfo("interviewerManagement.id"));
        view.setSelector(selector);
        InterviewRangeCollection interviewRangeCollection = iInterviewRange.getInterviewRangeCollection(view);
        HashMap<String, ArrayList> interviewRangemap = new HashMap<String, ArrayList>();
        ArrayList interviewRangeList = new ArrayList();
        String interviewerManagementId = "";
        if (interviewRangeCollection.size() > 0) {
            InterviewRangeInfo interviewRangeInfo;
            int size = interviewRangeCollection.size();
            for (int i = 0; i < size; ++i) {
                interviewRangeInfo = interviewRangeCollection.get(i);
                interviewerManagementId = interviewRangeInfo.getInterviewerManagement().getId().toString();
                if (interviewRangemap.get(interviewerManagementId) == null) {
                    interviewRangeList = new ArrayList();
                    interviewRangeList.add(interviewRangeInfo);
                    interviewRangemap.put(interviewerManagementId, interviewRangeList);
                    continue;
                }
                interviewRangeList = (ArrayList)interviewRangemap.get(interviewerManagementId);
                interviewRangeList.add(interviewRangeInfo);
                interviewRangemap.put(interviewerManagementId, interviewRangeList);
            }
            CoreBaseCollection coll = iInterviewerManagement.getCollection();
            int length = coll.size();
            for (int m = 0; m < length; ++m) {
                StringBuilder ableDepartNames = new StringBuilder("");
                StringBuilder ableHrOrgUnit = new StringBuilder("");
                StringBuilder ablePosiNames = new StringBuilder("");
                StringBuilder ablePosiIds = new StringBuilder("");
                InterviewerManagementInfo interviewerManagementInfo = (InterviewerManagementInfo)coll.get(m);
                interviewerManagementId = interviewerManagementInfo.getId().toString();
                interviewRangeList = (ArrayList)interviewRangemap.get(interviewerManagementId);
                if (interviewRangeList != null && interviewRangeList.size() > 0) {
                    size = interviewRangeList.size();
                    for (int i = 0; i < size; ++i) {
                        interviewRangeInfo = (InterviewRangeInfo)interviewRangeList.get(i);
                        if (interviewRangeInfo.getUseRange().equals((Object)InterviewerUseRangeEnum.ADMINORGUNIT)) {
                            ableDepartNames.append(interviewRangeInfo.getAbleDepartNames().getName()).append("\u3001");
                            if (StringUtils.isEmpty((String)interviewRangeInfo.getAblePositionIds())) continue;
                            if (!StringUtils.isEmpty((String)ablePosiIds.toString()) && !StringUtils.isEmpty((String)interviewRangeInfo.getAblePositionIds())) {
                                ablePosiIds.append(",");
                            }
                            ablePosiIds.append(interviewRangeInfo.getAblePositionIds());
                            continue;
                        }
                        ableHrOrgUnit.append(interviewRangeInfo.getHrOrgUnit().getName()).append("\u3001");
                        if (StringUtils.isEmpty((String)interviewRangeInfo.getAblePositionIds())) continue;
                        if (!StringUtils.isEmpty((String)ablePosiIds.toString())) {
                            ablePosiIds.append(",");
                        }
                        ablePosiIds.append(interviewRangeInfo.getAblePositionIds());
                    }
                    List datas = null;
                    try {
                        if (!StringUtils.isEmpty((String)ablePosiIds.toString())) {
                            StringBuilder sql = new StringBuilder("SELECT FName_L2 FROM T_ORG_Position WHERE FID In (");
                            int index = 0;
                            for (String id : ablePosiIds.toString().split(",")) {
                                if (index++ > 0) {
                                    sql.append(",");
                                }
                                sql.append("'").append(id).append("'");
                            }
                            sql.append(") ");
                            datas = RecDBUtils.getQueryData((Context)ctx, (String)sql.toString(), null);
                            for (Object[] data : datas) {
                                ablePosiNames.append((String)data[0]).append("\u3001");
                            }
                            if (!StringUtils.isEmpty((String)ablePosiNames.toString())) {
                                interviewerManagementInfo.setAblePosiNames(ablePosiNames.substring(0, ablePosiNames.length() - 1));
                            }
                        } else {
                            interviewerManagementInfo.setAblePosiNames("");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BOSException((Throwable)e);
                    }
                    if (!StringUtils.isEmpty((String)ableDepartNames.toString())) {
                        interviewerManagementInfo.setAbleDepartNames(ableDepartNames.substring(0, ableDepartNames.length() - 1));
                    } else {
                        interviewerManagementInfo.setAbleDepartNames("");
                    }
                    if (!StringUtils.isEmpty((String)ableHrOrgUnit.toString())) {
                        interviewerManagementInfo.setAbleDepartmentIds(ableHrOrgUnit.substring(0, ableHrOrgUnit.length() - 1));
                        continue;
                    }
                    interviewerManagementInfo.setAbleDepartmentIds("");
                    continue;
                }
                interviewerManagementInfo.setAblePosiNames("");
                interviewerManagementInfo.setAbleDepartNames("");
                interviewerManagementInfo.setAbleDepartmentIds("");
            }
            iInterviewerManagement.update(coll);
        }
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        return "";
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "RECCHECK", 100, 100);
    }
}

