/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.cmp.io;

import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.ColumnDTO;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.ExportDTO;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.StyleUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CmpExportHelper {
    public static final String EAS_HOME = System.getProperty("EAS_HOME");
    public static final String TMPNAME = "tmp";
    public static final String ZIPFOLDER = "newZipFolder";
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear";
    public static final String SHR_WEB_TMP_PATH = EAS_EAR_ROOT + File.separator + "shr_web.war" + File.separator + "tmp";
    public static final String SHR_NEWZIPFLODER = EAS_EAR_ROOT + File.separator + "shr_web.war" + File.separator + "newZipFolder";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.hr.mvdt.handler.cmp.io.CmpExporHelper");
    private static final int DEFAULT_SIZE = 200;
    private final int DESC_INDEX = 0;
    private final int TITLE_INDEX = 1;
    private final int DATA_INDEX = 2;
    private SXSSFWorkbook wb;
    private Sheet sheet;
    private ExportDTO exportDTO;

    public CmpExportHelper(ExportDTO exportDTO) {
        this(exportDTO, 200);
    }

    public CmpExportHelper(ExportDTO exportDTO, int windowSize) {
        this.wb = new SXSSFWorkbook(windowSize);
        this.exportDTO = exportDTO;
    }

    public String importDataToExcel() {
        this.createTitle();
        this.importData();
        return this.writeToExcel();
    }

    private void createTitle() {
        Map<String, CellStyle> stylesMap = StyleUtil.createStyles((Workbook)this.wb);
        this.sheet = this.wb.createSheet(this.exportDTO.getTempName());
        Row row = this.sheet.createRow(0);
        row.setHeight((short)1000);
        Cell cell = row.createCell(0);
        cell.setCellValue(this.exportDTO.getDesc());
        CellStyle cellStyle = this.wb.createCellStyle();
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        this.sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, this.exportDTO.getColumnList().size() - 1));
        row = this.sheet.createRow(1);
        List<ColumnDTO> columnList = this.exportDTO.getColumnList();
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            ColumnDTO columnDTO = columnList.get(i);
            cell = row.createCell(i);
            cell.setCellValue(columnDTO.getName());
            cell.setCellStyle(stylesMap.get("head"));
        }
    }

    private void importDataForRowSet() {
        int rowNum = 2;
        DecimalFormat df = new DecimalFormat("##.##");
        List<ColumnDTO> columnList = this.exportDTO.getColumnList();
        IRowSet rowSet = this.exportDTO.getRowSet();
        try {
            while (rowSet.next()) {
                Row row = this.sheet.createRow(rowNum);
                int size = columnList.size();
                for (int i = 0; i < size; ++i) {
                    ColumnDTO columnDTO = columnList.get(i);
                    Object value = rowSet.getObject(columnDTO.getNumber());
                    Cell cell = row.createCell(i);
                    if (null == value) continue;
                    if (2 == columnDTO.getDataType()) {
                        cell.setCellValue(Double.valueOf(df.format(Double.valueOf(null == value ? "0.00" : value.toString()))).doubleValue());
                        continue;
                    }
                    if (3 == columnDTO.getDataType()) {
                        cell.setCellValue(value.toString().substring(0, 10));
                        continue;
                    }
                    cell.setCellValue(value.toString());
                }
                ++rowNum;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
    }

    private void importDataForList() {
        int rowNum = 2;
        DecimalFormat df = new DecimalFormat("##.##");
        List<ColumnDTO> columnList = this.exportDTO.getColumnList();
        List<Map<String, Object>> dataList = this.exportDTO.getDataList();
        int listSize = dataList.size();
        for (int k = 0; k < listSize; ++k) {
            Row row = this.sheet.createRow(rowNum);
            int size = columnList.size();
            for (int i = 0; i < size; ++i) {
                ColumnDTO columnDTO = columnList.get(i);
                Object value = dataList.get(k).get(columnDTO.getNumber());
                Cell cell = row.createCell(i);
                if (null == value) continue;
                if (2 == columnDTO.getDataType()) {
                    cell.setCellValue(Double.valueOf(df.format(Double.valueOf(null == value ? "0.00" : value.toString()))).doubleValue());
                    continue;
                }
                if (3 == columnDTO.getDataType()) {
                    cell.setCellValue(value.toString().substring(0, 10));
                    continue;
                }
                cell.setCellValue(value.toString());
            }
            ++rowNum;
        }
    }

    private void importData() {
        List<ColumnDTO> columnList = this.exportDTO.getColumnList();
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            this.sheet.setColumnWidth(i, 3840);
        }
        List<Map<String, Object>> dataList = this.exportDTO.getDataList();
        if (null == dataList) {
            this.importDataForRowSet();
        } else {
            this.importDataForList();
        }
    }

    private String writeToExcel() {
        String path = SHR_WEB_TMP_PATH + File.separator + UUID.randomUUID().toString() + ".xlsx";
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        try {
            this.wb.write((OutputStream)out);
            out.close();
            this.wb.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        return path;
    }
}

