/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.cmp.io;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.CmpExportHelper;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.ColumnDTO;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.ExportDTO;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class CmpFileHandler
extends CoreHandler {
    public static void setExportExcelHead(HttpServletResponse response, String path, String fileName) throws Exception {
        int len;
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        byte[] buffer = new byte[5120];
        while ((len = bis.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
    }

    public String downloadCmpCostDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        ExportDTO exportDTO = this.getCostBearOrgForExport();
        CmpExportHelper exportHelper = new CmpExportHelper(exportDTO);
        String path = exportHelper.importDataToExcel();
        try {
            CmpFileHandler.setExportExcelHead(response, path, exportDTO.getFileName());
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public String downloadCmpPermDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        ExportDTO exportDTO = this.getCmpPerm();
        CmpExportHelper exportHelper = new CmpExportHelper(exportDTO);
        String path = exportHelper.importDataToExcel();
        try {
            CmpFileHandler.setExportExcelHead(response, path, exportDTO.getFileName());
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public String downloadCalFormulaDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        ExportDTO exportDTO = this.getCalFormulaForExport();
        CmpExportHelper exportHelper = new CmpExportHelper(exportDTO);
        String path = exportHelper.importDataToExcel();
        try {
            CmpFileHandler.setExportExcelHead(response, path, exportDTO.getFileName());
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public ExportDTO getCmpPerm() throws SHRWebException {
        String desc = "\u5347\u7ea7\u524d\u5458\u5de5\u7684\u85aa\u916c\u6570\u636e\u6743\u9650\u8bbe\u7f6e\u6570\u636e\u4e0b\u8f7d\u3002\u4e0b\u8f7d\u540e\uff0c\u9700\u8981\u6309\u7167\u539f\u85aa\u916c\u6570\u636e\u6743\u9650\u8bbe\u7f6e\uff0c\u91cd\u65b0\u5728\u53d1\u85aa\u6570\u636e\u6743\u9650\u3001\u793e\u4fdd\u6570\u636e\u6743\u9650\u3001\u5b9a\u8c03\u85aa\u6570\u636e\u6743\u9650\u4e2d\u8bbe\u7f6e\u3002";
        ExportDTO exportDTO = new ExportDTO("\u85aa\u916c\u6570\u636e\u6743\u9650", "\u85aa\u916c\u6570\u636e\u6743\u9650", desc);
        IRowSet rowSet = null;
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        ArrayList<ColumnDTO> list = new ArrayList<ColumnDTO>();
        list.add(new ColumnDTO("\u5458\u5de5\u7f16\u7801", "personNumber"));
        list.add(new ColumnDTO("\u59d3\u540d", "personName"));
        list.add(new ColumnDTO("\u6570\u636e\u6743\u9650", "perm"));
        exportDTO.setColumnList(list);
        StringBuilder str = new StringBuilder();
        str.append(" select t1.FNumber personNumber, t1.FName_l2 personName, t0.FDESCRIPTION_L2 perm ");
        str.append(" from T_HR_SCmpPerm_Back t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" where t0.FDESCRIPTION_L2 is not null ");
        try {
            rowSet = DbUtil.executeQuery((Context)SHRContext.getInstance().getContext(), (String)str.toString());
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("perm"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personNumber", rowSet.getString("personNumber"));
                map.put("personName", rowSet.getString("personName"));
                map.put("perm", rowSet.getString("perm"));
                dataList.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage());
        }
        exportDTO.setDataList(dataList);
        return exportDTO;
    }

    public ExportDTO getCostBearOrgForExport() throws SHRWebException {
        String desc = "\u5347\u7ea7\u524d\u5458\u5de5\u7684\u8d39\u7528\u5206\u644a\u8bbe\u7f6e\u6570\u636e\u4e0b\u8f7d\uff0c\u539f\u8d39\u7528\u5206\u644a\u8bbe\u7f6e\u4e2d\u6ca1\u6709\u4efb\u804c\u4fe1\u606f\u3002\r\u4e0b\u8f7d\u65f6\u53bb\u67e5\u627e\u5458\u5de5\u53d1\u85aa\u6863\u6848\u7684\u4efb\u804c\u4fe1\u606f\u4e2d\u7684\uff1a\u5931\u6548\u65e5\u671f\u4e3a2199-12-31\u7684\u4efb\u804c\u4fe1\u606f\u4e0b\u8f7d\u4e0b\u6765\uff0c\u5982\u679c\u4e0d\u5b58\u5728\u5219\u4efb\u804c\u7ec4\u7ec7\u548c\u804c\u4f4d\u4e3a\u7a7a\uff0c\u5176\u4ed6\u5b57\u6bb5\u4fdd\u6301\u539f\u6765\u7684\u503c\u4e0d\u53d8\u3002\r\u4e0b\u8f7d\u540e\uff0c\u9700\u8981\u5c06\u8d39\u7528\u5206\u644a\u8bbe\u7f6e\u6570\u636e\u91cd\u65b0\u6574\u7406\u5230\u8d39\u7528\u5206\u644a\u8bbe\u7f6e\u5bfc\u5165\u6a21\u677f\u4e2d\u91cd\u65b0\u5bfc\u5165\u8bbe\u7f6e\u3002";
        ExportDTO exportDTO = new ExportDTO("\u8d39\u7528\u5206\u644a\u8bbe\u7f6e", "\u8d39\u7528\u5206\u644a\u8bbe\u7f6e", desc);
        IRowSet rowSet = null;
        ArrayList<ColumnDTO> list = new ArrayList<ColumnDTO>();
        list.add(new ColumnDTO("\u5458\u5de5\u7f16\u7801", "personNumber"));
        list.add(new ColumnDTO("\u59d3\u540d", "personName"));
        list.add(new ColumnDTO("\u4efb\u804c\u7ec4\u7ec7", "orgName"));
        list.add(new ColumnDTO("\u804c\u4f4d", "position"));
        list.add(new ColumnDTO("\u53d1\u85aa\u7ec4\u7ec7\u7f16\u7801", "calOrgNumber"));
        list.add(new ColumnDTO("\u53d1\u85aa\u7ec4\u7ec7", "calOrgName"));
        list.add(new ColumnDTO("\u8d39\u7528\u627f\u62c5\u7ec4\u7ec7\u7f16\u7801", "costOrgNumber"));
        list.add(new ColumnDTO("\u8d39\u7528\u627f\u62c5\u7ec4\u7ec7", "costOrgName"));
        list.add(new ColumnDTO("\u8d39\u7528\u627f\u62c5\u6bd4\u4f8b(%)", "perc", 2));
        list.add(new ColumnDTO("\u542f\u7528\u72b6\u6001", "state"));
        list.add(new ColumnDTO("\u751f\u6548\u65e5\u671f", "effdt", 3));
        exportDTO.setColumnList(list);
        StringBuilder str = new StringBuilder();
        str.append(" select t1.FNumber personNumber, t1.FName_l2 personName, cal.FNumber calOrgNumber, cal.FName_l2 calOrgName, ");
        str.append(" cost.FNumber costOrgNumber, cost.FName_l2 costOrgName, t0.FCostBearPerc perc,  ");
        str.append(" case when t0.FState = 1 then '\u542f\u7528' else '\u7981\u7528' end state,  ");
        str.append(" t0.FEffactDate effdt, t4.FName_l2 orgName, t5.FName_l2 position ");
        str.append(" from T_HR_SCostBearOrg t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" inner join T_ORG_Admin cost on t0.FCostBearOrgID = cost.fid ");
        str.append(" left join T_ORG_Admin cal on t0.FCalOrgUnitID = cal.fid ");
        str.append(" left join T_HR_SCmpEmpORelation t2 on t1.fid = t2.FPersonId and t0.FEffactDate >= t2.FEFFECTDATE and t0.FEffactDate <= t2.FLEFFECTDATE ");
        str.append(" left join T_HR_EmpOrgRelation t3 on t2.FEmpOrgRelationID = t3.fid and FAssignType = 1 and FIsInner = 1 ");
        str.append(" left join T_ORG_Admin t4 on t3.FAdminOrgID = t4.fid ");
        str.append(" left join T_ORG_Position t5 on t3.FPositionId = t5.fid ");
        str.append(" order by t4.FSortCode, t4.FNumber, t5.FIndex, t5.FNumber, t1.FIndex, t1.FNumber ");
        try {
            rowSet = DbUtil.executeQuery((Context)SHRContext.getInstance().getContext(), (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage());
        }
        exportDTO.setRowSet(rowSet);
        return exportDTO;
    }

    private Map<String, String> getNewStructureConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        IRowSet r1 = null;
        Context ctx = SHRContext.getInstance().getContext();
        StringBuilder str = new StringBuilder();
        str.append(" select tt.FName_l2 name, tt.FNumber number, FClientNumber clientNumber ");
        str.append(" from T_HR_StructureConfigColumns tt ");
        str.append(" inner join T_HR_StructureConfig t0 on tt.FStructureConfigID = t0.fid ");
        str.append(" where t0.FSchemeID = 'sUhctsjbR1SbwkNKWDQ1oJodxk8=' ");
        try {
            r1 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            while (r1.next()) {
                map.put(r1.getString("clientNumber").toLowerCase() + "_f" + r1.getString("number").toLowerCase(), r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase(), r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "1", r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "2", r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "3", r1.getString("name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, String> getOldStructureConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        IRowSet r1 = null;
        Context ctx = SHRContext.getInstance().getContext();
        StringBuilder str = new StringBuilder();
        str.append(" select tt.FName_l2 name, tt.FNumber number, FClientNumber clientNumber ");
        str.append(" from T_HR_SCColumns_002 tt ");
        str.append(" inner join T_HR_StructureConfig_002 t0 on tt.FStructureConfigID = t0.fid ");
        try {
            r1 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            while (r1.next()) {
                if ("positionPlanCount".equalsIgnoreCase(r1.getString("number"))) {
                    map.put(r1.getString("clientNumber").toLowerCase() + "_fposplancount", r1.getString("name"));
                    continue;
                }
                map.put(r1.getString("clientNumber").toLowerCase() + "_f" + r1.getString("number").toLowerCase(), r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase(), r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "1", r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "2", r1.getString("name"));
                map.put(r1.getString("clientNumber").toLowerCase() + "_cf" + r1.getString("number").toLowerCase() + "3", r1.getString("name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private List<Map<String, Object>> getUnvalidFormualData() throws BOSException {
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>();
        Map<String, String> oldMap = this.getOldStructureConfig();
        Map<String, String> newMap = this.getNewStructureConfig();
        StringBuilder str = new StringBuilder();
        str.append(" select t0.FName_l2 as name, t0.FNumber as number, tt.FName_l2 as formulaName, tt.FListItem itemStr ");
        str.append(" from T_HR_SCalFormula tt ");
        str.append(" inner join T_HR_SCalScheme t0 on tt.FCalSchemeID = t0.fid ");
        str.append(" order by t0.FNumber ");
        IRowSet r1 = DbUtil.executeQuery((Context)SHRContext.getInstance().getContext(), (String)str.toString());
        try {
            while (r1.next()) {
                if (null == r1.getString("itemStr")) continue;
                String[] itemArr = r1.getString("itemStr").split(";");
                int size = itemArr.length;
                for (int i = 0; i < size; ++i) {
                    String[] elementArr = itemArr[i].split("~");
                    if (elementArr.length < 4) continue;
                    String number = elementArr[2].toLowerCase();
                    String key = elementArr[3].toLowerCase() + "_" + (number.contains("_") ? number.subSequence(0, number.indexOf("_")) : number);
                    if (newMap.containsKey(key)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", r1.getString("name"));
                    map.put("number", r1.getString("number"));
                    map.put("formulaName", r1.getString("formulaName"));
                    if (oldMap.containsKey(key)) {
                        map.put("field", oldMap.get(key));
                    } else {
                        map.put("field", "");
                    }
                    dataMap.add(map);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    public ExportDTO getCalFormulaForExport() throws SHRWebException {
        ArrayList<Map<String, Object>> dataList = new ArrayList();
        String desc = "\u5347\u7ea7\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u85aa\u916c\u516c\u5f0f\u5217\u8868";
        ExportDTO exportDTO = new ExportDTO("\u85aa\u916c\u516c\u5f0f", "\u85aa\u916c\u516c\u5f0f", desc);
        ArrayList<ColumnDTO> list = new ArrayList<ColumnDTO>();
        list.add(new ColumnDTO("\u8ba1\u7b97\u89c4\u5219\u7f16\u7801", "number"));
        list.add(new ColumnDTO("\u8ba1\u7b97\u89c4\u5219\u540d\u79f0", "name"));
        list.add(new ColumnDTO("\u8ba1\u7b97\u516c\u5f0f\u540d\u79f0", "formulaName"));
        list.add(new ColumnDTO("\u516c\u5f0f\u4e2d\u9700\u8981\u8c03\u6574\u7684\u5b57\u6bb5", "field"));
        exportDTO.setColumnList(list);
        try {
            dataList = this.getUnvalidFormualData();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        exportDTO.setDataList(dataList);
        return exportDTO;
    }
}

