/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.emp.util;

import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import org.apache.commons.beanutils.BeanUtils;

public class IRowSetUtil<T> {
    public static final String PREFIX_F = "F";

    public List<Map<String, Object>> resultSetToListMap(IRowSet rowSet) throws SQLException {
        IRowSet rs = rowSet.createCopy();
        ResultSetMetaData rsmd = rs.getMetaData();
        int fieldCount = rsmd.getColumnCount();
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> valueMap = null;
        while (rs.next()) {
            valueMap = new HashMap<String, Object>();
            for (int i = 1; i <= fieldCount; ++i) {
                String fieldName = rsmd.getColumnName(i);
                if (rs.wasNull()) {
                    valueMap.put(fieldName, null);
                    continue;
                }
                valueMap.put(fieldName, rs.getObject(fieldName));
            }
            records.add(valueMap);
        }
        return records;
    }

    public List<T> resultSetToObjectList(ResultSet rs, Class outputClass) {
        ArrayList outputList;
        block11: {
            outputList = null;
            try {
                if (rs != null) {
                    if (outputClass.isAnnotationPresent(Entity.class)) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        Field[] fields = this.getFields(outputClass);
                        while (rs.next()) {
                            Object bean = outputClass.newInstance();
                            block6: for (int _iterator = 0; _iterator < rsmd.getColumnCount(); ++_iterator) {
                                String columnName = rsmd.getColumnName(_iterator + 1);
                                String columnClassName = rsmd.getColumnClassName(_iterator + 1);
                                String columnTypeName = rsmd.getColumnTypeName(_iterator + 1);
                                int columnType = rsmd.getColumnType(_iterator + 1);
                                Object columnValue = rs.getObject(_iterator + 1);
                                for (Field field : fields) {
                                    if (!(PREFIX_F + field.getName()).equalsIgnoreCase(columnName) && !field.getName().equalsIgnoreCase(columnName) || columnValue == null) continue;
                                    this.copyPropertiesToBean(bean, field.getName(), columnTypeName, rs, _iterator + 1);
                                    continue block6;
                                }
                            }
                            if (outputList == null) {
                                outputList = new ArrayList();
                            }
                            outputList.add(bean);
                        }
                    }
                    break block11;
                }
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return outputList;
    }

    private void copyPropertiesToBean(T bean, String fieldName, String columnTypeName, ResultSet rs, int index) throws IllegalAccessException, InvocationTargetException, SQLException {
        if (columnTypeName.equalsIgnoreCase("VARCHAR2") || columnTypeName.equalsIgnoreCase("varchar") || columnTypeName.equalsIgnoreCase("nvarchar") || columnTypeName.equalsIgnoreCase("NUMERIC") || columnTypeName.equalsIgnoreCase("decimal") || columnTypeName.equalsIgnoreCase("DOUBLE") || columnTypeName.equalsIgnoreCase("Float") || columnTypeName.equalsIgnoreCase("INT") || columnTypeName.equalsIgnoreCase("NUMBER")) {
            String columnValue = rs.getString(index);
            BeanUtils.setProperty(bean, (String)fieldName, (Object)columnValue);
        } else if (columnTypeName.equalsIgnoreCase("TIMESTAMP")) {
            Timestamp s = rs.getTimestamp(index);
            Date date = new Date(s.getTime());
            BeanUtils.setProperty(bean, (String)fieldName, (Object)date);
        } else if (columnTypeName.equalsIgnoreCase("datetime")) {
            Timestamp s = rs.getTimestamp(index);
            Date date = new Date(s.getTime());
            BeanUtils.setProperty(bean, (String)fieldName, (Object)date);
        }
    }

    private Field[] getFields(Class<?> clazz) {
        Field[] fields = null;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null && !clazz.getName().toLowerCase().equals("java.lang.object")) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        fields = new Field[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            fields[i] = (Field)fieldList.get(i);
        }
        return fields;
    }
}

