/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.EconomicTypeEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitLayer;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgUnitLayerCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.client.uihelper.UIHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.IsMoveEnum;
import com.kingdee.eas.hr.org.OrgStateTypeEnum;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.client.AbstractAdminOrgUnitVerEidtUI;
import com.kingdee.eas.hr.org.client.OrgUnitListUI;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class AdminOrgUnitVerEidtUI
extends AbstractAdminOrgUnitVerEidtUI {
    private static final long serialVersionUID = 6205123112937988293L;
    private static final Logger logger = CoreUIObject.getLogger(AdminOrgUnitVerEidtUI.class);
    private AdminOrgUnitVerInfo editAdminOrg = null;
    private List newValList = new ArrayList();
    public boolean isCanceled = true;
    private String importOrgId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
    }

    private void initF7() throws EASBizException, BOSException {
        String adminId = (String)this.getUIContext().get("ID");
        this.prmptReplaceOrg.setEnabled(false);
        this.editAdminOrg = (AdminOrgUnitVerInfo)this.getUIContext().get("Current_SelectNode");
        if ("ADDNEW".equals(this.getOprtState()) && !StringUtil.isEmpty((String)adminId)) {
            StringBuffer oql = new StringBuffer();
            oql.append("select id,name,sortCode,longNumber,parent.id,parent.name,parent.sortCode,parent.longNumber where id='").append(adminId).append("' and orgAdjSchm='").append(this.editAdminOrg.getOrgAdjSchm().getId().toString()).append("'");
            AdminOrgUnitVerInfo adminInfo = AdminOrgUnitVerFactory.getRemoteInstance().getAdminOrgUnitVerInfo(oql.toString());
            if ("ADDNEW".equals(this.getOprtState())) {
                this.prmtParent.setData((Object)adminInfo);
            } else {
                this.prmtParent.setData((Object)adminInfo.getParent());
            }
            this.cboOrgUnitType.setSelectedIndex(-1);
            this.prmptReplaceOrg.setEditable(false);
            this.btnImport.setVisible(true);
        } else {
            this.btnImport.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.prmtParent.setEnabled(false);
        this.cboOrgUnitType.removeAllItems();
        try {
            IOrgUnitLayerType iLayerType = OrgUnitLayerTypeFactory.getRemoteInstance();
            OrgUnitLayerTypeCollection col = iLayerType.getOrgUnitLayerTypeCollection();
            UIHelper.initComboBoxModel((KDComboBox)this.cboOrgUnitType, (Iterator)col.iterator());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.adminRegisteredCapital.setMaximumNumber((Number)new BigDecimal("999999999999"));
        this.adminRegisteredCapital.setMinimumNumber((Number)new BigDecimal("0"));
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Admin_AddNew"));
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Admin_Edit"));
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Admin_View"));
        }
        UIHelper.initComboBoxModel((KDComboBox)this.adminEconomicType, (Iterator)EconomicTypeEnum.iterator());
        this.adminEconomicType.setEditable(false);
        if (this.getOprtState() == OprtState.VIEW) {
            this.prmtParent.setEnabled(false);
            this.prmptReplaceOrg.setEnabled(false);
            this.bizPromptAdminAddress.setEnabled(false);
            this.bizPromptIndustry.setEnabled(false);
            this.adminJuridicalPerson.setEnabled(false);
        } else {
            HROrgAdjSchmInfo adjSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)adjSchm.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            this.adminJuridicalPerson.setEntityViewInfo(viewInfo);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.isIsIndependence() && this.getOprtState() == OprtState.VIEW && this.editData.getJuridicalPerson() == null) {
            try {
                HROrgAdjSchmInfo adjSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
                AdminOrgUnitVerInfo orgInfo = (AdminOrgUnitVerInfo)this.getUIContext().get("Current_SelectNode");
                PersonVerInfo person = AdminOrgUnitVerFactory.getRemoteInstance().getAdminJuridicalPerson(adjSchm, orgInfo.getId().toString());
                this.adminJuridicalPerson.setData((Object)person);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            boolean isChurchyard = this.editData.isIsChurchyard();
            this.radioAdminCountry.setSelected(isChurchyard);
            this.radioAdminForeign.setSelected(!isChurchyard);
            try {
                this.loadLayer();
                this.cboOrgUnitLayer.setSelectedItem((Object)this.editData.getUnitLayer());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.setEspecialFieldEnable();
    }

    protected void setEspecialFieldEnable() {
        if (!this.chkIsIndependence.isSelected()) {
            this.adminEconomicType.setEnabled(false);
            this.bizPromptIndustry.setEnabled(false);
            this.adminRegisteredCapital.setEnabled(false);
            this.adminTxtRegisteredCode.setEnabled(false);
            this.adminSetupDate.setEnabled(false);
            this.adminEndupDate.setEnabled(false);
            this.adminTaxNumber.setEnabled(false);
            this.kDTextOrgCode.setEnabled(false);
        }
        if (!this.chkIsJuridicalCom.isSelected()) {
            this.adminJuridicalPerson.setEnabled(false);
            this.adminJuridicalPerson.setEditable(false);
        }
    }

    protected IObjectValue createNewData() {
        AdminOrgUnitVerInfo verInfo = new AdminOrgUnitVerInfo();
        AdminOrgUnitVerInfo parent = (AdminOrgUnitVerInfo)this.getUIContext().get("Current_SelectNode");
        verInfo.setCU(parent.getCU());
        verInfo.setOrgAdjSchm((HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm"));
        verInfo.setIsIndependence(false);
        return verInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AdminOrgUnitVerFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            AdminOrgUnitVerInfo saveSuccessObj = this.editData;
            super.actionSubmit_actionPerformed(e);
            if ("ADDNEW".equals(this.getOprtState())) {
                AdminOrgUnitVerInfo adminOrgVerInfo = saveSuccessObj;
                adminOrgVerInfo.setId(BOSUuid.read((String)this.idList.getCurrentID()));
                String longNumber = adminOrgVerInfo.getParent().getLongNumber() + "!" + adminOrgVerInfo.getNumber();
                adminOrgVerInfo.setLongNumber(longNumber);
                adminOrgVerInfo.setIsSealUp(false);
                adminOrgVerInfo.setOrgStateType(OrgStateTypeEnum.Wait_Enable);
                this.editAdminOrg = adminOrgVerInfo;
                this.prmtParent.setData((Object)adminOrgVerInfo.getParent());
                this.newValList.add(this.editAdminOrg);
                this.importOrgId = null;
            } else if ("EDIT".equals(this.getOprtState())) {
                this.editAdminOrg = saveSuccessObj;
            }
            this.isCanceled = false;
        }
        catch (Exception ex) {
            this.editAdminOrg = null;
            this.isCanceled = true;
            throw ex;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        MultiLangItem name = OrgUtils.getDefaultLangItemData(this.txtName);
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.cboOrgUnitType.getSelectedItem() == null) {
            this.cboOrgUnitType.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.ADMIN_UNITLAYERTYPE_NOT_NULL);
        }
        this.checkTelNum(this.txtFax.getText(), this.kDLabelContainer6.getBoundLabelText(), this.txtFax);
        this.checkTelNum(this.txtAdminPhone.getText(), this.kDLabelContainer7.getBoundLabelText(), this.txtAdminPhone);
        this.checkTelNum(this.txtZipCode.getText(), this.kDLabelContainer4.getBoundLabelText(), this.txtZipCode);
        if (this.chkIsJuridicalCom.isSelected() && this.adminJuridicalPerson.getData() == null) {
            throw new OrgBlankException(OrgBlankException.ADMIN_JURIDICALCOM_NOT_NULL);
        }
        int orgState = this.editData.getOrgStateType().getValue();
        if (orgState != 3 && orgState != 1) {
            this.editData.setOrgStateType(OrgStateTypeEnum.Wait_Enable);
            if (this.getOprtState().equals(OprtState.ADDNEW) && !StringUtils.isEmpty((String)this.importOrgId)) {
                AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)this.importOrgId));
                this.editData.setAdminOrgUnit(adminOrg);
            }
        }
    }

    private void checkTelNum(String telNum, String tip, KDTextField txtField) throws Exception {
        if (!Pattern.matches("[0-9\\-]*", telNum)) {
            txtField.requestFocusInWindow();
            throw new OUException(OUException.TELNUM_MUST_BE_THESE, (Object[])new String[]{tip});
        }
    }

    public AdminOrgUnitVerInfo getEditAdminOrg() {
        if (this.isCanceled) {
            return null;
        }
        return this.editAdminOrg;
    }

    public List getnewValList() {
        return this.newValList;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        HROrgAdjSchmInfo curSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
        if (IsMoveEnum.IS_MOVED.equals((Object)curSchm.getIsMoved())) {
            return HROrgVersionFacadeFactory.getRemoteInstance().getAdminOrgVerInfo(pk);
        }
        return super.getValue(pk);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isSealUp"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("unitLayerType.name"));
        sic.add(new SelectorItemInfo("unitLayer.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("orgStateType"));
        sic.add(new SelectorItemInfo("orgAdjSchm.id"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("juridicalPerson.name"));
        return sic;
    }

    @Override
    public void actionImportOrg_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Current_OrgAdjSchm", this.getUIContext().get("Current_OrgAdjSchm"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.OrgUnitListUI", (Map)uiContext);
        uiWindow.show();
        OrgUnitListUI listUI = (OrgUnitListUI)uiWindow.getUIObject();
        String selectOrgId = listUI.getCurOrgId();
        if (!StringUtils.isEmpty((String)selectOrgId)) {
            this.fillImportValue(selectOrgId);
        }
    }

    private void fillImportValue(String selectOrgId) throws EASBizException, BOSException {
        FullOrgUnitInfo info = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(selectOrgId));
        com.kingdee.bos.ui.util.UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)info, (String)"name");
        this.txtNumber.setText(info.getNumber());
        this.txtSimpleName.setText(info.getSimpleName());
        com.kingdee.bos.ui.util.UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtDescription, (IObjectValue)info, (String)"description");
        this.importOrgId = info.getId().toString();
    }

    public boolean isModify() {
        LanguageInfo lang = new LanguageInfo(SysContext.getSysContext().getLocale());
        String number = this.txtNumber.getText();
        String name = (String)this.txtName.getItemBy(lang).getData();
        if ("ADDNEW" == this.getOprtState() && StringUtils.isEmpty((String)number) && StringUtils.isEmpty((String)name) && this.cboOrgUnitType.getSelectedItem() == null) {
            return false;
        }
        return super.isModify();
    }

    @Override
    protected void cboOrgUnitType_itemStateChanged(ItemEvent e) throws Exception {
        super.cboOrgUnitType_itemStateChanged(e);
        this.loadLayer();
    }

    private void loadLayer() throws EASBizException, BOSException {
        OrgUnitLayerCollection col;
        this.cboOrgUnitLayer.removeAllItems();
        DefaultComboBoxModel<OrgUnitLayerInfo> model = new DefaultComboBoxModel<OrgUnitLayerInfo>();
        OrgUnitLayerTypeInfo typeInfo = (OrgUnitLayerTypeInfo)this.cboOrgUnitType.getSelectedItem();
        if (typeInfo != null && (col = this.getLayerCollection(typeInfo)) != null) {
            for (int i = 0; i < col.size(); ++i) {
                model.addElement(col.get(i));
            }
        }
        this.cboOrgUnitLayer.setModel(model);
    }

    private OrgUnitLayerCollection getLayerCollection(OrgUnitLayerTypeInfo typeInfo) throws BOSException, EASBizException {
        if (typeInfo != null) {
            IOrgUnitLayer iLayer = OrgUnitLayerFactory.getRemoteInstance();
            return iLayer.getOrgUnitLayerCollection("Select * Where layerType.id = '" + typeInfo.getId() + "'");
        }
        return null;
    }

    @Override
    protected void chkIsIndependence_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsIndependence.isSelected()) {
            this.adminEconomicType.setEnabled(true);
            this.bizPromptIndustry.setEnabled(true);
            this.adminRegisteredCapital.setEnabled(true);
            this.adminTxtRegisteredCode.setEnabled(true);
            this.adminSetupDate.setEnabled(true);
            this.adminEndupDate.setEnabled(true);
            this.adminTaxNumber.setEnabled(true);
            this.kDTextOrgCode.setEnabled(true);
        } else {
            this.adminEconomicType.setSelectedItem(null);
            this.bizPromptIndustry.setData(null);
            this.adminRegisteredCapital.setValue(null);
            this.adminTxtRegisteredCode.setText(null);
            this.adminSetupDate.setValue(null);
            this.adminEndupDate.setValue(null);
            this.adminSealUpDate.setValue(null);
            this.kDTextOrgCode.setText("");
            this.adminEconomicType.setEnabled(false);
            this.bizPromptIndustry.setEnabled(false);
            this.adminRegisteredCapital.setEnabled(false);
            this.adminTxtRegisteredCode.setEnabled(false);
            this.adminSetupDate.setEnabled(false);
            this.adminEndupDate.setEnabled(false);
            this.adminTaxNumber.setEnabled(false);
            this.kDTextOrgCode.setEnabled(false);
        }
    }

    @Override
    protected void chkIsJuridicalCom_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsJuridicalCom.isSelected()) {
            this.chkIsIndependence.setSelected(true);
            this.adminJuridicalPerson.setEnabled(true);
            this.adminJuridicalPerson.setEditable(true);
        } else {
            this.adminJuridicalPerson.setEditable(false);
            this.adminJuridicalPerson.setEnabled(false);
        }
    }
}

