/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.org.PositionBaseFacadeFactory;
import com.kingdee.eas.hr.org.client.AbstractBatchAddPostionByJobUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BatchAddPostionByJobUI
extends AbstractBatchAddPostionByJobUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddPostionByJobUI.class);
    private String sourceUIName = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.sourceUIName = (String)this.getUIContext().get("SourceUI");
        super.onLoad();
        this.tblJobTable.checkParsed();
        this.tblOrgTable.checkParsed();
        this.tblOrgTable.setEditable(false);
        this.tblJobTable.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblJobTable.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblJobTable.getColumn("isRespPosition").getStyleAttributes().setLocked(false);
        this.chkJobName.setSelected(true);
        this.kDContainer2.addButton((JButton)this.btnAddJob);
        this.kDContainer2.addButton((JButton)this.btnDelJob);
        this.kDContainer3.addButton((JButton)this.btnAddOrg);
        this.kDContainer3.addButton((JButton)this.btnDelOrg);
        if ("HRPositionMainListUI".equalsIgnoreCase(this.sourceUIName)) {
            this.kDSplitPane2.add((Component)this.kDContainer2, (Object)"top");
            this.kDSplitPane2.add((Component)this.kDContainer3, (Object)"bottom");
        }
        this.initJobTable();
        this.initOrgTable();
    }

    @Override
    public void actionAddJob_actionPerformed(ActionEvent e) throws Exception {
        Object[] obj;
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        JobPromptBox prmt = new JobPromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
        set.add(SysContext.getSysContext().getCurrentCtrlUnit());
        prmt.changeContextByCUSet(set);
        prmt.setIsSingleSelect(false);
        prmt.show();
        if (!prmt.isCanceled() && prmt.getData() instanceof Object[] && (obj = (Object[])prmt.getData()) != null && obj.length > 0) {
            ICell iCell = null;
            HashSet<String> tableJobSet = new HashSet<String>();
            for (int k = 0; k < this.tblJobTable.getRowCount(); ++k) {
                iCell = this.tblJobTable.getRow(k).getCell("id");
                if (iCell.getValue() == null) continue;
                tableJobSet.add(iCell.getValue().toString());
            }
            IRow row = null;
            JobInfo jobInfo = null;
            for (int i = 0; i < obj.length; ++i) {
                jobInfo = (JobInfo)obj[i];
                if (tableJobSet.contains(jobInfo.getId().toString())) continue;
                row = this.tblJobTable.addRow();
                row.getCell("id").setValue((Object)jobInfo.getId().toString());
                row.getCell("number").setValue((Object)jobInfo.getNumber());
                row.getCell("name").setValue((Object)jobInfo.getName());
                row.getCell("isRespPosition").setValue((Object)false);
            }
        }
    }

    @Override
    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        NewAdminF7 prmt = new NewAdminF7();
        prmt.setIsCUFilter(true);
        prmt.setMultiSelect(true);
        prmt.show();
        if (!prmt.isCanceled()) {
            OrgUnitInfo[] obj;
            Object object = prmt.getData();
            if (prmt.getData() instanceof OrgUnitInfo[] && (obj = (OrgUnitInfo[])object) != null && obj.length > 0) {
                ICell iCell = null;
                HashSet<String> tableAdminSet = new HashSet<String>();
                for (int k = 0; k < this.tblOrgTable.getRowCount(); ++k) {
                    iCell = this.tblOrgTable.getRow(k).getCell("id");
                    if (iCell.getValue() == null) continue;
                    tableAdminSet.add(iCell.getValue().toString());
                }
                IRow row = null;
                OrgUnitInfo adminInfo = null;
                for (int i = 0; i < obj.length; ++i) {
                    adminInfo = obj[i];
                    if (tableAdminSet.contains(adminInfo.getId().toString())) continue;
                    row = this.tblOrgTable.addRow();
                    row.getCell("id").setValue((Object)adminInfo.getId().toString());
                    row.getCell("number").setValue((Object)adminInfo.getNumber());
                    row.getCell("name").setValue((Object)adminInfo.getName());
                    row.getCell("displayName").setValue((Object)adminInfo.getDisplayName());
                    row.getCell("longNumber").setValue((Object)adminInfo.getLongNumber());
                }
            }
        }
    }

    @Override
    public void actionDelJob_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblJobTable);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblJobTable);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.tblJobTable.removeRow(selectRows[i]);
        }
        if (this.tblJobTable.getRowCount() == 0) {
            this.btnOk.setEnabled(true);
        }
    }

    @Override
    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblOrgTable);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblOrgTable);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.tblOrgTable.removeRow(selectRows[i]);
        }
        if (this.tblOrgTable.getRowCount() == 0) {
            this.btnOk.setEnabled(true);
        }
    }

    @Override
    public void actionCreatePosition_actionPerformed(ActionEvent e) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        JobCollection jobColl = new JobCollection();
        JobInfo primaryJob = null;
        JobInfo jobInfo = null;
        AdminOrgUnitInfo adminInfo = null;
        IRow row = null;
        for (int i = 0; i < this.tblJobTable.getRowCount(); ++i) {
            row = this.tblJobTable.getRow(i);
            jobInfo = new JobInfo();
            jobInfo.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            jobInfo.setName(row.getCell("name").getValue().toString());
            jobInfo.setNumber(row.getCell("number").getValue().toString());
            if (((Boolean)row.getCell("isRespPosition").getValue()).booleanValue()) {
                primaryJob = jobInfo;
                continue;
            }
            jobColl.add(jobInfo);
        }
        ArrayList<AdminOrgUnitInfo> adminList = new ArrayList<AdminOrgUnitInfo>();
        HashSet<String> adminIDSet = new HashSet<String>();
        String id = null;
        for (int i = 0; i < this.tblOrgTable.getRowCount(); ++i) {
            row = this.tblOrgTable.getRow(i);
            adminInfo = new AdminOrgUnitInfo();
            id = (String)row.getCell("id").getValue();
            adminInfo.setId(BOSUuid.read((String)id));
            adminInfo.setName(row.getCell("name").getValue().toString());
            adminInfo.setNumber(row.getCell("number").getValue().toString());
            adminInfo.setLongNumber(row.getCell("longNumber").getValue().toString());
            adminList.add(adminInfo);
            adminIDSet.add(id);
        }
        if (primaryJob == null) {
            this.checkExistRespPosition(adminIDSet);
        }
        Collections.sort(adminList, new Comparator<AdminOrgUnitInfo>(){

            @Override
            public int compare(AdminOrgUnitInfo o1, AdminOrgUnitInfo o2) {
                return o1.getLongNumber().length() - o2.getLongNumber().length();
            }
        });
        int createPosNameType = 0;
        if (this.chkAdminAndJob.isSelected()) {
            createPosNameType = 1;
        }
        PositionBaseFacadeFactory.getRemoteInstance().batchAddPosition(jobColl, adminList, primaryJob, createPosNameType);
        MsgBox.showInfo((String)com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label37", (Locale)ctx.getLocale()));
        this.btnOk.setEnabled(false);
    }

    private void checkExistRespPosition(Set<String> adminIDSet) throws BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", adminIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("responPosition", null));
        boolean exists = AdminOrgUnitFactory.getRemoteInstance().exists(filter);
        if (exists) {
            MsgBox.showWarning((String)com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label38", (Locale)ctx.getLocale()));
            SysUtil.abort();
        }
    }

    @Override
    protected void tblJobTable_editValueChanged(KDTEditEvent e) throws Exception {
        Object obj = e.getValue();
        int rowIndex = e.getRowIndex();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            for (int i = 0; i < this.tblJobTable.getRowCount(); ++i) {
                if (rowIndex == i) continue;
                this.tblJobTable.getRow(i).getCell("isRespPosition").setValue((Object)false);
            }
        }
    }

    private void initJobTable() {
        if (!this.getUIContext().containsKey("JobInfoList")) {
            return;
        }
        ArrayList jobInfoList = (ArrayList)this.getUIContext().get("JobInfoList");
        JobInfo jobInfo = null;
        IRow row = null;
        for (int i = 0; i < jobInfoList.size(); ++i) {
            jobInfo = (JobInfo)jobInfoList.get(i);
            row = this.tblJobTable.addRow();
            row.getCell("id").setValue((Object)jobInfo.getId().toString());
            row.getCell("number").setValue((Object)jobInfo.getNumber());
            row.getCell("name").setValue((Object)jobInfo.getName());
            row.getCell("isRespPosition").setValue((Object)false);
        }
    }

    private void initOrgTable() {
        if (!this.getUIContext().containsKey("AdminInfoList")) {
            return;
        }
        ArrayList adminInfoList = (ArrayList)this.getUIContext().get("AdminInfoList");
        AdminOrgUnitInfo adminInfo = null;
        IRow row = null;
        for (int i = 0; i < adminInfoList.size(); ++i) {
            adminInfo = (AdminOrgUnitInfo)adminInfoList.get(i);
            row = this.tblOrgTable.addRow();
            row.getCell("id").setValue((Object)adminInfo.getId().toString());
            row.getCell("number").setValue((Object)adminInfo.getNumber());
            row.getCell("name").setValue((Object)adminInfo.getName());
            row.getCell("displayName").setValue((Object)adminInfo.getDisplayName());
            row.getCell("longNumber").setValue((Object)adminInfo.getLongNumber());
        }
    }

    public void checkSelected(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

