/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.org.client.AbstractHRJobViewUI;
import com.kingdee.eas.hr.org.client.HRJobEditUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HRJobViewUI
extends AbstractHRJobViewUI {
    private static final Logger logger = CoreUIObject.getLogger(HRJobViewUI.class);
    private Map<String, JobInfo> jobMap;
    private JobInfo jobInfo;
    private String oldJobId = null;
    private CoreUIObject subui = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setEditable(false);
        this.btnSave.setEnabled(false);
        Set jobIdSet = (Set)this.getUIContext().get("JOBIDSET");
        try {
            JobCollection jobColl = JobFactory.getRemoteInstance().getJobCollection(this.getEntityViewInfo(jobIdSet));
            this.jobMap = new HashMap<String, JobInfo>();
            for (int i = 0; i < jobColl.size(); ++i) {
                this.jobMap.put(jobColl.get(i).getId().toString(), jobColl.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.loadMainTable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectRows[0]);
        String jobId = row.getCell("id").getValue().toString();
        this.jobInfo = this.jobMap.get(jobId);
        if (this.subui == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)jobId);
            uiContext.put((Object)"IDList", (Object)RealModeIDList.getEmptyIDList());
            this.subui = (CoreUIObject)UIFactoryHelper.initUIObject((String)HRJobEditUI.class.getName(), (Map)uiContext, null, (String)OprtState.VIEW);
            this.paneRight.getViewport().add((Component)this.subui);
        } else {
            ((HRJobEditUI)this.subui).reload(this.jobInfo, this.oldJobId);
        }
        this.oldJobId = jobId;
    }

    private EntityViewInfo getEntityViewInfo(Set<String> jobIdSet) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", jobIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("jobFamily.id"));
        evi.getSelector().add(new SelectorItemInfo("jobFamily.name"));
        evi.getSelector().add(new SelectorItemInfo("jobCategory.id"));
        evi.getSelector().add(new SelectorItemInfo("jobCategory.name"));
        evi.getSelector().add(new SelectorItemInfo("jobSubCategory.name"));
        evi.getSelector().add(new SelectorItemInfo("jobSubCategory.id"));
        evi.getSelector().add(new SelectorItemInfo("jobGrade.id"));
        evi.getSelector().add(new SelectorItemInfo("jobGrade.name"));
        return evi;
    }

    private void loadMainTable() {
        if (this.jobMap == null || this.jobMap.isEmpty()) {
            return;
        }
        JobInfo jobInfo = null;
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getSelectManager().setSelectMode(2);
        IRow row = null;
        Iterator<String> iter = this.jobMap.keySet().iterator();
        String jobID = null;
        while (iter.hasNext()) {
            jobID = iter.next();
            jobInfo = this.jobMap.get(jobID);
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)jobInfo.getId().toString());
            row.getCell("number").setValue((Object)jobInfo.getNumber());
            row.getCell("name").setValue((Object)jobInfo.getName());
        }
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.oldJobId = null;
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.subui != null) {
            ((HRJobEditUI)this.subui).actionEdit_actionPerformed(e);
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.subui != null) {
            ((HRJobEditUI)this.subui).actionSave_actionPerformed(e);
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.jobInfo = ((HRJobEditUI)this.subui).editData;
            this.jobMap.put(this.jobInfo.getId().toString(), this.jobInfo);
        }
    }

    public boolean destroyWindow() {
        if (this.subui != null) {
            ((HRJobEditUI)this.subui).destroyWindow();
        }
        return super.destroyWindow();
    }
}

