/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.GetDataDialog;
import com.kingdee.eas.hr.base.client.GetDataTaskAdapter;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.OrgVerEffectInfo;
import com.kingdee.eas.hr.org.OrgVersionEnableFacadeFactory;
import com.kingdee.eas.hr.org.client.AbstractHROrgAdjSchmListUI;
import com.kingdee.eas.hr.org.client.OrgAdjSchmSaveUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HROrgAdjSchmListUI
extends AbstractHROrgAdjSchmListUI {
    private static final Logger logger = CoreUIObject.getLogger(HROrgAdjSchmListUI.class);
    private HROrgAdjSchmInfo curOrgAdjSchm = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSwitchOrgAdjSchm.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setAutoSort();
    }

    private void setAutoSort() {
        KDTSortManager sortManager = new KDTSortManager(this.tblMain);
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sortManager.setSortAuto(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return HROrgAdjSchmFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    if (HROrgAdjSchmListUI.this.tblMain.getRowCount() > 0) {
                        int indexRow = e.getSelectBlock().getTop();
                        HROrgAdjSchmListUI.this.doButtonState(indexRow);
                    }
                }
                catch (Exception exc) {
                    HROrgAdjSchmListUI.this.handUIException(exc);
                }
            }
        });
    }

    private void doButtonState(int indexRow) {
        block5: {
            BizEnumValueInfo enable = (BizEnumValueInfo)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"enableStatus");
            if (enable != null && enable.getInt() != 1) {
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                try {
                    boolean permission = HROrgVersionFacadeFactory.getRemoteInstance().checkUserAdjSchmPermission(userInfo, this.getSelectedAdjSchemInfo().getId().toString());
                    if (!permission) {
                        this.btnEnable.setEnabled(false);
                        this.btnRemove.setEnabled(false);
                        this.btnEdit.setEnabled(false);
                        break block5;
                    }
                    this.btnEnable.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                    this.btnEdit.setEnabled(true);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnEnable.setEnabled(false);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSave", (Object)"1", CompareType.EQUALS));
        return filterInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionSwitchOrgAdjSchm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.curOrgAdjSchm = this.getSelectedAdjSchemInfo();
        this.getUIWindow().close();
    }

    private HROrgAdjSchmInfo getSelectedAdjSchemInfo() {
        HROrgAdjSchmInfo hrOrgAdjSchmInfo = new HROrgAdjSchmInfo();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        String id = (String)row.getCell("id").getValue();
        hrOrgAdjSchmInfo.setId(BOSUuid.read((String)id));
        hrOrgAdjSchmInfo.setName((String)row.getCell("name").getValue());
        String enableStatus = (String)((BizEnumValueDTO)row.getCell("enableStatus").getValue()).getValue();
        hrOrgAdjSchmInfo.setEnableStatus(EnableStateEnum.getEnum(String.valueOf(enableStatus)));
        return hrOrgAdjSchmInfo;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        String name = "";
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"currentAdjSchmName", (Object)((String)row.getCell("name").getValue()));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(OrgAdjSchmSaveUI.class.getName(), (Map)uiContext);
        curDialog.show();
        if (((OrgAdjSchmSaveUI)curDialog.getUIObject()).isCanceled()) {
            return;
        }
        name = ((OrgAdjSchmSaveUI)curDialog.getUIObject()).getName();
        String id = (String)row.getCell("id").getValue();
        HROrgAdjSchmInfo curOrgAdjSchm = new HROrgAdjSchmInfo();
        curOrgAdjSchm.setId(BOSUuid.read((String)id));
        curOrgAdjSchm.setName(name);
        curOrgAdjSchm.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        HROrgAdjSchmFactory.getRemoteInstance().save((CoreBaseInfo)curOrgAdjSchm);
        this.actionRefresh_actionPerformed(null);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        HROrgAdjSchmInfo curentEditSchm = (HROrgAdjSchmInfo)this.getUIContext().get("curOrgAdjSchm");
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        String selectId = (String)row.getCell("id").getValue();
        if (selectId.equals(curentEditSchm.getId().toString())) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.DELETE_ADJSCHM_ERROR);
        }
        UserInfo user = HROrgVersionFacadeFactory.getRemoteInstance().getOrgAdjSchmDataLockStatus(selectId);
        if (user != null) {
            Object[] param = new String[]{user.getName()};
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORGADJSCHM_DATA_LOCK, param);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String confirmInfo = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Enable_CurrentOrgAdjSchmComfirm");
        if (MsgBox.showConfirm2((String)confirmInfo) == 0) {
            GetDataDialog dlg = null;
            dlg = SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof Dialog ? new GetDataDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this))) : new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            dlg.setGetDataTask(new GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    HROrgAdjSchmListUI.this.excuteEnable();
                    return null;
                }
            });
            dlg.show();
            this.refreshList();
        }
    }

    public void excuteEnable() throws EASBizException, BOSException {
        OrgVerEffectInfo resulInfo = new OrgVerEffectInfo();
        HROrgAdjSchmInfo hrOrgAdjSchmInfo = this.getSelectedAdjSchemInfo();
        resulInfo.setAdjSchmInfo(hrOrgAdjSchmInfo);
        resulInfo = OrgVersionEnableFacadeFactory.getRemoteInstance().enableBeforCheck(resulInfo);
        if (resulInfo.isError()) {
            this.showDetailErrorMsg(resulInfo);
        }
        HROrgVersionFacadeFactory.getRemoteInstance().enableOrgAdjSchm(hrOrgAdjSchmInfo);
        if (resulInfo.isWarning()) {
            this.showDetailWarningMsg(resulInfo);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"70_HROrgAdjSchmListUI"));
        }
        try {
            this.actionRefresh_actionPerformed(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void showDetailErrorMsg(OrgVerEffectInfo resulInfo) {
        if (resulInfo.isError()) {
            StringBuffer InfoStr = new StringBuffer();
            InfoStr.append(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"71_HROrgAdjSchmListUI")).append(resulInfo.getErrorMsg());
            if (!StringUtils.isEmpty((String)resulInfo.getWarningMsg())) {
                InfoStr.append(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"72_HROrgAdjSchmListUI"));
                InfoStr.append(resulInfo.getWarningMsg());
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"71_HROrgAdjSchmListUI"), (String)InfoStr.toString(), (int)0);
            this.setCursorOfDefault();
            SysUtil.abort();
        }
    }

    private void showDetailWarningMsg(OrgVerEffectInfo resulInfo) {
        if (resulInfo.isWarning()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"73_HROrgAdjSchmListUI"), (String)resulInfo.getWarningMsg(), (int)2);
        }
    }

    public void setOrgVerAdjSchm(HROrgAdjSchmInfo curOrgAdjSchm) {
        this.curOrgAdjSchm = curOrgAdjSchm;
    }

    public HROrgAdjSchmInfo getOrgVerAdjSchm() {
        return this.curOrgAdjSchm;
    }
}

