/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanSchemeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;

public class PersonPlanSchemeEditUI
extends AbstractPersonPlanSchemeEditUI {
    String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";

    @Override
    public void loadFields() {
        super.loadFields();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.loadOldData();
        } else {
            this.actionRemove.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            if (this.editData.getStatus() != SchemeStatus.SAVE) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionCopy.setVisible(false);
            }
        } else {
            this.actionCopy.setVisible(true);
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setStartYear((Integer)this.txtStartYear.getSelectedItem());
        this.editData.setEndYear((Integer)this.txtEndYear.getSelectedItem());
        this.editData.setStartMonth(this.txtStartMonth.getSelectedIndex());
        this.editData.setEndMonth(this.txtEndMonth.getSelectedIndex());
    }

    protected IObjectValue createNewData() {
        PersonPlanSchemeInfo ppsInfo = new PersonPlanSchemeInfo();
        ppsInfo.setStatus(SchemeStatus.SAVE);
        ppsInfo.setPlanType((PersonPlanType)((Object)this.comboPlanType.getSelectedItem()));
        ppsInfo.setPeriod((Period)((Object)this.comboPeriod.getSelectedItem()));
        ppsInfo.setStartYear((Integer)this.txtStartYear.getSelectedItem());
        ppsInfo.setEndYear((Integer)this.txtEndYear.getSelectedItem());
        ppsInfo.setStartMonth(this.txtStartMonth.getSelectedIndex());
        ppsInfo.setEndMonth(this.txtEndMonth.getSelectedIndex());
        return ppsInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonPlanSchemeFactory.getRemoteInstance();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        if (OprtState.VIEW.equals(this.getOprtState()) && this.editData.getStatus() != SchemeStatus.SAVE) {
            this.btnEdit.setEnabled(false);
        }
        this.menuBar.remove((Component)this.menuBiz);
        this.btnEdit.setEnabled(false);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        for (int i = 1990; i < 2021; ++i) {
            this.txtStartYear.addItem((Object)i);
            this.txtEndYear.addItem((Object)i);
        }
        this.loadDefaultData();
    }

    private void loadOldData() {
        Period period = this.editData.getPeriod();
        if (period == Period.QUARTER) {
            this.createQuarterCombox();
        } else if (period == Period.HALF_YEAR) {
            this.createHalfYearCombox();
        } else if (period == Period.YEAR) {
            this.createYearCombox();
        } else {
            this.createMonthCombox();
        }
        this.txtEndYear.setSelectedIndex(this.editData.getEndYear() - 1990);
        this.txtStartYear.setSelectedIndex(this.editData.getStartYear() - 1990);
        if (period != Period.YEAR) {
            this.txtStartMonth.setSelectedIndex(this.editData.getStartMonth());
            this.txtEndMonth.setSelectedIndex(this.editData.getEndMonth());
        }
    }

    private void loadDefaultData() {
        this.comboPlanType.setSelectedItem((Object)PersonPlanType.POSITION);
        this.comboPeriod.setSelectedItem((Object)Period.MONTH);
        Calendar now = Calendar.getInstance();
        this.txtEndYear.setSelectedIndex(now.get(1) - 1990);
        this.txtStartYear.setSelectedIndex(now.get(1) - 1990);
        this.createMonthCombox();
    }

    private void createMonthCombox() {
        this.labMonth.setVisible(true);
        this.labMonth2.setVisible(true);
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.txtStartMonth.removeAllItems();
        this.txtEndMonth.removeAllItems();
        this.labMonth.setBoundLabelText(EASResource.getString((String)(this.resClass + "MONTH")));
        this.labMonth2.setBoundLabelText(EASResource.getString((String)(this.resClass + "MONTH")));
        for (int i = 1; i < 13; ++i) {
            this.txtStartMonth.addItem((Object)i);
            this.txtEndMonth.addItem((Object)i);
        }
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(11);
    }

    private void createQuarterCombox() {
        this.labMonth.setVisible(true);
        this.labMonth2.setVisible(true);
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.txtStartMonth.removeAllItems();
        this.txtEndMonth.removeAllItems();
        this.labMonth.setBoundLabelText(EASResource.getString((String)(this.resClass + "QUARTER")));
        this.labMonth2.setBoundLabelText(EASResource.getString((String)(this.resClass + "QUARTER")));
        for (int i = 1; i < 5; ++i) {
            this.txtStartMonth.addItem((Object)i);
            this.txtEndMonth.addItem((Object)i);
        }
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(3);
    }

    private void createHalfYearCombox() {
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.txtStartMonth.removeAllItems();
        this.txtEndMonth.removeAllItems();
        this.labMonth.setVisible(false);
        this.labMonth2.setVisible(false);
        this.txtStartMonth.addItem((Object)EASResource.getString((String)(this.resClass + "FIRST_HALFYEAR")));
        this.txtEndMonth.addItem((Object)EASResource.getString((String)(this.resClass + "FIRST_HALFYEAR")));
        this.txtStartMonth.addItem((Object)EASResource.getString((String)(this.resClass + "SECOND_HALF_YEAR")));
        this.txtEndMonth.addItem((Object)EASResource.getString((String)(this.resClass + "SECOND_HALF_YEAR")));
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(1);
    }

    private void createYearCombox() {
        this.labMonth.setVisible(false);
        this.labMonth2.setVisible(false);
        this.txtStartMonth.setVisible(false);
        this.txtEndMonth.setVisible(false);
    }

    @Override
    protected void comboPeriod_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            Period period = (Period)((Object)e.getItem());
            if (period == Period.QUARTER) {
                this.createQuarterCombox();
            } else if (period == Period.HALF_YEAR) {
                this.createHalfYearCombox();
            } else if (period == Period.YEAR) {
                this.createYearCombox();
            } else {
                this.createMonthCombox();
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        int startYear = (Integer)this.txtStartYear.getSelectedItem();
        int endYear = (Integer)this.txtEndYear.getSelectedItem();
        if (startYear * 100 + this.txtStartMonth.getSelectedIndex() > endYear * 100 + this.txtEndMonth.getSelectedIndex()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SCHEME_TIME_ERROR")));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("planType"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("startYear"));
        sic.add(new SelectorItemInfo("endYear"));
        sic.add(new SelectorItemInfo("startMonth"));
        sic.add(new SelectorItemInfo("endMonth"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText(null);
        this.editData.setStatus(SchemeStatus.SAVE);
    }
}

