/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.ResponsibilityFactory;
import com.kingdee.eas.hr.org.ResponsibilityInfo;
import com.kingdee.eas.hr.org.ResponsibilityTypeInfo;
import com.kingdee.eas.hr.org.client.AbstractResponsibilityEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class ResponsibilityEditUI
extends AbstractResponsibilityEditUI {
    private boolean hasCodingRule = false;
    private boolean isModifiable = false;

    public ResponsibilityEditUI() throws Exception {
        this.txtNumber.setText(null);
    }

    @Override
    public void loadFields() {
        this.setAutoNumberByOrg("ControlUnit");
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("ParentNode") == null) {
            this.btnAddNew.setEnabled(false);
            this.menuItemAddNew.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.menuBiz.setEnabled(false);
            this.menuBiz.setVisible(false);
        } else {
            this.btnAddNew.setEnabled(true);
            this.menuItemAddNew.setEnabled(true);
            this.actionAddNew.setEnabled(true);
            this.menuBiz.setEnabled(false);
            this.menuBiz.setVisible(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ResponsibilityInfo info = new ResponsibilityInfo();
        if ("ADDNEW".equals(this.getOprtState())) {
            info.setType((ResponsibilityTypeInfo)this.getUIContext().get("ParentNode"));
        }
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getCU() != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S4", (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)this.editData.getCU().getId().toString());
        }
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(this.isModifiable);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ResponsibilityFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (!this.hasCodingRule && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("type.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("workTask"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        ResponsibilityInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                this.isModifiable = iCodingRuleManager.isModifiable((IObjectValue)this.editData, companyID);
                this.hasCodingRule = true;
                this.txtNumber.setEnabled(this.isModifiable);
            }
            if (this.editData.getNumber() == null) {
                if (this.hasCodingRule && iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                    this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    this.txtNumber.setText(this.editData.getNumber());
                }
            } else {
                if (this.editData.getNumber().trim().length() > 0) {
                    this.txtNumber.setText(this.editData.getNumber());
                }
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    this.txtNumber.setEnabled(false);
                    this.txtNumber.setEditable(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            this.oldData = this.editData;
            SysUtil.abort();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"ControlUnit");
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("CU");
    }
}

