/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.util.HRHistoryUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.AdminOrgTreeHisCollection;
import com.kingdee.eas.hr.org.AdminOrgTreeHisFactory;
import com.kingdee.eas.hr.org.AdminOrgTreeHisInfo;
import com.kingdee.eas.hr.org.IAdminOrgTreeHis;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgTreeHisUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.util.OrgTreeHisUtil");
    public static final Locale locale_L1 = com.kingdee.util.LocaleUtils.getLocale((String)"L1");
    public static final Locale locale_L2 = com.kingdee.util.LocaleUtils.getLocale((String)"L2");
    public static final Locale locale_L3 = com.kingdee.util.LocaleUtils.getLocale((String)"L3");

    public static void addNewAdminOrgTreeHis(Context ctx, FullOrgUnitInfo fullOrgInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgInfo.getId().toString());
        OrgTreeHisUtil.addNewAdminOrgTreeHis(ctx, (IObjectPK)pk, null);
    }

    public static void addNewAdminOrgTreeHis(Context ctx, IObjectPK pk, java.util.Date effectDate) throws BOSException, EASBizException {
        java.util.Date effdt;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("EFFDT"));
        IAdminOrgTreeHis iAdminOrgTreeHis = AdminOrgTreeHisFactory.getLocalInstance(ctx);
        AdminOrgUnitInfo adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo(pk, selector);
        java.util.Date date = effdt = effectDate != null ? DateTimeUtils.truncateDate((java.util.Date)effectDate) : adminOrgInfo.getEFFDT();
        if (effdt == null && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(adminOrgInfo.getId().toString())) {
            effdt = HRHistoryUtil.getMinEffdtDate();
        }
        if (adminOrgInfo.getParent() != null) {
            String sql;
            AdminOrgTreeHisCollection parentOrgHisColl;
            AdminOrgTreeHisInfo adminOrgTreeHisInfo;
            AdminOrgTreeHisInfo parentTreeHisInfo;
            String effdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt);
            String parentId = adminOrgInfo.getParent().getId().toString();
            String oql = "select longnumber,displayname,effdt,leffdt where adminOrg = '" + parentId + "' and effdt >= " + effdtStr;
            AdminOrgTreeHisCollection parentOrgTreeHisColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(oql);
            int size = parentOrgTreeHisColl.size();
            if (size > 0) {
                CoreBaseCollection adminOrgTreeHisColl = new CoreBaseCollection();
                for (int i = 0; i < size; ++i) {
                    parentTreeHisInfo = parentOrgTreeHisColl.get(i);
                    adminOrgTreeHisInfo = new AdminOrgTreeHisInfo();
                    OrgTreeHisUtil.storefields(adminOrgTreeHisInfo, parentTreeHisInfo, adminOrgInfo, null);
                    adminOrgTreeHisColl.add((CoreBaseInfo)adminOrgTreeHisInfo);
                }
                iAdminOrgTreeHis.save(adminOrgTreeHisColl);
            }
            if ((parentOrgHisColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(sql = "select longnumber,displayname,effdt,leffdt where adminOrg = '" + parentId + "' and effdt < " + effdtStr + " and leffdt >= " + effdtStr)).size() > 0) {
                parentTreeHisInfo = parentOrgHisColl.get(0);
                adminOrgTreeHisInfo = new AdminOrgTreeHisInfo();
                OrgTreeHisUtil.storefields(adminOrgTreeHisInfo, parentTreeHisInfo, adminOrgInfo, effdt);
                iAdminOrgTreeHis.save(adminOrgTreeHisInfo);
            }
        } else {
            AdminOrgTreeHisInfo adminOrgTreeHisInfo = new AdminOrgTreeHisInfo();
            OrgTreeHisUtil.storefields(adminOrgTreeHisInfo, null, adminOrgInfo, effdt);
            iAdminOrgTreeHis.save(adminOrgTreeHisInfo);
        }
        OrgTreeHisUtil.mergeAdminOrgTreeHis(ctx);
    }

    private static void storefields(AdminOrgTreeHisInfo info, AdminOrgTreeHisInfo parentInfo, AdminOrgUnitInfo adminOrgInfo, java.util.Date effdt) {
        if (parentInfo != null) {
            String longNumber = parentInfo.getLongNumber() + "!" + adminOrgInfo.getNumber();
            info.setAdminOrg(adminOrgInfo);
            info.setParent(adminOrgInfo.getParent());
            info.setLongNumber(longNumber);
            if (effdt != null) {
                info.setEffdt(effdt);
            } else {
                info.setEffdt(parentInfo.getEffdt());
            }
            info.setLeffdt(parentInfo.getLeffdt());
            if (parentInfo.getDisplayName(locale_L1) != null && adminOrgInfo.getName(locale_L1) != null) {
                String disPlayName_1 = parentInfo.getDisplayName(locale_L1) + "_" + adminOrgInfo.getName(locale_L1);
                info.setDisplayName(disPlayName_1, locale_L1);
                OrgTreeHisUtil.limitDisplayNameLength(info, locale_L1);
            }
            if (parentInfo.getDisplayName(locale_L2) != null && adminOrgInfo.getName(locale_L2) != null) {
                String disPlayName_2 = parentInfo.getDisplayName(locale_L2) + "_" + adminOrgInfo.getName(locale_L2);
                info.setDisplayName(disPlayName_2, locale_L2);
                OrgTreeHisUtil.limitDisplayNameLength(info, locale_L2);
            }
            if (parentInfo.getDisplayName(locale_L3) != null && adminOrgInfo.getName(locale_L3) != null) {
                String disPlayName_3 = parentInfo.getDisplayName(locale_L3) + "_" + adminOrgInfo.getName(locale_L3);
                info.setDisplayName(disPlayName_3, locale_L3);
                OrgTreeHisUtil.limitDisplayNameLength(info, locale_L3);
            }
        } else {
            String longNumber = adminOrgInfo.getNumber();
            info.setAdminOrg(adminOrgInfo);
            info.setParent(null);
            info.setLongNumber(longNumber);
            info.setEffdt(effdt);
            info.setLeffdt(HistoryUtil.getMaxDate());
            if (adminOrgInfo.getName(locale_L1) != null) {
                String disPlayName_1 = adminOrgInfo.getName(locale_L1);
                info.setDisplayName(disPlayName_1, locale_L1);
            }
            if (adminOrgInfo.getName(locale_L2) != null) {
                String disPlayName_2 = adminOrgInfo.getName(locale_L2);
                info.setDisplayName(disPlayName_2, locale_L2);
            }
            if (adminOrgInfo.getName(locale_L3) != null) {
                String disPlayName_3 = adminOrgInfo.getName(locale_L3);
                info.setDisplayName(disPlayName_3, locale_L3);
            }
        }
    }

    public static void updateAdminOrgTreeHis(Context ctx, String adminOrgId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(adminOrgId.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("EFFDT"));
        AdminOrgUnitInfo adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk, selector);
        if (adminOrgInfo != null) {
            java.util.Date effdt = adminOrgInfo.getEFFDT();
            OrgTreeHisUtil.updateAdminOrgTreeHis(ctx, adminOrgInfo, effdt, "revise");
        }
    }

    public static void updateAdminOrgTreeHis(Context ctx, IObjectValue adminOrgHisInfo, FullOrgUnitInfo fullOrgInfo) throws BOSException, EASBizException {
        boolean isUpdateAdminOrgTreeHis;
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("EFFDT"));
        selector.add(new SelectorItemInfo("longNumber"));
        AdminOrgUnitInfo adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk, selector);
        if (adminOrgHisInfo != null && adminOrgInfo != null && (isUpdateAdminOrgTreeHis = OrgTreeHisUtil.isUpdateAdminOrgTreeHis(adminOrgHisInfo, adminOrgInfo))) {
            Date oldEffdt = adminOrgHisInfo.getDate("EFFDT");
            java.util.Date effdt = adminOrgInfo.getEFFDT();
            String historyOperateState = effdt.after(oldEffdt) ? "change" : "revise";
            OrgTreeHisUtil.updateAdminOrgTreeHis(ctx, adminOrgInfo, effdt, historyOperateState);
        }
        OrgTreeHisUtil.updateNewestAdminOrgHisInfo(ctx, adminOrgInfo);
    }

    private static void updateNewestAdminOrgHisInfo(Context ctx, AdminOrgUnitInfo adminOrgInfo) throws BOSException {
        if (adminOrgInfo == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_ORG_adminhis t1 set  (FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3) = ").append(" (select t2.FLongNumber,t2.FDisplayName_l1,t2.FDisplayName_l2,t2.FDisplayName_l3 from T_ORG_ADMIN t2").append(" where t2.FID = t1.FHISTORYRELATEID and t1.fleffdt={ts'2199-12-31'} and t2.flongnumber LIKE '").append(adminOrgInfo.getLongNumber() + "%')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static boolean isUpdateAdminOrgTreeHis(IObjectValue adminOrgHisInfo, AdminOrgUnitInfo adminOrgInfo) throws BOSException, EASBizException {
        String oldName_l1 = adminOrgHisInfo.getString("name_l1");
        String oldName_l2 = adminOrgHisInfo.getString("name_l2");
        String oldName_l3 = adminOrgHisInfo.getString("name_l3");
        String oldNumber = adminOrgHisInfo.getString("number");
        IObjectValue oldParent = adminOrgHisInfo.getObjectValue("parent");
        String oldParentId = oldParent != null ? oldParent.getString("id") : null;
        Date oldEffdt = adminOrgHisInfo.getDate("EFFDT");
        String name_l1 = adminOrgInfo.getString("name_l1");
        String name_l2 = adminOrgInfo.getString("name_l2");
        String name_l3 = adminOrgInfo.getString("name_l3");
        String number = adminOrgInfo.getNumber();
        String parentId = adminOrgInfo.getParent() != null ? adminOrgInfo.getParent().getId().toString() : null;
        java.util.Date effdt = adminOrgInfo.getEFFDT();
        if (!(StringUtils.equals((String)oldName_l1, (String)name_l1) && StringUtils.equals((String)oldName_l2, (String)name_l2) && StringUtils.equals((String)oldName_l3, (String)name_l3) && oldNumber.equals(number))) {
            return true;
        }
        if (oldParentId == null && parentId != null || oldParentId != null && parentId == null || oldParentId != null && parentId != null && !oldParentId.equals(parentId)) {
            return true;
        }
        return effdt.before(oldEffdt);
    }

    public static void updateAdminOrgTreeHis(Context ctx, AdminOrgUnitInfo changOrgInfo, java.util.Date effectDate, String historyOperateState) throws BOSException, EASBizException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = OrgTreeHisUtil.getConnection(ctx);
            stmt = conn.createStatement();
            OrgTreeHisUtil.updateAdminOrgTreeHis(ctx, effectDate, changOrgInfo, stmt, historyOperateState);
            OrgTreeHisUtil.cutAdminOrgTreeHis(ctx, effectDate, changOrgInfo, stmt, historyOperateState);
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"batch update AdminOrgTreeHis error! \n", (Throwable)e);
                logger.error((Object)"**************************** Next exception is: ***************************");
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        if ("revise".equals(historyOperateState)) {
            ObjectUuidPK pk = new ObjectUuidPK(changOrgInfo.getId().toString());
            String sql = "delete from T_ORG_AdminOrgTreeHis where fadminorgid = '" + pk.toString() + "' and feffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effectDate);
            DbUtil.execute((Context)ctx, (String)sql);
            OrgTreeHisUtil.addNewAdminOrgTreeHis(ctx, (IObjectPK)pk, effectDate);
        }
        OrgTreeHisUtil.mergeAdminOrgTreeHis(ctx);
    }

    private static void updateAdminOrgTreeHis(Context ctx, java.util.Date effdt, AdminOrgUnitInfo changOrgInfo, Statement stmt, String historyOperateState) throws BOSException, EASBizException {
        IAdminOrgTreeHis iAdminOrgTreeHis = AdminOrgTreeHisFactory.getLocalInstance(ctx);
        String changeOrgId = changOrgInfo.getId().toString();
        String changeParentId = changOrgInfo.getParent() != null ? changOrgInfo.getParent().getId().toString() : null;
        String number = changOrgInfo.getNumber();
        String name_1 = changOrgInfo.getName(locale_L1);
        String name_2 = changOrgInfo.getName(locale_L2);
        String name_3 = changOrgInfo.getName(locale_L3);
        String newLongNumber = "";
        String newDisplayName_1 = "";
        String newDisplayName_2 = "";
        String newDisplayName_3 = "";
        try {
            String oql = "select id,adminOrg.name,adminOrg.number,longNumber,displayName,effdt,leffdt where adminOrg = '" + changeOrgId + "' and effdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt);
            AdminOrgTreeHisCollection adminOrgTreeHisColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(oql);
            int size = adminOrgTreeHisColl.size();
            for (int i = 0; i < size; ++i) {
                AdminOrgTreeHisInfo adminOrgTreeHisInfo = adminOrgTreeHisColl.get(i);
                java.util.Date adminOrgTreeHisEffdt = adminOrgTreeHisInfo.getEffdt();
                String adminOrgTreeHisId = adminOrgTreeHisInfo.getId().toString();
                java.util.Date adminOrgTreeHisLEffdt = adminOrgTreeHisInfo.getLeffdt();
                if (!StringUtils.isEmpty((String)changeParentId)) {
                    String parentOql = OrgTreeHisUtil.getParentOrgTreeHisOql(changeParentId, adminOrgTreeHisEffdt);
                    AdminOrgTreeHisCollection parentColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(parentOql);
                    newLongNumber = parentColl.get(0).getLongNumber() + "!" + number;
                    newDisplayName_1 = parentColl.get(0).getDisplayName(locale_L1) + "_" + name_1;
                    newDisplayName_2 = parentColl.get(0).getDisplayName(locale_L2) + "_" + name_2;
                    newDisplayName_3 = parentColl.get(0).getDisplayName(locale_L3) + "_" + name_3;
                } else {
                    newLongNumber = number;
                    newDisplayName_1 = name_1;
                    newDisplayName_2 = name_2;
                    newDisplayName_3 = name_3;
                }
                String oldLongNumber = adminOrgTreeHisInfo.getLongNumber();
                String oldDisplayName_1 = adminOrgTreeHisInfo.getDisplayName(locale_L1);
                String oldDisplayName_2 = adminOrgTreeHisInfo.getDisplayName(locale_L2);
                String oldDisplayName_3 = adminOrgTreeHisInfo.getDisplayName(locale_L3);
                List childrenList = OrgTreeHisUtil.getUpdateChildrenOrgTreeHisList(ctx, oldLongNumber, adminOrgTreeHisEffdt, adminOrgTreeHisLEffdt);
                int listSize = childrenList.size();
                for (int j = 0; j < listSize; ++j) {
                    Map map = (Map)childrenList.get(j);
                    String id = (String)map.get("id");
                    String longNumber = (String)map.get("longNumber");
                    longNumber = HRUtilExtend.replace((String)longNumber, (String)oldLongNumber, (String)newLongNumber);
                    String displayName_1 = (String)map.get("displayName_1");
                    if (!StringUtils.isEmpty((String)displayName_1) && !StringUtils.isEmpty((String)oldDisplayName_1)) {
                        displayName_1 = HRUtilExtend.replace((String)displayName_1, (String)oldDisplayName_1, (String)newDisplayName_1);
                    }
                    displayName_1 = OrgTreeHisUtil.getDisplayName(displayName_1);
                    String displayName_2 = (String)map.get("displayName_2");
                    if (!StringUtils.isEmpty((String)displayName_2) && !StringUtils.isEmpty((String)oldDisplayName_2)) {
                        displayName_2 = HRUtilExtend.replaceNotNull((String)displayName_2, (String)oldDisplayName_2, (String)newDisplayName_2);
                    }
                    displayName_2 = OrgTreeHisUtil.getDisplayName(displayName_2);
                    String displayName_3 = (String)map.get("displayName_3");
                    if (!StringUtils.isEmpty((String)displayName_3) && !StringUtils.isEmpty((String)oldDisplayName_3)) {
                        displayName_3 = HRUtilExtend.replace((String)displayName_3, (String)oldDisplayName_3, (String)newDisplayName_3);
                    }
                    displayName_3 = OrgTreeHisUtil.getDisplayName(displayName_3);
                    String updateChildrenSql = "update T_ORG_AdminOrgTreeHis set flongnumber = '" + longNumber + "', fdisplayName_l1 = " + displayName_1 + ", fdisplayName_l2 = " + displayName_2 + ", fdisplayName_l3 = " + displayName_3 + " where fid = '" + id + "'";
                    stmt.addBatch(updateChildrenSql);
                }
                newDisplayName_1 = OrgTreeHisUtil.getDisplayName(newDisplayName_1);
                newDisplayName_2 = OrgTreeHisUtil.getDisplayName(newDisplayName_2);
                newDisplayName_3 = OrgTreeHisUtil.getDisplayName(newDisplayName_3);
                if (!historyOperateState.equals("change")) continue;
                String updateSql = "update T_ORG_AdminOrgTreeHis set flongnumber = '" + newLongNumber + "', fdisplayName_l1 = " + newDisplayName_1 + ", fdisplayName_l2 = " + newDisplayName_2 + ", fdisplayName_l3 = " + newDisplayName_3 + " where fid = '" + adminOrgTreeHisId + "'";
                stmt.addBatch(updateSql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"batch update AdminOrgTreeHis error! \n", (Throwable)e);
            logger.error((Object)"**************************** Next exception is: ***************************");
            logger.error((Object)"sql exception :", (Throwable)e);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static void cutAdminOrgTreeHis(Context ctx, java.util.Date effdt, AdminOrgUnitInfo adminOrgInfo, Statement stmt, String historyOperateState) throws BOSException, EASBizException {
        IAdminOrgTreeHis iAdminOrgTreeHis = AdminOrgTreeHisFactory.getLocalInstance(ctx);
        String effdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt);
        String changeOrgId = adminOrgInfo.getId().toString();
        String changeParentId = adminOrgInfo.getParent() != null ? adminOrgInfo.getParent().getId().toString() : "";
        String number = adminOrgInfo.getNumber();
        String name_1 = adminOrgInfo.getName(locale_L1);
        String name_2 = adminOrgInfo.getName(locale_L2);
        String name_3 = adminOrgInfo.getName(locale_L3);
        String newLongNumber = "";
        String newDisplayName_1 = "";
        String newDisplayName_2 = "";
        String newDisplayName_3 = "";
        String cutOql = "select id,effdt,leffdt,longNumber,displayName where adminOrg = '" + changeOrgId + "' and effdt < " + effdtStr + " and leffdt >= " + effdtStr;
        AdminOrgTreeHisCollection adminOrgTreeHisColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(cutOql);
        if (adminOrgTreeHisColl.size() > 0) {
            AdminOrgTreeHisInfo adminOrgTreeHisInfo = adminOrgTreeHisColl.get(0);
            String adminOrgTreeHisId = adminOrgTreeHisInfo.getId().toString();
            java.util.Date adminOrgTreeHisLeffdt = adminOrgTreeHisInfo.getLeffdt();
            String oldLeffdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)adminOrgTreeHisLeffdt);
            java.util.Date newLeffdt = HistoryUtil.getBeforeDay((java.util.Date)effdt);
            String newLeffdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)newLeffdt);
            if (!StringUtils.isEmpty((String)changeParentId)) {
                String parentOql = OrgTreeHisUtil.getParentOrgTreeHisOql(changeParentId, effdt);
                AdminOrgTreeHisCollection parentColl = iAdminOrgTreeHis.getAdminOrgTreeHisCollection(parentOql);
                newLongNumber = parentColl.get(0).getLongNumber() + "!" + number;
                newDisplayName_1 = parentColl.get(0).getDisplayName(locale_L1) + "_" + name_1;
                newDisplayName_2 = parentColl.get(0).getDisplayName(locale_L2) + "_" + name_2;
                newDisplayName_3 = parentColl.get(0).getDisplayName(locale_L3) + "_" + name_3;
            } else {
                newLongNumber = number;
                newDisplayName_1 = name_1;
                newDisplayName_2 = name_2;
                newDisplayName_3 = name_3;
            }
            String oldLongNumber = adminOrgTreeHisInfo.getLongNumber();
            String oldDisplayName_1 = adminOrgTreeHisInfo.getDisplayName(locale_L1);
            String oldDisplayName_2 = adminOrgTreeHisInfo.getDisplayName(locale_L2);
            String oldDisplayName_3 = adminOrgTreeHisInfo.getDisplayName(locale_L3);
            List childrenList = OrgTreeHisUtil.getCutChildrenOrgTreeHisList(ctx, oldLongNumber, effdt);
            try {
                int listSize = childrenList.size();
                for (int j = 0; j < listSize; ++j) {
                    Map map = (Map)childrenList.get(j);
                    String id = (String)map.get("id");
                    String updateChildrenSql = "update T_ORG_AdminOrgTreeHis set fleffdt = " + newLeffdtStr + " where fid = '" + id + "'";
                    stmt.addBatch(updateChildrenSql);
                    java.util.Date leffdt = (java.util.Date)map.get("leffdt");
                    String leffdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)leffdt);
                    String adminOrgId = (String)map.get("adminOrgId");
                    String parentId = (String)map.get("parentId");
                    String longNumber = (String)map.get("longNumber");
                    longNumber = HRUtilExtend.replace((String)longNumber, (String)oldLongNumber, (String)newLongNumber);
                    String displayName_1 = (String)map.get("displayName_1");
                    if (!StringUtils.isEmpty((String)displayName_1)) {
                        displayName_1 = HRUtilExtend.replace((String)displayName_1, (String)oldDisplayName_1, (String)newDisplayName_1);
                    }
                    displayName_1 = OrgTreeHisUtil.getDisplayName(displayName_1);
                    String displayName_2 = (String)map.get("displayName_2");
                    if (!StringUtils.isEmpty((String)displayName_2)) {
                        displayName_2 = HRUtilExtend.replaceNotNull((String)displayName_2, (String)oldDisplayName_2, (String)newDisplayName_2);
                    }
                    displayName_2 = OrgTreeHisUtil.getDisplayName(displayName_2);
                    String displayName_3 = (String)map.get("displayName_3");
                    if (!StringUtils.isEmpty((String)displayName_3)) {
                        displayName_3 = HRUtilExtend.replace((String)displayName_3, (String)oldDisplayName_3, (String)newDisplayName_3);
                    }
                    displayName_3 = OrgTreeHisUtil.getDisplayName(displayName_3);
                    String insertChildrenSql = "insert into T_ORG_AdminOrgTreeHis(fid, feffdt, fleffdt, flongNumber,fdisplayName_l1, fdisplayName_l2, fdisplayName_l3, fadminorgid, fparentid) values (newbosid('B5391C9A'), " + effdtStr + "," + leffdtStr + ",'" + longNumber + "'," + displayName_1 + "," + displayName_2 + "," + displayName_3 + ",'" + adminOrgId + "','" + parentId + "')";
                    stmt.addBatch(insertChildrenSql);
                }
                String updateSql = "update T_ORG_AdminOrgTreeHis set fleffdt = " + newLeffdtStr + " where fid = '" + adminOrgTreeHisId + "'";
                stmt.addBatch(updateSql);
                if (adminOrgTreeHisLeffdt.equals(HistoryUtil.getMaxDate())) {
                    List<HashMap> childrenChangeList = OrgTreeHisUtil.getUpdateChildrenChangeOrgTreeHisList(ctx, oldLongNumber, effdt);
                    int listSize2 = childrenChangeList.size();
                    for (int j = 0; j < listSize2; ++j) {
                        Map map = childrenChangeList.get(j);
                        String id = (String)map.get("id");
                        String longNumber = (String)map.get("longNumber");
                        longNumber = HRUtilExtend.replace((String)longNumber, (String)oldLongNumber, (String)newLongNumber);
                        String displayName_1 = (String)map.get("displayName_1");
                        if (!StringUtils.isEmpty((String)displayName_1)) {
                            displayName_1 = HRUtilExtend.replace((String)displayName_1, (String)oldDisplayName_1, (String)newDisplayName_1);
                        }
                        displayName_1 = OrgTreeHisUtil.getDisplayName(displayName_1);
                        String displayName_2 = (String)map.get("displayName_2");
                        if (!StringUtils.isEmpty((String)displayName_2)) {
                            displayName_2 = HRUtilExtend.replaceNotNull((String)displayName_2, (String)oldDisplayName_2, (String)newDisplayName_2);
                        }
                        displayName_2 = OrgTreeHisUtil.getDisplayName(displayName_2);
                        String displayName_3 = (String)map.get("displayName_3");
                        if (!StringUtils.isEmpty((String)displayName_3)) {
                            displayName_3 = HRUtilExtend.replace((String)displayName_3, (String)oldDisplayName_3, (String)newDisplayName_3);
                        }
                        displayName_3 = OrgTreeHisUtil.getDisplayName(displayName_3);
                        String updateChildrenSql = "update T_ORG_AdminOrgTreeHis set flongnumber = '" + longNumber + "', fdisplayName_l1 = " + displayName_1 + ", fdisplayName_l2 = " + displayName_2 + ", fdisplayName_l3 = " + displayName_3 + " where fid = '" + id + "'";
                        stmt.addBatch(updateChildrenSql);
                    }
                }
                newDisplayName_1 = OrgTreeHisUtil.getDisplayName(newDisplayName_1);
                newDisplayName_2 = OrgTreeHisUtil.getDisplayName(newDisplayName_2);
                newDisplayName_3 = OrgTreeHisUtil.getDisplayName(newDisplayName_3);
                if (historyOperateState.equals("change")) {
                    String insertSql = "insert into T_ORG_AdminOrgTreeHis(fid, feffdt, fleffdt, flongNumber,fdisplayName_l1, fdisplayName_l2, fdisplayName_l3, fadminorgid, fparentid) values (newbosid('B5391C9A'), " + effdtStr + "," + oldLeffdtStr + ",'" + newLongNumber + "'," + newDisplayName_1 + "," + newDisplayName_2 + "," + newDisplayName_3 + ",'" + changeOrgId + "','" + changeParentId + "')";
                    stmt.addBatch(insertSql);
                }
            }
            catch (Exception e) {
                logger.error((Object)"batch cut AdminOrgTreeHis error! \n", (Throwable)e);
                logger.error((Object)"**************************** Next exception is: ***************************");
                logger.error((Object)"sql exception :", (Throwable)e);
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static List<HashMap> getUpdateChildrenChangeOrgTreeHisList(Context ctx, String parentLongNumber, java.util.Date effdt) throws BOSException {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        String sql = "select fid,flongNumber,fdisplayName_l1,fdisplayName_l2,fdisplayName_l3 from T_ORG_AdminOrgTreeHis where flongnumber like '" + parentLongNumber + "!%' and feffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                String longNumber = rowSet.getString("flongNumber");
                String displayName_1 = rowSet.getString("fdisplayName_l1");
                String displayName_2 = rowSet.getString("fdisplayName_l2");
                String displayName_3 = rowSet.getString("fdisplayName_l3");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", id);
                map.put("longNumber", longNumber);
                map.put("displayName_1", displayName_1);
                map.put("displayName_2", displayName_2);
                map.put("displayName_3", displayName_3);
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private static List getUpdateChildrenOrgTreeHisList(Context ctx, String parentLongNumber, java.util.Date parentEffdt, java.util.Date parentLeffdt) throws BOSException {
        ArrayList list = new ArrayList();
        String sql = "select fid,flongNumber,fdisplayName_l1,fdisplayName_l2,fdisplayName_l3 from T_ORG_AdminOrgTreeHis where flongnumber like '" + parentLongNumber + "!%' and feffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)parentEffdt) + " and feffdt < " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)parentLeffdt);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                String longNumber = rowSet.getString("flongNumber");
                String displayName_1 = rowSet.getString("fdisplayName_l1");
                String displayName_2 = rowSet.getString("fdisplayName_l2");
                String displayName_3 = rowSet.getString("fdisplayName_l3");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", id);
                map.put("longNumber", longNumber);
                map.put("displayName_1", displayName_1);
                map.put("displayName_2", displayName_2);
                map.put("displayName_3", displayName_3);
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private static List getCutChildrenOrgTreeHisList(Context ctx, String parentLongNumber, java.util.Date effctDate) throws BOSException {
        ArrayList list = new ArrayList();
        String sql = "select * from T_ORG_AdminOrgTreeHis where flongnumber like '" + parentLongNumber + "!%' and feffdt < " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effctDate) + " and fleffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effctDate);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                String longNumber = rowSet.getString("flongNumber");
                String displayName_1 = rowSet.getString("fdisplayName_l1");
                String displayName_2 = rowSet.getString("fdisplayName_l2");
                String displayName_3 = rowSet.getString("fdisplayName_l3");
                Date effdt = rowSet.getDate("feffdt");
                Date leffdt = rowSet.getDate("fleffdt");
                String adminOrgId = rowSet.getString("fadminorgid");
                String parentId = rowSet.getString("fparentid");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                map.put("longNumber", longNumber);
                map.put("displayName_1", displayName_1);
                map.put("displayName_2", displayName_2);
                map.put("displayName_3", displayName_3);
                map.put("effdt", effdt);
                map.put("leffdt", leffdt);
                map.put("adminOrgId", adminOrgId);
                map.put("parentId", parentId);
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private static String getDisplayName(String displayName) {
        if (StringUtils.isEmpty((String)displayName) || displayName.indexOf("null") != -1) {
            return null;
        }
        return "'" + displayName + "'";
    }

    private static void mergeAdminOrgTreeHis(Context ctx) throws BOSException, EASBizException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select t1.fid,t1.feffdt,t1.fleffdt,t2.fid as nextfid,t2.feffdt as nextfeffdt,t2.fleffdt as nextleffdt,t1.fadminorgid from T_ORG_AdminOrgTreeHis t1 left join T_ORG_AdminOrgTreeHis t2 on t1.fdisplayname_" + l + " = t2.fdisplayname_" + l + " and t1.flongnumber = t2.flongnumber and t1.fadminorgid = t2.fadminorgid and t2.feffdt = dateAdd(d, 1, t1.fleffdt) where t2.fleffdt is not null order by t1.fadminorgid asc,t1.feffdt asc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.size() > 0) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = OrgTreeHisUtil.getConnection(ctx);
                stmt = conn.createStatement();
                while (rowSet.next()) {
                    String fid = rowSet.getString("fid");
                    String deleteSql = "delete from T_ORG_AdminOrgTreeHis where fid = '" + fid + "'";
                    stmt.addBatch(deleteSql);
                    java.util.Date effdt = rowSet.getDate("feffdt");
                    String nextid = rowSet.getString("nextfid");
                    if (map.containsKey(fid)) {
                        java.util.Date updateEffdt = (java.util.Date)map.get(fid);
                        effdt = updateEffdt;
                        map.remove(fid);
                    }
                    map.put(nextid, (Date)effdt);
                }
                for (Map.Entry entry : map.entrySet()) {
                    String fid = (String)entry.getKey();
                    java.util.Date effdt = (java.util.Date)entry.getValue();
                    String updateSql = "update T_ORG_AdminOrgTreeHis set feffdt = " + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt) + " where fid = '" + fid + "'";
                    stmt.addBatch(updateSql);
                }
                stmt.executeBatch();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"batch mergeAdminOrgTreeHis error! \n", (Throwable)e);
                    logger.error((Object)"**************************** Next exception is: ***************************");
                    logger.error((Object)"sql exception :", (Throwable)e);
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    private static String getParentOrgTreeHisOql(String parentId, java.util.Date effdt) {
        String effdtStr = HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)effdt);
        String oql = "select longnumber,displayname where adminOrg = '" + parentId + "' and effdt <= " + effdtStr + " and leffdt >= " + effdtStr;
        return oql;
    }

    private static void limitDisplayNameLength(AdminOrgTreeHisInfo info, Locale locale) {
        String displayName = info.getDisplayName(locale);
        String[] displayNameVar = StringUtil.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1) {
            if (displayName.length() > 500) {
                int len = displayName.indexOf("_");
                displayName = displayName.substring(len + 1);
                info.setDisplayName(displayName, locale);
                OrgTreeHisUtil.limitDisplayNameLength(info, locale);
            }
        } else if (displayNameVar.length == 1 && displayName.length() > 500) {
            displayName = displayName.substring(0, 500);
            info.setDisplayName(displayName, locale);
        }
    }

    public static void deleteAdminOrgTreeHis(Context ctx, String orgId) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"delete from T_ORG_AdminOrgTreeHis where fadminorgid = ?", (Object[])new Object[]{orgId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectCollection getAdminOrgHisCollection(Context ctx, FullOrgUnitInfo fullOrg) throws BOSException, EASBizException {
        IObjectCollection collection = null;
        String billId = fullOrg.getId().toString();
        java.util.Date leffdt = HistoryUtil.getMaxDate();
        BOSObjectType bosType = BOSObjectType.create((String)"6A6435BE");
        if (!StringUtils.isEmpty((String)billId) && leffdt != null) {
            Connection cn = null;
            try {
                cn = OrgTreeHisUtil.getConnection(ctx);
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("EFFDT"));
                selector.add(new SelectorItemInfo("parent"));
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.historyRelateID, (Object)billId));
                filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)leffdt, CompareType.EQUALS));
                view.setFilter(filter);
                EntityObjectInfo entityObjectInfo = HistoryUtil.getHistoryEntityParam((Context)ctx, (BOSObjectType)bosType).getHistoryEntityInfo();
                collection = HistoryUtil.getDao((Context)ctx, (Connection)cn, (EntityObjectInfo)entityObjectInfo).getCollection(view);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        return collection;
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static void dealSelfRef(Context ctx, String adminOrgId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("update T_ORG_Admin");
        sb.append(" set FCompanyID = '' , FDepartmentID = '',FOfficeID = '',").append("FLevelFourGroupID = '',FLevelFiveGroupID = '',FLevelSixGroupID = ''").append(" where fid = ?");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{adminOrgId});
    }
}

