/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.hr.party.ILaborUint;
import com.kingdee.eas.hr.party.LaborUintFactory;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class HRLaborUnitGroupReportUtil {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static String oldDSessionId = null;
    private static HashMap nodeCache = new HashMap();
    public static final Color CANNOT_INPUT_COLOR = new Color(208, 208, 208);
    public static final Color MUST_INPUT_COLOR = new Color(252, 251, 223);
    public static final Color WHITE_BACKGROUND = Color.WHITE;

    public static DefaultKingdeeTreeNode getLaborUnitTreeNode(boolean isIncludeCancel, String laborUnitId) throws Exception {
        Map treeNodeMap = HRLaborUnitGroupReportUtil.getLaborUnitTreeNodeMapInCache(isIncludeCancel, true);
        if (treeNodeMap == null || treeNodeMap.size() == 0) {
            return null;
        }
        if (laborUnitId != null) {
            return (DefaultKingdeeTreeNode)treeNodeMap.get(laborUnitId);
        }
        return (DefaultKingdeeTreeNode)treeNodeMap.get(nodeCache.get(oldDSessionId + "laborUnitTreeRootNode"));
    }

    public static Map getLaborUnitTreeNodeMapInCache(boolean isIncludeCancel, boolean isUseCache) throws Exception {
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache.clear();
        }
        String key = oldDSessionId + "LaborUnitTree" + isIncludeCancel;
        Map treeNodeMap = null;
        if (!isUseCache || nodeCache.get(key) == null) {
            treeNodeMap = HRLaborUnitGroupReportUtil.createLaborUnitTreeNodeMap(isIncludeCancel);
            nodeCache.put(key, treeNodeMap);
        } else {
            treeNodeMap = (Map)nodeCache.get(key);
        }
        return treeNodeMap;
    }

    public static Map createLaborUnitTreeNodeMap(boolean isIncludeCancel) throws Exception {
        ILaborUint iunit = LaborUintFactory.getRemoteInstance();
        EntityViewInfo entity = new EntityViewInfo();
        if (!isIncludeCancel) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isCancel", (Object)"0", CompareType.EQUALS));
            entity.setFilter(filter);
        }
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        entity.setSorter(sorterColl);
        TreeBaseCollection treeColl = iunit.getTreeBaseCollection(entity);
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        if (treeColl != null && treeColl.size() != 0) {
            DefaultKingdeeTreeNode rootTreeNode = null;
            DefaultKingdeeTreeNode subTreeNode = null;
            LaborUintInfo laboruint2 = null;
            String laborUnitID = null;
            String parentId = null;
            for (LaborUintInfo laboruint2 : treeColl) {
                laborUnitID = laboruint2.getId().toString();
                if (rootTreeNode == null) {
                    rootTreeNode = new DefaultKingdeeTreeNode((Object)laboruint2);
                    rootTreeNode.setCustomIcon(groupIcon);
                    nodeMap.put(laborUnitID, rootTreeNode);
                    String rootKeyId = oldDSessionId + "LaborUnitTreeRootNode";
                    if (nodeCache.get(rootKeyId) != null) {
                        nodeCache.remove(rootKeyId);
                    }
                    nodeCache.put(rootKeyId, laborUnitID);
                    continue;
                }
                subTreeNode = new DefaultKingdeeTreeNode((Object)laboruint2);
                subTreeNode.setCustomIcon(companyIcon);
                if (laboruint2.getParent() != null && nodeMap.containsKey(parentId = laboruint2.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(parentId)).add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(laborUnitID, subTreeNode);
            }
        }
        return nodeMap;
    }

    public static void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec) {
        LaborUintInfo laborUnit = null;
        DefaultKingdeeTreeNode childNode = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof LaborUintInfo) {
            int size = treeNode.getChildCount();
            for (int i = 0; i < size; ++i) {
                childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (childNode.getUserObject() instanceof LaborUintInfo) {
                    laborUnit = (LaborUintInfo)childNode.getUserObject();
                    laborUnit.setLevel(childNode.getLevel());
                    if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)childNode)) {
                        laborUnit.put("isEnable", new Boolean(false));
                    } else {
                        laborUnit.put("isEnable", new Boolean(true));
                    }
                    vec.add(laborUnit);
                }
                if (childNode.getChildCount() <= 0) continue;
                HRLaborUnitGroupReportUtil.getCellUserObjects(childNode, vec);
            }
        }
    }
}

