/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class HRPartyClientUtils {
    public static final String pubResource = "com.kingdee.eas.hr.party.PartyResource";

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = HRPartyClientUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || HRPartyClientUtils.isTableColumnSelected(table)) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"118_SelectEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"118_SelectEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        table.removeRow(top);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection != null && detailData != null) {
            collection.removeObject(top);
        }
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(new Integer(j));
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(new Integer(j));
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        HRPartyClientUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtName) {
        HRPartyClientUtils.verifyEmpty(ui, null, txtName, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker date) {
        HRPartyClientUtils.verifyEmpty(ui, null, date, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea textAreacontent) {
        HRPartyClientUtils.verifyEmpty(ui, null, textAreacontent, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntrys) {
        if (kdtEntrys == null || kdtEntrys.getRowCount() <= 0) {
            MsgBox.showInfo((Component)ui, (String)(EASResource.getString((String)pubResource, (String)"entrys") + EASResource.getString((String)pubResource, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
    }

    public static void checkFullWidthBlank(String number) {
        boolean checked = false;
        if (number != null && (checked = HRPartyClientUtils.checkFull_width(number))) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"BillNumber_Not_Null"));
            SysUtil.abort();
        }
    }

    public static boolean checkFull_width(String number) {
        boolean checked = false;
        byte[] bytes = number.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != -95) continue;
            bytes[i] = 32;
        }
        number = new String(bytes).trim();
        if (number.trim().equals("") || number == null) {
            checked = true;
        }
        return checked;
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        HRPartyClientUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtName, String msg) {
        Object txt = txtName.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtName.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)txtName)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)txtNumber)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker date, String msg) {
        Object content = date.getValue();
        if (content == null) {
            date.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)date)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTimePicker time, String msg) {
        Object content = time.getValue();
        if (content == null) {
            time.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)time)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)bizBox)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea textArea, String msg) {
        if (!textArea.isEnabled()) {
            return;
        }
        String content = textArea.getText();
        if (content == null || content.toString().trim().equals("")) {
            textArea.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRPartyClientUtils.getMessage((Component)textArea)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = HRPartyClientUtils.getBoundLabelText(component);
        return text + EASResource.getString((String)pubResource, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[+\\-]?\\d+(.\\d+)?");
        return pattern.matcher(str).matches();
    }

    public static int idListIndexOf(String personId, List idList) {
        int index = -1;
        if (idList != null) {
            for (int i = 0; i < idList.size(); ++i) {
                if (!personId.equals((String)idList.get(i))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static IRowSet query(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        IRowSet dataRows = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        return dataRows;
    }

    public static String metaQueryToSQL(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        String sql = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        sql = iqec.getSQL();
        return sql;
    }

    public static PartyGroupEmployeeF7PromptBox initPersonF7(FilterItemInfo filterItem) {
        PartyGroupEmployeeF7PromptBox memberF7 = null;
        memberF7 = new PartyGroupEmployeeF7PromptBox();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("QUERY_BASE", "com.kingdee.eas.hr.party.app.PartyGroupF7Query");
        map.put("QUERY_BY_HR", "com.kingdee.eas.hr.party.app.PartyGroupF7ByHRQuery");
        map.put("QUERY_BY_ALL_ADMIN", "com.kingdee.eas.hr.party.app.PartyGroupF7ByAllAdminQuery");
        map.put("QUERY_BY_NEW", "com.kingdee.eas.hr.party.app.PartyGroupF7Query");
        map.put("QUERY_BY_OLD", "com.kingdee.eas.hr.party.app.PartyGroupF7OldQuery");
        map.put("QUERY_FOR_NO_POSITION_NEW", "com.kingdee.eas.hr.party.app.PartyGroupF7NoPosition2NewQuery");
        map.put("QUERY_FOR_NO_POSITION", "com.kingdee.eas.hr.party.app.PartyGroupF7NoPosition2Query");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem);
        map.put("PARTY_GROUP_FILTER", (String)filter);
        memberF7.setPartyGroupProperties(map);
        memberF7.setIsSingleSelect(false);
        memberF7.setUserOrgRangeFilter(true);
        memberF7.setEnabledMultiSelection(true);
        memberF7.showNoPositionPerson(true);
        memberF7.setNopositionPersonFilter(filter);
        try {
            memberF7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return memberF7;
    }

    public static PartyGroupEmployeeF7PromptBox initPersonF7(FilterInfo filter) {
        PartyGroupEmployeeF7PromptBox memberF7 = null;
        memberF7 = new PartyGroupEmployeeF7PromptBox();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("QUERY_BASE", "com.kingdee.eas.hr.party.app.PartyGroupF7Query");
        map.put("QUERY_BY_HR", "com.kingdee.eas.hr.party.app.PartyGroupF7ByHRQuery");
        map.put("QUERY_BY_ALL_ADMIN", "com.kingdee.eas.hr.party.app.PartyGroupF7ByAllAdminQuery");
        map.put("QUERY_BY_NEW", "com.kingdee.eas.hr.party.app.PartyGroupF7Query");
        map.put("QUERY_BY_OLD", "com.kingdee.eas.hr.party.app.PartyGroupF7OldQuery");
        map.put("QUERY_FOR_NO_POSITION_NEW", "com.kingdee.eas.hr.party.app.PartyGroupF7NoPosition2NewQuery");
        map.put("QUERY_FOR_NO_POSITION", "com.kingdee.eas.hr.party.app.PartyGroupF7NoPosition2Query");
        map.put("PARTY_GROUP_FILTER", (String)filter);
        memberF7.setPartyGroupProperties(map);
        memberF7.setIsSingleSelect(false);
        memberF7.setUserOrgRangeFilter(true);
        memberF7.setEnabledMultiSelection(true);
        memberF7.showNoPositionPerson(true);
        memberF7.setNopositionPersonFilter(filter);
        try {
            memberF7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return memberF7;
    }

    public static void checkPersonDup(CoreUIObject ui, KDTable kdtEntrys, String personKey) {
        for (int x = 0; x < kdtEntrys.getRowCount(); ++x) {
            for (int y = x + 1; y < kdtEntrys.getRowCount(); ++y) {
                PersonInfo pInfo2;
                PersonInfo pInfo1 = (PersonInfo)kdtEntrys.getRow(x).getCell(personKey).getValue();
                if (!pInfo1.equals((Object)(pInfo2 = (PersonInfo)kdtEntrys.getRow(y).getCell(personKey).getValue()))) continue;
                MsgBox.showInfo((Component)ui, (String)(EASResource.getString((String)pubResource, (String)"several") + (x + 1) + EASResource.getString((String)pubResource, (String)"row") + EASResource.getString((String)pubResource, (String)"and") + EASResource.getString((String)pubResource, (String)"several") + (y + 1) + EASResource.getString((String)pubResource, (String)"row") + EASResource.getString((String)pubResource, (String)"personExist")));
                SysUtil.abort();
            }
        }
    }

    public static void verifyEntryEmpty(KDTable kdtEntrys, String[] entryKeys) {
        int rowCount = kdtEntrys.getRowCount();
        int keyCount = entryKeys.length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < keyCount; ++j) {
                if (kdtEntrys.getRow(i).getCell(entryKeys[j]).getValue() != null && !kdtEntrys.getRow(i).getCell(entryKeys[j]).getValue().toString().equals("")) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)pubResource, (String)"several") + (i + 1) + EASResource.getString((String)pubResource, (String)"row") + HRPartyClientUtils.getColumnAlias(kdtEntrys, entryKeys[j]) + EASResource.getString((String)pubResource, (String)"CanNotBeNull")));
                kdtEntrys.getSelectManager().select(i, kdtEntrys.getColumnIndex(entryKeys[j]));
                SysUtil.abort();
            }
        }
    }

    public static String getColumnAlias(KDTable kdt, String colName) {
        Object value = kdt.getHeadRow(0).getCell(colName).getValue();
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static void moveRows(CoreUIObject ui, KDTable kdtEntrys, boolean isUp) {
        HRPartyClientUtils.checkSelect(ui, kdtEntrys);
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)kdtEntrys);
        KDTSelectBlock block = kdtEntrys.getSelectManager().get(0);
        int top = block.getBeginRow();
        int bottom = block.getEndRow();
        ArrayList<IRow> rowList = new ArrayList<IRow>();
        if (isUp && top > 0 || !isUp && bottom < kdtEntrys.getRowCount() - 1) {
            for (int i = bottom; i >= top; --i) {
                rowList.add(kdtEntrys.getRow(i));
                kdtEntrys.removeRow(i);
            }
            if (isUp) {
                --top;
                --bottom;
            } else {
                ++top;
                ++bottom;
            }
            int index = top;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                kdtEntrys.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
        }
        kdtEntrys.getSelectManager().select(top, 0, bottom, 0);
    }

    private static void checkSelect(CoreUIObject ui, KDTable kdtEntrys) {
        ArrayList blocks;
        if (kdtEntrys.getRowCount() == 0 || kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)pubResource, (String)"Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((blocks = kdtEntrys.getSelectManager().getBlocks()) == null) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)pubResource, (String)"Msg_MustSelected"));
            SysUtil.abort();
        }
        if (blocks.size() > 1) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)pubResource, (String)"SelectContinuously"));
            SysUtil.abort();
        }
    }

    public static AdminOrgUnitInfo getNoPositionAdmin(String pID) throws Exception {
        HashSet<String> selectPersonSet = new HashSet<String>();
        selectPersonSet = new HashSet();
        selectPersonSet.add(pID);
        IRowSet rows = BaseInnerFacadeFactory.getRemoteInstance().getSelectPersonRowSet("com.kingdee.eas.hr.emp.app.EmployeeF7SelectQuery", selectPersonSet);
        AdminOrgUnitInfo adminInfo = null;
        while (rows.next()) {
            if (rows.getString("GKAdmin.id") == null) continue;
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rows.getString("GKAdmin.id")));
            adminInfo.setNumber(rows.getString("GKAdmin.number"));
            adminInfo.setName(rows.getString("GKAdmin.name"));
            adminInfo.setLevel(rows.getInt("GKAdmin.level"));
            adminInfo.setLongNumber(rows.getString("GKAdmin.longNumber"));
            adminInfo.setDisplayName(rows.getString("GKAdmin.displayName"));
        }
        return adminInfo;
    }

    public static FilterInfo getAdminRangeFilter(String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String sql = HRPartyClientUtils.getAdminRangeSQL(userID);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAdminRangeSQL(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static void setDateFormat(KDTable kdtEntrys, String[] dateKey) {
        for (int i = 0; i < dateKey.length; ++i) {
            for (int j = 0; j < kdtEntrys.getRowCount(); ++j) {
                Date oldDate = (Date)kdtEntrys.getRow(j).getCell(dateKey[i]).getValue();
                Date newDate = DateTimeUtils.truncateDate((Date)oldDate);
                kdtEntrys.getRow(j).getCell(dateKey[i]).setValue((Object)newDate);
            }
        }
    }
}

