/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.ILaborUnionMember;
import com.kingdee.eas.hr.party.LaborUnionActivityFactory;
import com.kingdee.eas.hr.party.LaborUnionActivityInfo;
import com.kingdee.eas.hr.party.LaborUnionMemberCollection;
import com.kingdee.eas.hr.party.LaborUnionMemberFactory;
import com.kingdee.eas.hr.party.LaborUnionMemberInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionActivityEditUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.LaborUnitPromptBox;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.party.client.PartyPrint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class LaborUnionActivityEditUI
extends AbstractLaborUnionActivityEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionActivityEditUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private static String partyPrintID = null;
    private static String printParth = "/HR/state/party/LaborUnionActivityBill";
    private static String queryName = "LaborUnionActivityPrintQuery";
    private static String entryQueryName = "LaborUnionActivityEntryPrintQuery";
    private static String queryParth = "com.kingdee.eas.hr.party.app";
    private static String entryID = "bill.id";
    private LaborUnitPromptBox laborUnitF7 = null;
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;

    public LaborUnionActivityEditUI() throws Exception {
        this.removeBelongUnitSelectorListener();
        this.initLaborUnitF7();
    }

    private void removeBelongUnitSelectorListener() {
        SelectorListener[] listeners = this.prmtbelongUnit.getSelectorListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.prmtbelongUnit.removeSelectorListener(listeners[i]);
        }
    }

    protected IObjectValue createNewData() {
        LaborUnionActivityInfo value = new LaborUnionActivityInfo();
        value.setCost(new BigDecimal(0));
        return value;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LaborUnionActivityFactory.getRemoteInstance();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.kdcEntry.addButton((JButton)this.btnAddLine);
        this.kdcEntry.addButton((JButton)this.btnInsertLine);
        this.kdcEntry.addButton((JButton)this.btnRemoveLine);
        this.kdcEntry.addButton((JButton)this.btnASC);
        this.kdcEntry.addButton((JButton)this.btnDESC);
        this.initF7();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.txtCost.setPrecision(2);
        this.txtCost.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.txtCost.setMinimumValue((Comparable)new BigDecimal(0));
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
        this.btnBatchPrint.setVisible(true);
        this.btnBatchPrint.setEnabled(true);
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.MenuItemBatchPrint.setVisible(true);
        this.MenuItemBatchPrint.setEnabled(true);
        this.kdtEntry.getSelectManager().setSelectMode(10);
        this.prmtAdminOrg.setEditable(false);
    }

    protected void initLaborUnitF7() {
        if (this.laborUnitF7 == null) {
            this.laborUnitF7 = new LaborUnitPromptBox();
            this.laborUnitF7.setIsSingleSelected(true);
            this.laborUnitF7.setIsUsePermission(true);
        }
    }

    private void initF7() {
        this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("LaborUnionMember.checkInDate", null, CompareType.ISNOT));
        this.memberF7.setIsShowAllAdmin(true);
        AdminByOrgRangePromptBox adminF7 = new AdminByOrgRangePromptBox();
        adminF7.showChkSealUp(true);
        adminF7.setIncludeSealUp("false");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminF7);
    }

    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByF7(false);
    }

    private void addLineByF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
        this.refreshSeq();
    }

    private void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        if (persons != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntry.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntry.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntry);
            }
            IRow row = null;
            PersonInfo person = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                person = (PersonInfo)persons.get(i);
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntry.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntry.addRow();
                }
                this.addLineByPerson(this.kdtEntry, row, person);
            }
        }
        this.refreshSeq();
    }

    private void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws Exception {
        if (table == null || pInfo == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        ILaborUnionMember iLaborUnionMember = LaborUnionMemberFactory.getRemoteInstance();
        LaborUnionMemberCollection coll = iLaborUnionMember.getLaborUnionMemberCollection(view);
        LaborUnionMemberInfo memberInfo = null;
        if (coll != null && coll.size() == 1) {
            memberInfo = coll.get(0);
        }
        row.getCell("name").setValue((Object)pInfo);
        row.getCell("empNumber").setValue((Object)pInfo.getNumber());
        if (pInfo.get("primaryAdminOrg") != null) {
            row.getCell("adminOrg").setValue(pInfo.get("primaryAdminOrg"));
        } else {
            row.getCell("adminOrg").setValue((Object)HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
        }
        if (memberInfo != null) {
            row.getCell("number").setValue((Object)memberInfo.getNumber());
            row.getCell("member").setValue((Object)memberInfo);
        }
        this.refreshSeq();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void btnASC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntry) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntry, true);
        }
        this.refreshSeq();
    }

    protected void btnDESC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntry) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntry, false);
        }
        this.refreshSeq();
    }

    protected void btnInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByF7(true);
        this.refreshSeq();
    }

    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        HRPartyClientUtils.removeLine(this.kdtEntry);
        this.refreshSeq();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.verify();
        super.beforeStoreFields(e);
    }

    private void verify() {
        Date endDate;
        Date startDate;
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtTopic);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtType);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkBeginDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.kdtEntry);
        HRPartyClientUtils.verifyEntryEmpty(this.kdtEntry, new String[]{"name"});
        if (this.txtCost.getText() == null || this.txtCost.getText().trim().equals("")) {
            this.txtCost.requestFocus(true);
            MsgBox.showInfo((Component)((Object)this), (String)(((KDLabelContainer)this.txtCost.getParent()).getBoundLabelText() + EASResource.getString((String)resClassName, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        HRPartyClientUtils.checkPersonDup((CoreUIObject)this, this.kdtEntry, "name");
        if (this.pkBeginDate.getValue() != null && this.pkEndDate.getValue() != null && (startDate = (Date)this.pkBeginDate.getValue()).after(endDate = (Date)this.pkEndDate.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"StartDateBeforeEndDate"));
            SysUtil.abort();
        }
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.btnAddLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnDESC.setEnabled(false);
            this.btnASC.setEnabled(false);
        } else {
            this.btnAddLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnDESC.setEnabled(true);
            this.btnASC.setEnabled(true);
        }
    }

    public void loadFields() {
        this.prmtbelongUnit.setSelector((KDPromptSelector)this.laborUnitF7);
        this.kdtEntry.checkParsed();
        this.kdtEntry.removeRows();
        if (this.editData.getEntry() != null) {
            block0: for (int i = 0; i < this.editData.getEntry().size(); ++i) {
                for (int j = i; j < this.editData.getEntry().size(); ++j) {
                    if (this.editData.getEntry().get(j).getSeq() - 1 != i) continue;
                    this.editData.getEntry().move(j, i - 1);
                    continue block0;
                }
            }
        }
        super.loadFields();
    }

    public void actionBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void MenuItemBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void refreshSeq() {
        if (this.kdtEntry != null) {
            int row = this.kdtEntry.getRowCount();
            for (int i = 0; i < row; ++i) {
                this.kdtEntry.getCell(i, 0).setValue((Object)String.valueOf(i + 1));
            }
        }
    }
}

