/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.party.ActivityTypeCollection;
import com.kingdee.eas.hr.party.ActivityTypeFactory;
import com.kingdee.eas.hr.party.ActivityTypeInfo;
import com.kingdee.eas.hr.party.IActivityType;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionActivityStatListUI;
import com.kingdee.eas.hr.party.client.HRLaborUnitGroupReportUtil;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.LaborUnionActivityStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LaborUnionActivityStatListUI
extends AbstractLaborUnionActivityStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionActivityStatListUI.class);
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.LaborUnionActivityStatFilterUI";
    private static final String COLUMN_NAME_TREECOLUMN = "latitude";
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.party.app";
    private static final String QUERY_NAME = "LaborUnionActivityStatCountTimesQuery";
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private HashMap headIDMap;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN).setWidth(200);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((LaborUnionActivityStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
            Iterator iterator = this.statusMap.entrySet().iterator();
            while (iterator.hasNext()) {
                logger.debug((Object)("+++++++++++++++++" + iterator.next() + "+++++++++++++++++"));
            }
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            LaborUnionActivityStatFilterUI filterUI = new LaborUnionActivityStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadData();
    }

    private void resetTable() {
        this.tblMain.removeRows();
        int count = this.tblMain.getColumnCount();
        for (int i = count - 1; i > this.tblMain.getColumnIndex(COLUMN_NAME_TREECOLUMN); --i) {
            this.tblMain.removeColumn(i);
        }
    }

    private void loadData() {
        this.resetTable();
        try {
            this.initTableHead();
        }
        catch (BOSException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"TableHeadInitError"));
            SysUtil.abort();
        }
        try {
            this.initLatitude();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"LatitudeInitError"));
            SysUtil.abort();
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        try {
            this.initData();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DataInitError"));
            SysUtil.abort();
        }
        HRPartyGroupReportUtil.sumUpOnTree(this.tblMain, COLUMN_NAME_TREECOLUMN, null);
    }

    private void initTableHead() throws BOSException {
        this.headIDMap = new HashMap();
        KDTMergeManager manager = this.tblMain.getHeadMergeManager();
        manager.mergeBlock(0, 0, 1, 0);
        IActivityType iActivityType = ActivityTypeFactory.getRemoteInstance();
        ActivityTypeCollection coll = iActivityType.getActivityTypeCollection();
        if (coll != null && coll.size() > 0) {
            IColumn col = null;
            ActivityTypeInfo atInfo = null;
            int baseColIndex = this.tblMain.getColumnCount();
            for (int i = 0; i < coll.size(); ++i) {
                col = this.tblMain.addColumn();
                atInfo = coll.get(i);
                this.headIDMap.put(atInfo.getId().toString(), new Integer(col.getColumnIndex()));
                manager.mergeBlock(0, baseColIndex, 0, baseColIndex + i);
                manager.mergeBlock(1, baseColIndex + i, 1, baseColIndex + i);
                this.tblMain.getHead().getRow(1).getCell(baseColIndex + i).setValue((Object)atInfo.getName());
            }
            this.tblMain.getHead().getRow(0).getCell(baseColIndex).setValue((Object)EASResource.getString((String)RES, (String)"activityTimes"));
        }
    }

    private void initLatitude() throws Exception {
        this.latitudeIDMap = new HashMap();
        Vector<LaborUintInfo> vec = new Vector<LaborUintInfo>();
        IRow row = null;
        LaborUintInfo info = null;
        DefaultKingdeeTreeNode rootNode = HRLaborUnitGroupReportUtil.getLaborUnitTreeNode((Boolean)this.statusMap.get("showCancel"), (String)this.statusMap.get("belongUnitId"));
        if (rootNode == null) {
            return;
        }
        LaborUintInfo rootInfo = (LaborUintInfo)rootNode.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootInfo.put("isEnable", new Boolean(false));
        } else {
            rootInfo.put("isEnable", new Boolean(true));
        }
        rootInfo.setLevel(rootNode.getLevel());
        vec.add(rootInfo);
        HRLaborUnitGroupReportUtil.getCellUserObjects(rootNode, vec);
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        int initLevel = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            info = (LaborUintInfo)vec.get(i);
            if (i == 0) {
                initLevel = info.getLevel();
            }
            row = this.tblMain.addRow(i);
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(info.getId().toString());
            orgCellObj.setName(info.getName());
            orgCellObj.setLongNumber(info.getLongNumber());
            orgCellObj.setIsLeaf(info.isIsLeaf());
            orgCellObj.setLevel(info.getLevel() - initLevel);
            orgCellObj.setExpanded(true);
            this.latitudeIDMap.put(info.getId().toString(), new Integer(row.getRowIndex()));
            row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
            row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
        }
    }

    private void initData() throws Exception {
        this.setDataOnTable(this.getData());
    }

    private IRowSet getData() throws BOSException {
        IRowSet dataRows = null;
        dataRows = HRPartyGroupReportUtil.query(this.mainQuery, QUERY_PATH, QUERY_NAME);
        return dataRows;
    }

    private void setDataOnTable(IRowSet dataRows) throws SQLException {
        int colIndex = -1;
        int rowIndex = -1;
        while (dataRows.next()) {
            if (this.headIDMap.get(dataRows.getString("TYPE.ID")) == null || this.latitudeIDMap.get(dataRows.getString("BELONGUNIT.ID")) == null) continue;
            colIndex = (Integer)this.headIDMap.get(dataRows.getString("TYPE.ID"));
            rowIndex = (Integer)this.latitudeIDMap.get(dataRows.getString("BELONGUNIT.ID"));
            this.tblMain.getCell(rowIndex, colIndex).setValue(dataRows.getObject("COUNTTIMES"));
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new LaborUnionActivityStatFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_TREECOLUMN;
    }
}

