/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionMemberStatListUI;
import com.kingdee.eas.hr.party.client.HRLaborUnitGroupReportUtil;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.LaborUnionMemberStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LaborUnionMemberStatListUI
extends AbstractLaborUnionMemberStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionMemberStatListUI.class);
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.LaborUnionMemberStatFilterUI";
    private static final String COLUMN_NAME_TREECOLUMN = "adminOrg";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.party.app";
    private static final String QUERY_NAME = "LaborUnionMemberStatCountPersonQuery";

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((LaborUnionMemberStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            Iterator iterator = this.statusMap.entrySet().iterator();
            while (iterator.hasNext()) {
                logger.debug((Object)("=====================" + iterator.next() + "+++++++++++++++++"));
            }
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            LaborUnionMemberStatFilterUI filterUI = new LaborUnionMemberStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadData();
    }

    private void loadData() {
        this.resetTable();
        try {
            this.initLatitude();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"LatitudeInitError"));
            SysUtil.abort();
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        try {
            this.initData();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DataInitError"));
            SysUtil.abort();
        }
        HRPartyGroupReportUtil.sumUpOnTree(this.tblMain, COLUMN_NAME_TREECOLUMN, null);
    }

    private void initLatitude() throws Exception {
        this.latitudeIDMap = new HashMap();
        Vector<LaborUintInfo> vec = new Vector<LaborUintInfo>();
        IRow row = null;
        LaborUintInfo info = null;
        DefaultKingdeeTreeNode rootNode = HRLaborUnitGroupReportUtil.getLaborUnitTreeNode((Boolean)this.statusMap.get("showCancel"), (String)this.statusMap.get("belongUintId"));
        if (rootNode == null) {
            return;
        }
        LaborUintInfo rootInfo = (LaborUintInfo)rootNode.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootInfo.put("isEnable", new Boolean(false));
        } else {
            rootInfo.put("isEnable", new Boolean(true));
        }
        rootInfo.setLevel(rootNode.getLevel());
        vec.add(rootInfo);
        HRLaborUnitGroupReportUtil.getCellUserObjects(rootNode, vec);
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        int initLevel = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            info = (LaborUintInfo)vec.get(i);
            if (i == 0) {
                initLevel = info.getLevel();
            }
            row = this.tblMain.addRow(i);
            if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(info.getId().toString());
            orgCellObj.setName(info.getName());
            orgCellObj.setLongNumber(info.getLongNumber());
            orgCellObj.setIsLeaf(info.isIsLeaf());
            orgCellObj.setLevel(info.getLevel() - initLevel);
            orgCellObj.setExpanded(true);
            this.latitudeIDMap.put(info.getId().toString(), new Integer(row.getRowIndex()));
            row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
            row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
        }
    }

    private void initData() throws Exception {
        this.setDataOnTable(this.getCheckInPersonsData(), "checkInPerson");
        this.setDataOnTable(this.getCheckOutPersonsData(), "checkOutPerson");
    }

    private IRowSet getPersonsData(EntityViewInfo view) throws BOSException {
        IRowSet dataRows = null;
        String subSQL = HRPartyGroupReportUtil.metaQueryToSQL(view, QUERY_PATH, QUERY_NAME);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll("BELONGUNIT.ID", "BELONGUNITID");
        queryStr.append("SELECT BELONGUNITID,COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n) AS T GROUP BY BELONGUNITID");
        dataRows = HRPartyGroupReportUtil.query(queryStr.toString());
        logger.debug((Object)("sql:=============" + subSQL));
        return dataRows;
    }

    private IRowSet getCheckInPersonsData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkInDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkInDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        dataRows = this.getPersonsData(view);
        return dataRows;
    }

    private void setDataOnTable(IRowSet dataRows, String colName) throws SQLException {
        if (dataRows != null) {
            while (dataRows.next()) {
                if (dataRows.getString("BELONGUNITID") == null || this.latitudeIDMap.get(dataRows.getString("BELONGUNITID")) == null) continue;
                this.tblMain.getRow(((Integer)this.latitudeIDMap.get(dataRows.getString("BELONGUNITID"))).intValue()).getCell(colName).setValue((Object)new Integer(dataRows.getInt("COUNTPERSONS")));
            }
        }
    }

    private IRowSet getCheckOutPersonsData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkOutDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkOutDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        dataRows = this.getPersonsData(view);
        return dataRows;
    }

    private void refreshData() {
        this.loadData();
    }

    private void resetTable() {
        this.tblMain.removeRows();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN).setWidth(200);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new LaborUnionMemberStatFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_TREECOLUMN;
    }
}

