/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemActivityFilterUI;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;

public class MemActivityFilterUI
extends AbstractMemActivityFilterUI {
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    protected MemOrgPromptBox memOrgF7 = null;

    public MemActivityFilterUI() throws Exception {
        this.cbIsSealUp.setVisible(false);
        this.initMemOrgF7();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
    }

    public void initMemOrgF7() {
        if (this.memOrgF7 == null) {
            this.memOrgF7 = new MemOrgPromptBox();
            this.memOrgF7.setIsSingleSelected(true);
            this.memOrgF7.setIsUsePermission(true);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.cbIsSealUp.setSelected(false);
        this.cbIsSealUp.setEnabled(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)this.memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtmemOrg.setValue(null);
        this.cbIsSealUp.setSelected(false);
        this.cbIsSealUp.setEnabled(true);
        this.pkDateEnd.setValue(null);
        this.pkDateStart.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtmemOrg.getData() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)memOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(memOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            try {
                filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
                filterInfo.setMaskString("(#0 or #1) and #2");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (!this.cbIsSealUp.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
        }
        this.setDateFilter(filterInfo);
        return filterInfo;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.pkDateStart.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.pkDateStart.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.pkDateEnd.getValue()), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        cp.putBoolean("isSealed", this.cbIsSealUp.isSelected());
        cp.putDate("beginDate", (Date)this.pkDateStart.getValue());
        cp.putDate("endDate", (Date)this.pkDateEnd.getValue());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("memOrgId") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("memOrgId")));
            try {
                this.prmtmemOrg.setValue((Object)MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.cbIsSealUp.setSelected(cp.getBoolean("isSealed"));
        this.pkDateStart.setValue((Object)cp.getDate("beginDate"));
        this.pkDateEnd.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        Date endDate;
        Date startDate;
        if (this.prmtmemOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"memOrgNotNull"));
            return false;
        }
        if (this.pkDateStart.getValue() != null && this.pkDateEnd.getValue() != null && (startDate = (Date)this.pkDateStart.getValue()).after(endDate = (Date)this.pkDateEnd.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"StartDateBeforeEndDate"));
            return false;
        }
        return true;
    }
}

