/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemChaBillFilterUI;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemChaBillFilterUI
extends AbstractMemChaBillFilterUI {
    private IMetaDataPK metaDataPKForPemmission;
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";

    public MemChaBillFilterUI() throws Exception {
        this.cbViewClosed.setVisible(false);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrg);
        this.prmtAdminOrg.setEditable(true);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsSingleSelected(true);
        memOrgF7.setIsUsePermission(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtmemOrg.setValue(null);
        this.cbViewClosed.setSelected(false);
        this.cbViewClosed.setEnabled(true);
    }

    public void setMetaDataPKForPemmissionByPath(String metaDataPath) {
        if (!StringUtils.isEmpty((String)metaDataPath)) {
            this.metaDataPKForPemmission = new MetaDataPK(metaDataPath);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.cbViewClosed.setEnabled(true);
        this.cbViewClosed.setSelected(false);
        this.prmtHROrg.setEditable(false);
        this.prmtAdminOrg.setEditable(false);
        this.cbInclude.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MemChaBillFilterUI.this.setBoxIsSealUp();
            }
        });
    }

    protected void setBoxIsSealUp() {
        if (this.cbInclude.isSelected()) {
            this.cbViewClosed.setEnabled(true);
        } else {
            this.cbViewClosed.setEnabled(false);
            this.cbViewClosed.setSelected(false);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtmemOrg.getData() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)memOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(memOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            try {
                filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
                filterInfo.setMaskString("(#0 or #1) and #2");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (!this.cbViewClosed.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtHROrg.getValue() != null) {
            HROrgUnitInfo info = (HROrgUnitInfo)this.prmtHROrg.getValue();
            cp.addCustomerParam("HrId", info.getId().toString());
        }
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        cp.putBoolean("isSealed", this.cbViewClosed.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("HrId") != null) {
            String HrId = cp.getCustomerParam("HrId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)HrId));
            HROrgUnitInfo HROrg = null;
            try {
                HROrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtHROrg.setValue((Object)HROrg);
        }
        if (cp.getCustomerParam("memOrgId") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("memOrgId")));
            try {
                this.prmtmemOrg.setValue((Object)MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.cbViewClosed.setSelected(cp.getBoolean("isSealed"));
    }

    public boolean verify() {
        if (this.prmtmemOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"memOrgNotNull"));
            return false;
        }
        return true;
    }
}

