/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.MemOrgBillInsideJobCollection;
import com.kingdee.eas.hr.party.MemOrgChartNodeInfo;
import com.kingdee.eas.hr.party.client.AbstractMemOrgChartUI;
import com.kingdee.eas.hr.party.client.DrawMemOrg;
import com.kingdee.eas.hr.party.client.PartyUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MemOrgChartUI
extends AbstractMemOrgChartUI {
    private static final Logger logger = CoreUIObject.getLogger(MemOrgChartUI.class);
    private DrawMemOrg drawMemOrg = null;
    private boolean isRefresh = false;
    private int level = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.buildTree();
        this.getSelectNodeLevel();
    }

    private void buildTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(treeSelectionListener);
        ITreeBuilder treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)100, (int)100, (FilterInfo)this.getDefaultFilter(), null);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.treeMain.setSelectionRow(0);
        this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return MemOrgBillFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilter() throws ParserException {
        FilterInfo cancelFilter = new FilterInfo("isCancel = 0");
        return cancelFilter;
    }

    public static DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    private void getChildrenNodes(DefaultKingdeeTreeNode parent, DefaultMutableTreeNode root) {
        if (parent.getUserObject() instanceof MemOrgBillInfo) {
            MemOrgBillInsideJobCollection insideJobs;
            MemOrgBillInfo memOrg = (MemOrgBillInfo)parent.getUserObject();
            MemOrgChartNodeInfo nodeInfo = new MemOrgChartNodeInfo();
            nodeInfo.ID = memOrg.getId().toString();
            nodeInfo.name = memOrg.getName();
            nodeInfo.number = memOrg.getNumber();
            nodeInfo.level = memOrg.getLevel();
            nodeInfo.insideJobs = insideJobs = memOrg.getInsideJob();
            if (!PartyUtils.isTreeNodeDisable(parent) && memOrg.get("CAN_VIEW") != null) {
                nodeInfo.canView = true;
            }
            root.setUserObject(nodeInfo);
            DefaultMutableTreeNode child = null;
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                child = new DefaultMutableTreeNode();
                this.getChildrenNodes((DefaultKingdeeTreeNode)parent.getChildAt(i), child);
                root.add(child);
            }
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        DefaultKingdeeTreeNode selectNode = MemOrgChartUI.getSelectTreeNode(this.treeMain);
        if (selectNode == null) {
            return;
        }
        this.getChildrenNodes(selectNode, (DefaultMutableTreeNode)root);
        if (this.drawMemOrg == null) {
            this.drawMemOrg = new DrawMemOrg(this.getWidth(), this.getHeight(), (DefaultMutableTreeNode)root, this.level);
            this.drawMemOrg.setUserComponents(null);
        } else {
            this.drawMemOrg.setRootNode((DefaultMutableTreeNode)root);
        }
        if (this.isRefresh) {
            this.drawMemOrg.clearCacheData();
        }
        this.pnlMain.setDividerLocation(240);
        this.pnlMain.add((Component)((Object)this.drawMemOrg), (Object)"right");
        this.pnlMain.revalidate();
    }

    private void getSelectNodeLevel() {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            this.level = treeBaseInfo.getLevel();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isRefresh = true;
        this.buildTree();
        this.isRefresh = false;
    }
}

