/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.IMemberPaymentBase;
import com.kingdee.eas.hr.party.MemberPaymentBaseCollection;
import com.kingdee.eas.hr.party.MemberPaymentBaseFactory;
import com.kingdee.eas.hr.party.MemberPaymentBaseInfo;
import com.kingdee.eas.hr.party.client.AbstractMemOrgPaymentBaseUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MemOrgPaymentBaseUI
extends AbstractMemOrgPaymentBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(MemOrgPaymentBaseUI.class);
    protected AdminByOrgRangePromptBox adminF7 = null;
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private boolean isEditStatus = false;
    private HashSet deleteIds = new HashSet();
    private MemberPaymentBaseCollection memberPaymentBaseCollection = null;
    private MemberPaymentBaseCollection newPaymentBaseColl = null;

    public MemOrgPaymentBaseUI() throws Exception {
        this.initEmpF7();
        this.adminF7 = new AdminByOrgRangePromptBox();
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setCellEditor();
        this.prmtAdminOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MemOrgPaymentBaseUI.this.prmtAdminOrgUnit_dataChanged();
            }
        });
        this.memberPaymentBaseCollection = this.getMemOrgPaymentBaseCollection();
    }

    private void setCellEditor() {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setNumberFormat("0.00");
        KDFormattedTextField kdtEntrys_formatted_TextField = new KDFormattedTextField();
        kdtEntrys_formatted_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_formatted_TextField.setVisible(true);
        kdtEntrys_formatted_TextField.setEditable(true);
        kdtEntrys_formatted_TextField.setDataType(1);
        kdtEntrys_formatted_TextField.setPrecision(2);
        kdtEntrys_formatted_TextField.setDataVerifierType(12);
        kdtEntrys_formatted_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_formatted_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_formatted_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_formatted_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_formatted_TextField);
        this.kdtEntrys.getColumn("payBase").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payBase").getStyleAttributes().setNumberFormat("0.00");
        KDTextField kdtEntrys_description_TextField = new KDTextField();
        kdtEntrys_description_TextField.setName("kdtEntrys_description_TextField");
        kdtEntrys_description_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_description_TextField);
        this.kdtEntrys.getColumn("remark").setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
    }

    protected void loadMemOrgPaymentBaseInfos() throws Exception {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.removeRows();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getFilterInfo());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.*"));
        sic.add(new SelectorItemInfo("adminOrg.*"));
        view.setSelector(sic);
        this.memberPaymentBaseCollection = ((IMemberPaymentBase)this.getBizInterface()).getMemberPaymentBaseCollection(view);
        MemberPaymentBaseInfo memberPaymentBaseInfo = null;
        IRow row = null;
        Iterator it = this.memberPaymentBaseCollection.iterator();
        while (it.hasNext()) {
            memberPaymentBaseInfo = (MemberPaymentBaseInfo)it.next();
            row = this.kdtEntrys.addRow();
            this.kdtEntrys.getCell(row.getRowIndex(), "ID").setValue((Object)memberPaymentBaseInfo.getId().toString());
            this.kdtEntrys.getCell(row.getRowIndex(), "personNumber").setValue((Object)memberPaymentBaseInfo.getPerson().getNumber());
            this.kdtEntrys.getCell(row.getRowIndex(), "personName").setValue((Object)memberPaymentBaseInfo.getPerson());
            this.kdtEntrys.getCell(row.getRowIndex(), "adminOrg").setValue((Object)memberPaymentBaseInfo.getAdminOrg());
            if (memberPaymentBaseInfo.getImportData() != null) {
                this.kdtEntrys.getCell(row.getRowIndex(), "importData").setValue((Object)memberPaymentBaseInfo.getImportData());
            } else {
                this.kdtEntrys.getCell(row.getRowIndex(), "importData").setValue((Object)ZERO);
            }
            if (memberPaymentBaseInfo.getPayBase() != null) {
                this.kdtEntrys.getCell(row.getRowIndex(), "payBase").setValue((Object)memberPaymentBaseInfo.getPayBase());
            } else {
                this.kdtEntrys.getCell(row.getRowIndex(), "payBase").setValue((Object)ZERO);
            }
            this.kdtEntrys.getCell(row.getRowIndex(), "remark").setValue((Object)memberPaymentBaseInfo.getRemark());
        }
        this.memberPaymentBaseCollection = this.getMemOrgPaymentBaseCollection();
    }

    protected MemberPaymentBaseCollection getMemOrgPaymentBaseCollection() {
        MemberPaymentBaseCollection memberPaymentBaseColl = new MemberPaymentBaseCollection();
        MemberPaymentBaseInfo memberPaymentBaseInfo = null;
        IRow row = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            row = this.kdtEntrys.getRow(i);
            memberPaymentBaseInfo = new MemberPaymentBaseInfo();
            if (row.getCell("ID").getValue() != null) {
                memberPaymentBaseInfo.setId(BOSUuid.read((String)row.getCell("ID").getValue().toString()));
            }
            if (row.getCell("personName").getValue() != null) {
                memberPaymentBaseInfo.setPerson((PersonInfo)row.getCell("personName").getValue());
            }
            if (row.getCell("adminOrg").getValue() != null) {
                memberPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)row.getCell("adminOrg").getValue());
            }
            if (row.getCell("importData").getValue() != null) {
                memberPaymentBaseInfo.setImportData((BigDecimal)row.getCell("importData").getValue());
            }
            if (row.getCell("payBase").getValue() != null) {
                memberPaymentBaseInfo.setPayBase((BigDecimal)row.getCell("payBase").getValue());
            }
            if (row.getCell("remark").getValue() != null) {
                memberPaymentBaseInfo.setRemark(row.getCell("remark").getValue().toString());
            }
            memberPaymentBaseColl.add(memberPaymentBaseInfo);
        }
        return memberPaymentBaseColl;
    }

    private FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtAdminOrgUnit.getValue() != null) {
            AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)adminOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
        }
        return filterInfo;
    }

    private void loadTableRow(MemberPaymentBaseInfo memberPaymentBase, IRow detailRow) {
        if (detailRow == null) {
            detailRow = this.kdtEntrys.addRow();
        }
        if (memberPaymentBase.getId() != null) {
            this.kdtEntrys.getCell(detailRow.getRowIndex(), "ID").setValue((Object)memberPaymentBase.getId().toString());
        }
        PersonInfo pInfo = memberPaymentBase.getPerson();
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "personName").setValue((Object)pInfo);
        if (pInfo != null) {
            this.kdtEntrys.getCell(detailRow.getRowIndex(), "personNumber").setValue((Object)pInfo.getNumber());
        }
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "adminOrg").setValue((Object)memberPaymentBase.getAdminOrg());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "importData").setValue((Object)memberPaymentBase.getImportData());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "payBase").setValue((Object)memberPaymentBase.getPayBase());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "remark").setValue((Object)memberPaymentBase.getRemark());
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contEntrys.setTitle(EASResource.getString((String)resClassName, (String)"PartyPaymentBase"));
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)this.adminF7);
        this.prmtAdminOrgUnit.setEditable(false);
        this.btDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btDeleteLine.setText(null);
        this.btInsertLine.setText(null);
        this.btAddLine.setText(null);
        this.btnPrint.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.contEntrys.addButton((JButton)this.btAddLine);
        this.contEntrys.addButton((JButton)this.btInsertLine);
        this.contEntrys.addButton((JButton)this.btDeleteLine);
        this.changeEditStatus(false);
    }

    protected void changeEditStatus(boolean lbEditStatus) {
        this.isEditStatus = lbEditStatus;
        if (this.isEditStatus) {
            this.kdtEntrys.setEditable(true);
            this.btAddLine.setEnabled(true);
            this.btDeleteLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
            this.btnImport.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnEdit.setEnabled(false);
        } else {
            this.kdtEntrys.setEditable(false);
            this.btnEdit.setEnabled(true);
            this.btAddLine.setEnabled(false);
            this.btDeleteLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnPrint.setEnabled(true);
        }
    }

    protected void prmtAdminOrgUnit_dataChanged() {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE"));
            if (comfirm == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (comfirm == 2) {
                SysUtil.abort();
            }
        }
        try {
            this.loadMemOrgPaymentBaseInfos();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtEntrys)) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        int top = this.kdtEntrys.getSelectManager().get().getTop();
        if (this.kdtEntrys.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        IRow currentRow = this.kdtEntrys.getRow(top);
        ICell cell = currentRow.getCell("ID");
        if (cell.getValue() != null) {
            this.deleteIds.add(cell.getValue().toString());
        }
        this.kdtEntrys.removeRow(top);
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("memberInfor.joinDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            } else if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        if ((persons = this.getProcessedPersons(persons)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected List getProcessedPersons(List persons) throws Exception {
        ArrayList<PersonInfo> personsTemp = new ArrayList<PersonInfo>();
        for (int i = 0; i < persons.size(); ++i) {
            PersonInfo person = (PersonInfo)persons.get(i);
            if (this.findPersonsInTable(person.getNumber())) continue;
            personsTemp.add(person);
        }
        return personsTemp;
    }

    protected boolean findPersonsInTable(String findValus) {
        boolean lb_return = false;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            if (!this.kdtEntrys.getRow(i).getCell("personNumber").getValue().equals(findValus)) continue;
            lb_return = true;
            break;
        }
        return lb_return;
    }

    protected MemberPaymentBaseInfo findPersonsInDB(String personID) throws Exception {
        MemberPaymentBaseCollection memberPaymentBases = ((IMemberPaymentBase)this.getBizInterface()).getMemberPaymentBaseCollection("SELECT person.*, adminOrg.*, importData, payBase, remark WHERE person.id='" + personID + "'");
        if (memberPaymentBases != null && memberPaymentBases.size() > 0) {
            return memberPaymentBases.get(0);
        }
        return null;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected String getKeyFieldName() {
        return "adminOrg";
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        try {
            MemberPaymentBaseInfo memberPaymentBaseInfo = this.findPersonsInDB(pInfo.getId().toString());
            if (memberPaymentBaseInfo == null) {
                memberPaymentBaseInfo = new MemberPaymentBaseInfo();
                memberPaymentBaseInfo.setPerson(pInfo);
                if (pInfo.get("primaryAdminOrg") != null) {
                    memberPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg"));
                } else {
                    try {
                        memberPaymentBaseInfo.setAdminOrg(HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                memberPaymentBaseInfo.setImportData(ZERO);
                memberPaymentBaseInfo.setPayBase(ZERO);
            }
            this.loadTableRow(memberPaymentBaseInfo, row);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.changeEditStatus(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MemberPaymentBaseFactory.getRemoteInstance();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.submit();
        this.loadFields();
        this.changeEditStatus(false);
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int intMsgReturn = MsgBox.showConfirm2((String)EASResource.getString((String)resClassName, (String)"delAllPaymentbase"));
        if (intMsgReturn == 0 && this.memberPaymentBaseCollection != null && this.memberPaymentBaseCollection.size() > 0) {
            IObjectPK[] arrayPK = new IObjectPK[this.memberPaymentBaseCollection.size()];
            for (int i = 0; i < this.memberPaymentBaseCollection.size(); ++i) {
                arrayPK[i] = new ObjectUuidPK(this.memberPaymentBaseCollection.get(i).getId());
            }
            this.getBizInterface().delete(arrayPK);
        }
        this.loadMemOrgPaymentBaseInfos();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE"));
            if (comfirm == 0) {
                this.submit();
            }
            if (comfirm == 2) {
                SysUtil.abort();
            }
        }
        this.loadMemOrgPaymentBaseInfos();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.party.MemberPaymentBaseInfo";
        param.alias = EASResource.getString((String)resClassName, (String)"import_memberPaymentBase");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"MODIFY_AND_SAVE"));
            return;
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        this.actionRefresh_actionPerformed(null);
    }

    private void submit() throws Exception {
        this.kdtEntrys.getEditManager().stopEditing();
        CoreBaseCollection coreCollAdd = new CoreBaseCollection();
        CoreBaseCollection coreCollUpdate = new CoreBaseCollection();
        int countCycle = this.kdtEntrys.getRowCount();
        for (int i = 0; i < countCycle; ++i) {
            BigDecimal bigDecValue;
            IRow currentRow = this.kdtEntrys.getRow(i);
            MemberPaymentBaseInfo memberPaymentBaseInfo = new MemberPaymentBaseInfo();
            Object cellValue = currentRow.getCell("ID").getValue();
            if (cellValue != null) {
                memberPaymentBaseInfo.setId(BOSUuid.read((String)cellValue.toString()));
            }
            memberPaymentBaseInfo.setPerson((PersonInfo)currentRow.getCell("personName").getValue());
            memberPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)currentRow.getCell("adminOrg").getValue());
            cellValue = currentRow.getCell("importData").getValue();
            if (cellValue != null) {
                bigDecValue = (BigDecimal)cellValue;
                memberPaymentBaseInfo.setImportData(bigDecValue);
            } else {
                memberPaymentBaseInfo.setImportData(ZERO);
            }
            cellValue = currentRow.getCell("payBase").getValue();
            if (cellValue != null) {
                bigDecValue = (BigDecimal)cellValue;
                memberPaymentBaseInfo.setPayBase(bigDecValue);
            } else {
                memberPaymentBaseInfo.setPayBase(ZERO);
            }
            cellValue = currentRow.getCell("remark").getValue();
            if (cellValue != null) {
                memberPaymentBaseInfo.setRemark(cellValue.toString());
            } else {
                memberPaymentBaseInfo.setRemark("");
            }
            if (memberPaymentBaseInfo.getId() == null) {
                coreCollAdd.add((CoreBaseInfo)memberPaymentBaseInfo);
                continue;
            }
            coreCollUpdate.add((CoreBaseInfo)memberPaymentBaseInfo);
        }
        if (!this.deleteIds.isEmpty() && this.memberPaymentBaseCollection != null && this.memberPaymentBaseCollection.size() > 0) {
            String deleteID2 = null;
            for (String deleteID2 : this.deleteIds) {
                if (this.memberPaymentBaseCollection.get(BOSUuid.read((String)deleteID2)) == null) continue;
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)deleteID2)));
            }
        }
        if (!coreCollAdd.isEmpty()) {
            this.getBizInterface().save(coreCollAdd);
        }
        if (!coreCollUpdate.isEmpty()) {
            this.getBizInterface().update(coreCollUpdate);
        }
        this.deleteIds.clear();
        this.loadMemOrgPaymentBaseInfos();
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE_EXIT"));
            if (comfirm == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else if (comfirm == 2) {
                return false;
            }
        }
        return super.checkBeforeWindowClosing();
    }

    protected boolean isModify() {
        this.newPaymentBaseColl = this.getMemOrgPaymentBaseCollection();
        return this.memberPaymentBaseCollection == null && this.newPaymentBaseColl != null || this.memberPaymentBaseCollection != null && this.newPaymentBaseColl == null || this.memberPaymentBaseCollection != null && this.newPaymentBaseColl != null && !this.memberPaymentBaseCollection.equals((Object)this.newPaymentBaseColl);
    }
}

